/*
 * FILE: FoxHunt.h
 *
 * DESCRIPTION: Application's main module
 *
 * HISTORY:
 *   Sep 6, 2000 Created by Aleksey Matiushin
 */
#ifndef __FOX_HUNTING_H__
#define __FOX_HUNTING_H__

#include <cywin.h>

#define MUSIC_TITLE "title.mus" // Title music

#define MUSIC_ON_FOX "fox.mus" // Music for "found fox"

#define MUSIC_ON_DISABLE "disable.mus" // Music for "disable some lines"

#define MUSIC_SUCCESS "success.mus" // All foxes found

#define PICTURES_NAME "fox_hunting.pic" // Picture archive 

// Best Results archive 
// !! NOT COMPRESSED (flag "-" in makefile)
#define BESTS_ARCNAME "bests.dat"
                                      
#define GAME_CONTINUE 0 // Game is not over

#define GAME_DONE 1 // All foxes have been found

#define BOARD_SIZE 9 // Number of cells in the playfield side

#define CELL_SIZE 11 // Cell size, in pixels

#define FOXES_MIN 3 // Min number of foxes in the game

#define FOXES_MAX 9 // Max number of foxes in the game

#define NEXT_LEVEL_POWER 69 // If current_power is higher, foxes increased

#define MARK_EMPTY_FIELD -1 // Empty cell

#define MARK_ALIVE_FOX -2 // Live fox in the cell

#define MARK_DEAD_FOX -3 // Dead fox in the cell

#define DEFAULT_PICTURES 0 // Number of default picture resource files (.pic)

#define PIC_CELLFREE 0 // Picture Index of Free Cell

#define PIC_CELLFOX 1 // Picture Index of Fox in Cell

#define PIC_CELLDISB 2 // Picture Index of Disabled Cell

#define PIC_CURSOR 3 // Picture Index of Cursor

#define PIC_PANEL 4 // Picture Index of Info Panel Background

#define FRONT_PAGE 0 // Front page graphic display

#define BACK_PAGE 1 // Back page graphic display

// Indexes (Macro) to access board_lines data:
#define VER_INDEX( x, y ) ( x ) // Index of Vertical

#define HOR_INDEX( x, y ) ( y + BOARD_SIZE ) // Index of Horizontal

#define DG1_INDEX( x, y ) ( x + y + 2 * BOARD_SIZE ) // Index of diag1 "/"

#define DG2_INDEX( x, y ) ( y - x + 5 * BOARD_SIZE - 2 ) // Index of diag2 "\"

#define TOTAL_INDEX 0 // See board_lines description below...

#define FOUND_INDEX 1 // -"-

#define DISABLE_INDEX 2 // -"-

void init_session( void );                                     

void clear_session( void );

void init_game( void );                                     

void clear_game_data( void );

void make_clear_board( void );

void get_random_empty( int* i, int* j );

bool move_cursor( int direction,int fastmode );

int make_dialog( char *prompt, long style, char* musics );

bool set_field( void );

void say_game_over( void );

void do_vibrate( int level,int duration );

void try_disable_lines( int x, int y );

bool set_search_param( int px, int py, int drct,
  int *sx, int *sy, int *lx, int *ly );

bool search_cell( int x, int y );

void draw_board( void );

void refresh_info( void );

int calc_current_power( void );

int show_result( void );

bool got_next_level( void );

void set_results( void );

int check_winner( void );

void fill_best_powers( void );

void store_best_powers( void );

void play_music( char *musfile, bool inback );

#endif