/*
 * FILE: Bullet.c
 *
 * DESCRIPTION: Implementation of the player's weapon
 *
 * HISTORY:
 *   Nov 17, 2000 Created by Aleksey Slesarev
 */
#include "Bullet.h"
#include "Main.h"
#include "Utils.h"
#include "Screen.h"
#include "Vehicles.h"

struct Bullet player_bullet[ 3 ];

struct Bitmap* ptr_bullet_image;  // Image of the bullet

/*
 * FUNCTION: init_bullets
 *
 * DESCRIPTION: Initializes player's bullet object
 *
 * PARAMETERS: none 
 *
 * RETURNS: nothing
 */
void init_bullets( void )
{
  int index;

  for( index = 0; index < 3; index++ )
  {
    player_bullet[ index ].active = FALSE;

    player_bullet[ index ].w = player_bullet[ index ].h = 3;
  }
  ptr_bullet_image = BitmapSequence_get_bitmap( &game_images, 11 );
}

/*
 * FUNCTION: shoot
 *
 * DESCRIPTION: Activates the player's gun
 *
 * PARAMETERS: none 
 *
 * RETURNS: nothing
 */
void shoot( void )
{
  int index;

  for( index = 0; index < 3; index++ )
  {
    if( !player_bullet[ index ].active )
    {
      player_bullet[ index ].active = TRUE;

      player_bullet[ index ].x = player_vehicle.x + 38;

      player_bullet[ index ].y = player_vehicle.y + 8;

      player_bullet[ index ].drift_velocity = player_vehicle.vertical_velocity;

      play_sound( SOUND_SHOOT );

      break;
    }
  }
}

/*
 * FUNCTION: move_bullets
 *
 * DESCRIPTION: Updates positions of the player's bullets
 *
 * PARAMETERS: none 
 *
 * RETURNS: nothing
 */
void move_bullets( void )
{
  int index;

  struct rect_t test_rectangle;

  for( index = 0; index < 3; index++ )
  {
    if( player_bullet[ index ].active )
    {
      player_bullet[ index ].x += BULLET_VELOCITY;

      player_bullet[ index ].y += player_bullet[ index ].drift_velocity;

      // Checks if a bullet has struck an enemy
      if( current_enemy.active && !current_enemy.explosion &&
        rect_and( &test_rectangle, &current_enemy,
          (struct Bullet*) player_bullet + index ))
      {
        player_bullet[ index ].active = FALSE;

        current_enemy.hit_points--;

        if( current_enemy.hit_points <= 0 )
        {
          explosion( &current_enemy );

          remining_enemes--;

          score += current_enemy.score;
        }
        draw_info();
      } 
      // Checks if a bullet has gone off the screen
      if( !rect_and( &test_rectangle, &road_edge, 
        (struct Bullet*) player_bullet + index ))
      {
        player_bullet[ index ].active = FALSE;
      }
    }
  }
}

/*
 * FUNCTION: draw_bullets
 *
 * DESCRIPTION: Draws the player's bullets on the screen
 *
 * PARAMETERS: none 
 *
 * RETURNS: nothing
 */
void draw_bullets( void )
{
  int index;

  for( index = 0; index < 3; index++ )
  {
    if( player_bullet[ index ].active )
    {
      DisplayGraphics_draw_bitmap( main_module.m_gfx,
        ptr_bullet_image, player_bullet[ index ].x, 
          player_bullet[ index ].y, BM_NORMAL );   
    }
  }
}
