/*
 * FILE: Main.h
 *
 * DESCRIPTION: Application's main module
 *
 * HISTORY:
 *   Nov 17, 2000 Created by Aleksey Slesarev
 */
#ifndef __MAIN_H__
#define __MAIN_H__

#include <cywin.h>

#define MENU_START 0 // "Game Start" was selected

#define MENU_HIGH_SCORES 1 // "Show High Scores" was selected

#define MENU_EXIT 2 // "Exit the Game" was selected

extern struct module_t main_module; // Application's main module 

extern struct score_t high_scores[ 10 ]; // High Scores for the game

void init_menu( void );

void release_menu( void );

int select_action( void );

bool game_process( void );

void show_high_scores( void );

void init_high_scores( void );

void update_high_scores( void );

void release_high_scores( void );

#endif