/*
 * FILE: Screen.h
 *
 * DESCRIPTION: Drawing of the game scene
 *
 * HISTORY:
 *   Nov 17, 2000 Created by Aleksey Slesarev
 */
#ifndef __SCREEN_H__
#define __SCREEN_H__

#include <cywin.h>

// Destination for drawing initial_screen
extern struct Graphics virtual_graphics;   

// Images of the game's objects
extern struct BitmapSequence game_images;  

// Bounding rectangle of the road
extern const struct rect_t road_edge;

// Delay of generating the first enemy at this level
extern int generation_delay;    

// Current level
extern int level;               

// TRUE if game is over
extern bool game_over;          

// Current score
extern int score;            

// Remaining enemies to destroy at this level
extern int remining_enemes;  

// Current scroll velocity
extern int scroll_velocity;    

void init_scene( void );

void release_scene( void );

void init_new_game( void );

void init_level( void );

void draw_scene( void );

bool calculate_scene( void );

void draw_info( void );

#endif