/*
 * FILE: Utils.h
 *
 * DESCRIPTION: Helper functions
 *
 * HISTORY:
 *   Nov 17, 2000 Created by Aleksey Slesarev
 */
#ifndef __UTILS_H__
#define __UTILS_H__

#include <cywin.h>

#define SOUND_MENU 0 // Menu music

#define SOUND_DRIVE 1 // Moving vehicle sound effect

#define SOUND_SPEED_UP 2 // Acceleration sound effect

#define SOUND_SLOW_DOWN 3 // Slowing-down sound effect 

#define SOUND_EXPLOSION 4 // Explosion sound effect

#define SOUND_KNOCK 5 // Knocking sound effect

#define SOUND_SHOOT 6 // Shooting sound effect

#define SOUND_LEVEL 7 // "Welcome to this level" music

#define SOUND_WIN 8 // "Mission completed" music

#define SOUND_LOSE 9 // "Game Over" music

#define EXIT_GAME 0 // User chose to exit the game

#define CONTINUE_GAME 1 // User chose to continue the game

#define RESTART_GAME 2 // User chose to restart game

#define DIALOG_EXIT 0 // Do you really want to exit the game?

#define DIALOG_LEVEL 1 // Welcome to the next level

#define DIALOG_GAME_OVER 2 // Game result dialog

extern int background_sound; // Current background music

extern struct MSequence game_sounds[ 10 ]; // Sound effects for the game

void load_sound( void );

void release_sound( void );

void play_sound( int sound_id );

int show_dialog( int dialog_id );

#endif