/*
 * FILE: Vehicles.h
 *
 * DESCRIPTION: Implementation of the vehicles
 *
 * HISTORY:
 *   Nov 17, 2000 Created by Aleksey Slesarev
 */
#ifndef __VEHICLES_H__
#define __VEHICLES_H__

#include <cywin.h>

#define  PLAYER_X_VELOCITY 3 // Player's velocity in x - direction

#define  PLAYER_Y_VELOCITY 3 // Player's velocity in y - direction 

// Vehicle object
struct Vehicle : public rect_t
{                                       
  struct Bitmap* ptr_image; // Bitmap image of the vehicle

  int explosion; // If not 0 when explosion occurs
};

// Player's vehicle object
struct PlayerVehicle : public Vehicle
{
  int vertical_velocity; // Current vertical velocity

  int horizontal_velocity; // Current horizontal velocity
};

// Enemy's vehicle objects
struct EnemyType : public Vehicle
{
  int hit_points; // Hit points

  int type; // Type

  int move_param; // Behavioral parameter

  int score; // Score increment for enemy
};

// Current enemy vehicle
struct EnemyVehicle : public EnemyType
{
  bool active; // TRUE if enemy is on-screen
};

extern struct EnemyVehicle current_enemy; 

extern struct BitmapSequence explosion_images; // Images of the explosion

extern struct PlayerVehicle player_vehicle;

void init_vehicles( void );

void init_player_vehicle( void );

void release_vehicles( void );

void draw_vehicle( struct Vehicle* ptr_vehicle );

void explosion( struct Vehicle* ptr_vehicle );

void generate_enemy( void );

void move_enemy( void );

void move_player_vehicle( void );

void move_vehicle_1( struct EnemyVehicle* ptr_vehicle );

void move_vehicle_2( struct EnemyVehicle* ptr_vehicle );

void move_vehicle_3( struct EnemyVehicle* ptr_vehicle );

void move_vehicle_4( struct EnemyVehicle* ptr_vehicle );

void move_vehicle_5( struct EnemyVehicle* ptr_vehicle );

void move_vehicle_6( struct EnemyVehicle* ptr_vehicle );

void move_vehicle_7( struct EnemyVehicle* ptr_vehicle );

void move_vehicle_8( struct EnemyVehicle* ptr_vehicle );

void move_vehicle_9( struct EnemyVehicle* ptr_vehicle );

void move_vehicle_10( struct EnemyVehicle* ptr_vehicle );

#endif