
#include <cywin.h>

#define MSG_RESTART MSG_USER + 1

#define MENU_START 0 // values of 'menu_choice'
#define MENU_SCORE 1
#define MENU_EXIT  2

#define MODE_MENU  0 // values of 'mode'
#define MODE_GAME  1

#define FLIES_MAX 10 // max number of flies
#define LIZARD_X  80 // (67) monster's head coordinates
#define LIZARD_Y  85
#define TIMEOUT   60

struct aim_t
{
  int x;
  int y;
};

struct fly_t
{
  int x;
  int y;
  int dir;
  int ch_dir;
  int restlessness;
  bool good_place;
  int smart;
  struct fly_t* next;
};

struct MSequence mus_shot;
struct MSequence mus_level;
struct MSequence mus_eat;
struct MSequence mus_win;
struct MSequence mus_lose;
struct MSequence mus_title;

struct module_t app;
struct DirectKeyboard* pdk;
struct cDialog* dlg;
struct DisplayGraphics* gfx;
struct BitmapSequence bmp_end;
struct BitmapSequence bmp_menu;
struct Score score_archive;
struct score_t high_scores[ 5 ];

char *page_0, *page_1;
bool eat, any_key, clicks, draw_lose, exit_app = FALSE;
struct aim_t aim;    // target
struct fly_t* flies; // list of flies
int flies_count;     // length of that list
int flies_on_level;  // number of flies on the level
int menu_choice, mode, level, last_shot, last_score = -1;
long score, level_time, cur_time, sleep_time;
char time_str[ 20 ], score_str[ 20 ], sz_name[ NICKNAMESIZE + 1 ];

/*
 * FUNCTION: draw_menu
 *
 * DESCRIPTION: -
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void draw_menu( void )
{
  if( mode == MODE_MENU && !exit_app && cWinApp_has_focus( app.m_process ))
  {
    cEngine_Lock( &Screen );

    DisplayGraphics_set_draw_mode( gfx, DM_PUT );

    DisplayGraphics_draw_bitmap( gfx,
      BitmapSequence_get_bitmap( &bmp_menu, 0 ), 0, 0, BM_NORMAL );

    DisplayGraphics_set_color( gfx, CLR_BLACK );

    Graphics_set_font( gfx, cool_bold_font );

    Graphics_draw_text( gfx, "Start", 80, 45 );

    Graphics_draw_text( gfx, "Best scores", 80, 60 );

    Graphics_draw_text( gfx, "Exit", 80, 75 );

    DisplayGraphics_set_draw_mode( gfx, DM_OR );

    DisplayGraphics_set_bkcolor( gfx, CLR_WHITE );

    draw_lib( 0, 0, 63,  43 + menu_choice * 15, BM_NORMAL );

    DisplayGraphics_show( gfx );

    cEngine_Unlock( &Screen );
  }
}

/*
 * FUNCTION: draw_scores
 *
 * DESCRIPTION: -
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void draw_scores( void )
{
  if( cWinApp_has_focus( app.m_process ))
  {
    int i;

    cEngine_Lock( &Screen );

    DisplayGraphics_set_draw_mode( gfx, DM_PUT );

    DisplayGraphics_set_color( gfx, CLR_WHITE );

    DisplayGraphics_fill_screen( gfx, DM_PUT );

    DisplayGraphics_set_color( gfx, CLR_BLACK );

    Graphics_set_font( gfx, cool_bold_font );

    DisplayGraphics_set_color( gfx, CLR_BLACK );

    TGraph_fill_rect( gfx, 0, 0, SCREEN_WIDTH, 14 );

    TGraph_draw_rect( gfx, 0, 14, SCREEN_WIDTH, 86 );

    for( i = 0; i < 5; i++ )
    {
      char str[ 10 ];

      if( !high_scores[ i ].score ) break;

      sprintf( str, "%ld", high_scores[ i ].score );

      if( i == last_score )
      {
        DisplayGraphics_set_color( gfx, CLR_DKGRAY );

        TGraph_fill_rect( gfx, 1, 15 + i * 15, SCREEN_WIDTH - 2, 15 );

        DisplayGraphics_set_color( gfx, CLR_WHITE );
      }
      Graphics_draw_text( gfx, high_scores[ i ].nickname, 10, 16 + i * 15 );

      Graphics_draw_text( gfx, str, 90, 16 + i * 15 );

      if( i == last_score ) DisplayGraphics_set_color( gfx, CLR_BLACK );
    }
    DisplayGraphics_set_color( gfx, CLR_WHITE );

    Graphics_draw_text( gfx, "Best scores", 45, 1 );

    DisplayGraphics_set_color( gfx, CLR_LTGRAY );

    TGraph_fill_rect( gfx, 1, 89, SCREEN_WIDTH - 2, 10 );

    Graphics_set_font( gfx, mini_bold_font );

    DisplayGraphics_set_color( gfx, CLR_BLACK );

    Graphics_draw_text( gfx, "Press any key to continue", 10, 90 );

    DisplayGraphics_show( gfx );

    cEngine_Unlock( &Screen );
  }
}

/*
 * FUNCTION: draw_page1
 *
 * DESCRIPTION: -
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void draw_page1( void )
{
  // TRACE("draw_page1()");

  cEngine_Lock( &Screen );

  DisplayGraphics_set_page( gfx, 1 );

  DisplayGraphics_set_draw_mode( gfx, DM_PUT );

  DisplayGraphics_set_color( gfx, CLR_WHITE );

  DisplayGraphics_fill_screen( gfx, DM_PUT );

  draw_lib( 0, 10, 4, 89, BM_NORMAL );

  // draw_lib( 0, 8, LIZARD_X - 22, LIZARD_Y - 2, BM_NORMAL );

  DisplayGraphics_set_color( gfx, CLR_BLACK );

  Graphics_set_font( gfx, mini_bold_font );

  // Graphics_draw_text_Ex( gfx, score_str, 93, 90, 20 );

  draw_lib( 0, 17, 110, 89, BM_NORMAL );

  Graphics_draw_text_Ex( gfx, score_str, 125, 90, 20 );

  Graphics_draw_text_Ex( gfx, time_str, 20, 90, 4 );

  DisplayGraphics_set_page( gfx, 0 );

  cEngine_Unlock( &Screen );
}

/*
 * FUNCTION: flies_draw
 *
 * DESCRIPTION: draw entire list of flies
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void flies_draw( void )
{
  if( mode == MODE_GAME && !exit_app && cWinApp_has_focus( app.m_process ))
  {
    int dx, dy, a, fly_pic, aim_y, aim_x;

    cEngine_Lock( &Screen );

    if( draw_lose )
    {
      int npic = 0;

      if( !random( 20 ))
      {
        vibrate( 255 );

        npic = (int) random( 2 ) + 1; // 1 or 2; fixed: was random( 1 )
      }
      DisplayGraphics_set_draw_mode( gfx, DM_PUT );

      DisplayGraphics_draw_bitmap( gfx,
          BitmapSequence_get_bitmap( &bmp_end, npic ), 0, 0, BM_NORMAL );

      Graphics_set_font( gfx, mini_bold_font );

      DisplayGraphics_set_color( gfx, CLR_BLACK );

      if( any_key )
      {
        Graphics_draw_text( gfx, "Press any key to continue", 10, 89 );
      }
      if( npic ) vibrate( 0 );
    }
    else
    {
      struct fly_t* fly = flies;

      // DisplayGraphics_page_copy( gfx, 1, 0, 0, 0, 160, 100);

      memcpy( page_0, page_1, 4000 );

      DisplayGraphics_set_draw_mode( gfx, DM_OR );

      DisplayGraphics_set_bkcolor( gfx, CLR_WHITE );

      while( fly )
      {
        draw_lib( 0, fly->dir, fly->x - 6,  fly->y - 6, BM_NORMAL );

        fly = fly->next;
      }
      if( last_shot > 8 )
      {
        DisplayGraphics_set_color( gfx, CLR_BLACK );

        aim_y = LIZARD_Y - aim.y;

        aim_x = aim.x - LIZARD_X;

        if( aim_x < 0 ) aim_x = -aim_x;

        if( aim_x > aim_y )
        {
          DisplayGraphics_draw_line( gfx, LIZARD_X , LIZARD_Y - 1 + 10,
            aim.x, aim.y - 1 );

          DisplayGraphics_draw_line( gfx, LIZARD_X , LIZARD_Y + 1 + 10,
            aim.x, aim.y + 1 );

          DisplayGraphics_set_color( gfx, CLR_DKGRAY );

          DisplayGraphics_draw_line( gfx, LIZARD_X, LIZARD_Y + 10,
            aim.x, aim.y );
        }
        else
        {
          DisplayGraphics_draw_line( gfx, LIZARD_X - 1, LIZARD_Y + 10,
            aim.x - 1, aim.y );

          DisplayGraphics_draw_line( gfx, LIZARD_X + 1, LIZARD_Y + 10,
            aim.x + 1, aim.y );

          DisplayGraphics_set_color( gfx, CLR_DKGRAY );

          DisplayGraphics_draw_line( gfx, LIZARD_X, LIZARD_Y + 10, aim.x, aim.y );
        }
        // draw_lib( 0, 11, LIZARD_X - 6, LIZARD_Y - 2, BM_NORMAL );
      }
      draw_lib( 0, 9, aim.x - 6, aim.y - 6, BM_NORMAL );

      dx = aim.x - LIZARD_X;

      dy = LIZARD_Y - aim.y;

      if( !dy ) dy = 1;

      a = dx * 128 / dy;

      // TRACE("a = %d", a);

      if( eat )
      {
        eat = FALSE;

        fly_pic = (int) random( 7 );

        if( a < 65 && a > -65 )
          draw_lib( 0, fly_pic, LIZARD_X - 7, LIZARD_Y - 7, BM_NORMAL );

        if( a >= 65 && a < 170 )
          draw_lib( 0, fly_pic, LIZARD_X - 7 + 3, LIZARD_Y - 7 + 1, BM_NORMAL );

        if( a >= 170 && a < 270 )
          draw_lib( 0, fly_pic, LIZARD_X - 7 + 6, LIZARD_Y - 7 + 2, BM_NORMAL );

        if( a >= 270 )
          draw_lib( 0, fly_pic, LIZARD_X - 7 + 9, LIZARD_Y - 7 + 3, BM_NORMAL );

        if( a <= -65 && a > -170 )
          draw_lib( 0, fly_pic, LIZARD_X - 7 - 3, LIZARD_Y - 7 + 1, BM_NORMAL );

        if( a <= -170 && a > -270 )
          draw_lib( 0, fly_pic, LIZARD_X - 7 - 6, LIZARD_Y - 7 + 2, BM_NORMAL );

        if( a <= -270 )
          draw_lib( 0, fly_pic, LIZARD_X - 7 - 9, LIZARD_Y - 7 + 3, BM_NORMAL );
      }
      if( a < 65 && a > -65 )
        draw_lib( 0, 8, LIZARD_X - 22, LIZARD_Y - 2, BM_NORMAL );

      if( a >= 65 && a < 170 )
        draw_lib( 0, 11, LIZARD_X - 22, LIZARD_Y - 2, BM_NORMAL );

      if( a >= 170 && a < 270 )
        draw_lib( 0, 12, LIZARD_X - 22, LIZARD_Y - 2, BM_NORMAL );

      if( a >= 270 )
        draw_lib( 0, 13, LIZARD_X - 22, LIZARD_Y - 2, BM_NORMAL );

      if( a <= -65 && a > -170 )
        draw_lib( 0, 14, LIZARD_X - 22, LIZARD_Y - 2, BM_NORMAL );

      if( a <= -170 && a > -270 )
        draw_lib( 0, 15, LIZARD_X - 22, LIZARD_Y - 2, BM_NORMAL );

      if( a <= -270 )
        draw_lib( 0, 16, LIZARD_X - 22, LIZARD_Y - 2, BM_NORMAL );
    }
    DisplayGraphics_show( gfx );

    cEngine_Unlock( &Screen );
  }
}

/*
 * FUNCTION: flies_move
 *
 * DESCRIPTION: move entire list of flies
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void flies_move( void )
{
  struct fly_t* fly = flies;

  while( fly )
  {
    int r, n;

    if( !random( fly->restlessness ))
    {
      // fly->dir = random( 7 );

      r = (int) random( fly->ch_dir ); // + 1;

      if( random( 2 )) // fixed: was random( 1 )
      {
        fly->dir -= r;

        if( fly->dir < 0 ) fly->dir += 8;
      }
      else
      {
        fly->dir += r;

        if( fly->dir > 7 ) fly->dir -= 8;
      }
    }
    r = (int) random( 7 ) + 1;

    if( last_shot )
    {
      if( fly->good_place ) r = (int) random( 4 /*?*/ ); else r += fly->smart;
    }
    n = 2 - (int) random( 5 ); // fixed: was random( 4 )

    switch( fly->dir )
    {
      case 0: fly->y -= r; fly->x += n; break;

      case 1: fly->x += r; fly->y -= r + n; /* fly->y -= n; */ break;

      case 2: fly->x += r; fly->y += n; break;

      case 3: fly->x += r; fly->y += r + n; /* fly->y += n; */ break;

      case 4: fly->y += r; fly->x += n; break;

      case 5: fly->x -= r; fly->y += r + n; /* fly->y += n; */ break;

      case 6: fly->x -= r; fly->y += n; break;

      case 7: fly->x -= r; fly->y -= r + n; /* fly->y -= n; */ break;
    }
    if( fly->x < 6 )
    {
      fly->x = 6;

      fly->dir = (int) random( 8 ); // fixed: was random( 7 )
    }
    else if( fly->x > 152 )
    {
      fly->x = 152;

      fly->dir = (int) random( 8 ); // fixed: was random( 7 )
    }
    if( fly->y < 7 )
    {
      fly->y = 7;

      fly->dir = (int) random( 8 ); // fixed: was random( 7 )
    }
    else if( fly->y > LIZARD_Y - 11 )
    {
      fly->y = LIZARD_Y - 11;

      fly->dir = (int) random( 8 ); // fixed: was random( 7 )
    }
    fly = fly->next;
  }
  flies_draw();

  if( last_shot > 0 ) last_shot--;
}

/*
 * FUNCTION: flies_add
 *
 * DESCRIPTION: add one more fly
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void flies_add( void )
{
  struct fly_t* fly = (struct fly_t*) malloc( sizeof *fly );

  vibrate( 255 );

  fly->next = flies;

  fly->x = (int) random( 150 ) + 5;

  fly->y = (int) random( LIZARD_Y  - 11 ) + 5;

  fly->dir = (int) random( 8 ); // fixed: was random( 7 )

  fly->ch_dir = (int) random( 3 ) + 1;

  fly->restlessness = (int) random( 10 ) + 2;

  fly->smart = 0;

  fly->good_place = FALSE;

  flies_count++;

  flies = fly;
}

/*
 * FUNCTION: flies_eat
 *
 * DESCRIPTION: check who has been eaten
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void flies_eat( void )
{
  if( !last_shot )
  {
    struct fly_t* fly = flies;

    struct fly_t* fly_prev = NULL;

    long old_score = score;

    long n, m, p, d, aim_y, aim_x, fly_x, fly_y;

    MSequence_play( &mus_shot );

    last_shot = 10;

    aim_y = LIZARD_Y - aim.y;

    aim_x = aim.x - LIZARD_X;

    p = aim_y * aim_y + aim_x * aim_x; // squared length of the tongue

    while( fly )
    {
      fly_x = fly->x - LIZARD_X;

      fly_y = LIZARD_Y - fly->y;

      n = aim_y * fly_x;

      m = aim_x * fly_y;

      d = ( n * n + m * m - n * m * 2 ) / p;

      if( d < 36 )
      {
        m = fly_y * fly_y + fly_x * fly_x;

        if( m <= p )
        {
          if( fly_prev )
          {
            fly_prev->next = fly->next;

            free( fly );

            fly = fly_prev->next;
          }
          else
          {
            flies = fly->next;

            free( fly );

            fly = flies;
          }
          flies_count--;

          score += 100;

          continue;
        }
      }
      else if( d < 64 )
      {
        if( fly->restlessness > 1 ) fly->restlessness--;

        fly->good_place = FALSE;
      }
      else if( d < 400 )
      {
        if( fly->smart < 8 ) fly->smart += 2;

        if( fly->restlessness < 12 ) fly->restlessness++;

        fly->good_place = FALSE;
      }
      else if( d < 900 && fly->smart < 8 )
      {
        fly->smart++;
      }
      else fly->good_place = TRUE;

      fly_prev = fly;

      fly = fly->next;
    }
    while( flies_on_level > 0 && flies_count < FLIES_MAX )
    {
      flies_add();

      flies->y = (int) random( 5 ) + 5;

      flies_on_level--;
    }
    if( old_score != score )
    {
      eat = TRUE;

      MSequence_play( &mus_eat );

      // sprintf( score_str, "Score: %ld", score );

      sprintf( score_str, "%ld", score );

      draw_page1();
    }
  }
}

/*
 * FUNCTION: flies_delete
 *
 * DESCRIPTION: clean the list
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void flies_delete( void )
{
  while( flies )
  {
    struct fly_t* fly = flies->next;

    free( flies );

    flies = fly;
  }
  flies_count = 0;

  flies_draw();
}

/*
 * FUNCTION: eat_kbd_messages
 *
 * DESCRIPTION: -
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void eat_kbd_messages( void )
{
  for(;;) // eat up keyboard messages
  {
    struct Message* msg = cWinApp_peek_message( app.m_process, TRUE,
      MSG_KEYMIN, MSG_KEYMAX );

    if( msg ) Message_delete( msg ); else break;
  }
}

/*
 * FUNCTION: next_level
 *
 * DESCRIPTION: advance to the next level
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void next_level( void )
{
  char str[ 30 ];

  MSequence_play_background( &mus_level );

  strcpy( time_str, "1:00" );

  eat = FALSE;

  last_shot = 0;

  level++;

  flies_delete();

  flies_on_level = level + 2;

  while( flies_on_level > 0 && flies_count < FLIES_MAX )
  {
    flies_add();

    flies_on_level--;
  }
  draw_page1();

  // cEngine_Lock( &Screen );
  // DisplayGraphics_page_copy( gfx, 1, 0, 0, 0, 160, 100);
  // cEngine_Unlock( &Screen );

  flies_draw();

  sprintf( str, "Level %ld", level );

  dlg = (struct cDialog*) malloc( sizeof *dlg );

  cDialog_ctor( dlg, 0, str, mbOk, 0, app.m_process );

  eat_kbd_messages();

  vibrate( 0 );

  set_clicks_enabled( clicks );

  cDialog_ShowModal( dlg );

  set_clicks_enabled( FALSE );

  cDialog_dtor( dlg, FREE_MEMORY );

  flies_draw();

  level_time = time();

  // TRACE("level_time == %ld", level_time );
}

/*
 * FUNCTION: new_game
 *
 * DESCRIPTION: start new game session
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void new_game( void )
{
  mode = MODE_GAME;

  set_clicks_enabled( FALSE );

  app.m_process->HelpContext = 0;

  score = 0;

  strcpy( score_str, "0" ); // "Score: 0"

  last_score = -1;

  aim.x = 80;

  aim.y = 40;

  level = 0;

  draw_lose = FALSE;

  next_level();
}

/*
 * FUNCTION: show_high_scores
 *
 * DESCRIPTION: -
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void show_high_scores( void )
{
  bool exit = FALSE;

  int old_help = app.m_process->HelpContext;

  app.m_process->HelpContext = 2;

  draw_scores();

  while( !exit )
  {
    struct Message* msg = cWinApp_get_message( app.m_process, 20, 1, MSG_USER );

    if( msg )
    {
      switch( msg->msgid )
      {
        case MSG_LOSTFOCUS:

          set_clicks_enabled( clicks ), vibrate( 0 ); break;

        case MSG_GOTFOCUS:

          set_clicks_enabled( FALSE ), draw_page1(), draw_scores(); break;

        case MSG_SHUTUP:
        case MSG_QUIT:

          exit_app = exit = TRUE; break;

        case MSG_KEYDOWN:

          if( Message_get_key_param( msg )->mask & KEYMASK_AUTOREPEAT ) break;

          if( Message_get_key_param( msg )->scancode == KEY_HELP )
          {
            cWinApp_defproc( app.m_process, msg );
          }
          else exit = TRUE;

          break;
      }
      Message_delete( msg );
    }
  }
  app.m_process->HelpContext = old_help;
}

/*
 * FUNCTION: update_high_scores
 *
 * DESCRIPTION: -
 *
 * PARAMETERS:
 *   name - FALSE if called upon MSG_QUIT or MSG_SHUTUP, TRUE otherwise
 *
 * RETURNS: TRUE if updated, FALSE otherwise
 */
bool update_high_scores( bool name )
{
  if( score && score > high_scores[ 4 ].score )
  {
    int i, res;

    bool table = FALSE, save = TRUE, mode;

    char tmp_name[ NICKNAMESIZE + 1 ], dlg_txt[ 60 ];

    struct score_t* hs_buffer = malloc( 4 * sizeof *hs_buffer );

    MSequence_play_background( &mus_win );

    if( name )
    {
      eat_kbd_messages();

      for( i = 0; i < 5; i++ )
      {
        if( score > high_scores[ i ].score ) break;
      }
      sprintf( dlg_txt, "Score - %ld\nThis is the ", score );

      switch( i )
      {
        case 0: strcat( dlg_txt, "BEST" ); break;

        case 1: strcat( dlg_txt, "2nd" ); break;

        case 2: strcat( dlg_txt, "3rd" ); break;

        case 3: strcat( dlg_txt, "4th" ); break;

        case 4: strcat( dlg_txt, "5th" ); break;
      }
      strcat( dlg_txt, " score!\nEnter your name" );

      dlg = (struct cDialog*) malloc( sizeof *dlg );

      cDialog_ctor( dlg, 0, dlg_txt, mbOk | mbCancel | mbEdit,
        NICKNAMESIZE, app.m_process );

      cDialog_SetEditText( dlg, ptr_Finder->mf.f_nick );

      set_clicks_enabled( clicks );

      mode = get_critical_mode();

      if( !mode ) set_critical_mode( TRUE );

      for(;;)
      {
        res = cDialog_ShowModal( dlg );

        if( res == mrOk )
        {
          cDialog_GetEditText( dlg, tmp_name );

          if( !tmp_name[ 0 ] ) continue;

          for( i = 0; i < strlen( tmp_name ); i++ )
          {
            if( tmp_name[ i ] != ' ' )
            {
              strcpy( sz_name, tmp_name );

              table = TRUE;

              break;
            }
          }
          if( table ) break;
        }
        else
        {
          save = FALSE;

          break;
        }
      }
      set_critical_mode( mode );

      set_clicks_enabled( FALSE );

      cDialog_dtor( dlg, FREE_MEMORY );
    }
    else strcpy( sz_name, "unknown" );

    if( save )
    {
      for( i = 0; i < 5; i++ )
      {
        if( score > high_scores[ i ].score )
        {
          if( i != 4)
          {
            memcpy( hs_buffer, high_scores, 4 * sizeof *hs_buffer );

            memcpy( high_scores + i + 1, hs_buffer + i,
              ( 4 - i ) * sizeof *hs_buffer );
          }
          last_score = i;

          high_scores[ i ].score = score;

          high_scores[ i ].cyid = get_own_id();

          high_scores[ i ].time = time();

          strncpy( high_scores[ i ].nickname, sz_name, NICKNAMESIZE );

          break;
        }
      }
    }
    score = 0;

    free( hs_buffer );

    if( table ) show_high_scores();

    last_score = -1;

    return TRUE;
  }
  return FALSE;
}

/*
 * FUNCTION: init_music
 *
 * DESCRIPTION: -
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void init_music( void )
{
  MSequence_ctor( &mus_shot,  "shot.mus" );

  MSequence_ctor( &mus_level, "level.mus" );

  MSequence_ctor( &mus_eat, "eat.mus" );

  MSequence_ctor( &mus_win, "win.mus" );

  MSequence_ctor( &mus_lose, "lose.mus" );

  MSequence_ctor( &mus_title, "title.mus" );
}

/*
 * FUNCTION: release_music
 *
 * DESCRIPTION: -
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void release_music( void )
{
  MSequence_dtor( &mus_shot, LEAVE_MEMORY );

  MSequence_dtor( &mus_level, LEAVE_MEMORY );

  MSequence_dtor( &mus_eat, LEAVE_MEMORY );

  MSequence_dtor( &mus_win, LEAVE_MEMORY );

  MSequence_dtor( &mus_lose, LEAVE_MEMORY );

  MSequence_dtor( &mus_title, LEAVE_MEMORY );
}

/*
 * FUNCTION: init_high_scores
 *
 * DESCRIPTION: -
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void init_high_scores( void )
{
  Score_ctor( &score_archive, app.m_process->module );

  if( Score_is_valid ( &score_archive ))
  {
    int i;

    for( i = 0; i < 5; i++ )
    {
      Score_read( &score_archive, i, high_scores + i );
    }
  }
}

/*
 * FUNCTION: release_high_scores
 *
 * DESCRIPTION: -
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void release_high_scores( void )
{
  int i;

  for( i = 0; i < 5; i++ )
  {
    Score_write( &score_archive, i, high_scores + i );
  }
  Score_dtor( &score_archive, LEAVE_MEMORY );
}

/*
 * FUNCTION: on_key
 *
 * DESCRIPTION: -
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void on_key( void )
{
  DirectKeyboard_scan( pdk );

  if( DirectKeyboard_is_key_pressed( pdk, KEY_LEFT ) && aim.x > 3 )
  {
    aim.x -= 4;
  }
  if( DirectKeyboard_is_key_pressed( pdk, KEY_RIGHT ) &&
    aim.x < ( SCREEN_WIDTH - 3 ))
  {
    aim.x += 4;
  }
  if( DirectKeyboard_is_key_pressed( pdk, KEY_UP ) && aim.y > 3 )
  {
    aim.y -= 4;
  }
  if( DirectKeyboard_is_key_pressed( pdk, KEY_DOWN ) &&
    aim.y < ( LIZARD_Y - 11 ))
  {
    aim.y += 4;
  }
  if( DirectKeyboard_is_key_pressed( pdk, KEY_ENTER ))
  {
    flies_eat();
  }
}

/*
 * FUNCTION: main
 *
 * DESCRIPTION: program entry point
 *
 * PARAMETERS:
 *   argc - number of arguments
 *   argv - array of 'argc' arguments passed to the application
 *   start - TRUE if the application is being initialized, FALSE otherwise
 *
 * RETURNS: 0L
 */
long main( int argc, char* argv[], bool start )
{
  bool restarting;

  long old_t, dlg_style, t = 0;

  int res, min, sec, key;

  struct Message *ptr_message, *msg;

  init_module( &app );

  init_high_scores();

  init_music();

  pdk = DirectKeyboard_get_instance();

  gfx = app.m_gfx;

  page_0 = DisplayGraphics_get_page_ptr( gfx, 0 );

  page_1 = DisplayGraphics_get_page_ptr( gfx, 1 );

  draw_page1();

  BitmapSequence_ctor_Ex( &bmp_end, "end.pic" );

  BitmapSequence_ctor_Ex( &bmp_menu, "menu.pic" );

  clicks = get_clicks_enabled();

  menu_choice = 0;

  flies = NULL;

  restarting = FALSE;

  mode = MODE_MENU;

  app.m_process->HelpContext = 1;

  MSequence_play_background( &mus_title );

  while( !exit_app )
  {
    msg = cWinApp_get_message( app.m_process, 20, 1, MSG_USER );

    if( msg )
    {
      switch( msg->msgid )
      {
        case MSG_LOSTFOCUS: // Application has lost its focus

          set_clicks_enabled( clicks );

          vibrate( 0 );

          sleep_time = time();

          break;

        case MSG_GOTFOCUS: // Application has the focus

          set_clicks_enabled( FALSE );

          draw_page1();

          sleep_time -= time();

          if( sleep_time < 0 ) sleep_time = -sleep_time;

          level_time += sleep_time;

          break;

        case MSG_SHUTUP: // Processes system exit signals
        case MSG_QUIT:

          exit_app = TRUE;

          update_high_scores( FALSE );

          break;

        case MSG_KEYDOWN:

          key = Message_get_key_param( msg )->scancode;
          
          if( draw_lose )
          {
            if( key == KEY_HELP )
            {
              cWinApp_defproc( app.m_process, msg );
            }
            else
            {
              restarting = TRUE;

              mode = MODE_MENU;

              set_clicks_enabled( FALSE );

              app.m_process->HelpContext = 1;

              draw_lose = FALSE;
            }
            break;
          }
          if( Message_get_key_param( msg )->mask & KEYMASK_AUTOREPEAT ) break;

          if( mode == MODE_MENU )
          {
            if( key == KEY_UP  )
            {
              if( --menu_choice < 0 ) menu_choice = 2;

              break;
            }
            if( key == KEY_DOWN )
            {
              if( ++menu_choice > 2 ) menu_choice = 0;

              break;
            }
            if( key == KEY_ENTER )
            {
              switch( menu_choice )
              {
                case MENU_START:

                  strcpy( time_str, "1:00" );

                  strcpy( score_str, "0" ); // "Score: 0"

                  draw_page1();

                  restarting = TRUE;

                  ptr_message = Message_new( sizeof *ptr_message );

                  ptr_message->msgid = MSG_RESTART;

                  Message_post( ptr_message, "Lizard_Luncheon", get_own_id());

                  break;
                
                case MENU_SCORE: show_high_scores(); break;

                case MENU_EXIT: exit_app = TRUE; break;
              }
              break;
            }
          }
          if( key == KEY_ESC )
          {
            vibrate( 0 );

            if( mode == MODE_MENU ) dlg_style = mbQuit | mbCancel | mbs1;

            else if( mode == MODE_GAME )
            {
              dlg_style = mbQuit | mbRestart | mbs1;

              sleep_time = time();
            }
            dlg = (struct cDialog*) malloc( sizeof *dlg );

            cDialog_ctor( dlg, 0, str_Really_exit, dlg_style, 0,
              app.m_process );

            set_clicks_enabled( clicks );

            res = cDialog_ShowModal( dlg );

            set_clicks_enabled( FALSE );

            cDialog_dtor( dlg, FREE_MEMORY );

            sleep_time -= time();

            if( sleep_time < 0 ) sleep_time = -sleep_time;

            level_time += sleep_time;

            if( res == mrQuit )
            {
              if( mode == MODE_GAME && !draw_lose )
              {
                restarting = TRUE;

                update_high_scores( TRUE );

                mode = MODE_MENU;

                menu_choice = 2;

                draw_menu();

                // set_clicks_enabled( clicks );

                app.m_process->HelpContext = 1;
              }
              else if( mode == MODE_MENU ) exit_app = TRUE;
            }
            else if( res == mrRestart )
            {
              restarting = TRUE;

              ptr_message = Message_new( sizeof *ptr_message );

              ptr_message->msgid = MSG_RESTART;

              Message_post( ptr_message, "Lizard_Luncheon", get_own_id() );
            }
            else if( draw_lose )
            {
              restarting = TRUE;

              ptr_message = Message_new( sizeof *ptr_message );

              ptr_message->msgid = MSG_RESTART;

              Message_post( ptr_message, "Lizard_Luncheon", get_own_id() );
            }
            break;
          }
          cWinApp_defproc( app.m_process, msg );

          break;

        case MSG_RESTART:

          // strcpy( time_str, "1:00" );
          // strcpy( score_str, "Score: 0" );

          update_high_scores( TRUE );

          new_game();

          restarting = FALSE;

          break;
      }
      Message_delete( msg );
    }
    if( mode == MODE_MENU )
    {
      draw_menu();

      continue;
    }
    if( draw_lose )
    {
      flies_draw();

      continue;
    }
    if( cWinApp_has_focus( app.m_process ) && !restarting && !draw_lose )
    {
      if( !flies_count )
      {
        if( sec )
        {
          score += sec;

          // sprintf( score_str, "Score: %ld", score );

          sprintf( score_str, "%ld", score );

          sprintf( time_str, "%01d:%02d", min, sec );

          draw_page1();

          flies_draw();
        }
        next_level();

        continue;
      }
      on_key();

      flies_move();

      cur_time = time();

      t = level_time - cur_time;

      if( t < 0 ) t = -t;

      if( t != old_t )
      {
        min = (int)(( TIMEOUT - t ) / 60 );

        sec = (int)(( TIMEOUT - t ) % 60 );

        if( t >= TIMEOUT && flies_count )
        {
          strcpy( time_str, "0:00" );

          draw_page1();

          flies_draw();

          if( update_high_scores( TRUE ))
          {
            restarting = TRUE;

            mode = MODE_MENU;

            draw_menu();

            set_clicks_enabled( FALSE );

            app.m_process->HelpContext = 1;
          }
          else
          {
            draw_lose = TRUE;

            any_key = FALSE;

            flies_draw();

            MSequence_play_background( &mus_lose );

            cWinApp_pause( app.m_process, 1000 );

            any_key = TRUE;
          }
        }
        else sprintf( time_str, "%01d:%02d", min, sec );

        draw_page1();

        old_t = t;

        vibrate( 0 );
      }
    }
  }
  flies_delete();

  DirectKeyboard_dtor( pdk, FREE_MEMORY );

  BitmapSequence_dtor( &bmp_end, LEAVE_MEMORY );

  BitmapSequence_dtor( &bmp_menu, LEAVE_MEMORY );

  set_clicks_enabled( clicks );

  vibrate( 0 );

  release_music();

  release_high_scores();

  return 0L;
}
