/*
 * FILE: compete.c
 *
 * HISTORY:
 *   May 15, 2001 Created by Dmitry Novikov
 */
#include "main.h"
#include "utils.h"
#include "train.h"

struct Buffer *ptr_buffer_char, *ptr_buffer_long;

int tik_time;

/*
 * FUNCTION: cSquat_draw_game_net
 *
 * DESCRIPTION: Draws the competition
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
static void cSquat_draw_game_net( struct DisplayGraphics* ptr_displ,
  struct cWinApp* ptr_win_app, bool beging )
{
  if( beging )
  {
    DisplayGraphics_set_color( ptr_displ, CLR_WHITE );

    DisplayGraphics_fill_rect( ptr_displ, 0, 0, 160, 100 );

    DisplayGraphics_set_color( ptr_displ, CLR_BLACK );

    DisplayGraphics_set_font( ptr_displ, cool_bold_font );

    DisplayGraphics_draw_text( ptr_displ,"Waiting for link...", 30, 45 );
  }
  if( !beging )
  {
    long tmp = 11 * power;

    AppGeneric_clear_screen();

    if( status < 7 )
    {
      DisplayGraphics_draw_bitmap( ptr_displ,
        BitmapSequence_get_bitmap( &sphere, status ), 0, 0, BM_NORMAL );
    }
    else
    {
     DisplayGraphics_draw_bitmap( ptr_displ,
        BitmapSequence_get_bitmap( &sphere, 14 - status ), 0, 0, BM_NORMAL );
    }
    cSquat_draw_weight( ptr_displ, status );

    // status bar
    if( weight < 1000 )
    {
      sprintf( res, "%03d", weight );
    }
    else
    {
      sprintf( res, "%04d", weight );
    }
    DisplayGraphics_set_font ( ptr_displ, mini_bold_font );

    DisplayGraphics_set_color( ptr_displ, CLR_BLACK );

    DisplayGraphics_draw_rect( ptr_displ, 0, 80, 160, 20 );

    if( your_step )
    {
      DisplayGraphics_set_color( ptr_displ, CLR_LTGRAY );

      DisplayGraphics_fill_rect( ptr_displ, 41,
        93, (int) (( tmp * (long) stamina ) / 10000 ), 3 );

      DisplayGraphics_set_color( ptr_displ, CLR_BLACK );

      DisplayGraphics_draw_rect( ptr_displ, 40,
        92, (int) (( tmp * (long) max_stamina ) / 10000 + 2 ), 5 );

      DisplayGraphics_draw_line( ptr_displ,
        (int)( 38 + ( 11 * weight ) / 100 + 2 ),
        91, (int)( 38 + ( 11 * weight ) / 100 + 2 ), 97 );

      DisplayGraphics_draw_text( ptr_displ, "Power:", 3, 89 );
    }
    else
    {
      DisplayGraphics_set_color( ptr_displ, CLR_BLACK );

      DisplayGraphics_draw_text( ptr_displ, sz_nicks, 3, 90 );
    }
    DisplayGraphics_set_color( ptr_displ, CLR_BLACK );

    DisplayGraphics_draw_text( ptr_displ, "Weight:", 3, 81 );

    DisplayGraphics_draw_text( ptr_displ, res, 40, 81 );

    DisplayGraphics_draw_text( ptr_displ, "lbs", 70, 81 );
  }
  if( has_focus()) DisplayGraphics_show( ptr_displ );
}

/*
 * FUNCTION: cSquat_apprun_net
 *
 * DESCRIPTION: The main loop of the competition
 *
 * PARAMETERS:
 *
 * RETURNS:
 */
int cSquat_apprun_net( struct cWinApp* ptr_win_app, bool csquat_status_flag )
{
  delivery_t delivery_result;

  int i,old_status = 0;

  int your_result = 0, his_result = 0;

  int tik_enter = 0, tik_begin = 0, dlg_res = 0, tik_ping = 0;

  bool exit = FALSE, end_fix = TRUE, end = FALSE, exit_game = FALSE;

  bool exit_level = FALSE, f_enter = FALSE, send_mess = FALSE;

  bool lift = FALSE, lift_down = FALSE, dialog_show = FALSE, lift_up = TRUE;

  bool connfai = FALSE, lnkoff = FALSE, partsurr = FALSE;

  struct cDialog* dlg = NULL, *send_dlg = NULL;

  struct cDialog *fin_dlg = NULL;

  set_critical_mode( TRUE );

  ptr_win_app->HelpContext = 2;

  weight = 300;

  begin = TRUE;

  my_id = get_own_id();

  old_channel = get_appchannel();

  if( !csquat_status_flag )
  {
    while(( ptr_message = cWinApp_get_message( ptr_win_app, 160,
      MSG_USER, MSG_USER + 1 )))
    {
      Message_delete( ptr_message );
    }
    set_critical_mode( FALSE );

    cWinApp_cancel_shutup( ptr_win_app );

    partner_id = select_game_partner( main_module.m_process,
      "\nLocker Room - Bench", SGP_NONE, sz_partner_nickname );

    if( partner_id == 0 )
    {
      exit = exit_level = end = TRUE;

      begin = FALSE;

      return 0;
    }
  }
  else
  {
     set_critical_mode( FALSE );

     set_best_appchannel( RF_GROUP_GAMES );

     begin_message = Message_new( sizeof *begin_message );

     begin_message->msgid = MSG_USER;

     begin_message->param[ 0 ] = 23;

     Message_deliver( begin_message, "Locker_Room-Bench",
       partner_id, 60 * 1000 );

     your_step = FALSE;

     send_mess = TRUE;

     tik_begin = -1;
  }
  sz_nicks=(char*) malloc( 15 * sizeof( char ));

  strcpy( sz_nicks, sz_partner_nickname );

  strcat( sz_nicks, "'s turn." );

  load_settings();

  max_stamina = 100;

  minus_time = time();

  status = 0;

  stamina = max_stamina;

  fix = TRUE;

  set_bar( weight );

  lift = FALSE;

  if( csquat_status_flag )
  {
    your_step = FALSE;
  }
  else your_step = TRUE;

  if( !exit )
  {
    cSquat_draw_game_net( main_module.m_gfx, ptr_win_app, FALSE );

    dialog_show = TRUE;

    dlg = (struct cDialog*) malloc( sizeof *dlg );

    cDialog_ctor( dlg, 0, str_Waiting_link, mbs2, 0, ptr_win_app );

    set_clicks_enabled( TRUE );

    cDialog_Show( dlg );
  }
  while( !exit )
  {
    your_level = his_level = FALSE;

    his_result = your_result = 0;

    stamina = max_stamina;

    status = 0;

    fix = TRUE;

    exit_level = FALSE;

    set_bar( weight );

    lift = FALSE;

    if( csquat_status_flag )
    {
      your_step = FALSE;
    }
    else your_step = TRUE;

    while( !exit_level )
    {
      if( begin ) sleep( 80 );

      if( !send_mess && begin &&
        (( tik_begin >= 0 && tik_begin < 2 && csquat_status_flag ) ||
          ( tik_begin >= 2 && !csquat_status_flag )))
      {
        if( tik_begin == 0 || tik_begin == 2 )
        {
          begin_message = Message_new( sizeof *begin_message );

          begin_message->msgid = MSG_RESULT;

          ptr_buffer_char = (struct Buffer*) malloc( sizeof *ptr_buffer_char );

          Buffer_ctor( ptr_buffer_char, 5 * 8, 8 );

          for( i = 0; i < 5; i++ )
          {
            Buffer_store_string( ptr_buffer_char,
              high_scores[ i ].nickname, i * 8 );
          }
          Message_attach_buffer( begin_message, ptr_buffer_char );

          Message_deliver( begin_message, "Locker_Room-Bench",
            partner_id, 45 * 1000 );
        }
        else if( tik_begin == 1 || tik_begin == 3 )
        {
          begin_message = Message_new( sizeof *begin_message );

          begin_message->msgid = MSG_RESULT;

          ptr_buffer_long = (struct Buffer*) malloc( sizeof *ptr_buffer_long );

          Buffer_ctor( ptr_buffer_long, 5 * sizeof( long ), sizeof( long ));

          for( i = 0; i < 5; i++ )
          {
            Buffer_set_long( ptr_buffer_long, i * sizeof( long ),
              ( long ) high_scores[ i ].score );
          }
          Message_attach_buffer( begin_message, ptr_buffer_long );

          Message_deliver( begin_message, "Locker_Room-Bench",
            partner_id, 45 * 1000 );
        }
        send_mess = TRUE;
      }
      if( your_step )
      {
        if( !fix && !end && has_focus())
        {
          if( power * stamina < weight * 100 && !dialog_show )
          {
            if( status < 7 )
            {
              status += 1;

              MSequence_play( &down_squat );
            }
            if( status > 7 )
            {
              status -= 1;

              MSequence_play( &down_squat );
            }
            lift_up = FALSE;

            if( !lift_down )
            {
              init_message = Message_new( sizeof *init_message );

              init_message->msgid = MSG_USER;

              init_message->param[ 0 ] = status;

              Message_post( init_message, "Locker_Room-Bench", partner_id );
            }
          }
          else if( !end && !dialog_show )
          {
            if( status >= 7 )
            {
              status += 1;

              MSequence_play( &up_squat );
            }
            if( status < 7 && status > 0 )
            {
              status -= 1;

              MSequence_play( &up_squat );
            }
            if( status == 14 ) status = 0;

            lift_down = FALSE;

            if( !lift_up )
            {
              init_message = Message_new( sizeof *init_message );

              init_message->msgid = MSG_USER;

              init_message->param[ 0 ] = status;

              Message_post( init_message, "Locker_Room-Bench", partner_id );
            }
          }
          if( !status && lift && !end && !dialog_show )
          {
            if( has_focus())
            {
              cSquat_draw_game_net( main_module.m_gfx, ptr_win_app, FALSE );
            }
            your_level = TRUE;

            your_result = 2;

            your_step = FALSE;

            begin_message = Message_new( sizeof *begin_message );

            begin_message->msgid = MSG_USER;

            begin_message->param[ 0 ] = 21;

            Message_deliver( begin_message, "Locker_Room-Bench",
              partner_id, 45000 );

            send_mess = TRUE;
          }
          if( status == 7 )
          {
            lift = TRUE;

            lift_down = TRUE;
          }
          if( status == 0 ) lift_up = TRUE;

          if( power * max_stamina < weight * 100 && !end && status == 7 )
          {
            your_level = TRUE;

            your_step = FALSE;

            your_result = 1;

            begin_message = Message_new( sizeof *begin_message );

            begin_message->msgid = MSG_USER;

            begin_message->param[ 0 ] = 22;

            Message_deliver( begin_message, "Locker_Room-Bench",
              partner_id, 45000 );

            send_mess = TRUE;
          }
          tik_time = ( tik_time + 1 ) % 8;

          if( !tik_time && stamina > 5 && !dialog_show )
          {
            stamina -= 2;

            MSequence_play_background( &count_down );
          }
        }
        else if( !send_dlg && !end && !dlg && !begin && has_focus())
        {
          cSquat_draw_game_net( main_module.m_gfx, ptr_win_app, FALSE );

          dialog_show = TRUE;

          send_dlg = (struct cDialog*) malloc( sizeof *send_dlg );

          cDialog_ctor( send_dlg, 0,
            "Your turn.\nWhen ready, press <Ok>.", mbOk, 0, ptr_win_app );

          MSequence_play( &begin_play );

          set_clicks_enabled( FALSE );

          if( max_stamina * power > weight * 100 )
          {
            stamina = weight * 100 / power + 1;
          }
          else stamina = max_stamina;

          if( stamina > 100 ) stamina = 100;
        }
      }
      if( !dialog_show && has_focus())
      {
        DirectKeyboard_scan( ptr_keyboard );

        if( DirectKeyboard_is_key_pressed( ptr_keyboard, KEY_ENTER ) &&
           !f_enter )
        {
          if( your_step && !fix && !end )
          {
            if( tik_enter == depletion )
            {
              if( max_stamina > 0 )
              {
                max_stamina--;
              }
              tik_enter = 0;
            }
            tik_enter++;

            if( stamina < max_stamina )
            {
              stamina += 2;

              MSequence_play_background( &count_up );
            }
          }
          f_enter = TRUE;
        }
        else if( !DirectKeyboard_is_key_pressed( ptr_keyboard, KEY_ENTER ))
        {
          f_enter = FALSE;
        }
      }
      ptr_message = cWinApp_get_message( main_module.m_process,
        60, 0, MSG_USER + 1 );

      if( ptr_message )
      {
        // check id
        if( ptr_message->cyid_from == partner_id ||
           ptr_message->cyid_from == my_id )
        {
          switch( ptr_message->msgid )
          {
            case MSG_LOSTFOCUS:

              sleep( 50 );

              break;

            case MSG_GOTFOCUS:

              sleep( 50 );

              break;

            case MSG_QUIT:
            case MSG_SHUTUP:

              if( !end )
              {
                end_message = Message_new( sizeof *end_message );

                end_message->msgid = MSG_USER;

                end_message->param[ 0 ] = 20;

                Message_deliver( end_message, "Locker_Room-Bench",
                  partner_id, 60 * 1000 | MSG_AUTODELETE );

                sleep( 200 );
              }
              end = exit = exit_level = TRUE;

              set_clicks_enabled( FALSE );

              if( dlg ) cDialog_dtor( dlg, FREE_MEMORY );

              dlg = NULL;

              if( send_dlg ) cDialog_dtor( send_dlg, FREE_MEMORY );

              send_dlg = NULL;

              dialog_show = FALSE;

              return 4;

            case MSG_USER:

              if(!end)
              {
                old_status = (int) ptr_message->param[ 0 ];

                if( old_status < 20 ) status = old_status;

                if( old_status == 20 && exit == FALSE && !end )
                {
                  status = 0;

                  if( send_dlg )
                  {
                    cDialog_dtor( send_dlg, FREE_MEMORY );

                    send_dlg = NULL;
                  }
                  if( dlg )
                  {
                    cDialog_dtor( dlg, FREE_MEMORY );

                    dlg = NULL;
                  }
                  if( has_focus())
                  {
                    if( !begin )
                    {
                      strncpy( sz_nickname, finder.mf.f_nick, 8 );

                      sel_res = save_results( weight, sz_nickname );
                    }
                    MSequence_ctor( &linkoff, "no-contact-squat.mus" );

                    send_dlg = (struct cDialog*) malloc( sizeof *send_dlg );

                    if( !begin )
                    {
                      cDialog_ctor( send_dlg, 0, str_Partner_surrender,
                        mbQuit | mbCancel, 0, ptr_win_app );
                    }
                    else
                    {
                      cDialog_ctor( send_dlg, 0, "Connection failed.",
                        mbOk | mbs2, 0, ptr_win_app );
                    }
                    MSequence_play( &linkoff );

                    set_clicks_enabled( TRUE );

                    cDialog_ShowModal( send_dlg );

                    MSequence_dtor( &linkoff, LEAVE_MEMORY );

                    if( send_dlg->ModalResult == mrQuit ||
                       send_dlg->ModalResult == mrOk ||
                         ( begin && send_dlg->ModalResult == mrCancel ))
                    {
                      end = exit = exit_level = TRUE;

                      Message_delete( ptr_message );

                      cDialog_dtor( send_dlg, FREE_MEMORY );

                      if( dlg ) cDialog_dtor( dlg, FREE_MEMORY );

                      if( begin )
                      {
                        if( !csquat_status_flag )
                        {
                          return 0;
                        }
                        return 4;
                      }
                      return 3;
                    }
                    set_clicks_enabled( FALSE );

                    end = TRUE;

                    cDialog_dtor( send_dlg, FREE_MEMORY );

                    if( !dlg ) dialog_show = FALSE;

                    AppGeneric_clear_screen();

                    send_dlg = NULL;
                  }
                  else if( !begin )
                  {
                    partsurr = TRUE;
                  }
                  else connfai = TRUE;
                }
                if( old_status == 21 )
                {
                   status = 0;

                   if( !end )
                   {
                     if( !your_level )
                     {
                       your_step = TRUE;
                     }
                     his_level = TRUE;

                     his_result = 2;
                   }
                }
                if( old_status == 22 )
                {
                  status = 0;

                  if( !end )
                  {
                    if( !your_level )
                    {
                      your_step = TRUE;
                    }
                    his_level = TRUE;

                    his_result = 1;
                  }
                }
                if( old_status == 23 )
                {
                  status == 0;

                  set_appchannel( get_appchannel_of( partner_id ));
                }
                if( old_status == 24 )
                {
                  tik_ping = 0;
                }
              }
              break;

            case MSG_KEYDOWN:

              switch( Message_get_key_param( ptr_message )->scancode )
              {
                case KEY_ESC:

                  if( has_focus())
                  {
                    if( begin )
                    {
                      cDialog_dtor( dlg, FREE_MEMORY );

                      dlg = NULL;

                      end_message = Message_new( sizeof *end_message );

                      end_message->msgid = MSG_USER;

                      end_message->param[ 0 ] = 20;

                      Message_deliver( end_message, "Locker_Room-Bench",
                        partner_id, 60 * 1000 | MSG_AUTODELETE );

                      sleep( 200 );

                      exit = exit_level = end = TRUE;
                    }
                    else if( !dlg && !send_dlg )
                    {
                      dialog_show = TRUE;

                      dlg = (struct cDialog*) malloc( sizeof *dlg );

                      cDialog_ctor( dlg, 0, str_Really_exit,
                        mbQuit | mbCancel, 0, ptr_win_app );

                      MSequence_play( &dialog_squat );

                      set_clicks_enabled( TRUE );
                    }
                    else if( dlg )
                    {
                      if(!send_dlg ) dialog_show = FALSE;

                      set_clicks_enabled( FALSE );

                      cDialog_dtor( dlg, FREE_MEMORY );

                      dlg = NULL;
                    }
                    else if( send_dlg )
                    {
                      if(!dlg) dialog_show = FALSE;

                      cDialog_dtor( send_dlg, FREE_MEMORY );

                      set_clicks_enabled( FALSE );

                      send_dlg = NULL;

                      if( !end ) fix = FALSE;
                    }
                  }
                  break;

                case KEY_HELP:
                  if( !dlg && !send_dlg && !begin && has_focus() &&
                    !( Message_get_key_param( ptr_message )->mask &
                       KEYMASK_AUTOREPEAT ))
                  {
                    sleep( 100 );

                    cWinApp_defproc( ptr_win_app, ptr_message );
                  }
                  break;

                default:

                  cWinApp_defproc( ptr_win_app, ptr_message );

                  break;
              }
              break;

            case MSG_RESULT:

              if( !csquat_status_flag )
              {
                 tik_begin++;
              }
              if( tik_begin >= 2 && csquat_status_flag ) tik_begin++;

              if(( tik_begin == 1 || tik_begin == 3 ) && !end )
              {
                set_appchannel( get_appchannel_of( partner_id ));

                for( i = 0; i < 5; i++ )
                {
                  Buffer_load_string( Message_get_buffer( ptr_message ),
                    send_nickname[ i ], 8 * i, 8 );
                }
              }
              else if(( tik_begin == 0 || tik_begin == 2 || tik_begin == 4 ) &&
                       !end )
              {
                for( i = 0; i < 5; i++ )
                {
                  sort_results((int)Buffer_get_long( Message_get_buffer(
                    ptr_message ), i * sizeof( long )), send_nickname[ i ] );
                }
                save_res();

                load_results();
              }
              break;

            default:

               cWinApp_defproc( ptr_win_app, ptr_message );

               break;
          }
          if( dlg && ( Message_get_key_param( ptr_message )->scancode !=
            KEY_ESC ) && has_focus())
          {
            if( cDialog_proc( dlg, ptr_message ) &&
               dlg->ModalResult != mrNone )
            {
              if( dlg->ModalResult == mrOk || dlg->ModalResult == mrCancel ||
                 dlg->ModalResult == mrQuit )
              {
                if(dlg->ModalResult == mrOk||dlg->ModalResult == mrQuit)
                {
                  exit = exit_level = TRUE;

                  if(!end)
                  {
                    end_message = Message_new( sizeof *end_message );

                    end_message->msgid = MSG_USER;

                    end_message->param[ 0 ] = 20;

                    Message_deliver( end_message, "Locker_Room-Bench",
                      partner_id, 60 * 1000 | MSG_AUTODELETE );

                    sleep( 200 );
                  }
                }
                set_clicks_enabled( FALSE );

                cDialog_dtor( dlg, FREE_MEMORY );

                if( !send_dlg ) dialog_show = FALSE;

                dlg = NULL;
              }
            }
          }
          else if( send_dlg &&
            ( Message_get_key_param( ptr_message )->scancode != KEY_ESC ) &&
               has_focus())
          {
            if( cDialog_proc( send_dlg, ptr_message ) &&
               send_dlg->ModalResult != mrNone )
            {
              if( send_dlg->ModalResult == mrOk)
              {
                set_clicks_enabled( FALSE );

                cDialog_dtor( send_dlg, FREE_MEMORY );

                if( !dlg ) dialog_show = FALSE;

                send_dlg = NULL;

                fix = FALSE;
              }
            }
          }
        }
        else
        { // id is wrong
          cWinApp_defproc( ptr_win_app, ptr_message );
        }
        Message_delete( ptr_message );

        ptr_message = NULL;
      }
      if( has_focus())
      {
        if( dialog_show )
        {
          if( dlg )
          {
             if( !begin ) cDialog_Show( dlg );

             if( !begin ) set_clicks_enabled( TRUE );
          }
          else if( send_dlg )
          {
             cDialog_Show( send_dlg );

             set_clicks_enabled( TRUE );
          }
        }
        else
        {
          cSquat_draw_game_net( main_module.m_gfx, ptr_win_app, FALSE );
        }
      }
      else
      {
        sleep( 100 );
      }
      // verify the sending
      if( send_mess )
      {
        delivery_result = Message_check_delivery( begin_message );

        if( delivery_result == DL_SUCCESS )
        {
          send_mess = FALSE;

          if( begin && tik_begin >= 0 )
          {
            tik_begin++;
          }
          else tik_begin = 0;

          Message_delete( begin_message );
        }
        else if( delivery_result == DL_ABORT || delivery_result == DL_TIMEOUT )
        {
          send_mess = FALSE;

          Message_delete( begin_message );

          if( has_focus() && !end )
          {
            if( begin )
            {
              if( dlg ) cDialog_dtor( dlg, FREE_MEMORY );

              dlg = (struct cDialog*) malloc( sizeof *dlg );

              cDialog_ctor( dlg, 0, "Connection failed.", mbOk | mbs2, 0,
                ptr_win_app );

              set_clicks_enabled( TRUE );

              cDialog_ShowModal( dlg );

              if( dlg->ModalResult == mrOk || dlg->ModalResult == mrCancel)
              {
                begin = FALSE;

                exit = exit_level = end = TRUE;
              }
              cDialog_dtor( dlg, FREE_MEMORY );

              dlg = NULL;
            }
            else
            {
              if( send_dlg ) cDialog_dtor( send_dlg, FREE_MEMORY );

              if( dlg ) cDialog_dtor( dlg, FREE_MEMORY );

              dlg = NULL;

              cWinApp_pause( ptr_win_app, 100 );

              send_dlg = (struct cDialog*) malloc( sizeof *send_dlg );

              end = TRUE;

              cDialog_ctor( send_dlg, 0, str_Link_off,
                mbQuit | mbCancel | mbs1, 0, ptr_win_app );

              set_clicks_enabled( TRUE );

              cDialog_ShowModal( send_dlg );

              if( send_dlg->ModalResult == mrQuit )
              {
                exit_level = exit = end = TRUE;
              }
              set_clicks_enabled( FALSE );

              end = TRUE;

              cDialog_dtor( send_dlg, FREE_MEMORY );

              send_dlg = NULL;

              dialog_show = FALSE;
            }
          }
          else if( begin )
          {
            connfai = TRUE;
          }
          else lnkoff = TRUE;
        }
      }
      if( connfai && has_focus())
      {
        if( dlg ) cDialog_dtor( dlg, FREE_MEMORY );

        dlg = NULL;

        dlg = (struct cDialog*) malloc( sizeof *dlg );

        cDialog_ctor( dlg, 0, "Connection failed.",
          mbOk | mbs2, 0, ptr_win_app);

        set_clicks_enabled( TRUE );

        cSquat_draw_game_net( main_module.m_gfx, ptr_win_app, FALSE );

        cDialog_ShowModal( dlg );

        if( dlg->ModalResult == mrOk || dlg->ModalResult == mrCancel )
        {
          begin = FALSE;

          exit = exit_level = end = TRUE;
        }
        cDialog_dtor( dlg, FREE_MEMORY );

        dlg = NULL;

        connfai = FALSE;
      }
      else if( lnkoff && has_focus() && !end )
      {
        if( send_dlg ) cDialog_dtor( send_dlg, FREE_MEMORY );

        send_dlg = (struct cDialog*) malloc( sizeof *send_dlg );

        if( dlg ) cDialog_dtor( dlg, FREE_MEMORY );

        dlg = NULL;

        cWinApp_pause( ptr_win_app, 200 );

        end = TRUE;

        cSquat_draw_game_net( main_module.m_gfx, ptr_win_app, FALSE );

        if( !begin )
        {
          cDialog_ctor( send_dlg, 0, str_Link_off,
            mbQuit | mbCancel | mbs1, 0, ptr_win_app );
        }
        else
        {
          cDialog_ctor( send_dlg, 0, "Connection failed.",
            mbOk | mbs2, 0, ptr_win_app );
        }
        set_clicks_enabled( TRUE );

        cDialog_ShowModal( send_dlg );

        set_clicks_enabled( FALSE );

        if( send_dlg->ModalResult == mrQuit || send_dlg->ModalResult == mrOk ||
          ( send_dlg->ModalResult == mrCancel && begin ))
        {
          exit_level = exit = end = TRUE;
        }
        end = TRUE;

        cDialog_dtor( send_dlg, FREE_MEMORY );

        send_dlg = NULL;

        dialog_show = FALSE;

        lnkoff = FALSE;
      }
      else if( partsurr && has_focus() && !end )
      {
        MSequence_ctor( &linkoff, "no-contact-squat.mus" );

        send_dlg = (struct cDialog*) malloc( sizeof *send_dlg );

        cDialog_ctor( send_dlg, 0, str_Partner_surrender,
          mbQuit | mbCancel, 0, ptr_win_app );

        MSequence_play( &linkoff );

        set_clicks_enabled( TRUE );

        cSquat_draw_game_net( main_module.m_gfx, ptr_win_app, FALSE );

        cDialog_ShowModal( send_dlg );

        set_clicks_enabled( FALSE );

        strncpy( sz_nickname, finder.mf.f_nick, 8 );

        sel_res = save_results( weight, sz_nickname );

        MSequence_dtor( &linkoff, LEAVE_MEMORY );

        if( send_dlg->ModalResult == mrQuit )
        {
          end = exit = exit_level = TRUE;

          Message_delete( ptr_message );

          cDialog_dtor( send_dlg, FREE_MEMORY );

          return 3;
        }
        end = TRUE;

        cDialog_dtor( send_dlg, FREE_MEMORY );

        if( !dlg ) dialog_show = FALSE;

        AppGeneric_clear_screen();

        send_dlg = NULL;

        partsurr = FALSE;
      }
      real_time = time();

      if( real_time - minus_time > 9 && !end )
      {
        minus_time = real_time;

        tik_ping += 1;

        init_message = Message_new( sizeof *init_message );

        init_message->msgid = MSG_USER;

        init_message->param[ 0 ] = 24;

        Message_post( init_message, "Locker_Room-Bench", partner_id );

        if( tik_ping == 6 )
        { // link off
          if( has_focus())
          {
            if( send_dlg ) cDialog_dtor( send_dlg, FREE_MEMORY );

            if( dlg ) cDialog_dtor( dlg, FREE_MEMORY );

            dlg = NULL;

            cWinApp_pause( ptr_win_app, 200 );

            send_dlg = (struct cDialog*) malloc( sizeof *send_dlg );

            end = TRUE;

            if( !begin )
            {
              cDialog_ctor( send_dlg, 0, str_Link_off,
                mbQuit | mbCancel | mbs1, 0, ptr_win_app );
            }
            else
            {
              cDialog_ctor( send_dlg, 0, "Connection failed.",
                mbOk | mbs2, 0, ptr_win_app );
            }
            set_clicks_enabled( TRUE );

            cSquat_draw_game_net( main_module.m_gfx, ptr_win_app, FALSE );

            cDialog_ShowModal( send_dlg );

            set_clicks_enabled( FALSE );

            if( send_dlg->ModalResult == mrQuit ||
              send_dlg->ModalResult == mrOk ||
                ( send_dlg->ModalResult == mrCancel && begin ))
            {
              exit_level = exit = end = TRUE;

              begin = FALSE;
            }
            if( send_dlg->ModalResult == mrCancel )
            {
              end = TRUE;
            }
            end = TRUE;

            cDialog_dtor( send_dlg, FREE_MEMORY );

            send_dlg = NULL;

            begin = FALSE;

            dialog_show = FALSE;
          }
          else lnkoff = TRUE;
        }
      }
      if( your_level && his_level ) exit_level = TRUE; // the end of the level

      if( begin && tik_begin >= 4 )
      {
        cDialog_dtor( dlg, FREE_MEMORY );

        dlg = NULL;

        dialog_show = FALSE;

        begin = FALSE;
      }
    }
    if( !exit && !end )
    {
      if( !end && !( your_result == 2 && his_result == 2 ))
      {
        if( dlg ) cDialog_dtor( dlg, FREE_MEMORY );

        dlg = NULL;

        if( send_dlg ) cDialog_dtor( send_dlg, FREE_MEMORY );

        dlg = NULL;

        while(( ptr_message = cWinApp_get_message( main_module.m_process,
          40, MSG_KEYMIN, MSG_KEYMAX )))
        {
          Message_delete( ptr_message );
        }
        if( your_result == 2 )
        {
          cWinApp_pause( ptr_win_app, 250 );

          MSequence_ctor( &winsquat, "win.mus" );

          while( !has_focus());

          cSquat_draw_game_net( main_module.m_gfx,ptr_win_app, FALSE );

          fin_dlg = (struct cDialog*) malloc( sizeof *fin_dlg );

          cDialog_ctor( fin_dlg, 0, str_You_win, mbQuit | mbCancel,
            0, ptr_win_app );

          MSequence_play( &winsquat );

          set_clicks_enabled( TRUE );

          cDialog_ShowModal( fin_dlg );

          set_clicks_enabled( FALSE );

          strncpy( sz_nickname, finder.mf.f_nick, 8 );

          sel_res = save_results( weight, sz_nickname );

          MSequence_dtor( &winsquat, LEAVE_MEMORY );

          if( fin_dlg->ModalResult == mrQuit )
          {
            cDialog_dtor( fin_dlg, FREE_MEMORY );

            exit = exit_level = end = TRUE;

            return 3;
          }
          sel_res = 10;

          cDialog_dtor( fin_dlg, FREE_MEMORY );

          end = TRUE;
        }
        else if( his_result == 2 )
        {
          MSequence_ctor( &losesquat, "lose.mus" );

          cWinApp_pause( ptr_win_app, 250 );

          while( !has_focus());

          cSquat_draw_game_net( main_module.m_gfx, ptr_win_app, FALSE );

          fin_dlg = (struct cDialog*) malloc( sizeof *fin_dlg );

          cDialog_ctor( fin_dlg, 0, str_You_lose, mbQuit | mbCancel,
            0, ptr_win_app );

          MSequence_play( &losesquat );

          set_clicks_enabled( TRUE );

          cDialog_ShowModal( fin_dlg );

          set_clicks_enabled( FALSE );

          save_results( weight, sz_partner_nickname );

          MSequence_dtor( &losesquat, LEAVE_MEMORY );

          if( fin_dlg->ModalResult == mrQuit )
          {
            exit = exit_level = TRUE;
          }
          end = TRUE;

          cDialog_dtor( fin_dlg, FREE_MEMORY );
        }
        else
        {
          MSequence_ctor( &drawsquat, "drow.mus" );

          while(!has_focus());

          cSquat_draw_game_net( main_module.m_gfx, ptr_win_app, FALSE );

          fin_dlg = (struct cDialog*) malloc( sizeof *fin_dlg );

          cDialog_ctor( fin_dlg, 0, str_Draw, mbQuit | mbCancel, 0,
            ptr_win_app );

          set_clicks_enabled( TRUE );

          MSequence_play( &drawsquat );

          cDialog_ShowModal( fin_dlg );

          set_clicks_enabled( FALSE );

          MSequence_dtor( &drawsquat, LEAVE_MEMORY );

          cWinApp_pause( ptr_win_app, 300 );

          if( fin_dlg->ModalResult == mrQuit )
          {
            exit = exit_level = end = TRUE;
          }
          else
          {
            end = TRUE;
          }
          cDialog_dtor( fin_dlg, FREE_MEMORY );
        }
        fix = TRUE;

        fin_dlg = NULL;

        dialog_show = FALSE;
      }
      if( weight < 1000 && !end ) weight += 25;

      exit_level = FALSE;
    }
  }
  set_clicks_enabled( TRUE );

  if( dlg ) cDialog_dtor( dlg, FREE_MEMORY );

  dlg = NULL;

  if( send_dlg ) cDialog_dtor( dlg, FREE_MEMORY );

  send_dlg = NULL;

  dialog_show = FALSE;

  if( csquat_status_flag || exit_game ) return 4;

  return 0;
}
