/*
 * FILE: main.c
 *
 * HISTORY:
 *   May 15, 2001 Created by Dmitry Novikov
 */
#include "main.h"
#include "utils.h"
#include "train.h"
#include "compete.h"

struct module_t main_module;

int stat_sphere; // flag for a list pointer

struct Message *ptr_message, *init_message, *begin_message, *end_message;

struct MSequence up_squat, down_squat, dialog_squat, hand_squat,
  count_up, count_down, menu_select, intro_music,
  begin_play, linkoff, winsquat, drawsquat,losesquat;

char old_channel;

cyid_t partner_id, my_id;

bool begin;

struct cDialog need_dlg;

struct Input* ptr_input;

struct Output* ptr_output;

struct BitmapSequence sphere, hands, menu, table, bearing;

char* sz_nickname;

char* sz_partner_nickname;

char* sz_nicks;

char* str_name, *str_weight;

char* result_table;

struct Score score_archive;

char* send_nickname[ 5 ];

int record_number;

bool csquat_status_flag; // start flag, TRUE - if the other player was called

time_t minus_time, real_time;

char res[ 5 ]; // result on the panel

char send_res[ 9 ];

int bar[ 6 ];

int sel;

long weight;

long power; // maximum starting weight

int add_power;

long stamina;

long max_stamina; // maximum starting power

long depletion;

int status, old_status;

int sel_res;

bool lift; // marks the lift

int tik_lift; // counts the lift

bool flag_hands;

int tik_hands;

bool fix = TRUE; // bearing weight

bool your_step = TRUE;

bool your_level = FALSE;

bool his_level = FALSE;

struct DirectKeyboard* ptr_keyboard;

/*
 * FUNCTION: cSquat_draw_game
 *
 * DESCRIPTION: Draws the menu
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
static void cSquat_draw_game( struct DisplayGraphics* ptr_displ )
{
  DisplayGraphics_set_draw_mode( ptr_displ, DM_PUT );

  draw_lib( 4, 0, 0, 0, BM_NORMAL );

  switch( stat_sphere )
  {
    case 0:

      draw_lib( 4, 1, 101, 49, BM_NORMAL );

      break;

    case 1:

      draw_lib( 4, 2, 90, 59, BM_NORMAL );

      break;

    case 2:

      draw_lib( 4, 3, 91, 69, BM_NORMAL );

      break;

    case 3:

      draw_lib( 4, 4, 105, 79, BM_NORMAL );

      break;
  }
  DisplayGraphics_show( ptr_displ );
}

/*
 * FUNCTION: cSquat_apprun_menu
 *
 * DESCRIPTION: The menu's main loop
 *
 * PARAMETERS:
 *
 * RETURNS:
 */
static int cSquat_apprun_menu( struct cWinApp* ptr_win_app,
  bool csquat_status_flag, int sel )
{
  int flag_ret = 0;

  bool exit = FALSE, f_up = FALSE, f_down = FALSE;

  ptr_win_app->HelpContext = 0;

  set_clicks_enabled( FALSE );

  stat_sphere = sel - 1;

  while( !exit )
  {
    if( has_focus())
    {
      cSquat_draw_game( main_module.m_gfx );
    }
    ptr_message = cWinApp_get_message( ptr_win_app, 20, 0, MSG_USER + 1 );

    if( ptr_message )
    {
      switch( ptr_message->msgid )
      {
        case MSG_LOSTFOCUS:

          sleep( 50 );

          break;

        case MSG_GOTFOCUS:

          sleep( 50 );

          break;

        case MSG_KEYDOWN:

          if( Message_get_key_param( ptr_message )->scancode == KEY_UP &&
           !( Message_get_key_param( ptr_message )->mask & KEYMASK_AUTOREPEAT ))
          {
            stat_sphere--;

            if( stat_sphere < 0 ) stat_sphere = 3;

            MSequence_play( &menu_select );
          }
          else if( Message_get_key_param( ptr_message )->scancode == KEY_DOWN &&
           !( Message_get_key_param( ptr_message )->mask & KEYMASK_AUTOREPEAT ))
          {
            stat_sphere = ( stat_sphere + 1 ) % 4;

            MSequence_play( &menu_select );
          }
          else if( Message_get_key_param( ptr_message )->scancode ==
            KEY_ENTER && !( Message_get_key_param( ptr_message )->mask &
              KEYMASK_AUTOREPEAT ))
          {
            exit = TRUE;

            flag_ret = stat_sphere + 1;
          }
          else if( Message_get_key_param( ptr_message )->scancode == KEY_ESC )
          {
            exit = TRUE;

            set_clicks_enabled( TRUE );

            Message_delete( ptr_message );

            ptr_message = NULL;

            return 4;
          }
          else cWinApp_defproc( ptr_win_app,ptr_message );

          break;

        case MSG_QUIT:
        case MSG_SHUTUP:

          exit = TRUE;

          set_clicks_enabled( TRUE );

          return 4;

        default:

          cWinApp_defproc( ptr_win_app, ptr_message );

          break;
      }
      Message_delete( ptr_message );

      ptr_message = NULL;
    }
  }
  set_clicks_enabled( TRUE );

  return flag_ret;
}

/*
 * FUNCTION: main
 *
 * DESCRIPTION: Program entry point
 *
 * PARAMETERS:
 *   argc - number of arguments
 *   argv - an array of 'argc' arguments passed to the application
 *   start - TRUE if the application is being initialized, FALSE otherwise
 *
 * RETURNS: 0L
 */
long main( int argc, char* argv[], bool start )
{
  int result, index, i;

  stat_sphere = 0;

  sel_res = 10;

  MSequence_ctor( &intro_music, "title.mus" );

  MSequence_play_background( &intro_music );

  init_module( &main_module );

  MSequence_ctor( &dialog_squat, "dialog.mus" );

  MSequence_ctor( &hand_squat, "hand.mus" );

  MSequence_ctor(&count_up, "plus.mus");

  MSequence_ctor( &count_down, "minus.mus" );

  MSequence_ctor( &menu_select, "choice-menu.mus" );

  MSequence_ctor( &up_squat, "up.mus" );

  MSequence_ctor( &down_squat, "down.mus" );

  MSequence_ctor( &begin_play, "beginplay.mus" );

  BitmapSequence_ctor_Ex( &sphere, "sphere.pic" );

  BitmapSequence_ctor_Ex( &hands, "hands.pic" );

  BitmapSequence_ctor_Ex( &bearing, "bearing.pic" );

  ptr_keyboard = DirectKeyboard_get_instance();

  sz_nickname = (char *) malloc( 9 * sizeof( char ) );

  sz_partner_nickname = (char *) malloc( 9 * sizeof( char ));

  for( i = 0; i < 5; i++ )
  {
    send_nickname[ i ] = (char *) malloc( 9 * sizeof( char ));
  }
  if( argc != 1 )
  {
    begin = TRUE;

    partner_id = atoul( argv[ 1 ] );

    cWinApp_pause( main_module.m_process, 200 );

    strncpy( sz_partner_nickname, argv[ 2 ], 8 );

    csquat_status_flag = TRUE;

    your_step = FALSE;

    weight = 300;
  }
  else
  {
     csquat_status_flag = FALSE;

     your_step = TRUE;
  }
  Score_ctor( &score_archive, main_module.m_process->module );

  load_results();

  if( !csquat_status_flag )
  {
    result = cSquat_apprun_menu( main_module.m_process, csquat_status_flag, 1 );

    sel = 1;
  }
  else result = 2;

  while( result != 4 )
  {
    if( result == 0 )
    {
      result = cSquat_apprun_menu( main_module.m_process,
        csquat_status_flag, sel );

      sel = 1;
    }
    if( result == 1 )
    {
      result = cSquat_apprun_single( main_module.m_process );

      sel = 1;
    }
    if( result == 2 )
    {
      result = cSquat_apprun_net( main_module.m_process, csquat_status_flag );

      begin = FALSE;

      if( begin_message ) Message_delete( begin_message );

      if( init_message ) Message_delete( init_message );

      set_appchannel( old_channel );

      sel = 2;
    }
    if( result == 3 )
    {
      result = cSquat_apprun_res( main_module.m_process, csquat_status_flag );

      sel_res = 10;

      sel = 3;
    }
  }
  set_clicks_enabled( TRUE );

  while(( ptr_message = cWinApp_get_message( main_module.m_process,
    160, 0, MSG_USER + 4 )))
  {
    Message_delete( ptr_message );

    ptr_message = NULL;
  }
  free( sz_nickname );

  free( sz_partner_nickname );

  for( i = 0; i < 5; i++ ) free( send_nickname[ i ] );

  DirectKeyboard_dtor( ptr_keyboard, FREE_MEMORY );

  BitmapSequence_dtor( &sphere, LEAVE_MEMORY );

  BitmapSequence_dtor( &hands, LEAVE_MEMORY );

  BitmapSequence_dtor( &bearing, LEAVE_MEMORY );

  Score_dtor( &score_archive, FREE_MEMORY );

  MSequence_dtor( &begin_play, LEAVE_MEMORY );

  MSequence_dtor( &up_squat, LEAVE_MEMORY );

  MSequence_dtor( &down_squat, LEAVE_MEMORY );

  MSequence_dtor( &menu_select, LEAVE_MEMORY );

  MSequence_dtor( &intro_music, LEAVE_MEMORY );

  MSequence_dtor( &dialog_squat, LEAVE_MEMORY );

  MSequence_dtor( &hand_squat, LEAVE_MEMORY );

  MSequence_dtor( &count_up, LEAVE_MEMORY );

  MSequence_dtor( &count_down, LEAVE_MEMORY );

  return 0L;
}
