/*
 * FILE: train.c
 *
 * HISTORY:
 *   May 15, 2001 Created by Dmitry Novikov
 */
#include "main.h"
#include "utils.h"

/*
 * FUNCTION: cSquat_draw_weight
 *
 * DESCRIPTION: Draws the weight
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
void cSquat_draw_weight( struct DisplayGraphics* ptr_displ, int status )
{
  int tmp_tik;

  int x_left, x_right;

  int y, ia, delta_y, delta_x;

  x_left = 40;

  x_right = 120;

  if( status > 7 )
  {
    y = 14 - status;
  }
  else y = status;

  y *= 2;

  y += 13;

  DisplayGraphics_set_color( ptr_displ, CLR_BLACK );

  DisplayGraphics_set_draw_mode( ptr_displ, DM_PUT );

  for( ia = 0; ia < 6; ia++ )
  {
    switch(ia)
    {
      case 0:

        delta_y = 0;

        delta_x = 0;

        break;

      case 1:

        delta_y = 2;

        break;

      case 2:

        delta_y = 4;

        break;

      case 3:

        delta_y = 6;

        break;

      case 4:

        delta_y = 8;

        break;

      case 5:

        delta_y=10;

        break;
    }
    delta_x += 2 * bar[ ia ];

    if( bar[ ia ] > 0 )
    {
      DisplayGraphics_fill_rect( ptr_displ, x_left - delta_x,
        y + delta_y, 2 * bar[ ia ], 28 - 2 * delta_y );

      DisplayGraphics_fill_rect( ptr_displ, x_right + delta_x - 2 * bar[ ia ],
        y + delta_y, 2 * bar[ ia ], 28 - 2 * delta_y );
    }
  }
}

/*
 * FUNCTION: cSquat_draw_game_single
 *
 * DESCRIPTION: Fully draws the training example
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
static void cSquat_draw_game_single( struct DisplayGraphics* ptr_displ,
  struct cWinApp* ptr_win_app )
{
  long tmp;

  tmp = 11 * power;

  AppGeneric_clear_screen();

  if( status < 7 )
  {
    DisplayGraphics_draw_bitmap( ptr_displ,
      BitmapSequence_get_bitmap( &sphere, status ), 0, 0, BM_NORMAL );
  }
  else
  {
    DisplayGraphics_draw_bitmap( ptr_displ,
      BitmapSequence_get_bitmap( &sphere, 14 - status ), 0, 0, BM_NORMAL );
  }
  cSquat_draw_weight( ptr_displ, status );

  if( flag_hands )
  {
    tik_hands++;

    if( tik_hands < 8 && tik_hands % 2 == 1 )
    {
      MSequence_play( &hand_squat );
    }
    if( tik_hands <= 21 )
    {
      DisplayGraphics_set_bkcolor( ptr_displ, CLR_LTGRAY );

      DisplayGraphics_set_draw_mode( ptr_displ, DM_OR );

      DisplayGraphics_draw_bitmap( ptr_displ,
        BitmapSequence_get_bitmap( &hands, tik_hands - 1 ), 59, 0, BM_NORMAL );
    }
    if( tik_hands > 8 && tik_hands < 16 )
    {
      status += 1;
    }
    if( tik_hands >= 16 )
    {
      fix = TRUE;

      status = 0;

      stamina = max_stamina = 100;
    }
    if( tik_hands == 16 ) MSequence_play( &hand_squat );

    if( tik_hands == 21 )
    {
      status = tik_hands = 0;

      flag_hands = FALSE;

      fix = TRUE;

      stamina = max_stamina = 100;
    }
  }
  if( fix )
  {
    DisplayGraphics_set_bkcolor( ptr_displ, CLR_WHITE );

    DisplayGraphics_set_draw_mode( ptr_displ, DM_OR );

    DisplayGraphics_draw_bitmap( ptr_displ,
      BitmapSequence_get_bitmap( &bearing, 0 ), 42, 24, BM_NORMAL );

    DisplayGraphics_draw_bitmap( ptr_displ,
      BitmapSequence_get_bitmap( &bearing, 1 ), 99, 24, BM_NORMAL );
  }
  if( weight < 1000 )
  {
    sprintf( res, "%03d", weight );
  }
  else sprintf( res,"%04d", weight );

  DisplayGraphics_set_font( ptr_displ, mini_bold_font );

  DisplayGraphics_set_color( ptr_displ, CLR_BLACK );

  DisplayGraphics_draw_rect( ptr_displ, 0, 80, 160, 20 );

  DisplayGraphics_set_color( ptr_displ, CLR_LTGRAY );

  DisplayGraphics_fill_rect( ptr_displ, 41,
    93, (int) (( tmp * (long) stamina ) / 10000 ), 3 );

  DisplayGraphics_set_color( ptr_displ, CLR_BLACK );

  DisplayGraphics_draw_rect( ptr_displ, 40,
    92, (int) (( tmp * (long) max_stamina ) / 10000 + 2 ), 5 );

  DisplayGraphics_draw_line( ptr_displ,
    (int)( 38 + ( 11 * weight ) / 100 + 2 ),
    91, (int)( 38 + ( 11 * weight ) / 100 + 2 ), 97 );

  DisplayGraphics_draw_text( ptr_displ, "Weight:", 3, 81 );

  DisplayGraphics_draw_text( ptr_displ, res, 40, 81 );

  DisplayGraphics_draw_text( ptr_displ, "lbs", 70, 81 );

  DisplayGraphics_draw_text( ptr_displ, "Power:", 3, 89 );

  if( tik_hands == 9 ) MSequence_stop( &hand_squat );

  if( has_focus()) DisplayGraphics_show( ptr_displ );
}

/*
 * FUNCTION: cSquat_apprun_single
 *
 * DESCRIPTION: The main loop of the training example
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
int cSquat_apprun_single( struct cWinApp* ptr_win_app )
{
  int tik_enter = 0;

  long delta_power = 0, delta_depletion = 0;

  bool exit = FALSE, f_enter = FALSE, sel = FALSE, play_game = FALSE;

  bool show_dlg = FALSE, lift = FALSE;

  ptr_win_app->HelpContext = 1;

  set_clicks_enabled( FALSE );

  fix = TRUE;

  load_settings();

  weight = 350; // start weight

  stamina = 100;

  max_stamina = 100;

  status = 0;

  set_bar( weight );

  flag_hands = FALSE;

  tik_hands = 0;

  if( has_focus())
  {
    cSquat_draw_game_single( main_module.m_gfx, ptr_win_app );
  }
  while( !exit )
  {
    if( fix )
    {
      tik_lift = 0;

      power += (int) ( delta_power / 20 );

      depletion += (int) ( delta_depletion / 20 );

      if( power > 1000 ) power = 1000;

      if( depletion > 50 ) depletion = 50;

      delta_depletion = delta_power = 0;

      if( power == 1000 && depletion == 50 && !show_dlg )
      {
        struct cDialog* dlg= (struct cDialog*) malloc( sizeof *dlg );

        int dlg_res;

        cDialog_ctor( dlg, 0,
         "You've already achieved the ideal form.  Do you want to quit training?",
           mbQuit|mbCancel, 0, ptr_win_app );

        MSequence_play( &dialog_squat );

        set_clicks_enabled( TRUE );

        dlg_res = cDialog_ShowModal( dlg );

        set_clicks_enabled( FALSE );

        if( dlg_res == mrQuit )
        {
          exit = TRUE;

          save_settings();
        }
        cDialog_dtor( dlg, FREE_MEMORY );

        show_dlg = TRUE;
      }
    }
    if( !fix && play_game && has_focus() && !sel && !flag_hands )
    {
      if( power * stamina < weight * 100 )
      {
        if( status < 7 )
        {
          status += 1;

          MSequence_play( &down_squat );
        }
        if( status > 7 )
        {
          status -= 1;

          MSequence_play( &down_squat );
        }
      }
      else
      {
        if( status >= 7 )
        {
          status += 1;

          MSequence_play( &up_squat );
        }
        if( status < 7 && status > 0 )
        {
          status -= 1;

          MSequence_play( &up_squat );
        }
        if( status == 14 ) status = 0;
      }
      if( !status && lift )
      {
        long temp = 0;

        tik_lift += 1;

        temp = ( 1000 - power ) / 36 + 1;

        if( weight > power * 6 / 10 )
        {
          delta_power += temp;

          delta_depletion += temp / 5 + 1;
        }
        if( weight < power * 6 / 10 && tik_lift > 10 )
        {
          delta_depletion += temp / 3 + 1;

          delta_power += temp / 3 + 1;
        }
        lift = FALSE;
      }
      if( status == 7 && !lift )
      {
        lift = TRUE;

        tik_lift += 1;
      }
      if( power * max_stamina < weight * 100 && status == 7 )
      {
        play_game = FALSE;
      }
    }
    if( sel && !fix && play_game )
    {
      if( status < 7 ) status += 1;

      if( status > 7 ) status -= 1;

      if( status == 7 )
      {
        play_game = FALSE;

        sel = FALSE;

        flag_hands = TRUE;
      }
    }
    if( !fix && !play_game && !flag_hands )
    {
      flag_hands = TRUE;

      delta_depletion = delta_power = 0;
    }
    if( play_game && stamina > 0 && has_focus())
    {
      stamina -= 1;

      MSequence_play_background( &count_down );
    }
    if( has_focus())
    {
      DirectKeyboard_scan( ptr_keyboard );

      if( DirectKeyboard_is_key_pressed( ptr_keyboard, KEY_UP ))
      {
        if( fix )
        {
          if( weight < power - 4 && has_focus())
          {
            weight += 5;

            set_bar( weight );

            cWinApp_pause( main_module.m_process, 80 );
          }
        }
        else if( status == 0 )
        {
          fix = TRUE;

          play_game = FALSE;

          stamina = max_stamina = 100;
        }
      }
      else if( DirectKeyboard_is_key_pressed( ptr_keyboard, KEY_DOWN ) &&
        fix && has_focus())
      {
        if( weight > 45 + 4 )
        {
          weight -= 5;

          set_bar( weight );

          cWinApp_pause( main_module.m_process, 80 );
        }
      }
    }
    ptr_message = cWinApp_get_message( main_module.m_process,
      20, 0, MSG_USER + 1 );

    if( ptr_message )
    {
      switch( ptr_message->msgid )
      {
        case MSG_LOSTFOCUS:

          sleep( 50 );

          break;

        case MSG_GOTFOCUS:

          sleep( 50 );

          break;

        case MSG_QUIT:
        case MSG_SHUTUP:

          if( has_focus())
          {
            cSquat_draw_game_single( main_module.m_gfx, ptr_win_app );
          }
          cWinApp_pause( ptr_win_app, 100 );

          set_clicks_enabled( FALSE );

          flag_hands = FALSE;

          exit = TRUE;

          save_settings();

          Message_delete( ptr_message );

          ptr_message = NULL;

          return 4;

        case MSG_KEYDOWN:

          if( Message_get_key_param( ptr_message )->scancode == KEY_ENTER &&
           !( Message_get_key_param( ptr_message )->mask & KEYMASK_AUTOREPEAT ))
          {
            if( fix && !flag_hands )
            {
              fix = FALSE;

              play_game = TRUE;

              if( max_stamina * power > weight * 100 )
              {
                stamina = weight * 100 / power + 1;
              }
              else stamina = max_stamina;

              if( stamina > 100 ) stamina = 100;
            }
            if( !fix && play_game && !flag_hands )
            {
              if( tik_enter == depletion )
              {
                if( max_stamina > 0) max_stamina -= 1;

                tik_enter = 0;
              }
              tik_enter++;

              if( stamina < max_stamina - 4 )
              {
                stamina += 4;

                MSequence_play_background( &count_up );
              }
            }
          }
          if( Message_get_key_param( ptr_message )->scancode == KEY_DOWN )
          {
            if( !fix && play_game && !flag_hands )
            {
              sel = TRUE;

              stamina = 0;
            }
          }
          if( Message_get_key_param( ptr_message )->scancode == KEY_ESC )
          {
            int dlg_res;

            cDialog_ctor( &need_dlg, 0, "Do you really want to stop training?",
              mbQuit | mbCancel, 0, ptr_win_app );

            set_clicks_enabled( TRUE );

            MSequence_play( &dialog_squat );

            dlg_res = cDialog_ShowModal( &need_dlg );

            set_clicks_enabled( FALSE );

            if( dlg_res == mrQuit )
            {
              exit = TRUE;

              save_settings();
            }
            cDialog_dtor( &need_dlg, LEAVE_MEMORY );
          }
          else cWinApp_defproc( ptr_win_app, ptr_message );

          break;

        default:

          cWinApp_defproc( ptr_win_app, ptr_message );

          break;
      }
      Message_delete( ptr_message );

      ptr_message = NULL;
    }
    if( has_focus())
    {
      cSquat_draw_game_single( main_module.m_gfx, ptr_win_app );
    }
    else if( !exit )
    {
      sleep( 100 );
    }
  }
  set_clicks_enabled( TRUE );

  return 0;
}