/*
 * FILE: utils.c
 *
 * HISTORY:
 *   May 15, 2001 Created by Dmitry Novikov
 */
#include "main.h"
#include "utils.h"

struct score_t high_scores[ 7 ];

/*
 * FUNCTION: cSquat_draw_game_res
 *
 * DESCRIPTION: Draws results
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
static void cSquat_draw_game_res( struct DisplayGraphics* ptr_displ,
  struct cWinApp* ptr_win_app, struct score_t* high_scores )
{
  int i;

  AppGeneric_clear_screen();

  DisplayGraphics_set_font( ptr_displ, mini_bold_font );

  draw_lib( 5, 0, 0, 0, BM_NORMAL );

  if( sel_res < 5 )
  {
    DisplayGraphics_set_color( ptr_displ, CLR_WHITE );

    DisplayGraphics_fill_rect( ptr_displ, 25, 1 + sel_res * 18, 111, 18 );

    DisplayGraphics_set_color( ptr_displ, CLR_BLACK );

    DisplayGraphics_draw_rect( ptr_displ, 25, 1 + sel_res * 18, 111, 18 );
  }
  for( i = 0; i < 5; i++ )
  {
    DisplayGraphics_set_color( ptr_displ, CLR_BLACK );

    DisplayGraphics_draw_text( ptr_displ, &high_scores[ i ].nickname,
      30, 5 + i * 18 );

    sprintf( res, "%ld", high_scores[ i ].score );

    DisplayGraphics_draw_text( ptr_displ, res, 100, 5 + i * 18 );
  }
  DisplayGraphics_show( ptr_displ );
}

/*
 * FUNCTION: load_settings
 *
 * DESCRIPTION:  Loads the high and low power settings
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
void load_settings( void )
{
  int index;

  if( Score_is_valid( &score_archive ))
  {
    for( index = 5; index < 7; index++ )
    {
      Score_read( &score_archive, index, &high_scores[ index ] );
    }
  }
  power = (int) high_scores[ 5 ].score;

  depletion = (int) high_scores[ 6 ].score;
}

/*
 * FUNCTION: save_settings
 *
 * DESCRIPTION:  Saves the high and low power settings
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
void save_settings( void )
{
  int i;

  high_scores[ 5 ].score = (long) power;

  high_scores[ 6 ].score = (long) depletion;

  for( i = 5; i < 7; i++ )
  {
    Score_write( &score_archive, i, &high_scores[ i ] );
  }
}

/*
 * FUNCTION: load_results
 *
 * DESCRIPTION:  Loads results
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
void load_results( void )
{
  if( Score_is_valid( &score_archive ))
  {
    int index;

    for( index = 0; index < 5; index++ )
    {
      Score_read( &score_archive, index, &high_scores[ index ] );
    }
  }
}

/*
 * FUNCTION: sort_results
 *
 * DESCRIPTION:  Sorts the results
 *
 * PARAMETERS:
 *
 * RETURNS:
 */
int sort_results( long weight, char* nickname )
{
  int i = 0,j = 0;

  int numb_i = 5;

  int long1, long2 = strlen( nickname );

  for( i = 4; i >= 0; i-- )
  {
    if( weight > high_scores[ i ].score )
    {
      numb_i = i;
    }
  }
  if( numb_i > 0 && numb_i < 5 )
  {
    long1 = strlen( high_scores[ numb_i - 1 ].nickname );

    long2 = strlen( nickname );
  }
  if( numb_i > 0 && numb_i < 5 && weight == high_scores[ numb_i - 1 ].score &&
    long1 == long2 && strncmp( &high_scores[ numb_i - 1 ].nickname,
      nickname, long2 ) == 0 )
  {
    numb_i -= 1;
  }
  else if( numb_i < 5 )
  {
    for( i = numb_i; i < 4; i++ )
    {
      high_scores[ i + 1 ].score = high_scores[ i ].score;

      strncpy( high_scores[ i + 1 ].nickname, high_scores[ i ].nickname, 8 );
    }
    high_scores[ numb_i ].score = weight;

    strncpy( high_scores[ numb_i ].nickname, nickname, long2 );

    for( i = long2; i < 8; i++ )
    {
        high_scores[ numb_i ].nickname[ i ] = 0;
    }
  }
  for( i = 0; i < 5; i++ )
  {
    if( high_scores[ i ].nickname[ 0 ] < 33 ||
       high_scores[ i ].nickname[ 0 ] > 126 )
    {
      return 5;
    }
  }
  return numb_i;
}

/*
 * FUNCTION: save_results
 *
 * DESCRIPTION:  Saves the results
 *
 * PARAMETERS:
 *
 * RETURNS:
 */
int save_results( long weight, char* nickname )
{
  int i = 0, number_i = 5;

  number_i = sort_results( weight, nickname );

  if( number_i == 5 ) return 5;

  for( i=0; i < 5; i++ )
  {
    Score_write( &score_archive, i, &high_scores[ i ] );
  }
  return number_i;
}

/*
 * FUNCTION: save_res
 *
 * DESCRIPTION:  Saves results without sorting
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
void save_res( void )
{
  int i;

  for( i = 0; i < 5; i++ )
  {
    if( high_scores[ i ].score > 1000 ) return;
  }
  for( i = 0; i < 5; i++ )
  {
    Score_write( &score_archive, i, &high_scores[ i ] );
  }
}

/*
 * FUNCTION: set_bar
 *
 * DESCRIPTION:  Calculation of weight
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
void set_bar( long power )
{
  long tmp_power = power, tik, num_weight;

  if( tmp_power <= 45 )
  {
    for( tik = 0; tik < 6; tik++ )
        bar[ tik ] = 0;

    return;
  }
  tmp_power -= 45;

  num_weight = (int) ( tmp_power / 90 );

  bar[ 0 ] = (int)num_weight;

  tmp_power -= num_weight * 90;

  num_weight = (int)( tmp_power / 70 );

  bar[ 1 ] = (int)num_weight;

  tmp_power -= num_weight * 70;

  num_weight = tmp_power / 50;

  bar[ 2 ] = (int)num_weight;

  tmp_power -= num_weight * 50;

  num_weight = tmp_power / 20;

  bar[ 3 ] = (int)num_weight;

  tmp_power -= num_weight * 20;

  num_weight = tmp_power / 10;

  bar[ 4 ] = (int)num_weight;

  tmp_power -= num_weight * 10;

  num_weight = tmp_power / 5;

  bar[ 5 ] = (int)num_weight;

  tmp_power -= num_weight * 5;
}

/*
 * FUNCTION: cSquat_apprun_res
 *
 * DESCRIPTION:  Result output
 *
 * PARAMETERS:
 *
 * RETURNS: nothing
 */
int cSquat_apprun_res( struct cWinApp* ptr_win_app, bool csquat_status_flag )
{
  bool exit = FALSE;

  int index;

  ptr_win_app->HelpContext = 0;

  load_results();

  if( has_focus())
  {
    cSquat_draw_game_res( main_module.m_gfx, ptr_win_app, &high_scores );
  }
  sleep( 200 );

  while( !exit )
  {
    ptr_message = cWinApp_get_message( main_module.m_process,
      50, 0, MSG_USER + 1 );

    if( ptr_message )
    {
      switch( ptr_message->msgid )
      {
        case MSG_LOSTFOCUS:

          cWinApp_pause( ptr_win_app, 250 );

          break;

        case MSG_GOTFOCUS:

          cWinApp_pause( ptr_win_app, 250 );

          break;

        case MSG_QUIT:
        case MSG_SHUTUP:

          exit=TRUE;

          Score_dtor( &score_archive, FREE_MEMORY );

          return 4;

        case MSG_KEYDOWN:

          if( Message_get_key_param( ptr_message )->scancode == KEY_HELP )
          {
            cWinApp_defproc( ptr_win_app, ptr_message );
          }
          else if( !( Message_get_key_param( ptr_message )->mask &
            KEYMASK_AUTOREPEAT ))
          {
             Score_dtor( &score_archive, FREE_MEMORY );

             exit = TRUE;
          }
          break;

        default:

          cWinApp_defproc( ptr_win_app, ptr_message );

          break;
      }
      Message_delete( ptr_message );

      ptr_message = NULL;
    }
    if( has_focus())
    {
      cSquat_draw_game_res( main_module.m_gfx, ptr_win_app, &high_scores );
    }
  }
  if( !csquat_status_flag ) return 0;

  return 4;
}
