/*
 * FILE: DataTypes.h
 *
 * DESCRIPTION: These are the common types and their definitions.
 *
 * HISTORY:
 *   May 14, 2001 Created by Dmitry Kaloshin
 */
#ifndef __DATATYPES_H_INCLUDED__
#define __DATATYPES_H_INCLUDED__

#include <cywin.h>

#define R_DO_NOTHING 0

#define R_INITIALIZE 1

#define R_RELEASE 2

#define R_INIT_LEVEL 3 

#define R_SHOW_SPLASH 4

#define R_SHOW_FRAME 5

#define R_MOVE_MONSTERS 6

#define R_PLAY_SOUND 7

#define R_DIE 8

#define R_ACTIVE 9

#define R_PASSIVE 10

#define R_OPEN 11

#define R_CLOSE 12

#define ELEMENT_SIZE 16

#define BULLET_SIZE 8

#define QUARTER_ELEMENT_SIZE  4

#define HERO_SIMPLE_STEP 4

#define MONSTER_SIMPLE_STEP 4

#define BULLET_SIMPLE_STEP 6

#define HERO_DIE_FRAMES 4

#define FALL_FRAMES 4

#define FIRE_FRAMES 4

#define HERO_MAD 4

#define TIMEOUT_MAD 80

#define TIMEOUT_MAD_AFTER_DIE 15

#define TIMEOUT_BARRICADE 100

#define HERO_KILL_MONSTER 3

#define MAX_LIVES 3

#define INFO_X 127

#define INTERSECT_BERRY_STEP  8 // ( HERO_SIMPLE_STEP * 2 )

#define ABS( x ) ((( x ) >= 0 ) ? ( x ) : -( x ))

#define SIGN( x ) (( x ) ? ( x ) > 0 ? 1 : -1 : 0 )

#define LEVEL_MUS 0

#define BOOT_MUS 1

#define BERRY_MUS 2

#define BONUS_MUS 3

#define LOSE_MUS 4

#define EAT_MUS 5

#define KEY_MUS 6

#define BUTTON_MUS 7

#define END_BONUS_MUS 8

#define BANANA_MUS 9

#define GATE_MUS 10

#define CLOSE_BARRICADE_MUS 11

#define STAIRS_MUS 12

#define TITLE_MUS 13

#define WIN_MUS 14

#define NUM_MUS_FILE 15

#define NO_SOUND NUM_MUS_FILE

#define MAX_BULLETS_NUM 1

#define MAX_START_BULLETS 10

#define START_BULLETS_NUM 10

enum directions
{
  DIRECTION_LEFT = 1,

  DIRECTION_RIGHT = 2,

  DIRECTION_UP = 3,

  DIRECTION_DOWN = 4
};

struct BaseActor 
{
  char request; 
};

struct System : public BaseActor
{
};

struct MusicPlayer : public BaseActor 
{
  int background_index;

  int melody_index;

  bool mute;
};

struct SplashScreen : public BaseActor
{
};

struct ActivePoint : public BaseActor
{
  int x;

  int y; 
};

struct Creature : public ActivePoint
{
  int x_step;

  int y_step;

  int direction;  
};

struct HeroField : public ActivePoint
{
  int level;
};

struct Hero : public Creature
{
  struct DirectKeyboard* ptr_keyboard;

  int die_frame;

  int type;

  int timeout;
  
  int boot;

  int fall;

  int fall_frame;

  int score;
  
  int lives;

  int current_bullets_num;

  struct Creature *ptr_bullets;

  int start_x;

  int start_y;
};

struct Monster : public Creature
{
  int start_x;

  int start_y;
};

struct Monsters : public BaseActor
{
  int number;

  struct Monster* ptr_monsters;
};

struct Button : public ActivePoint
{
};

struct Barricade : public ActivePoint
{
  int timeout;
};

struct Barricades : public BaseActor
{
  struct Button* ptr_buttons;

  struct Barricade* ptr_barricades;

  int number_buttons;

  int number_barricades;
};

struct Door : public ActivePoint
{
  int type;
};

struct Doors : public BaseActor
{
  struct Door* ptr_doors;

  int number;
};

struct MediaFile
{
  struct MSequence* ptr_msequence;

  bool background;

  bool repeat;
};

struct Fire : public ActivePoint
{
  int frame;
};

struct Fires : public BaseActor
{
  int number;

  struct Fire *ptr_fires;
};

struct Bananas : public BaseActor
{
  int number;

  struct ActivePoint *ptr_bananas;
};

struct Info : public BaseActor
{
  char digits[ 10 ];
};

struct Stairs : public ActivePoint
{
};

struct Menu : public BaseActor
{
  int index_menu;
};

struct Final : public BaseActor
{
};

#endif
