/*
 * FILE: maps.c
 *
 * DESCRIPTION:
 *   Contains maps of the levels
 *
 * HISTORY:
 *   May 29, 2001 Created by Dmitry Kaloshin
 */
#include "Maps.h"

char level_1[ 21 ][ 17 ] =
{
  {
     BRICK, TELEPORT, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, 
     BRICK, BRICK, BRICK, TELEPORT, BRICK, BRICK, BRICK, BRICK, BRICK  
  },
  {
     BRICK, EMPTY, BRICK, EMPTY, BANANA, EMPTY, BRICK, EMPTY, 
     EMPTY, EMPTY, BRICK, EMPTY, BRICK, BANANA, EMPTY, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, 
     BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK    
  },
  {
     BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, 
     BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, 
     BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK, BRICK, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, 
     EMPTY, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK
  },
  {
     BRICK, BRICK, BRICK, EMPTY, BRICK, BRICK, BRICK, EMPTY, 
     BRICK, BRICK, BRICK, BRICK, BL_GATE, EMPTY, EMPTY, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, 
     EMPTY, EMPTY, BRICK, BRICK, KEY, BRICK, BRICK, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, BRICK, BRICK, BRICK, EMPTY, BRICK, BRICK, 
     BRICK, EMPTY, BRICK, BUTTON, BRICK, BOOT, BRICK, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, EMPTY, MONSTER, 
     BRICK, EMPTY, BARRICADE, EMPTY, BRICK, DOOR, EMPTY, EMPTY, BRICK
  },
  {
     BRICK, BRICK, BRICK, EMPTY, BRICK, MONSTER, BRICK, MONSTER, 
     BRICK, EMPTY, BRICK, HERO, BRICK, BRICK, BRICK, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, EMPTY, MONSTER, 
     BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, BRICK, BRICK, BRICK, EMPTY, BRICK, BRICK, 
     BRICK, EMPTY, BRICK, FIRE, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, KEY + 1, EMPTY, 
     EMPTY, EMPTY, BRICK, STAIRS, FIRE, EMPTY, BRICK, EMPTY, BRICK
  },
  {
     BRICK, BRICK, BRICK, EMPTY, BRICK, BRICK, BRICK, DOOR + 1, 
     BRICK, BRICK, BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, 
     EMPTY, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, BERRY, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, BERRY, 
     BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK, BRICK, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, 
     BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, 
     BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
     BRICK, EMPTY, BRICK, BERRY, BONUS, EMPTY, BRICK, BERRY, 
     EMPTY, EMPTY, BRICK, EMPTY, BRICK, BONUS, EMPTY, EMPTY, BRICK
  },
  {
     BRICK, TELEPORT, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, 
     BRICK, BRICK, BRICK, TELEPORT, BRICK, BRICK, BRICK, BRICK, BRICK
  }
};
                                   
char level_2[ 21 ][ 17 ] =
{
  {
    BRICK, TELEPORT, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK,
    BRICK, BRICK, BRICK  , BRICK  , BRICK, BRICK, BRICK, TELEPORT, BRICK
  },
  {
    BRICK, BERRY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, BUTTON,
    HERO, BRICK, KEY, MONSTER, EMPTY, EMPTY, EMPTY, BERRY, BRICK
  },
  {
    BRICK, BARRICADE, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK,
    BRICK, BRICK, BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY,
    BRICK, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK, BRICK, EMPTY,
    BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, BRICK, BERRY, BRICK, EMPTY,
    EMPTY, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, BRICK, BONUS, BRICK, EMPTY,
    BRICK, BRICK, BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, EMPTY, EMPTY,
    BRICK, BRICK, EMPTY, BONUS, EMPTY, EMPTY, BRICK, BANANA, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK,
    BRICK, BRICK, EMPTY, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, BANANA,
    EMPTY, MONSTER, EMPTY, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK,
    BRICK, BRICK, BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY,
    EMPTY, BOOT, EMPTY, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK,
    BRICK, BRICK, EMPTY, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, EMPTY, EMPTY,
    BRICK, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, DOOR,
    BRICK, BRICK, BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, BRICK, STAIRS, BRICK, FIRE,
    BRICK, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK, BRICK, FIRE,
    BRICK, BRICK, BRICK, BRICK, BRICK, EMPTY, EMPTY, EMPTY, BRICK
  },
  {
    BRICK, EMPTY, BRICK, EMPTY, FIRE, FIRE, FIRE, FIRE,
    BRICK, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK,
    BRICK, BRICK, BRICK, EMPTY, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  {
    BRICK, BERRY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, MONSTER,
    EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, BERRY, BRICK
  },
  {
    BRICK, TELEPORT, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK,
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, TELEPORT, BRICK
  }
};

char level_3[ 21 ][ 17 ] =
{

  { 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK,
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK 
  },
  { 
    TELEPORT, HERO, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, 
    EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, TELEPORT 
  },
  { 
    BRICK, EMPTY, BRICK, BRICK, EMPTY, BRICK, BARRICADE, BRICK, 
    BRICK, BRICK, BRICK, BRICK, BRICK, BARRICADE + 1, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, BUTTON, BRICK, EMPTY, EMPTY, BRICK, BERRY, EMPTY, EMPTY, 
    EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, 
    BRICK, BRICK, BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, 
    EMPTY, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, DOOR + 2, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, 
    BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, BANANA, BRICK, KEY + 1, EMPTY, EMPTY, EMPTY, EMPTY, 
    EMPTY, EMPTY, EMPTY, MONSTER, BRICK, EMPTY, BRICK, BANANA, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, 
    BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, DOOR + 1, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, 
    EMPTY, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK, FIRE, BRICK, 
    BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, STAIRS, EMPTY, 
    EMPTY, EMPTY, BRICK, BONUS, BRICK, EMPTY, BRICK, EMPTY, BRICK
  },
  { 
    BRICK, MONSTER, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK,
    BRICK, BRICK, BRICK, BRICK, BRICK, EMPTY, BRICK, MONSTER, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, 
    EMPTY, EMPTY, EMPTY, KEY + 2, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, 
    BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, 
    EMPTY, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    TELEPORT, EMPTY, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, 
    BRICK, BRICK, BRICK, BRICK, BRICK, KEY, BRICK, EMPTY, TELEPORT 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, BONUS, EMPTY, BRICK, BRICK, 
    EMPTY, EMPTY, EMPTY, BRICK, BERRY, BUTTON + 1, BRICK, EMPTY, BRICK 
  },
  {      
    BRICK, EMPTY, BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, 
    TR_GATE, BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, BERRY, EMPTY, EMPTY, EMPTY, EMPTY, DOOR, EMPTY, 
    EMPTY, BRICK, EMPTY, BOOT, EMPTY, EMPTY, BRICK, BERRY, BRICK 
  },
  { 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK 
  }
};

char level_4[ 21 ][ 17 ] =
{      
  { 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK 
  },
  { 
    BRICK, HERO, BRICK, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, 
    EMPTY, EMPTY, BRICK, EMPTY, TR_GATE, EMPTY, EMPTY, BERRY, BRICK 
  },
  { 
    TELEPORT, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, 
    BRICK, EMPTY, EMPTY, EMPTY, EMPTY, BRICK, BL_GATE, BOOT, TELEPORT 
  },
  { 
    BRICK, BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK, BRICK, 
    BRICK, BRICK, BRICK, EMPTY, BRICK, BRICK, EMPTY, BRICK, BRICK 
  },
  { 
    BRICK, EMPTY, EMPTY, EMPTY, EMPTY, BERRY, EMPTY, EMPTY, 
    EMPTY, EMPTY, BRICK, EMPTY, EMPTY, BRICK, BONUS, KEY + 1, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, 
    BRICK, EMPTY, BRICK, BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK 
  },
  { 
    BRICK, EMPTY, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, 
    BRICK, EMPTY, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, BRICK 
  },
  { 
    BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK, BANANA, 
    BRICK, BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, EMPTY, BRICK, EMPTY, EMPTY, BRICK, EMPTY, 
    EMPTY, BRICK, EMPTY, EMPTY, BERRY, BRICK, EMPTY, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, BRICK, BRICK, EMPTY, BRICK, BRICK, 
    EMPTY, BRICK, BRICK, BRICK, BANANA, BRICK, FIRE, BRICK, BRICK 
  },
  { 
    BRICK, MONSTER, EMPTY, BRICK, EMPTY, EMPTY, BRICK, MONSTER, 
    EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, EMPTY, BRICK 
  },
  { 
    BRICK, BRICK, FIRE, BRICK, EMPTY, BRICK, BRICK, DOOR + 1, 
    BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, EMPTY, BRICK, EMPTY, EMPTY, BRICK, EMPTY, 
    BRICK, EMPTY, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, 
    BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK 
  },
  { 
    BRICK, EMPTY, EMPTY, BRICK, EMPTY, EMPTY, BRICK, EMPTY, 
    BRICK, BRICK, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, BRICK 
  },
  { 
    BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK, EMPTY, 
    EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK, BRICK, EMPTY, BRICK 
  },
  { 
    TELEPORT, EMPTY, EMPTY, BRICK, EMPTY, BRICK, BRICK, BRICK, 
    BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK, MONSTER, EMPTY, TELEPORT 
  },
  { 
    BRICK, EMPTY, BRICK, BRICK, EMPTY, EMPTY, EMPTY, BONUS, 
    BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK 
  },
  { 
    BRICK, BERRY, MONSTER, BRICK, BRICK, BRICK, BRICK, EMPTY, 
    BRICK, BRICK, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, BRICK, BRICK 
  },
  { 
    BRICK, BRICK, EMPTY, DOOR, EMPTY, EMPTY, EMPTY, MONSTER, 
    BRICK, BRICK, STAIRS, BRICK, EMPTY, EMPTY, TL_GATE, KEY, BRICK 
  },
  { 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK 
  }
};

char level_5[ 21 ][ 17 ] =
{
  { 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, TELEPORT, 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK 
  },
  { 
    BRICK, KEY + 4, BRICK, EMPTY, EMPTY, BERRY, BRICK, BANANA, 
    EMPTY, EMPTY, BRICK, HERO, EMPTY, EMPTY, EMPTY, BERRY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, DOOR + 3, BRICK, BRICK, BRICK, EMPTY, 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BANANA, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, 
    BRICK, BONUS, BRICK, EMPTY, EMPTY, EMPTY, EMPTY, BRICK 
  },
  { 
    BRICK, MONSTER, BRICK, DOOR, BRICK, BRICK, BRICK, BRICK, 
    BRICK, EMPTY, EMPTY, BRICK, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, MONSTER, BRICK, EMPTY, EMPTY, EMPTY, 
    DOOR + 4, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK, BRICK, 
    DOOR + 1, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, STAIRS, 
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, FIRE, 
    BRICK, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    TELEPORT, BANANA, BRICK, BONUS, EMPTY, KEY + 3, BRICK, FIRE, 
    BRICK, DOOR + 2, BRICK, KEY + 1, BRICK, EMPTY, BRICK, BANANA, TELEPORT 
  },
  { 
    BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK, BRICK, FIRE, 
    BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK 
  },
  { 
    BRICK, EMPTY, EMPTY, EMPTY, BRICK, KEY + 2, BRICK, FIRE, 
    BRICK, MONSTER, BRICK, EMPTY, EMPTY, EMPTY, BRICK, BERRY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, FIRE, 
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, BOOT, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, 
    EMPTY, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, BRICK, 
    BRICK, BRICK, BRICK, EMPTY, BRICK, KEY, BRICK, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY, BRICK, EMPTY,      
    EMPTY, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, BRICK, MONSTER, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, EMPTY, EMPTY, EMPTY, BRICK, EMPTY, 
    BRICK, BRICK, BRICK, BRICK, BRICK, EMPTY, EMPTY, TR_GATE, BRICK 
  },
  { 
    BRICK, MONSTER, BRICK, BRICK, BL_GATE, EMPTY, BRICK, FIRE, 
    BRICK, EMPTY, MONSTER, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, BRICK 
  },
  { 
    BRICK, EMPTY, BRICK, BRICK, BRICK, EMPTY, BRICK, EMPTY, 
    BRICK, EMPTY, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK 
  },
  { 
    TELEPORT, BANANA, BRICK, BERRY, EMPTY, EMPTY, BRICK, BANANA, 
    BRICK, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, BANANA, TELEPORT
  },
  { 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, TELEPORT, 
    BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK, BRICK 
  }
};

struct LevelMap game_maps[ MAX_LEVEL ] =
{
  { 21, 17, &level_1[ 0 ][ 0 ] }, { 21, 17, &level_2[ 0 ][ 0 ] }, 
 
  { 21, 17, &level_3[ 0 ][ 0 ] }, { 21, 17, &level_4[ 0 ][ 0 ] }, 

  { 21, 17, &level_5[ 0 ][ 0 ] }
};