/*
 * FILE: utils.c
 *
 * DESCRIPTION: Helper function
 *
 * HISTORY:
 *   Nov 17, 2000 Created by Aleksey Slesarev
 */
#include "DataTypes.h"
#include "utils.h"
#include "actors.h"
#include "Maps.h"
#include "main.h"
/*
 * FUNCTION: show_dialog
 *
 * DESCRIPTION:
 *   Shows the model form for the specified dialog
 *
 * PARAMETERS:
 *   dialog_id -
 *
 * RETURNS:
 */
int show_dialog( int dialog_id )
{
  char* sz_dialog_text;

  struct cDialog player_dialog;

  struct Message* ptr_message;

  long dialog_mode = mbQuit | mbRestart;

  int result = CONTINUE_GAME;

  sz_dialog_text = (char*) malloc( 48 );

  if( media_player.background_index != NO_SOUND )
  {
    MSequence_stop( music[ media_player.background_index ].ptr_msequence );
  }
  // Chooses dialog mode and dialog text
  switchfast( dialog_id )
  {
    case DIALOG_EXIT: // Do you really want to exit the game ?

      strcpy( sz_dialog_text, str_Really_exit );

      dialog_mode |= mbs5;

      break;
  }
  // Creates CyWin dialog
  cDialog_ctor( &player_dialog, NULL, sz_dialog_text,
    dialog_mode, 0, main_module.m_process );

  // Deletes keyboard events from the message queue
  cWinApp_pause( main_module.m_process, 250 );

  while( ptr_message = cWinApp_peek_message( main_module.m_process,
    TRUE, MSG_KEYDOWN, MSG_KEYDOWN ))
  {
    Message_delete( ptr_message );
  }
  // Shows the CyWin dialog in modal form
  switch( cDialog_ShowModal( &player_dialog )) 
  {
    case mrQuit:

      result = EXIT_GAME;

      break;

    case mrRestart:

      result = RESTART_GAME;

      break;
  }
  cDialog_dtor( &player_dialog, LEAVE_MEMORY );

  free( sz_dialog_text );  

  return result;
}
