/*
 * FILE: TicTacToe.h
 *
 * DESCRIPTION: Application's main module
 *
 * HISTORY:
 *   Sep 6, 2000 Created by Aleksey Slesarev
 */
#ifndef __TIC_TAC_TOE_H__
#define __TIC_TAC_TOE_H__

#include <cywin.h>

// Board objects      
enum 
{ 
  MARK_X = 0, // Field with "X" mark

  MARK_0 = 1, // Field with "0" mark

  EMPTY_FIELD = 2 // Empty field
};              

extern struct module_t main_module; // Application's main module 

extern int cursor_index; // Cursor coordinate

extern int player_mark_type; // Type of player's mark 

extern int board_field[ 9 ]; // Board's fields

extern int move_number; // Number of the current move

void init_session( void );

void init_game( void );

void move_cursor( int direction );

bool set_mark( void );

void draw_board( void );

void draw_info_screen( void );

void draw_3d_frame( int x0, int y0, int width , int heigth );

bool show_score( void );

#endif