/*
 * FILE: walls.c
 *
 * DESCRIPTION: Renders the image of the walls.
 *
 * HISTORY:
 *   Feb 9, 2001 Created by Aleksey Slesarev
 */
#include "walls.h"

#define WALLS_NUMBER 4 // Number of the walls in the scene.

raster_t* ptr_walls_tex; // Wall texture.

struct Wall // Wall object.
{
  point_t p1;

  point_t p2;
};

// Coordinates of the walls in the scene.
struct Wall walls[ WALLS_NUMBER ] = 
{
  { { -600, 1100 }, { 600, 1100 } }, { { 600, 1100 }, { 600, -1100 } },
  { { 600, -1100 }, { -600, -1100 } }, { { -600, -1100 }, { -600, 1100 } }  
};

/*
 * FUNCTION: init_walls
 *
 * DESCRIPTION: Initializes the image of the wall texture.
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void init_walls( void )
{
  ptr_walls_tex = cy3d_load_tex( 0 );
}

/*
 * FUNCTION: render_walls
 *
 * DESCRIPTION: Performs rendering of the walls.
 *
 * PARAMETERS:
 *   ptr_gfx_buffer -
 *   camera         -
 *   direction      -
 *   z_buffer       -
 *
 * RETURNS: nothing
 */
void render_walls( char* ptr_gfx_buffer, point_t camera,
  int direction, int* z_buffer )
{ 
  int index;

  struct Wall* ptr_wall = walls;

  // Fills z-buffer with maximum values.
  memset( z_buffer, 0x7F, 160 * sizeof( fixed_t ));

  // Transforms and renders the walls. 
  for( index = 0; index < WALLS_NUMBER; index++ )
  {
    cy3d_draw_wall( ptr_gfx_buffer,
      cy3d_warp( ptr_wall->p1, camera, direction ), 
        cy3d_warp( ptr_wall->p2, camera, direction ), 
          ptr_walls_tex, 0, 0, z_buffer );

    ptr_wall++;
  } 
}

/*
 * FUNCTION: release_walls
 *
 * DESCRIPTION: Releases the image of the wall texture.
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void release_walls( void )
{
  free( ptr_walls_tex );
}
