/*
 * FILE: Archive.c
 *
 * DESCRIPTION: Archive tutorial
 *
 * HISTORY:
 *   Sep 6, 2000 Created by Aleksey Slesarev
 */
#include <cywin.h>

/*
 * FUNCTION: main
 *
 * DESCRIPTION: program entry point
 *
 * PARAMETERS:
 *   argc - number of arguments
 *   argv - array of 'argc' arguments passed to the application
 *   start - TRUE if the application is being initialized, FALSE otherwise
 *
 * RETURNS: 0L
 */
long main( int argc, char* argv[], bool start )
{
  struct module_t main_module;

  struct Input* ptr_input;

  struct Output* ptr_output;

  struct cDialog* ptr_edit_dialog;

  long index = 0;

  char file_contents[ 20 ];

  init_module( &main_module );

  // Reads the string from the "text.txt" resource file
  ptr_input =
    Archive_open_Ex( main_module.m_process->module->archive, "text.txt" );

  if( Input_is_good( ptr_input ))
  {
    while( file_contents[ index ] = (char) Input_read_byte( ptr_input ))
    {
      index++;
    }
  }
  Input_dtor( ptr_input, FREE_MEMORY );

  // Creates a dialog with the <Ok> and <Cancel> buttons and the edit line
  ptr_edit_dialog = malloc( sizeof *ptr_edit_dialog );

  cDialog_ctor( ptr_edit_dialog, 0, "Resource text.txt contents:",
    mbEdit | mbOk | mbCancel | mbs1, 19, main_module.m_process );

  ptr_edit_dialog->HelpContext = 0;
  
  // Sets the text in the dialog's edit box
  cDialog_SetEditText( ptr_edit_dialog, file_contents );

  if( cDialog_ShowModal( ptr_edit_dialog ) == mbOk )
  {
    cDialog_GetEditText( ptr_edit_dialog, file_contents );
  }
  cDialog_dtor( ptr_edit_dialog, FREE_MEMORY );
  
  // Writes string to the "text.txt" resource file
  ptr_output = Archive_open_write_Ex( main_module.m_process->module->archive,
    "text.txt" );
  
  Output_write( ptr_output, file_contents, strlen( file_contents ));

  Output_write_byte( ptr_output, '\0' );

  Output_dtor( ptr_output, FREE_MEMORY );

  return 0L;
}
