/*
 * FILE: dynamic.c
 *
 * DESCRIPTION:
 *   This file implements an exported function.
 *   Note that the definition doesn't contain a __dl directive, but
 *   the dynamic.h header is included instead.
 *
 * HISTORY:
 *   Mar 5, 2001 Created by Sergey Gromov
 */
#include <cybiko.h>
#include "dynamic.h"

/*
 * FUNCTION: simple_export
 *
 * DESCRIPTION: -
 *
 * PARAMETERS:
 *   str -
 *
 * RETURNS: -
 */
int simple_export( const char* str )
{
  TRACE( "Dynamic linkage: %s", str );

  return strlen( str );
}

/*
 * FUNCTION: main
 *
 * DESCRIPTION: program entry point
 *
 * PARAMETERS:
 *   argc - number of arguments
 *   argv - array of 'argc' arguments passed to the application
 *   start - TRUE if the application is being initialized, FALSE otherwise
 *
 * RETURNS: 0L
 */
long main( int argc, char* argv[], bool start )
{
  /* do nothing */

  return 0L;
}
