/*
 * FILE: dynamic.h
 *
 * DESCRIPTION:
 *   To EXPORT a function from a dynamic library, you must provide a prototype
 *   of the following form:
 *   
 *   __dl <export ordinal> <regular prototype>
 *
 *   To IMPORT a dynamically exported function its prototype must
 *   be of the form:
 *
 *   __dl <quoted library name> <export ordinal> <regular prototype>
 *
 *   To accomplish this, you usually make a header with prototypes
 *   and define some macro that expands in a library name when
 *   the header is included in the user file, and is empty when 
 *   it is included as a part of the library.
 *
 * HISTORY:
 *   Mar 5, 2001 Created by Sergey Gromov
 */
#ifdef LIB

  #define LIB_NAME

#else

  #define LIB_NAME "dynamic.dl"

#endif

__dl LIB_NAME 0 int simple_export( const char* str );