/*
 * FILE: Files.c
 *
 * DESCRIPTION: This tutorial shows how to work with files
 *
 * HISTORY:
 *   Sep 6, 2000 Created by Aleksey Slesarev
 */
#include <cywin.h>

/*
 * FUNCTION: main
 *
 * DESCRIPTION: program entry point
 *
 * PARAMETERS:
 *   argc - number of arguments
 *   argv - array of 'argc' arguments passed to the application
 *   start - TRUE if the application is being initialized, FALSE otherwise
 *
 * RETURNS: 0L
 */
long main( int argc, char* argv[], bool start )
{
  struct module_t main_module;

  struct FileInput* ptr_file_input;

  struct FileOutput* ptr_file_output;

  struct cDialog* ptr_edit_dialog;

  char file_contents[ 20 ];

  init_module( &main_module );
  
  // Reads string from the "text.dat" file
  ptr_file_input = (struct FileInput*) malloc( sizeof *ptr_file_input );

  FileInput_ctor_Ex( ptr_file_input, "text.dat" );

  if( FileInput_is_good( ptr_file_input ))
  {
    long file_size = FileInput_get_size( ptr_file_input );

    if( file_size > 0 && file_size < 20 )
    {
      FileInput_read( ptr_file_input, file_contents, file_size );

      file_contents[ file_size ] = '\0';
    }
    else
    {
      file_contents[ 0 ] = '\0';
    }
  }
  else
  {
    file_contents[ 0 ] = '\0';
  }
  FileInput_dtor( ptr_file_input, FREE_MEMORY );

  // Creates a dialog with the <Ok> and <Cancel> buttons and the edit line
  ptr_edit_dialog = malloc( sizeof *ptr_edit_dialog );

  cDialog_ctor( ptr_edit_dialog, 0, "File text.dat contents:",
    mbEdit | mbOk | mbCancel | mbs1, 19, main_module.m_process );

  ptr_edit_dialog->HelpContext = 0;

  // Sets text in the dialog's edit box.
  cDialog_SetEditText( ptr_edit_dialog, file_contents );

  if( cDialog_ShowModal( ptr_edit_dialog ) == mbOk )
  {
    cDialog_GetEditText( ptr_edit_dialog, file_contents );
  }
  cDialog_dtor( ptr_edit_dialog, FREE_MEMORY );

  // Writes string to the "text.dat" file
  ptr_file_output = (struct FileOutput*) malloc( sizeof *ptr_file_output );

  FileOutput_ctor_Ex( ptr_file_output, "text.dat", TRUE );

  FileOutput_write( ptr_file_output, file_contents, strlen( file_contents ));

  FileOutput_truncate( ptr_file_output, strlen( file_contents ));

  FileOutput_dtor( ptr_file_output, FREE_MEMORY );

  return 0L;
}
