/*
 * FILE: FlashDevices.c
 *
 * DESCRIPTION:
 *   This module contains routines for creating files on the
 *   Cybiko computer's flash drive, memory card flash drives
 *   and mp3 flash drives.
 *
 * HISTORY:
 *   Jan 23, 2001 Created by Diakov Oleg
 */
#include <cywin.h>

// Name of the flash device
typedef struct _TCreate
{
  char *DRIVE_NAME;
}
TCreate;

// Application's main module
struct module_t main_module;

// Main nenu form
struct cCustomForm* ptr_menu_form;

// Application's main menu
struct cList* ptr_menu;

bool TRUE_DEVICE = TRUE;

/*
 * FUNCTION: create_file
 *
 * DESCRIPTION: Creates a file on the device's flash drives
 *
 * PARAMETERS:
 *   pCreate -
 *
 * RETURNS: -
 */
void create_file( TCreate* pCreate )
{
  struct FileInput* ptr_file_input;

  struct FileOutput* ptr_file_output;

  struct cDialog* ptr_edit_dialog;

  struct cDialog* mp3_error_dialog;

  char* sz_full_file_name;

  char file_contents[ 20 ];

  long file_size;

  // Param sz_full_name is a full name of the file   
  sz_full_file_name = (char*) malloc( mFileName_max_file_name_length());

  // Creates a file on flash DRIVE_NAME
  // mFileName_make_path
  // Retrieves the file path from the absolute file name
  mFileName_make_path( sz_full_file_name, 
    pCreate->DRIVE_NAME, "text.dat" );

  ptr_file_input = (struct FileInput*) malloc( sizeof *ptr_file_input );

  FileInput_ctor_Ex( ptr_file_input, sz_full_file_name );

  if( FileInput_is_good( ptr_file_input ))
  {
    file_size = FileInput_get_size( ptr_file_input );

    if( file_size > 0  && file_size < 20 )
    {
      FileInput_read( ptr_file_input, file_contents, file_size );

      file_contents[ file_size ] = '\0';
    }
    else
    {
      file_contents[ 0 ] = '\0';
    }
  }
  else
  {
    file_contents[ 0 ] = '\0';
  }
  FileInput_dtor( ptr_file_input, FREE_MEMORY );

  // Creates an edit dialog with <Ok> and <Cancel> buttons and an edit line
  ptr_edit_dialog = malloc( sizeof *ptr_edit_dialog );

  if( File_bytes_total( pCreate->DRIVE_NAME ) > 0 )
  {
    cDialog_ctor( ptr_edit_dialog, 0, "File text.dat contents:",
      mbEdit | mbOk | mbCancel | mbs1, 19,
        main_module.m_process );

    ptr_edit_dialog->HelpContext = 2;

    // Sets text in the dialog's edit box
    cDialog_SetEditText( ptr_edit_dialog, file_contents );
  
    if( cDialog_ShowModal( ptr_edit_dialog ) == mbOk )
    {
      cDialog_GetEditText( ptr_edit_dialog, file_contents );
    }
    cDialog_dtor( ptr_edit_dialog, FREE_MEMORY );
  }
  if( File_bytes_total( MP3_DRIVE_NAME ) == 0 && 
    pCreate->DRIVE_NAME == MP3_DRIVE_NAME  && TRUE_DEVICE == TRUE )
  {
      mp3_error_dialog = malloc( sizeof *mp3_error_dialog );

      cDialog_ctor( mp3_error_dialog, 0,
        "You don't have MP3 device flash.", mbOk, 0,
           main_module.m_process );

      cDialog_ShowModal( mp3_error_dialog );

      cDialog_dtor( mp3_error_dialog, LEAVE_MEMORY );
  }

  ptr_file_output = (struct FileOutput*) malloc( sizeof *ptr_file_output );

  FileOutput_ctor_Ex( ptr_file_output, sz_full_file_name, TRUE );

  FileOutput_write( ptr_file_output, file_contents,
    strlen( file_contents ));

  FileOutput_truncate( ptr_file_output, strlen( file_contents ));

  FileOutput_dtor( ptr_file_output, FREE_MEMORY );

  free( sz_full_file_name );
}

/*
 * FUNCTION: cMainMenu_proc
 *
 * DESCRIPTION: Prosesses messages from the main menu.
 *
 * PARAMETERS:
 *   ptr_form -
 *   ptr_message -
 *
 * RETURNS: -
 */
bool cMainMenu_proc( struct cCustomForm* ptr_form,
  struct Message* ptr_message )
{
  struct cDialog error_dialog;

  TCreate Create;

  TRUE_DEVICE = TRUE;

  switch( ptr_message->msgid )
  {
    case MSG_SHUTUP:    
    case MSG_QUIT:

      ptr_form->ModalResult = mrQuit;

      return TRUE;

    case MSG_KEYDOWN: 

      if( Message_get_key_param( ptr_message )->scancode == KEY_ENTER )
      {
        switch( cList_Sel( ptr_menu ))
        {
          case 0:

            // Creates a file on the main flash drive
            Create.DRIVE_NAME = DEFAULT_DRIVE_NAME;

            if( File_bytes_total( DEFAULT_DRIVE_NAME ) == 0 )
            {
              cDialog_ctor( &error_dialog, NULL,
                "You don't have Device flash.", mbOk, 0,
                   main_module.m_process );

              cDialog_ShowModal( &error_dialog );

              cDialog_dtor( &error_dialog, FREE_MEMORY );
            }
            break;

          case 1:

            // Creates a file on the card flash drive

            Create.DRIVE_NAME = DRIVE_A_NAME;

            if( File_bytes_total( DRIVE_A_NAME ) == 0 )
            {
              cDialog_ctor( &error_dialog, NULL,
                "You don't have Memory Card flash.", mbOk, 0,
                   main_module.m_process );

              cDialog_ShowModal( &error_dialog );

              cDialog_dtor( &error_dialog, FREE_MEMORY );
            }
            break;

          case 2:

            // Creates a file on the mp3 flash drive
            Create.DRIVE_NAME = MP3_DRIVE_NAME;

            if( File_bytes_total( MP3_DRIVE_NAME ) == 0 )
            {
              cDialog_ctor( &error_dialog, NULL,
                "You don't have MP3 device flash.", mbOk, 0,
                   main_module.m_process );

              cDialog_ShowModal( &error_dialog );

              cDialog_dtor( &error_dialog, FREE_MEMORY );

              TRUE_DEVICE = FALSE;
            }
            break;
        }
        create_file( &Create );

        return TRUE;
      }
  }  
  return cCustomForm_proc( ptr_form, ptr_message );
}

/*
 * FUNCTION: cMainMenu_ShowModal
 *
 * DESCRIPTION: Shows the main menu of the application.
 *
 * PARAMETERS:
 *   ptr_form -
 *
 * RETURNS: -
 */
int cMainMenu_ShowModal( struct cCustomForm* ptr_form )
{
  cCustomForm_Show( ptr_form );
  
  ptr_form->ModalResult = mrNone;
  
  while( ptr_form->ModalResult == mrNone )
  {
    struct Message* ptr_message = 
      cWinApp_get_message( ptr_form->CurrApplication, 0, 1, MSG_USER );

    cMainMenu_proc( ptr_form, ptr_message );

    cCustomForm_update( ptr_form );

    Message_delete( ptr_message );
  }
  return ptr_form->ModalResult;
}

/*
 * FUNCTION: cMainForm_ctor
 *
 * DESCRIPTION: Initializes the main form of the application
 *
 * PARAMETERS:
 *   ptr_form -
 *   sz_caption -
 *   ptr_win_app -
 *
 * RETURNS: -
 */
struct cFrameForm* cMainForm_ctor( struct cFrameForm* ptr_form,
  char* sz_caption, struct cWinApp* ptr_win_app )
{
  int index;

  struct cText* ptr_text;

  struct cText* ptr_text_1;

  struct cText* ptr_text_2;

  struct cText* ptr_text_3;

  struct cText* ptr_text_4;

  struct cItem* ptr_menu_item;

  struct rect_t form_rect;

  static char* sz_menu_text[ 3 ] =
  {
    "Main flash", "Card flash", "MP3  flash"
  };

  // Initializes the application's main form
  cFrameForm_ctor( ptr_form, sz_caption, ptr_win_app );

  ptr_form->HelpContext = 0;

  ptr_form->ModalResult = mrNone;

  // Creates a menu
  ptr_menu = (struct cList*) malloc( sizeof *ptr_menu );

  cList_ctor( ptr_menu, 90 );
  
  // Adds items to the menu
  for( index = 0; index < 3; index++ )
  {
    ptr_menu_item = (struct cItem*) malloc( sizeof *ptr_menu_item );

    cItem_ctor( ptr_menu_item, 94, sz_menu_text[ index ], TRUE, NULL, NULL );

    cList_AddItem( ptr_menu, ptr_menu_item );
  }
  // Creates the form for the menu
  ptr_menu_form = (struct cCustomForm*) malloc( sizeof *ptr_menu_form );

  form_rect.x = 30;

  form_rect.y = 20;
  
  form_rect.w = 96;
  
  form_rect.h = 60;
  
  // Adds the menu to the menu form
  cCustomForm_ctor( ptr_menu_form, &form_rect, "Choose device", TRUE,
    ptr_win_app );

  ptr_menu_form->HelpContext = 1;

  ptr_menu_form->ModalResult = mrNone;

  // Creates text
  cCustomForm_AddObj( ptr_menu_form, ptr_menu, 0, 0 );

  cCustomForm_Hide( ptr_menu_form );

  // Adds the text to the main form
  ptr_text = (struct cText*) malloc( sizeof *ptr_text );

  cText_ctor( ptr_text, "This program create file on:", cool_normal_font,
    CLR_BLACK );  

  cFrameForm_AddObj( ptr_form, ptr_text, 6, 3 );

  ptr_text_1 = (struct cText*) malloc( sizeof *ptr_text_1 );

  cText_ctor( ptr_text_1, "Device Flash", cool_normal_font, CLR_BLACK );

  cFrameForm_AddObj( ptr_form, ptr_text_1, 16, 15 );

  ptr_text_2 = (struct cText*) malloc( sizeof *ptr_text_2 );

  cText_ctor( ptr_text_2, "Memory card flash", cool_normal_font, CLR_BLACK );

  cFrameForm_AddObj( ptr_form, ptr_text_2, 16, 27 );

  ptr_text_3 = (struct cText*) malloc( sizeof *ptr_text_3 );

  cText_ctor( ptr_text_3, "press <Enter> to continue", 
    mini_bold_font, CLR_BLACK );

  cFrameForm_AddObj( ptr_form, ptr_text_3, 6, 75 );

  ptr_text_4 = (struct cText*) malloc( sizeof *ptr_text_4 );

  cText_ctor( ptr_text_4, "MP3 device flash", cool_normal_font, CLR_BLACK );

  cFrameForm_AddObj( ptr_form, ptr_text_4, 16, 39 );
}

/*
 * FUNCTION: cMainForm_proc
 *
 * DESCRIPTION: Processes messages from the main form.
 *
 * PARAMETERS:
 *   ptr_form -
 *   ptr_message -
 *
 * RETURNS: -
 */
bool cMainForm_proc( struct cFrameForm* ptr_form, struct Message* ptr_message )
{
  struct KeyParam* ptr_key_param;

  struct cDialog* ptr_quit_dialog; 
  
  switch( ptr_message->msgid )
  {
    case MSG_SHUTUP: // Processes the system exit signal.
    case MSG_QUIT:

      ptr_form->ModalResult = mrQuit;

      break;

    case MSG_KEYDOWN: // Processes the keyboard 

      ptr_key_param = Message_get_key_param( ptr_message );

      switch( ptr_key_param->scancode ) 
      {
        case KEY_ESC:

          // Creates a dialog box with <Quit> and <Cancel> buttons.
          ptr_quit_dialog = (struct cDialog*) malloc( sizeof *ptr_quit_dialog );

          cDialog_ctor( ptr_quit_dialog, 0, str_Really_exit,
            mbQuit | mbCancel | mbs1, 0, ptr_form->CurrApplication );

          // The cDialog_ShowModal() function shows the dialog
          // and returns the code of the button pressed
          // If the user pressed the <Quit> button the application
          // will be closed otherwise it will continue a processing messages
          if( cDialog_ShowModal( ptr_quit_dialog ) == mrQuit )
          {
            ptr_form->ModalResult = mrQuit;
          }
          cDialog_dtor( ptr_quit_dialog, FREE_MEMORY );
    
          return TRUE;

        case KEY_ENTER:
          
          // When user presses the <Enter> key in the application's main form, 
          // the application creates a main menu.
          cMainMenu_ShowModal( ptr_menu_form );

          // Hides menu
          cCustomForm_Hide( ptr_menu_form );

          return TRUE;
      }
  }
  return cFrameForm_proc( ptr_form, ptr_message );
}

/*
 * FUNCTION: cMainForm_ShowModal
 *
 * DESCRIPTION: Shows the main form of the application.
 *
 * PARAMETERS:
 *   ptr_form -
 *
 * RETURNS: -
 */
int cMainForm_ShowModal( struct cFrameForm* ptr_form )
{ 
  cFrameForm_Show( ptr_form );

  ptr_form->ModalResult = mrNone;

  while( ptr_form->ModalResult == mrNone  &&
    ptr_menu_form->ModalResult != mrQuit )
  {
    struct Message *ptr_message = 
      cWinApp_get_message( ptr_form->CurrApplication, 
        0, 1, MSG_USER );

    cMainForm_proc( ptr_form, ptr_message );

    Message_delete( ptr_message );
  }
  return ptr_form->ModalResult;
}

/*
 * FUNCTION: main
 *
 * DESCRIPTION: program entry point
 *
 * PARAMETERS:
 *   argc - number of arguments
 *   argv - array of 'argc' arguments passed to the application
 *   start - TRUE if the application is being initialized, FALSE otherwise
 *
 * RETURNS: 0L
 */
long main( int argc, char* argv[], bool start )
{
  struct cFrameForm* ptr_main_form;

  init_module( &main_module );

  ptr_main_form = 
    (struct cFrameForm*) malloc( sizeof *ptr_main_form );

  cMainForm_ctor( ptr_main_form, "Flash Devices Tutorial",
    main_module.m_process );

  cMainForm_ShowModal( ptr_main_form );

  cFrameForm_dtor( ptr_main_form, FREE_MEMORY );

  return 0L;
}
