/*
 * FILE: Game.c
 *
 * DESCRIPTION:
 *   This module creates the game menu with the high scores file
 *
 * HISTORY:
 *   Jan 21, 2001 Created by Oleg Diakov
 */
#include <highscore.h>
#include "Menu.h"

struct cDialog player_dialog;
struct cFrameForm* ptr_main_form;
struct module_t main_module;

/*
 * FUNCTION: cMyApp_apprun
 *
 * DESCRIPTION: -
 *
 * PARAMETERS:
 *   ptr_win_app -
 *
 * RETURNS: nothing
 */
void cMyApp_apprun( struct cWinApp* ptr_win_app )
{
  struct DirectKeyboard* ptr_keyboard;

  bool end_game = FALSE; // Game status

  bool menu_active = TRUE; // Game menu status

  int index_menu = 0; // Game menu index

  ptr_keyboard = DirectKeyboard_get_instance();

  cWinApp_clear_screen();

  while( !end_game )
  {
    struct Message* ptr_message;

    if( menu_active )
    {
      index_menu = enter_menu( &main_module, index_menu ); 

      switch( index_menu )
      {
       case 0:

         // Creates a dialog with <Ok> and <Cancel> buttons.
         cDialog_ctor( &player_dialog, NULL, "Your game is here.", mbOk, 0,
              main_module.m_process ); 

         cDialog_ShowModal( &player_dialog );

         cDialog_dtor( &player_dialog, LEAVE_MEMORY );

         break;

       case 1:

         ptr_main_form->ModalResult = mrCancel;

         if( highscore_enter( &main_module, 0, HSM_SHOW ) == HSR_INVITE )
         {
           end_game = TRUE;
         }
         continue;

       default:

         end_game = TRUE;

         continue;
      }
    }
    ptr_message = cWinApp_get_message( ptr_win_app, 5, 1, MSG_USER );

    if( cWinApp_has_focus( ptr_win_app ))
    {
      if( !ptr_message ) continue;

      switch( ptr_message->msgid )
      {
        case MSG_LOSTFOCUS:

          vibrate( 0 );

          break;

        case MSG_GOTFOCUS:

          cWinApp_clear_screen();

          break;

        case MSG_QUIT:
        case MSG_SHUTUP:

          end_game = TRUE;

          continue;

        default:

          cWinApp_defproc( main_module.m_process, ptr_message );

          break;
      }
      Message_delete( ptr_message );
    }
  }
  DirectKeyboard_dtor( ptr_keyboard, FREE_MEMORY );
}

/*
 * FUNCTION: main
 *
 * DESCRIPTION: program entry point
 *
 * PARAMETERS:
 *   argc - number of arguments
 *   argv - array of 'argc' arguments passed to the application
 *   start - TRUE if the application is being initialized, FALSE otherwise
 *
 * RETURNS: 0L
 */
long main( int argc, char* argv[], bool start )
{
  init_module( &main_module );

  highscore_init( &main_module ); // Initializes the highscore module

  load_menu();

  cMyApp_apprun( main_module.m_process );

  release_menu();

  highscore_cleanup( &main_module ); // Saves and updates the highsre.inf

  return 0L;
}
