/*
 * FILE: MessageLoop.c
 *
 * DESCRIPTION: Implements the message processing function
 *
 * HISTORY:
 *   Sep 6, 2000 Created by Aleksey Slesarev
 */
#include <cywin.h>

/*
 * FUNCTION: message_loop
 *
 * DESCRIPTION: Processes messages for the application
 *
 * PARAMETERS:
 *   ptr_main_module -
 *
 * RETURNS: nothing
 */
void message_loop( struct module_t* ptr_main_module )
{
  bool exit_application = FALSE;

  while( !exit_application )
  {
    struct Message* ptr_message = 
      cWinApp_get_message( ptr_main_module->m_process, 0, 1, MSG_USER );

    switch( ptr_message->msgid )
    {
      case MSG_SHUTUP: // Processes the system exit signal
      case MSG_QUIT:

        exit_application = TRUE;

        break;

      case MSG_GOTFOCUS: // Redraws the screen

        DisplayGraphics_fill_screen( ptr_main_module->m_gfx, CLR_WHITE );

        DisplayGraphics_set_color( ptr_main_module->m_gfx, CLR_BLACK );

        DisplayGraphics_set_font( ptr_main_module->m_gfx, cool_normal_font );

        DisplayGraphics_draw_text( ptr_main_module->m_gfx,
          "Hello world !", 50, 35 );

        DisplayGraphics_show( ptr_main_module->m_gfx );

        break;

      case MSG_KEYDOWN: // Processes keyboard messages

        if( Message_get_key_param( ptr_message )->scancode == KEY_ESC )
        {
          exit_application = TRUE;

          break;
        }
      default: // Processes all unprocessed messages

        cWinApp_defproc( ptr_main_module->m_process, ptr_message );
    } 
    Message_delete( ptr_message );
  }
}
