/*
 * FILE: Step2.c
 *
 * DESCRIPTION: Interface tutorial, Step 2
 *
 * HISTORY:
 *   Sep 6, 2000 Created by Aleksey Slesarev
 */
#include <cywin.h>

/*
 * FUNCTION: cMainForm_proc
 *
 * DESCRIPTION: Processes messages for the the form
 *
 * PARAMETERS:
 *   ptr_frame_form - 
 *   ptr_message    - 
 *
 * RETURNS: -
 */
bool cMainForm_proc( struct cFrameForm* ptr_frame_form,
  struct Message* ptr_message )
{ 
  if( ptr_message->msgid == MSG_KEYDOWN && 
    Message_get_key_param( ptr_message )->scancode == KEY_ESC )
  {
    // Creates the dialog box with <Quit> and <Cancel> buttons.
    struct cDialog* ptr_quit_dialog = 
      (struct cDialog*) malloc( sizeof *ptr_quit_dialog );
    
    cDialog_ctor( ptr_quit_dialog, 0, str_Really_exit,
      mbQuit | mbCancel | mbs1, 0, ptr_frame_form->CurrApplication );

    // The cDialog_ShowModal() function shows the dialog
    // and returns the code of the button pressed
    // If the user pressed the <Quit> button, the application will close
    // otherwise it will continue processing messages
    if( cDialog_ShowModal( ptr_quit_dialog ) == mrQuit )
    {
      ptr_frame_form->ModalResult = mrQuit;
    }
    cDialog_dtor( ptr_quit_dialog, FREE_MEMORY );
    
    return TRUE;
  }
  return cFrameForm_proc( ptr_frame_form, ptr_message );
}

/*
 * FUNCTION: main
 *
 * DESCRIPTION: program entry point
 *
 * PARAMETERS:
 *   argc - number of arguments
 *   argv - array of 'argc' arguments passed to the application
 *   start - TRUE if the application is being initialized, FALSE otherwise
 *
 * RETURNS: 0L
 */
long main( int argc, char* argv[], bool start )
{
  struct module_t main_module;

  struct cFrameForm* ptr_frame_form;

  // Initializes the application
  init_module( &main_module );
  
  // Creates the application's main window class
  // with the "Interface Tutorial" caption
  ptr_frame_form = (struct cFrameForm*) malloc( sizeof *ptr_frame_form );

  cFrameForm_ctor( ptr_frame_form, "Interface Tutorial",
    main_module.m_process );

  ptr_frame_form->HelpContext = 0;
  
  // Shows the frame form
  cFrameForm_Show( ptr_frame_form );

  // Application's main loop
  ptr_frame_form->ModalResult = mrNone;

  while( ptr_frame_form->ModalResult == mrNone )
  {
    struct Message* ptr_message = 
      cWinApp_get_message( main_module.m_process, 0, 1, MSG_USER );

    switch( ptr_message->msgid )
    {
      case MSG_SHUTUP: // Processes the system exit signal
      case MSG_QUIT:

        ptr_frame_form->ModalResult = mrQuit;

        break;

      case MSG_KEYDOWN: // Processes keyboard input

        if( cMainForm_proc( ptr_frame_form, ptr_message ))
        {
          break;
        }
      default:

        // You must use the standard message processing function
        // for the other messages
        cWinApp_defproc( main_module.m_process, ptr_message );
    }
    Message_delete( ptr_message );
  }
  // Deletes all allocated objects
  cFrameForm_dtor( ptr_frame_form, FREE_MEMORY );

  return 0L;
}
