/*
 * FILE: Step3.c
 *
 * DESCRIPTION: Interface tutorial, Step 3
 *
 * HISTORY:
 *   Sep 6, 2000 Created by Aleksey Slesarev
 */
#include <cywin.h>

struct module_t main_module; // Application's main module

struct cCustomForm* ptr_menu_form; // Main menu form

struct cList* ptr_menu; // Application's main menu

/*
 * FUNCTION: cMyApp_on_menu1
 *
 * DESCRIPTION: Shows CyWin dialog 1
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void cMyApp_on_menu1( void )
{ 
  struct cDialog* ptr_dialog = 
    (struct cDialog*) malloc( sizeof *ptr_dialog );

  cDialog_ctor( ptr_dialog, 0, "dummy dialog 1", mbYes | mbNo | mbs2,
    0, main_module.m_process );

  cDialog_ShowModal( ptr_dialog );
  
  cDialog_dtor( ptr_dialog, FREE_MEMORY );
}

/*
 * FUNCTION: cMyApp_on_menu2
 *
 * DESCRIPTION: Shows CyWin dialog 2
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void cMyApp_on_menu2( void )
{
  struct cDialog* ptr_dialog =
    (struct cDialog*) malloc( sizeof *ptr_dialog );

  cDialog_ctor( ptr_dialog, "Caption", "dummy dialog 2", mbOk | mbs1,
    0, main_module.m_process );

  cDialog_ShowModal( ptr_dialog );
  
  cDialog_dtor( ptr_dialog, FREE_MEMORY );
}

/*
 * FUNCTION: cMyApp_on_menu3
 *
 * DESCRIPTION: Shows CyWin dialog 3
 *
 * PARAMETERS: none
 *
 * RETURNS: nothing
 */
void cMyApp_on_menu3( void )
{
  struct cDialog* ptr_dialog =
    (struct cDialog*) malloc( sizeof *ptr_dialog );

  cDialog_ctor( ptr_dialog, 0, "dummy dialog 3",
    mbQuit | mbCancel | mbEdit | mbs6, 10, main_module.m_process );

  cDialog_ShowModal( ptr_dialog );
  
  cDialog_dtor( ptr_dialog, FREE_MEMORY );
}

/*
 * FUNCTION: cMainMenu_proc
 *
 * DESCRIPTION: Prosesses messages for the main menu
 *
 * PARAMETERS:
 *   ptr_form    -
 *   ptr_message -
 *
 * RETURNS: -
 */
bool cMainMenu_proc( struct cCustomForm* ptr_form,
  struct Message* ptr_message )
{
  switch( ptr_message->msgid )
  {
    case MSG_SHUTUP: // Processes the system exit signal
    case MSG_QUIT:

      ptr_form->ModalResult = mrQuit;

      return TRUE;

    case MSG_KEYDOWN: // Processes keyboard input

      if( Message_get_key_param( ptr_message )->scancode == KEY_ENTER )
      {
        switch( cList_Sel( ptr_menu ))
        {
          case 0:

            cMyApp_on_menu1();

            break;

          case 1:

            cMyApp_on_menu2();

            break;

          case 2:

            cMyApp_on_menu3();
        }
        return TRUE;
      }
  }
  return cCustomForm_proc( ptr_form, ptr_message );
}

/*
 * FUNCTION: cMainMenu_ShowModal
 *
 * DESCRIPTION: Shows the main menu of the application
 *
 * PARAMETERS:
 *   ptr_form    -
 *
 * RETURNS: -
 */
int cMainMenu_ShowModal( struct cCustomForm* ptr_form )
{
  cCustomForm_Show( ptr_form );

  ptr_form->ModalResult = mrNone;

  while( ptr_form->ModalResult == mrNone )
  {
    struct Message* ptr_message = 
      cWinApp_get_message( ptr_form->CurrApplication, 0, 1, MSG_USER );

    cMainMenu_proc( ptr_form, ptr_message );

    cCustomForm_update( ptr_form );

    Message_delete( ptr_message );
  }
  return ptr_form->ModalResult;
}

/*
 * FUNCTION: cMainForm_ctor
 *
 * DESCRIPTION: Initializes the application's main form
 *
 * PARAMETERS:
 *   ptr_form - 
 *   sz_caption - 
 *   ptr_win_app -
 *
 * RETURNS: -
 */
struct cFrameForm* cMainForm_ctor( struct cFrameForm* ptr_form,
  char* sz_caption, struct cWinApp* ptr_win_app )
{
  int index;

  struct cText* ptr_text;

  struct rect_t form_rect;

  // Initializes the application's main form
  cFrameForm_ctor( ptr_form, sz_caption, ptr_win_app );

  ptr_form->HelpContext = 0;

  ptr_form->ModalResult = mrNone;

  // Creates a menu
  ptr_menu = (struct cList*) malloc( sizeof *ptr_menu );

  cList_ctor( ptr_menu, 80 );
  
  // Adds items to the menu
  for( index = 1; index < 4; index++ )
  {
    char sz_menu_text[ 8 ];

    struct cItem* ptr_menu_item = 
      (struct cItem*) malloc( sizeof *ptr_menu_item );

    sprintf( sz_menu_text, "Item %d", index );

    cItem_ctor( ptr_menu_item, 80, sz_menu_text, TRUE, NULL, NULL );

    cList_AddItem( ptr_menu, ptr_menu_item );
  }  
  // Creates the form for the menu
  ptr_menu_form = (struct cCustomForm*) malloc( sizeof *ptr_menu_form );

  form_rect.x = 40;

  form_rect.y = 20;

  form_rect.w = 86;

  form_rect.h = 60;

  cCustomForm_ctor( ptr_menu_form, &form_rect, "Main Menu",
    TRUE, ptr_win_app );

  ptr_menu_form->HelpContext = 0;

  ptr_menu_form->ModalResult = mrNone;

  // Adds the menu to the menu form
  cCustomForm_AddObj( ptr_menu_form, ptr_menu, 0, 0 );

  cCustomForm_Hide( ptr_menu_form );
  
  // Creates text
  ptr_text = (struct cText*) malloc( sizeof *ptr_text );

  cText_ctor( ptr_text, "Press <Enter>", cool_normal_font, CLR_BLACK );

  // Adds the text to the main form
  cFrameForm_AddObj( ptr_form, ptr_text, 42, 35 );
}

/*
 * FUNCTION: cMainForm_proc
 *
 * DESCRIPTION: Processes messages for the main form
 *
 * PARAMETERS:
 *   ptr_form    - 
 *   ptr_message - 
 *
 * RETURNS: -
 */
bool cMainForm_proc( struct cFrameForm* ptr_form, struct Message* ptr_message )
{
  struct KeyParam* ptr_key_param;

  struct cDialog* ptr_quit_dialog;
  
  switch( ptr_message->msgid )
  {
    case MSG_SHUTUP: // Processes the system exit signal
    case MSG_QUIT:

      ptr_form->ModalResult = mrQuit;

      break;

    case MSG_KEYDOWN: // Processes keyboard input

      ptr_key_param = Message_get_key_param( ptr_message );

      switch( ptr_key_param->scancode )
      {
        case KEY_ESC:

          // Creates the dialog box with <Quit> and <Cancel> buttons
          ptr_quit_dialog = 
            (struct cDialog*) malloc( sizeof *ptr_quit_dialog );

          cDialog_ctor( ptr_quit_dialog, 0, str_Really_exit,
            mbQuit | mbCancel | mbs1, 0, 
              ptr_form->CurrApplication );

          // The cDialog_ShowModal() function shows the dialog
          // and returns the code of the button pressed
          // If the user pressed the <Quit> button the application will closed
          // otherwise it will continue processing messages
          if( cDialog_ShowModal( ptr_quit_dialog ) == mrQuit )
          {
            ptr_form->ModalResult = mrQuit;
          }
          cDialog_dtor( ptr_quit_dialog, FREE_MEMORY );
    
          return TRUE;

        case KEY_ENTER:

          // When the user presses the <Enter> key in the application's main 
          // form, the application creates a main menu
          cMainMenu_ShowModal( ptr_menu_form );

          // Hides the menu
          cCustomForm_Hide( ptr_menu_form );

          return TRUE;
      }
  }
  return cFrameForm_proc( ptr_form, ptr_message );
}

/*
 * FUNCTION: cMainForm_ShowModal
 *
 * DESCRIPTION: Shows the main form of the application
 *
 * PARAMETERS:
 *   ptr_form    - 
 *
 * RETURNS: -
 */
int cMainForm_ShowModal( struct cFrameForm* ptr_form )
{
  cFrameForm_Show( ptr_form );

  ptr_form->ModalResult = mrNone;

  while( ptr_form->ModalResult == mrNone && 
    ptr_menu_form->ModalResult != mrQuit )
  {
    struct Message *ptr_message = 
      cWinApp_get_message( ptr_form->CurrApplication, 0, 
        1, MSG_USER );

    cMainForm_proc( ptr_form, ptr_message );

    Message_delete( ptr_message );
  }  
  return ptr_form->ModalResult;
}

/*
 * FUNCTION: main
 *
 * DESCRIPTION: program entry point
 *
 * PARAMETERS:
 *   argc - number of arguments
 *   argv - array of 'argc' arguments passed to the application
 *   start - TRUE if the application is being initialized, FALSE otherwise
 *
 * RETURNS: 0L
 */
long main( int argc, char* argv[], bool start )
{
  struct cFrameForm* ptr_main_form;

  // Initializes the application.
  init_module( &main_module );
  
  // Creates the application's main form
  // with the "Interface Tutorial" caption
  ptr_main_form = (struct cFrameForm*) malloc( sizeof *ptr_main_form );

  cMainForm_ctor( ptr_main_form, "Interface Tutorial", main_module.m_process );
  
  // Shows the main form
  cMainForm_ShowModal( ptr_main_form );

  // Performs cleanup
  cFrameForm_dtor( ptr_main_form, FREE_MEMORY );

  return 0L;
}
