/** 
 *  @file engine.h
 *  Hook to cywin cEngine classes.
 */
#ifndef __ENGINE_H_INCLUDED__
#define __ENGINE_H_INCLUDED__

/**
 *  @brief Provides timely graphical output.
 *  @ingroup base_group
 *  Provides timely graphical output.
 *  The screen shows only one cEngine object.
 *  @see base_group
 */
struct cEngine : public cClip
{
#ifndef _SKIP_DOC
  char cEngine_Members_STUB[152];
};
#endif

//============================
//=                          =
//=     object cEngine.      =
//= Timely graphical output. =
//=                          =
//============================

/**
 *  Locks a cEngine object. Updates are not performed while it is locked.
 *  After each cEngine_Lock function, the cEngine_Unlock function must be 
 *  called somewhere later in the program.
 *  @param ptr_engine A pointer to the initialized cEngine object
 *  @return Lock counter
 *  @code
 *       #include <cywin.h>
 *       ...
 *       cEngine_Lock( &Screen );
 *       ...
 *       //  Performs time-consuming drawing.
 *       ...
 *       cEngine_Unlock(  &Screen );
 *       ...
 *  @endcode
 *  @see cEngine_Unlock.
 */
#ifndef _SKIP_DOC
__cyos "CyWin" 84
#endif
int cEngine_Lock(struct cEngine* ptr_engine);

/**
 *  Unlocks a cEngine object. The cEngine_Unlock function must be called once for every time
 *  the cEngine_Lock function was called.
 *  @param ptr_engine A pointer to the initialized cEngine object
 *  @return Lock counter. If it is greater than 0, cEngine is still locked
 *  @code
 *       #include <cywin.h>
 *       ...
 *       cEngine_Lock( &Screen );
 *       //  Performs time-consuming drawing.
 *       ...
 *       cEngine_Unlock(  &Screen );
 *       ...
 *  @endcode
 *  @see cEngine_Lock.
 */
#ifndef _SKIP_DOC
__cyos "CyWin" 85
#endif
int cEngine_Unlock(struct cEngine* ptr_engine);

/**
 *  Global CyWin cEngine object.
 *  @code
 *       #include <cywin.h>
 *       ...
 *       cEngine_Lock( &Screen );
 *       ...
 *       //  Performs time-consuming drawing.
 *       ...
 *       cEngine_Unlock(  &Screen );
 *       ...
 *  @endcode
 */
#ifndef _SKIP_DOC
__cyos "CyWin" 76
#endif
struct cEngine Screen;

#ifdef _SKIP_DOC
};
#endif

#endif  // #ifndef __ENGINE_H_INCLUDED__
                     
