/** @defgroup system_supergroup %System
*/

/** @defgroup multithreads_overview Processes and Modules
 *  @brief These structures and functions are used to control the application as a whole. You may want to look at cWinApp and module_t structures.
 *
 *  These structures and functions are used to control the application as a whole. You may want to look at cWinApp and module_t structures.
*/

/** @defgroup syncronization_group Synchronization
 *  @brief Synchronization objects are used to synchronize access to shared objects. In many cases, you can use the Mutex structure.
 *
 *  Synchronization objects are used to synchronize access to shared objects. In many, cases you can use the Mutex structure.
*/

/** @defgroup memory_overview Memory Management
 *  @brief CyOS routines you can use to allocate, manipulate and free memory. 
 *
 *  CyOS routines you can use to allocate, manipulate and free memory.
*/

/** @defgroup time_overview Time-related
 *  @brief Some functions for setting and changing the date and time. Please look at the Time structure.
 *
 *  Some functions for setting and changing the date and time. Please look at the Time structure
*/

/** @defgroup sound_overview Sound, Music and Vibration
 *  @brief These structures are used to control sound, music and vibration in the Cybiko computer. Most music control methods can be found within the description of the MSequence structure.
 *
 *  These structures are used to control sound, music and vibration in the Cybiko computer. Most music control methods can be found within the description of the MSequence structure.
*/

/** @defgroup communications_supergroup %Communications
*/

/** @defgroup messaging_group Messaging
 *  @brief These functions and structures are used to send messages between applications, including those running on different Cybiko computers. You may also want to examine the Message and Buffer structures.
 *
 *  These functions and structures are used to send messages between applications, including those running on different Cybiko computers. You may also want to examine the Message and Buffer structures.
*/

/** @defgroup selecting_remote_partner_group Selecting Remote Partners
 *  @brief These structures allow the user to find a partner for a multiplayer game.
 *
 *  These structures allow the user to find a partner for a multiplayer game.
*/

/** @defgroup finder_related_group Finder-related
 *  @brief With these structures, you can gather information about the Cy-environment (that is, the other people and Cybiko computers in the vicinity). Finder is probably the most important of these structures.
 *
 *  With these structures, you can gather information about the Cy-environment (that is, the other people and Cybiko computers in the vicinity). Finder is probably the most important of these structures.
*/

/** @defgroup low_level_group Low Level
 *  @brief Some low level communication functions. Don't use these functions if you don't know exactly what are you doing.
 *
 *  Some low level communication functions. Don't use these functions if you don't know exactly what are you doing.
*/

/** @defgroup graphics_supergroup %Graphics
*/

/** @defgroup drawing_primitives_group Drawing Primitives and Screen Manipulation
 *  @brief These structures and functions are used for drawing various graphical primitives and displaying them onscreen. Please pay special attention to the DisplayGraphics and Graphics structures.
 *
 *  These structures and functions are used for drawing various graphical primitives and displaying them onscreen. Please pay special attention to the DisplayGraphics and Graphics structures.
*/

/** @defgroup bitmaps_and_bitmap_sequence_group Bitmaps and Bitmap Sequences
 *  @brief The Bitmap structure is used for work with a single bitmap, while the BitmapSequence is used for work with a Bitmap array. (see Bitmap and BitmapSequence).
 *
 *  The Bitmap structure is used for work with a single bitmap, while the BitmapSequence is used for work with a Bitmap array. (see Bitmap and BitmapSequence).
*/

/** @defgroup three_d 3D Graphics
 *  @brief These functions implement Wolfenstein3D/Ultima Underworld style graphics -- they simplify creation of your own 3D worlds. Please, pay special attention to the cy3d_draw_sprite() and cy3d_draw_wall() functions.
 *
 *  These functions implement Wolfenstein3D/Ultima Underworld style graphics -- they simplify creation of your own 3D worlds. Please, pay special attention to the cy3d_draw_sprite() and cy3d_draw_wall() functions.
*/

/** @defgroup fonts_and_text_group Fonts and Text
 *  @brief Some structures for work with text (please pay attention to Font structure).
 *
 *  Some structures for work with text (please pay attention to Font structure).
*/

/** @defgroup interface_supergroup %Interface Elements
*/

/** @defgroup application_group Application
 *  @brief These structures represent applications' major building blocks. In fact, your application is an instance of cWinApp (please note that module_t structure contains m_process field that is a pointer to 'your' instance), which is important, since it allows for the usage of forms, controls, as well as other interface elements.
 *
 *  These structures represent applications' major building blocks. In fact, your application is an instance of cWinApp (please note that module_t structure contains m_process field that is a pointer to 'your' instance), which is important, since it allows for the usage of forms, controls, as well as other interface elements.
*/

/** @defgroup base_group Base Structures
 *  @brief The most basic structures (cObject, cClip, etc.) that serve as a base for the rest of this group, save the AppGeneric and the cWinApp structures. Please pay special attention to the cEngine structure that provides a couple of quite useful services (also, note that there exists a single, unique instance of such an object in the system).
 *  
 *  The most basic structures (cObject, cClip, etc.) that serve as a base for the rest of this group, save the AppGeneric and the cWinApp structures. Please pay special attention to the cEngine structure that provides a couple of quite useful services (also, note that there exists a single, unique instance of such an object in the system).
*/

/** @defgroup forms_group Forms & Containers
 *  @brief Forms (cCustomForm, cFrameForm) are structures that can be used as containers that 'host' other elements, such as controls (see below). Please note that cDialog is a ready-to-use thing, you just have to provide its constructor with flags (there are about 40 bit masks for your convenience, so the whole thing is highly configurable).
 *
 *  Forms (cCustomForm, cFrameForm) are structures that can be used as containers that 'host' other elements, such as controls (see below). Please note that cDialog is a ready-to-use thing, you just have to provide its constructor with flags (there are about 40 bit masks for your convenience, so the whole thing is highly configurable).
*/

/** @defgroup controls_group Controls
 *  @brief This section groups standard controls found on many systems, such as cList (a list of selectable strings), cButton (a button with associated text and return value), cEdit (textual entry field), etc. These controls could be attached to the above described forms. Please note that cDialog is nothing else but a cCustomForm with several controls attached to it, according to the flags (its 'style') you pass to its constructor.
 *
 *  This section groups standard controls found on many systems, such as cList (a list of selectable strings), cButton (a button with associated text and return value), cEdit (textual entry field), etc. These controls could be attached to the above described forms. Please note that cDialog is nothing else but a cCustomForm with several controls attached to it, according to the flags (its 'style') you pass to its constructor.
*/

/** @defgroup variables_overview Built-in String Constants
 *  @brief String constants that are instantly usable from within your application or game.
 *
 *  String constants that are instantly usable from within your application or game.
*/


/** @defgroup input_and_output_supergroup %Input and Output
*/

/** @defgroup filesystem_overview File I/O
 *  @brief Structures of the File I/O section define the most basic file operations in the CyOS. Please look at Archive, FileInput, FileOutput and FileFind structures.
 *
 *  Structures of the File I/O section define the most basic file operations in the CyOS. These rules apply to file names that include any of these valid symbols:\n 
 *  valid_symbols = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM 1234567890-_+.()";\n
 *  start_disabled = " -+.";\n
 *  end_disabled = " -+."; 
*/

/** @defgroup keyboard_overview Keyboard Input
 *  @brief Some structures, functions and defines for work with keyboard. We recommend that you look at DirectKeyboard structure. It's more difficult, but it's a more effective way to handle keyboard input (the easy way is to just process respective Message's).
 *
 *  Some structures, functions and defines for work with keyboard. We recommend that you look at DirectKeyboard structure. It's more difficult, but it's a more effective way to handle keyboard input (the easy way is to just process respective Message's).
*/

/** @defgroup comport_overview Serial Port Access
 *  @brief Functions for working with com port. Please see the respective <a href="Tutorial.html#sect1-1">Accessing Serial Port  </a>tutorials.
 *
 *  Functions for working with com port. Please see the respective <a href="Tutorial.html#sect1-1">Accessing Serial Port </a>tutorial.
*/

/** @defgroup io_overview Formatted Output
 *  @brief With the help of these functions you can output data to either console or string buffer.
 *
 *  With the help of these functions you can output data to either console or string buffer.
*/

/** @defgroup utilities_supergroup %Utilities
*/

/** @defgroup string_overview String Manipulation
 *  @brief Some functions for string manipulations. Among these functions you can find ANSI C compatible ones( like strcpy(), strcmp() and others) as well as and functions specific to CyOS (is_pattern(), trunc_spaces(), strends()).
 *
 *  Some functions for string manipulations. Among these functions you can find ANSI C compatible ones( like strcpy(), strcmp() and others) as well as and functions specific to CyOS (is_pattern(), trunc_spaces(), strends()).
*/

/** @defgroup convertion_overview Conversion Routines
 *  @brief These functions are used to convert values from one format to another. Please make special note of cyid2str() and str2cyid(), because they can help to convert CyID to string and vice versa.
 *
 *  These functions are used to convert values from one format to another. Please make special note of cyid2str() and str2cyid(), because they can help to convert CyID to string and vice versa.
*/

/** @defgroup math_group Integer Math
 *  @brief Here you can find some mathematical functions, imin() and imax() among them. If you need to find the minimal or maximal of two numbers, look at these <b>efficient</b> functions.
 *
 *  Here you can find some mathematical functions, imin() and imax() among them. If you need to find the minimal or maximal of two numbers, look at these <b>efficient</b> functions.
*/

/** @defgroup vararg_overview Vararg Functions
 *  @brief Some functions for handling variable numbers of arguments (like those in stdarg.h).
 *
 *  Some functions for handling variable numbers of arguments (like those in stdarg.h).
*/

/** @defgroup misc_overview Miscellaneous
 *  @brief Structures and functions that don't fit anywhere else. By using Score structure methods, you make your game players' results available for upload to the Cybiko site. Thus, your game becomes contest-enabled!
 *
 *  Structures and functions that don't fit anywhere else. By using Score structure methods, you make your game players' results available for upload to the Cybiko site. Thus, your game becomes contest-enabled!
 *  
*/

