/** 
 *  @file round.h
 *  Function of drawing custom rectangle.
 */

#ifndef __ROUND_H_INCLUDED__
#define __ROUND_H_INCLUDED__

/**
 *  Arrow up.
 * @ingroup drawing_primitives_group
 */
#define ARROW_UP   0x01 

/**
 *  Arrow down.
 * @ingroup drawing_primitives_group
 */
#define ARROW_DOWN 0x02 

/**  
 *   Custom rectangle styles.
 * @ingroup drawing_primitives_group
 *   @see ARROW_UP, ARROW_DOWN.
 */
enum
{
  /**
   *  Simple rectangle.
   */
  RR_NONE = 0,

  /**
   *  Rectangle with an arrow at the top pointing up.
   */
  RR_ARROWUP = ARROW_UP,

  /**
   *  Rectangle with an arrow at the top pointing down.
   */
  RR_ARROWDOWN = ARROW_DOWN,

  /**
   *  Rectangle with rounded corners.
   */
  RR_ROUND = 4,

  /**
   *  Clear background.
   */
  RR_ERASE = 8
};

/**
 *  @ingroup drawing_primitives_group
 *   Draws a custom rectangle with caption. 
 *   There are five rectangle styles: RR_NONE, RR_ARROWUP, RR_ARROWDOWN, RR_ROUND and RR_ERASE. 
 *   @param ptr_graphics a pointer to an initialized Graphics object.
 *   @param ptr_rectangle a pointer to the bounding rectangle.
 *   @param style the rectangle's style.
 *   @param sz_caption the rectangle's caption.
 *   @return None.
 *   @code
 *        #include <cywin.h>
 *        ...
 *        struct rect_t rect;
 *        struct module_t main_module;
 *        ...
 *        init_module( &main_module );
 *        rect_set( &rect, 10, 10, 100, 100 );
 *        ...
 *        draw_roundrect( main_module.m_gfx, &rect, RR_ROUND, "Rect caption" );
 *        ...
 *   @endcode
 */
#ifndef _SKIP_DOC
__cyos "CyWin" 253
#endif
void draw_roundrect(struct Graphics* ptr_graphics, struct rect_t* ptr_rectangle, int style, char* sz_caption);

#endif  // #ifndef __ROUND_H_INCLUDED__

