/**
 *  @file vibrator.h
 *  Vibrator control functions.
 */

#ifndef __VIBRATOR_H_INCLUDED__
#define __VIBRATOR_H_INCLUDED__

/** 
 *  @ingroup sound_overview
 *  Enables or disables vibration.
 *  @param enable If TRUE, vibration will be enabled, else one will be disabled.
 *  @return None.
 *  @code
 *       #include <cybiko.h>
 *       ...
 *       struct module_t main_module;
 *       ...
 *       init_module( &main_module );
 *       ...
 *       enable_vibration( TRUE );
 *       ...
 *       vibrate( 255 );
 *       cWinApp_pause( main_module.m_process, 250 );
 *       vibrate( 0 );
 *       ...
 *  @endcode
 *  @see vibrate.
 */
#ifndef _SKIP_DOC
__cyos 541
#endif
void enable_vibration(bool enable);

/** 
 *  @ingroup sound_overview
 *  Turns the vibrator on (if index > 0) or off (if index is 0).
 *  The greater the index (0 .. 255), the stronger the vibrations.
 *  @param index Strength of the vibration (0 .. 255). If \a index is 0, 
 *  vibration will stop.
 *  @return None.
 *  @code
 *       #include <cybiko.h>
 *       ...
 *       struct module_t main_module;
 *       ...
 *       init_module( &main_module );
 *       ...
 *       enable_vibration( TRUE );
 *       ...
 *       vibrate( 255 );
 *       cWinApp_pause( main_module.m_process, 250 );
 *       vibrate( 0 );
 *       ...
 *  @endcode
 *  @see enable_vibration.
 */
#ifndef _SKIP_DOC
__cyos 1271
#endif
void vibrate(int index);

#endif  //  #ifndef __VIBRATOR_H_INCLUDED__






