
#line 1 "src/yopu.c"


#line 14 "d:\PROGRA~1\CYBIKO\SDK/inc/cyber-types.h"
typedef char bool;

#line 20
typedef int seek_t;

#line 25
typedef long clock_t;

#line 30
typedef clock_t time_t;

#line 35
typedef int size_t;

#line 40
typedef int priority_t;

#line 45
typedef int click_kind_t;

#line 50
typedef long cyid_t;

#line 55
typedef int delivery_t;

#line 60
typedef int color_t;

#line 65
typedef int drawmode_t;


struct rect_t
{

short x;


short y;


short w;


short h;
};

#line 112
__cyos 1089

void rect_set(struct rect_t* ptr_rect, int x, int y, int width, int height);

#line 145
__cyos 368

bool rect_and(struct rect_t* ptr_rect, struct rect_t* ptr_rect_1, struct rect_t* ptr_rect_2);

#line 176
__cyos 922

bool rect_or(struct rect_t* ptr_rect, struct rect_t* ptr_rect_1, struct rect_t* ptr_rect_2);

#line 9 "d:\PROGRA~1\CYBIKO\SDK/inc/time.h"
struct Time
{

char year;


char month;


char day;


char hour;


char minute;


char second;


char hundreds;


char Time_PADDING;

};

#line 55
__cyos 489

void Time_decode(struct Time* ptr_time, time_t time);

#line 84
__cyos 543

time_t Time_encode(struct Time* ptr_time);

#line 104
__cyos 1082

bool Time_set_RTC(struct Time* ptr_time);

#line 125
__cyos 621

bool Time_get_RTC(struct Time* ptr_time);

#line 146
__cyos 749

int Time_get_weekday(struct Time* ptr_time);

#line 167
__cyos 1316

int Time_clear_alarm_flag(void);

#line 188
__cyos 1317

bool Time_enable_alarm_int(bool enable);

#line 207
__cyos 451

clock_t clock(void);

#line 227
__cyos 1249

time_t time(void);

#line 22 "d:\PROGRA~1\CYBIKO\SDK/inc/cyber.h"
enum Flags
{
FLAG_BAD = 1,
FLAG_EOF = 2,
FLAG_EXCEPTIONS = 4
};

#line 53
struct Buffer
{

char Buffer_Members_STUB[40];

};

#line 76
struct Input
{

char Input_Members_STUB[20];

};

#line 99
struct Output
{

char Output_Members_STUB[20];

};

#line 110
struct Flag
{

char Flag_Members_STUB[32];

};

#line 135
struct Mutex
{

char Mutex_Members_STUB[28];

};

#line 163
struct Flagex : public Mutex
{

char Flagex_Members_STUB[4];

};

#line 201
__cyos 222

struct Buffer* Buffer_ctor(struct Buffer* ptr_buffer, size_t size, size_t increment);

#line 232
__cyos 221

struct Buffer* Buffer_ctor_Ex(struct Buffer* ptr_buffer, struct Buffer* templ);

#line 263
__cyos 1196

void Buffer_store(struct Buffer* ptr_buffer, void* ptr_data , size_t offset, size_t length);

#line 290
__cyos 1201

void Buffer_store_string(struct Buffer* ptr_buffer, char* str, size_t offset);

#line 320
__cyos 851

void* Buffer_load(struct Buffer* ptr_buffer, void* ptr_data, size_t offset, size_t length);

#line 362
__cyos 862

char* Buffer_load_string(struct Buffer* ptr_buffer, char* str, size_t offset, size_t length);

#line 400
__cyos 728

size_t Buffer_get_size(struct Buffer* ptr_buffer);


__cyos 1165
size_t Buffer_size(struct Buffer* ptr_buffer);

#line 435
__cyos 628

size_t Buffer_get_allocated_size(struct Buffer* ptr_buffer);

#line 467
__cyos 467

void Buffer_compact(struct Buffer* ptr_buffer);

#line 500
__cyos 1154

bool Buffer_set_size(struct Buffer* ptr_buffer, size_t size);

#line 523
__cyos 612

void Buffer_free(struct Buffer* ptr_buffer);

#line 551
__cyos 548

bool Buffer_ensure_size(struct Buffer* ptr_buffer, size_t test_size);


__cyos 642
char Buffer_get_byte(struct Buffer* ptr_buffer, size_t offset);



__cyos 1099
void Buffer_set_byte(struct Buffer* ptr_buffer, size_t offset, char data);

#line 588
__cyos 648

char Buffer_get_char(struct Buffer* ptr_buffer, size_t offset);

#line 614
__cyos 1100

void Buffer_set_char(struct Buffer* ptr_buffer, size_t offset, char data);

#line 641
__cyos 682

int Buffer_get_int(struct Buffer* ptr_buffer, size_t offset);

#line 667
__cyos 1129

void Buffer_set_int(struct Buffer* ptr_buffer, size_t offset, int data);

#line 694
__cyos 685

long Buffer_get_long(struct Buffer* ptr_buffer, size_t offset);

#line 720
__cyos 1133

void Buffer_set_long(struct Buffer* ptr_buffer, size_t offset, long data);

#line 748
__cyos 815

bool Buffer_is_locked(struct Buffer* ptr_buffer);

#line 780
__cyos 866

void* Buffer_lock(struct Buffer* ptr_buffer);

#line 811
__cyos 1262

void Buffer_unlock(struct Buffer* ptr_buffer);

#line 848
__cyos 107

void Buffer_dtor(struct Buffer* ptr_buffer, int);

#line 895
import 3

long Input_seekg(struct Input* ptr_input, long pos, seek_t mode);

#line 922
import 4

long Input_tellg(struct Input* ptr_input);

#line 948
import 22

long Input_read(struct Input* ptr_input, void* buffer, long length);

#line 972
import 5

int Input_read_byte(struct Input* ptr_input);

#line 997
import 21

int Input_get_flags(struct Input* ptr_input);

#line 1030
import 1

long Input_get_size(struct Input* ptr_input);

#line 1058
import 2

void Input_dtor(struct Input* ptr_input, int);

#line 1088
__cyos 1007

short Input_read_word(struct Input* ptr_input);

#line 1116
__cyos 1001

long Input_read_dword(struct Input* ptr_input);

#line 1165
import 6

long Output_seekp(struct Output* ptr_output, long pos, seek_t mode);

#line 1194
import 7

long Output_tellp(struct Output* ptr_output);

#line 1225
import 26

long Output_write(struct Output* ptr_output, void* buffer, long length);

#line 1252
import 8

int Output_write_byte(struct Output* ptr_output, int byte);

#line 1282
import 25

int Output_get_flags(struct Output* ptr_output);

#line 1319
import 23

long Output_get_size(struct Output* ptr_output);

#line 1349
import 24

void Output_dtor(struct Output* ptr_output, int);

#line 1383
__cyos 1298

short Output_write_word(struct Output* ptr_output, short word);

#line 1415
__cyos 1293

long Output_write_dword(struct Output* ptr_output, long dword);

#line 1455
__cyos 209

struct Flag* Flag_ctor(struct Flag* ptr_flag, char* name, bool set);

#line 1490
__cyos 1087

void Flag_set(struct Flag* ptr_flag);

#line 1525
__cyos 1088

void Flag_set_Ex(struct Flag* ptr_flag, bool state);

#line 1559
__cyos 439

void Flag_clear(struct Flag* ptr_flag);

#line 1586
__cyos 821

bool Flag_is_set(struct Flag* ptr_flag);

#line 1616
__cyos 600

void Flag_flip(struct Flag* ptr_flag);

#line 1650
__cyos 1279

bool Flag_wait_set(struct Flag* ptr_flag, clock_t timeout);

#line 1684
__cyos 1275

bool Flag_wait_clear(struct Flag* ptr_flag, clock_t timeout);

#line 1719
__cyos 1273

bool Flag_wait(struct Flag* ptr_flag, bool set, clock_t timeout);

#line 1756
__cyos 214

struct Mutex* Mutex_ctor(struct Mutex* ptr_mutex, char* name);

#line 1783
__cyos 814

bool Mutex_is_locked(struct Mutex* ptr_mutex);

#line 1819
__cyos 865

bool Mutex_lock(struct Mutex* ptr_mutex, clock_t timeout);


__cyos 1022
void Mutex_release(struct Mutex* ptr_mutex);

#line 1857
__cyos 1261

void Mutex_unlock(struct Mutex* ptr_mutex);

#line 1893
__cyos 223

struct Flagex* Flagex_ctor(struct Flagex* ptr_flagex, char* name);

#line 1924
__cyos 1274

bool Flagex_wait(struct Flagex* ptr_flagex, clock_t timeout);

#line 1951
__cyos 903

void Flagex_notify(struct Flagex* ptr_flagex);

#line 1992
__cyos 1128

void set_hourglass(bool enable);

#line 2012
__cyos 701

cyid_t get_own_id(void);

#line 36 "d:\PROGRA~1\CYBIKO\SDK/inc/cyber-graph.h"
struct Bitmap
{

char Members_STUB_1[12];


int w;
int h;


char Members_STUB_2[12];


};

#line 65
__cyos 217

struct Bitmap* Bitmap_ctor(struct Bitmap* ptr_bitmap);

#line 85
__cyos 218

struct Bitmap* Bitmap_ctor_Ex1(struct Bitmap* ptr_bitmap, char* filename);

#line 107
__cyos 220

struct Bitmap* Bitmap_ctor_Ex2(struct Bitmap* ptr_bitmap, int width, int height, int bpp);

#line 132
__cyos 219

struct Bitmap* Bitmap_ctor_Ex3(struct Bitmap* ptr_bitmap, struct Bitmap* templ);

#line 155
__cyos 106

void Bitmap_dtor(struct Bitmap* ptr_bitmap, int);


__cyos 430
char* Bitmap_class_name(struct Bitmap*);

#line 180
__cyos 584

void Bitmap_fill(struct Bitmap* ptr_bitmap, color_t color);

#line 202
__cyos 440

void Bitmap_clear(struct Bitmap* ptr_bitmap);

#line 232
__cyos 846

bool Bitmap_load(struct Bitmap* ptr_bitmap, struct Input* input);

#line 264
__cyos 1195

bool Bitmap_store(struct Bitmap* ptr_bitmap, struct Output* output);


__cyos 750
int Bitmap_get_width(struct Bitmap* ptr_bitmap);



__cyos 677
int Bitmap_get_height(struct Bitmap* ptr_bitmap);



__cyos 714
struct rect_t* Bitmap_get_rect(struct Bitmap* ptr_bitmap, struct rect_t* rc);



__cyos 713
struct rect_t* Bitmap_get_r(struct Bitmap* ptr_bitmap, struct rect_t* rc);

#line 306
struct BitmapSequence
{

char BitmapSequence_Members_STUB[ 48 ];

};

#line 327
__cyos 192

struct BitmapSequence* BitmapSequence_ctor(struct BitmapSequence* ptr_bitmap_sequence);

#line 345
__cyos 193

struct BitmapSequence* BitmapSequence_ctor_Ex(struct BitmapSequence* ptr_bitmap_sequence, char* file_name);

#line 367
__cyos 96

void BitmapSequence_dtor(struct BitmapSequence* ptr_bitmap_sequence, int);


__cyos 424
char* BitmapSequence_class_name(struct BitmapSequence* ptr_bitmap_sequence);

#line 393
__cyos 727

int BitmapSequence_get_size(struct BitmapSequence* ptr_bitmap_sequence);


__cyos 751
int BitmapSequence_get_x(struct BitmapSequence* ptr_bitmap_sequence, int bitmap_index);



__cyos 753
int BitmapSequence_get_y(struct BitmapSequence* ptr_bitmap_sequence, int bitmap_index);

#line 425
__cyos 634

struct Bitmap* BitmapSequence_get_bitmap(struct BitmapSequence* ptr_bitmap_sequence, int bitmap_index);

#line 452
__cyos 842

bool BitmapSequence_load(struct BitmapSequence* ptr_bitmap_sequence, struct Input* input);

#line 486
__cyos 1194

bool BitmapSequence_store(struct BitmapSequence* ptr_bitmap_sequence, struct Output* output);

#line 512
struct Font : public BitmapSequence
{

char Font_Members_STUB[ 40 ];

};

#line 522
__cyos 468

struct Font* cool_bold_font;

#line 529
__cyos 469

struct Font* cool_normal_font;

#line 536
__cyos 891

struct Font* mini_bold_font;

#line 543
__cyos 892

struct Font* mini_normal_font;

#line 561
__cyos 210

struct Font* Font_ctor(struct Font* ptr_font);

#line 582
__cyos 211

struct Font* Font_ctor_Ex(struct Font* ptr_font, char* file_name, bool fixed, int spacing);

#line 604
__cyos 102

void Font_dtor(struct Font* ptr_font, int);


__cyos 428
char* Font_class_name(struct Font* ptr_font);

#line 631
__cyos 691

char* Font_get_name(struct Font* ptr_font);

#line 652
__cyos 1135

void Font_set_name(struct Font* ptr_font, char* filename);

#line 675
__cyos 651

int Font_get_char_width(struct Font* ptr_font, int chr);

#line 700
__cyos 736

int Font_string_width(struct Font* ptr_font, char* str);

#line 726
__cyos 737

int Font_string_width_Ex(struct Font* ptr_font, char* str, int len);

#line 749
__cyos 649

int Font_get_char_height(struct Font* ptr_font);

#line 770
__cyos 809

bool Font_is_fixed(struct Font* ptr_font);

#line 790
__cyos 1123

void Font_set_fixed(struct Font* ptr_font, bool fixed);

#line 812
__cyos 730

int Font_get_spacing(struct Font* ptr_font);

#line 833
__cyos 1155

void Font_set_spacing(struct Font* ptr_font, int spacing);

#line 859
__cyos 844

bool Font_load(struct Font* ptr_font, struct Input* input);

#line 883
__cyos 387

struct Bitmap* Font_bmp_by_char(struct Font* ptr_font, int chr);

#line 905
__cyos 1169

char* Font_split_string(struct Font* ptr_font, char** str, int width, int* len);

#line 931
struct TGraph
{

char TGraph_Members_STUB_1[12];
char* _buf;
char TGraph_Members_STUB_2[16];

};

#line 970
import 9

void TGraph_draw_rect(struct TGraph* ptr_graph, int x, int y, int w, int h);

#line 997
import 10

void TGraph_draw_rect_Ex(struct TGraph* ptr_graph, struct rect_t* rc);


__cyos 112
void TGraph_dtor(struct TGraph* ptr_graph, int);

#line 1032
import 11

void TGraph_fill_rect(struct TGraph* ptr_graph, int x, int y, int w, int h);

#line 1062
import 12

void TGraph_fill_rect_Ex(struct TGraph* ptr_graph, struct rect_t* rc);

#line 1089
import 13

color_t TGraph_get_color(struct TGraph* ptr_graph);

#line 1121
import 14

drawmode_t TGraph_get_draw_mode(struct TGraph* ptr_graph);

#line 1153
import 15

void TGraph_set_draw_mode(struct TGraph* ptr_graph, drawmode_t mode);



import 16
void TGraph_set_line_style(struct TGraph* ptr_graph, short mask);

#line 1187
__cyos 528

void TGraph_draw_hline(struct TGraph* ptr_graph, int x, int y, int dx);

#line 1214
__cyos 534

void TGraph_draw_vline(struct TGraph* ptr_graph, int x, int y, int dy);

#line 1240
__cyos 530

void TGraph_draw_line(struct TGraph* ptr_graph, int x1, int y1, int x2, int y2);

#line 1265
__cyos 587

void TGraph_fill_screen(struct TGraph* ptr_graph, color_t fc);

#line 1290
__cyos 655

void TGraph_get_clip(struct TGraph* ptr_graph, struct rect_t* rc);

#line 1313
__cyos 709

color_t TGraph_get_pixel(struct TGraph* ptr_graph, int x, int y);

#line 1352
__cyos 966

void TGraph_put_background(struct TGraph* ptr_graph, char* ptr_background);

#line 1391
__cyos 645

int TGraph_get_bytes_total(struct TGraph* ptr_graph);

#line 1421
__cyos 1057

void TGraph_scroll(struct TGraph* ptr_graph, int left, int top, int width, int height, int dx, int dy);

#line 1452
__cyos 1098

void TGraph_set_bkcolor(struct TGraph* ptr_graph, color_t color);

#line 1477
__cyos 1104

void TGraph_set_clip(struct TGraph* ptr_graph, int x, int y, int width, int height);

#line 1509
__cyos 1103

void TGraph_set_clip_Ex(struct TGraph* ptr_graph, struct rect_t* rc);

#line 1537
__cyos 1108

void TGraph_set_color(struct TGraph* ptr_graph, color_t color);

#line 1561
__cyos 1142

void TGraph_set_pixel(struct TGraph* ptr_graph, int x, int y, color_t color);

#line 1582
struct Graphics : public TGraph
{

char Graphics_Members_STUB[12];

};

#line 1603
__cyos 243

struct Graphics* Graphics_ctor(struct Graphics* ptr_gfx);

#line 1626
__cyos 244

struct Graphics* Graphics_ctor_Ex(struct Graphics* ptr_gfx, struct Bitmap* bitmap);




__cyos 435
char* Graphics_class_name(struct Graphics* ptr_gfx);

#line 1658
__cyos 526

void Graphics_draw_bitmap(struct Graphics* ptr_gfx, struct Bitmap* bmp, int left, int top, short fm);

#line 1683
__cyos 527

int Graphics_draw_char(struct Graphics* ptr_gfx, int x, int y, char fc);

#line 1706
__cyos 532

void Graphics_draw_text(struct Graphics* ptr_gfx, char* text, int left, int top);

#line 1729
__cyos 533

void Graphics_draw_text_Ex(struct Graphics* ptr_gfx, char* str, int left, int top, int len);

#line 1751
__cyos 635

struct Bitmap* Graphics_get_bitmap(struct Graphics* ptr_gfx);

#line 1776
__cyos 650

int Graphics_get_char_height(struct Graphics* ptr_gfx);

#line 1801
__cyos 652

int Graphics_get_char_width(struct Graphics* ptr_gfx, char chr);

#line 1826
__cyos 673

struct Font* Graphics_get_font(struct Graphics* ptr_gfx);

#line 1852
__cyos 738

int Graphics_string_width(struct Graphics* ptr_gfx, char* str);

#line 1878
__cyos 739

int Graphics_string_width_Ex(struct Graphics* ptr_gfx, char* str, int len);

#line 1902
__cyos 1097

void Graphics_set_bitmap(struct Graphics* ptr_gfx, struct Bitmap* bmp);

#line 1925
__cyos 1126

void Graphics_set_font(struct Graphics* ptr_gfx, struct Font* font);

#line 1966
struct DisplayGraphics : public Graphics
{

char DisplayGraphics_Members_STUB[12];

};

#line 2001
import 18

void draw_lib(int lib_index,int frame,int x,int y,short mode);




__cyos 425
char* DisplayGraphics_class_name(struct DisplayGraphics*);

#line 2062
__cyos 599

void DisplayGraphics_flip(struct DisplayGraphics*);

#line 2091
__cyos 702

int DisplayGraphics_get_page(struct DisplayGraphics*);

#line 2130
__cyos 703

char* DisplayGraphics_get_page_ptr(struct DisplayGraphics* ptr_gfx, int page);

#line 2166
__cyos 935

void DisplayGraphics_page_copy(struct DisplayGraphics* ptr_gfx,int from_page,int to_page,int x,int y,int w,int h);

#line 2204
__cyos 934

void DisplayGraphics_page_copy_Ex(struct DisplayGraphics* ptr_gfx,int from_page,int to_page,struct rect_t* rc);

#line 2237
__cyos 1137

void DisplayGraphics_set_page(struct DisplayGraphics*,int fp);

#line 2279
__cyos 1163

void DisplayGraphics_show(struct DisplayGraphics*);

#line 2322
__cyos 1164

void DisplayGraphics_show_Ex(struct DisplayGraphics*,int page);

#line 133 "d:\PROGRA~1\CYBIKO\SDK/inc/cyber-message.h"
enum qflag_t
{
QF_NONE = 0,
QF_DEVICES = 1,
QF_FILES = 2,
QF_APPMASK = 0x1000,
QF_ALL = 0xffff
};


enum keymask_t
{

KEYMASK_SHIFT = 0x0001,

KEYMASK_CTRL = 0x0002,

KEYMASK_AUTOREPEAT = 0x0004
};

#line 159
struct Queue
{

char Queue_Members_STUB;

};

#line 169
struct Message
{

struct Buffer* buffer;
char procname[12];

struct Message* next;
char* dst_name;
cyid_t cyid_from;
cyid_t cyid_to;
bool deleted;

bool PADDING;

short msgid;
long param[2];


void* session;

};

#line 194
struct KeyParam
{
int scancode;
int mask;
char ch;
};

#line 204
struct PDParam
{
int x;
int y;
int mask;
};

#line 214
struct file_event_t
{

#line 219
int kind;


char device;
};

#line 257
__cyos 270

struct Message* Message_new(size_t sizeof_Message);

#line 289
__cyos 804

bool Message_is_broadcast(struct Message*);

#line 312
__cyos 943

bool Message_post(struct Message*, char* process_name, cyid_t cyid);

#line 333
__cyos 945

void Message_post_all(struct Message*, short mask);

#line 374
__cyos 501

void* Message_deliver(struct Message*, char* process_name, cyid_t cyid, clock_t timeout);

#line 427
__cyos 413

delivery_t Message_check_delivery(struct Message*);

#line 466
__cyos 1277

delivery_t Message_wait_delivery(struct Message*, struct Flag* flag);

#line 496
__cyos 757

bool Message_has_buffer(struct Message*);

#line 526
__cyos 640

struct Buffer* Message_get_buffer(struct Message*);

#line 564
__cyos 373

void Message_attach_buffer(struct Message*,struct Buffer* buffer);

#line 589
__cyos 470

void Message_copy(struct Message*, struct Message* templ);

#line 609
__cyos 265

void Message_delete(struct Message*);

#line 640
__cyos 940

struct Message* Queue_peek_message(struct Queue* ptr_queue, bool remove, int min, int max);

#line 667
__cyos 687

struct Message* Queue_get_message(struct Queue* ptr_queue, long timeout, int min, int max);

#line 698
__cyos 975

void Queue_put_message(struct Queue* ptr_queue, struct Message* ptr_message);


__cyos 692
char* Queue_get_name(struct Queue* ptr_queue);




__cyos 1076
bool send_msg(char* app_name,int msgid,long d0,long d1,void* data,size_t size);

__cyos 1075
bool send_copy_msg(char* app_name,struct Message* msg);

__cyos 1081
bool send_remote_msg(cyid_t cyid,char* app_name,int msgid,long d0,long d1,void* data,size_t size);

__cyos 1080
bool send_remote_copy_msg(cyid_t cyid,char* app_name,struct Message* msg);

__cyos 1078
bool send_msg_launch(char* app_name);

#line 21 "d:\PROGRA~1\CYBIKO\SDK/inc/archive.h"
struct Archive
{

char* name;
void* index;
short total_entries;
short PADDING;

};

#line 39
__cyos 789
void Archive_init(struct Archive* ptr_archive);

#line 77
__cyos 916

struct Input* Archive_open(struct Archive* ptr_archive, int entry);

#line 111
__cyos 915

struct Input* Archive_open_Ex(struct Archive* ptr_archive, char* name);

#line 143
__cyos 1334

struct Output* Archive_open_write(struct Archive* ptr_archive, int entry);

#line 176
__cyos 1333

struct Output* Archive_open_write_Ex(struct Archive* ptr_archive, char* name);

#line 209
__cyos 693

char* Archive_get_name(struct Archive* ptr_archive, int entry);

#line 16 "d:\PROGRA~1\CYBIKO\SDK/inc/module.h"
struct Module
{

char Module_Members_STUB_1[84];


struct Archive* archive;


char Module_Members_STUB_2[32];

};


enum modulestate_t
{

MODULE_OK = 0,


MODULE_BAD,


MODULE_TIMEOUT
};

#line 68
__cyos 555

int execute_module(char* comstr, long* retcode, clock_t timeout);

#line 90
__cyos 1177

bool start_module(char* command_line);

#line 119
__cyos 920

struct Input* open_resource(int index);

#line 147
__cyos 919

struct Input* open_resource_Ex(char* name);

#line 166
__cyos 770

void increment_usage(void);

#line 185
__cyos 495

void decrement_usage(void);

#line 20 "d:\PROGRA~1\CYBIKO\SDK/inc/process.h"
struct SystemThread
{

char SystemThread_Members_STUB[40];
bool wake_state;
char wake_state_PADDING[3];
void* controller;
clock_t total_time;
clock_t last_time;
clock_t start_time;
clock_t end_time;
bool resume_status;
char resume_status_PADDING[3];
char* stack_top;
char* stack_bottom;
long flags;


struct Module* module;


char priority;
char saved_priority;
char priority_PADDING[2];
struct SystemThread* next;
void* sp;
void* sp_peak;
void* queue;

};

#line 65
struct Thread : public SystemThread
{

int stack_size;
int stack_size_PADDING;

};

#line 80
struct Process : public Thread
{

char Process_Members_STUB[56];

};

#line 110
__cyos 939

bool SystemThread_pause(struct SystemThread*, clock_t);

#line 127
__cyos 711

priority_t SystemThread_get_priority(struct SystemThread* ptr_system_thread);

#line 145
__cyos 1147

void SystemThread_set_priority(struct SystemThread* ptr_system_thread, priority_t priority);

#line 177
__cyos 1034

struct Process* Process_request_focus(struct Process*);

#line 198
__cyos 758

bool Process_has_focus(struct Process*);

#line 221
__cyos 666

struct DisplayGraphics* Process_get_display(void);

#line 15 "d:\PROGRA~1\CYBIKO\SDK/inc/cyber-files.h"
struct FileInput : public Input
{

char FileInput_Members_STUB[64];

};

#line 25
struct FileOutput : public Output
{

char FileOutput_Members_STUB[64];

};

#line 35
struct File
{

void* vtable;



char name[64];


long size;


time_t modification_time;
};


struct FileFind
{

void* vtable;
char mask[ 64 ];
char fname[ 64 ];
int lastfile;
int PADDING;
struct File* fileinfo;

};




struct FileBase
{
char FileBase_Members_STUB[64];
};

#line 104
__cyos 250

struct FileInput* FileInput_ctor_STUB(struct FileInput* ptr_file_input, int Magic);

#line 132
__cyos 251

struct FileInput* FileInput_ctor_Ex_STUB(struct FileInput* ptr_file_input, int Magic, char* file_name);


__cyos 436
char* FileInput_class_name(struct FileInput* ptr_file_input);

#line 165
__cyos 914

bool FileInput_open(struct FileInput* ptr_file_input, char* file_name);

#line 200
__cyos 1061

long FileInput_seek(struct FileInput* ptr_file_input, long pos, seek_t mode);

#line 227
__cyos 1236

long FileInput_tell(struct FileInput* ptr_file_input);

#line 276
__cyos 174

struct FileOutput* FileOutput_ctor_STUB(struct FileOutput* ptr_file_output, int Magic);

#line 303
__cyos 175

struct FileOutput* FileOutput_ctor_Ex_STUB(struct FileOutput* ptr_file_output, int Magic, char* filename, bool create, short attr);


__cyos 420
char* FileOutput_class_name(struct FileOutput* ptr_file_output);

#line 340
__cyos 912

bool FileOutput_open_STUB(struct FileOutput* ptr_file_output, char* file_name, bool create, short attr);

#line 376
__cyos 1060

long FileOutput_seek(struct FileOutput* ptr_file_output, long pos, seek_t mode);

#line 403
__cyos 1235

long FileOutput_tell(struct FileOutput* ptr_file_output);

#line 428
__cyos 1257

bool FileOutput_truncate(struct FileOutput* ptr_file_output, long position);

#line 471
__cyos 207

struct File* File_ctor(struct File* ptr_file);

#line 497
__cyos 208

struct File* File_ctor_Ex(struct File* ptr_file, char* filename);


__cyos 1003
bool File_read_opened(struct File* ptr_file);



__cyos 1295
bool File_write_opened(struct File* ptr_file);

#line 532
__cyos 810

bool File_is_free(struct File* ptr_file);


__cyos 1093
bool File_set_attribute(struct File* ptr_file, short attr);

__cyos 631
short File_get_attribute(struct File* ptr_file);

#line 569
__cyos 1348

time_t File_get_date(struct File* ptr_file);

#line 597
__cyos 1349

bool File_set_date(struct File* ptr_file, time_t date);

#line 622
__cyos 680

bool File_get_info(struct File* ptr_file, char* filename);


__cyos 427
char* File_class_name(struct File* ptr_file);

__cyos 572
int File_file_header_size(char* name);

#line 655
__cyos 614

long File_free_bytes_total(char* devname);

#line 680
__cyos 616

long File_free_user_bytes_total(char* devname);

#line 705
__cyos 582

long File_files_total(char* devname);

#line 730
__cyos 396

long File_bytes_total(char* devname);

#line 755
__cyos 386

long File_blocks_total(char* devname);

#line 780
__cyos 377

long File_bad_blocks_total(char* devname);

#line 805
__cyos 384

int File_block_size(char* devname);

#line 830
__cyos 613

long File_free_blocks_total(char* devname);

#line 855
__cyos 389

bool File_bootable(char* devname);

#line 876
__cyos 826

bool File_is_valid_name(char* filename);

#line 895
__cyos 1033

bool File_rename(char* old_filename, char* new_filename);

#line 919
__cyos 1026

bool File_remove(char* filename);

#line 943
__cyos 557

bool File_exists(char* filename);

#line 982
__cyos 241

struct FileFind* FileFind_ctor(struct FileFind* ptr_file_find, struct File* file_info, char* mask);

#line 1010
__cyos 760

bool FileFind_has_more_elements(struct FileFind* ptr_file_find);

#line 1047
__cyos 791

void FileFind_init(struct FileFind* ptr_file_find, struct File* file_info, char* mask);


__cyos 434
char* FileFind_class_name(struct FileFind* ptr_file_find);

#line 1080
__cyos 901

struct File* FileFind_next_element(struct FileFind* ptr_file_find);

#line 25 "d:\PROGRA~1\CYBIKO\SDK/inc/cyber-rf.h"
__cyos 710
bool get_power(void);

__cyos 1145
void set_power(bool increased);

#line 45
__cyos 660

bool get_communications(void);

#line 61
__cyos 1109

void set_communications(bool enable);

#line 86
__cyos 629

char get_appchannel(void);

#line 112
__cyos 630

char get_appchannel_of(cyid_t device);

#line 137
__cyos 1091

void set_appchannel(char channel);

#line 159
__cyos 1096

char set_best_appchannel(char group);


__cyos 716
int get_rfchannel(void);

__cyos 1150
void set_rfchannel(int no);

__cyos 718
bool get_server_mode(void);

__cyos 1152
void set_server_mode(bool enable);

#line 198
__cyos 675

char get_groupchannel(char group,char channel);

#line 222
__cyos 1127

char set_groupchannel(char group,char channel);

#line 247
__cyos 1315

char get_group_size(char group);

#line 272
__cyos 705

int get_people_on_channel(char channel);

#line 296
__cyos 704

cyid_t get_people_around(cyid_t prev_device);

#line 323
__cyos 1268

void update_people_around(clock_t timeout);

#line 348
__cyos 1342

bool is_rf_paused(void);

#line 373
__cyos 1344

void rf_pause(void);

#line 398
__cyos 1345

void rf_resume(void);


__cyos 707
char* get_ping_listener(void);

__cyos 1141
void set_ping_listener(char* app_name);

__cyos 1039
void reset_ping_listener(char* app_name);

__cyos 1341
bool is_gate_visible(void);

__cyos 1340
long get_gate_cyid(void);

#line 435
__cyos 1343

clock_t last_rf_clock(void);

#line 456
__cyos 832

time_t last_rf_time(void);


__cyos 1269
void update_rf_time(void);

#line 484
__cyos 484

void cyid2str(char* str, cyid_t cyid);

#line 508
__cyos 1205

cyid_t str2cyid(char* str);

#line 10 "d:\PROGRA~1\CYBIKO\SDK/inc/cyber-lib.h"
struct bitset
{

short size;
short PADDING;
char* val;

};

#line 39
__cyos 233

struct bitset* bitset_ctor(struct bitset* ptr_bitset, short size);

#line 59
__cyos 441

void bitset_clear(struct bitset* ptr_bitset);

#line 83
__cyos 553

void bitset_excl(struct bitset* ptr_bitset, short bit);

#line 109
__cyos 767

bool bitset_in(struct bitset* ptr_bitset, short bit);

#line 140
__cyos 768

void bitset_incl(struct bitset* ptr_bitset, short bit);

#line 164
__cyos 366

void bitset_add(struct bitset* ptr_bitset_1, struct bitset* ptr_bitset_2);

#line 188
__cyos 898

void bitset_mul(struct bitset* ptr_bitset_1, struct bitset* ptr_bitset_2);

#line 212
__cyos 1219

void bitset_sub(struct bitset* ptr_bitset_1, struct bitset* ptr_bitset_2);

#line 239
__cyos 114

void bitset_dtor(struct bitset* ptr_bitset, int);

#line 29 "d:\PROGRA~1\CYBIKO\SDK/inc/tone_gen.h"
__cyos 729

bool get_sounds_enabled(void);

#line 46
__cyos 539

void enable_sounds(bool enable);

#line 62
__cyos 380

void beep(int beep_type);

#line 78
__cyos 823

bool is_tone_playing(void);

#line 101
__cyos 942

void play_tone(int index);

#line 130
__cyos 941

void play_raw(int divisor);

#line 157
__cyos 1190

void stop_tone(void);

#line 27 "d:\PROGRA~1\CYBIKO\SDK/inc/vibrator.h"
__cyos 541

void enable_vibration(bool enable);

#line 51
__cyos 1271

void vibrate(int index);

#line 35 "d:\PROGRA~1\CYBIKO\SDK/inc/cybiko.h"
struct AppGeneric : public Process
{

bool cls;
bool exit_to_root;
bool enable_section_keys;
bool PADDING_1;
int HelpContext;
int PADDING_2;

};

#line 52
struct cWinApp : public AppGeneric
{

char cWinApp_Members_STUB[52];

};

#line 63
struct module_t
{
struct DisplayGraphics* m_gfx;
struct cWinApp* m_process;

long m_tick;
short m_tick_period;
short m_key;
short m_key_mask;
char m_visible;
char m_quit;

};

#line 102
import 0

long init_module(struct module_t* module);

#line 118
import 17

long random(int max);



import 19
void xlib_load( void );

import 20

void xlib_free( void );

#line 150
__cyos 75

void TRACE(char const* fmt,...);

#line 170
__cyos 478

int cprintf(char* fmt,...);


__cyos 407
int cgetch(clock_t timeout);

__cyos 408
int cgets(char* buff,size_t max_size,clock_t timeout);

__cyos 479
void cputch(char chr,clock_t timeout);

__cyos 480
void cputs(char* str,clock_t timeout);

#line 203
__cyos 876

char* malloc(size_t size);

#line 223
__cyos 399

void* calloc(size_t num,size_t size);

#line 246
__cyos 1008

void* realloc(void* block,size_t new_size);

#line 262
__cyos 610

void free(void* block);

#line 280
__cyos 816

bool is_low_memory(void);

#line 295
__cyos 717

size_t get_safety_pool_size(void);

#line 315
__cyos 884

void* memset(void* buff,int val,size_t size);

#line 343
__cyos 882

void* memcpy(void* dst,void* src,size_t size);

#line 370
__cyos 883

void* memmove(void* dst,void* src,size_t size);

#line 389
__cyos 881

int memcmp(void* buff1,void* buff2,size_t size);

#line 408
__cyos 1218

char* strstr(char* str1,char* str2);

#line 427
__cyos 1209

char* strcpy(char* dst,char* src);

#line 447
__cyos 1215

int strncpy(char* dst,char* src,size_t size);

#line 467
__cyos 1208

int strcmp(char* str1,char* str2);

#line 488
__cyos 1214

int strncmp(char* str1,char* str2,size_t size);

#line 507
__cyos 1207

char* strchr(char* str,char chr);

#line 526
__cyos 1216

char* strrchr(char* str,int chr);


__cyos 1210
char* strdup(char* str);

#line 551
__cyos 1217

bool strstarts(char* str,char* pattern);

#line 571
__cyos 1211

bool strends(char* str,char* pattern);

#line 589
__cyos 1213

bool strmatch(char* pattern,char* str);

#line 610
__cyos 1170

int sprintf(char* buff,char* fmt,...);

#line 632
__cyos 1272

int vsprintf(char* buff,char* fmt,void* argv);

#line 649
__cyos 817

bool is_pattern(char* name);

#line 666
__cyos 1166

char* skipws(char* str);

#line 684
__cyos 372

long atoul(char* str);

#line 706
__cyos 1299

long xtoi(char* str);

#line 724
__cyos 765

long htoul(char* str);


__cyos 938
int parse_int(char** ptr);

__cyos 356
int _rand(void);

__cyos 982
int rand(void);

#line 754
__cyos 1171

void srand(int seed);


__cyos 759
bool has_focus(void);

#line 776
__cyos 562

void exit(int exit_code);

#line 792
__cyos 1350

long get_hardware_version(void);

#line 810
__cyos 1212

size_t strlen(char* str);

#line 828
__cyos 1206

char* strcat(char* str1,char* str2);

#line 35 "d:\PROGRA~1\CYBIKO\SDK/inc/appgen.h"
__cyos "CyWin" 4

struct DisplayGraphics* AppGeneric_init_display(void);

#line 59
__cyos "CyWin" 5

void AppGeneric_clear_screen(void);

#line 81
__cyos "CyWin" 7

void AppGeneric_proc(struct AppGeneric*, struct Message*);

#line 109
__cyos "CyWin" 9

void AppGeneric_cancel_shutup(struct AppGeneric* ptr_app_generic);

#line 138
__cyos "CyWin" 307

void AppGeneric_ext_cancel_shutup(void);

#line 9 "d:\PROGRA~1\CYBIKO\SDK/inc/around.h"
enum
{

SGP_NONE = 0x0,

SGP_HOT_SEAT = 0x4,

SGP_CYBIKO = 0x2,

SGP_CYBIKO_EASY = 0x10,

SGP_CYBIKO_HARD = 0x20,

SGP_SINGLE_GAME = 0x40,

SGP_CYLANDIA = 0x100,


SGP_DONT_INVITE = 0x8000
};


enum
{

SGP_RES_HOT_SEAT = -3L,

SGP_RES_CYBIKO = -2L,

SGP_RES_CYBIKO_EASY = -5L,

SGP_RES_CYBIKO_HARD = -6L,

SGP_RES_SINGLE_GAME = -7L
};


enum invite_mode_t
{

IM_DEFAULT = 0x1000000,

IM_GAME = 0x02000000,

IM_CHAT = 0x3000000,

IM_PHONEBOOK = 0x4000000
};

#line 92
__cyos "CyWin" 23

cyid_t select_partner(struct Process*, int, char *);

#line 138
__cyos "CyWin" 313

cyid_t select_partner_Ex(struct Process*, int, char*, char*, cyid_t*);

#line 196
__cyos "CyWin" 314

cyid_t select_app_partner(struct Process*, char*, int, char*, char*, long, cyid_t*);

#line 246
__cyos "CyWin" 25

cyid_t select_game_partner(struct Process*, char*, int, char*);

#line 13 "d:\PROGRA~1\CYBIKO\SDK/inc/object.h"
struct cObject
{

char cObject_Members_STUB[20];

};

#line 26
struct cClip : public cObject
{

char cClip_Members_STUB[28];

};

#line 45
__cyos "CyWin" 227
struct cObject* cObject_ctor(struct cObject*);

#line 58
__cyos "CyWin" 182
void cObject_dtor(struct cObject*, int);

#line 93
__cyos "CyWin" 184

void cObject_Disconnect(struct cObject*);

#line 121
__cyos "CyWin" 186

bool cObject_Select(struct cObject*);

#line 150
__cyos "CyWin" 188

void cObject_update(struct cObject*);

#line 180
__cyos "CyWin" 221

struct cClip* cObject_GetParent(struct cObject*);

#line 210
__cyos "CyWin" 223

void cObject_Hide(struct cObject*);

#line 240
__cyos "CyWin" 224

void cObject_Show(struct cObject*);

#line 272
__cyos "CyWin" 225

void cObject_Disable(struct cObject*);

#line 304
__cyos "CyWin" 226

void cObject_Enable(struct cObject*);

#line 340
__cyos "CyWin" 185

bool cObject_proc(struct cObject*, struct Message*);

#line 352
enum tScrolls
{

sNone = 0,

sUp = 1,

sDown = 2,

sUpDown = 3
};

#line 371
__cyos "CyWin" 204
struct cClip* cClip_ctor(struct cClip*, int, int);

#line 385
__cyos "CyWin" 206
void cClip_dtor(struct cClip*, int);

#line 412
__cyos "CyWin" 220

void cClip_AddObj(struct cClip*, struct cObject*, int, int);

#line 447
__cyos "CyWin" 207

void cClip_InsObj(struct cClip*, struct cObject*, int, int, int);

#line 474
__cyos "CyWin" 189

void cClip_RemObj(struct cClip*, struct cObject*);

#line 509
__cyos "CyWin" 197

bool cClip_SelectFirst(struct cClip*);

#line 548
__cyos "CyWin" 198

bool cClip_SelectPrev(struct cClip*, bool);

#line 587
__cyos "CyWin" 199

bool cClip_SelectNext(struct cClip*, bool);

#line 620
__cyos "CyWin" 201

void cClip_Scroll(struct cClip* ptr_clip, struct rect_t* rectangle);

#line 650
__cyos "CyWin" 203

void cClip_Scroll_Ex(struct cClip* ptr_clip, int x, int y);

#line 681
__cyos "CyWin" 211

void cClip_SendScroll(struct cClip* ptr_clip);

#line 716
__cyos "CyWin" 212

int cClip_GetShifty(struct cClip* ptr_clip);

#line 751
__cyos "CyWin" 213

int cClip_GetShiftx(struct cClip* ptr_clip);

#line 786
__cyos "CyWin" 216

int cClip_GetCount(struct cClip* ptr_clip);

#line 828
__cyos "CyWin" 217

struct cObject* cClip_get_by_index(struct cClip*, int);

#line 867
__cyos "CyWin" 218

int cClip_FindObj(struct cClip*, struct cObject*);

#line 907
__cyos "CyWin" 219

struct cObject* cClip_GetSelectedObject(struct cClip* ptr_clip);

#line 917
__cyos "CyWin" 202
bool cClip_proc(struct cClip* ptr_clip, struct Message* ptr_message);

#line 11 "d:\PROGRA~1\CYBIKO\SDK/inc/engine.h"
struct cEngine : public cClip
{

char cEngine_Members_STUB[172];

};

#line 53
__cyos "CyWin" 78

struct cEngine* cEngine_ctor(struct cEngine*);

#line 90
__cyos "CyWin" 86

void cEngine_dtor(struct cEngine*, int);

#line 112
__cyos "CyWin" 84

int cEngine_Lock(struct cEngine*);

#line 133
__cyos "CyWin" 85

int cEngine_Unlock(struct cEngine*);

#line 150
__cyos "CyWin" 76

struct cEngine Screen;

#line 11 "d:\PROGRA~1\CYBIKO\SDK/inc/controls.h"
struct cBox : public cObject
{

char cBox_Members_STUB[4];

};

#line 24
struct cBevel : public cObject
{

char cBevel_Members_STUB[4];

};

#line 34
struct cBitmap : public cObject
{

char cBitmap_Members_STUB[36];

};

#line 46
struct cEdit : public cObject
{

char cEdit_Members_STUB[64];

};

#line 58
struct cProgressBar : public cBevel
{

char cProgressBar_Members_STUB[36];

};

#line 95
__cyos "CyWin" 74

struct cBox* cBox_ctor(struct cBox*, int, int, color_t, bool);

#line 122
__cyos "CyWin" 67

void cBox_dtor(struct cBox*, int);

#line 144
enum tBevelSidesTypes
{

Top = 1,


Bottom = 2,


Left = 4,


Right = 8,


All = 15
};

#line 186
__cyos "CyWin" 73

struct cBevel* cBevel_ctor(struct cBevel*, int, int, color_t, char);

#line 214
__cyos "CyWin" 63

void cBevel_dtor(struct cBevel*, int);

#line 261
__cyos "CyWin" 32

struct cBitmap* cBitmap_ctor(struct cBitmap*, struct Bitmap*);

#line 293
__cyos "CyWin" 30

struct cBitmap* cBitmap_ctor_Ex(struct cBitmap*, struct Bitmap*, color_t);

#line 326
__cyos "CyWin" 65

void cBitmap_dtor(struct cBitmap*, int);

#line 357
__cyos "CyWin" 72

void cBitmap_SetFlips(struct cBitmap*, short);

#line 379
enum tEditStyles
{

es_normal = 0,


es_readonly = 1,


es_password = 2,


es_centered = 4
};


enum tEditCursorCommand
{

mc_lineup = 0,


mc_linedown = 1,


mc_pageup = 2,


mc_pagedown = 3,


mc_home = 4,


mc_end = 5
};

#line 447
__cyos "CyWin" 34

struct cEdit* cEdit_ctor(struct cEdit*, struct Font*, int, int, color_t, int);

#line 481
__cyos "CyWin" 37

void cEdit_dtor(struct cEdit*, int);

#line 514
__cyos "CyWin" 39

void cEdit_HighliteText(struct cEdit*, bool);

#line 549
__cyos "CyWin" 44

bool cEdit_SetReadOnly(struct cEdit*, bool);

#line 590
__cyos "CyWin" 45

int cEdit_SetPageLineCount(struct cEdit*, int);

#line 623
__cyos "CyWin" 47

bool cEdit_IsHighlited(struct cEdit*);

#line 661
__cyos "CyWin" 48

int cEdit_SetCursorPos(struct cEdit*, int);

#line 700
__cyos "CyWin" 49

int cEdit_MoveCursor(struct cEdit*, int);

#line 740
__cyos "CyWin" 50

int cEdit_GetCursorPos(struct cEdit*);

#line 774
__cyos "CyWin" 51

int cEdit_SetText(struct cEdit*, char*);

#line 809
__cyos "CyWin" 52

int cEdit_AppendText(struct cEdit*, char*);

#line 845
__cyos "CyWin" 53

int cEdit_SetText_Ex(struct cEdit*, struct Input*);

#line 881
__cyos "CyWin" 54

int cEdit_GetText_Ex(struct cEdit*, struct Output*);

#line 920
__cyos "CyWin" 68

bool cEdit_IsModified(struct cEdit*);

#line 959
__cyos "CyWin" 69

int cEdit_GetTextLength(struct cEdit*);

#line 991
__cyos "CyWin" 70

char* cEdit_GetBufferPtr(struct cEdit*);

#line 1031
__cyos "CyWin" 71

int cEdit_GetText(struct cEdit*, char*);

#line 1066
__cyos "CyWin" 57

bool cEdit_proc(struct cEdit*, struct Message*);

#line 1121
__cyos "CyWin" 58

struct cProgressBar* cProgressBar_ctor(struct cProgressBar*, int, int, int, struct Font*, color_t, color_t, int);

#line 1157
__cyos "CyWin" 62

void cProgressBar_dtor(struct cProgressBar*, int);

#line 1197
__cyos "CyWin" 61

void cProgressBar_SetCurrentPos(struct cProgressBar*, int);

#line 15 "d:\PROGRA~1\CYBIKO\SDK/inc/lists.h"
struct cList : public cClip
{
};

#line 25
struct cItem : public cObject
{

char cItem_Members_STUB[20];

};

#line 38
struct cXItem : public cItem
{

char cXItem_Members_STUB[32];

};

#line 50
struct cXStr : public cXItem
{

char cXStr_Members_STUB[48];

};

#line 62
struct cSItem : public cItem
{

char cSItem_Members_STUB[4];

};

#line 75
struct cXByte : public cXStr
{

char cXByte_Members_STUB[8];

};

#line 123
__cyos "CyWin" 123

struct cList* cList_ctor(struct cList*, int);

#line 165
__cyos "CyWin" 125

void cList_dtor(struct cList*, int);

#line 204
__cyos "CyWin" 177

void cList_AddItem(struct cList*, struct cObject*);

#line 244
__cyos "CyWin" 126

void cList_AddItem_Ex(struct cList*, struct cObject*, int);

#line 287
__cyos "CyWin" 127

void cList_RemItem(struct cList*, struct cObject*);

#line 333
__cyos "CyWin" 128

bool cList_proc(struct cList*, struct Message*);

#line 386
__cyos "CyWin" 176

int cList_Sel(struct cList*);

#line 472
__cyos "CyWin" 129

struct cItem* cItem_ctor(struct cItem*, int, char*, bool, char*, struct Bitmap*);

#line 518
__cyos "CyWin" 172

void cItem_dtor(struct cItem*, int);

#line 561
__cyos "CyWin" 175

char* cItem_GetTitle(struct cItem*);

#line 591
__cyos "CyWin" 131

bool cItem_proc(struct cItem*, struct Message*);

#line 664
__cyos "CyWin" 133

struct cXItem* cXItem_ctor(struct cXItem*, int, char*, char**, char*, bool, bool, struct Bitmap**, char*);

#line 718
__cyos "CyWin" 135

void cXItem_dtor(struct cXItem*, int);

#line 771
__cyos "CyWin" 136

void cXItem_SelLeft(struct cXItem*);

#line 824
__cyos "CyWin" 137

void cXItem_SelRight(struct cXItem*);

#line 877
__cyos "CyWin" 138

void cXItem_SetLeft(struct cXItem*, int);

#line 930
__cyos "CyWin" 139

void cXItem_SetRight(struct cXItem*, int);

#line 984
__cyos "CyWin" 140

void cXItem_OK(struct cXItem*);

#line 1038
__cyos "CyWin" 141

void cXItem_Esc(struct cXItem*);

#line 1099
__cyos "CyWin" 142

bool cXItem_proc(struct cXItem*, struct Message*);

#line 1167
__cyos "CyWin" 145

struct cXStr* cXStr_ctor(struct cXStr*, int, char*, char*, int, int, struct Bitmap **, char*, bool);

#line 1215
__cyos "CyWin" 148

void cXStr_dtor(struct cXStr*, int);

#line 1223
__cyos "CyWin" 149
void cXStr_ScrollLR(struct cXStr*);

#line 1269
__cyos "CyWin" 150

void cXStr_SetStart(struct cXStr*);

#line 1315
__cyos "CyWin" 153

void cXStr_SelRight(struct cXStr*);

#line 1361
__cyos "CyWin" 155

void cXStr_OK(struct cXStr*);

#line 1407
__cyos "CyWin" 156

void cXStr_Esc(struct cXStr*);

#line 1416
__cyos "CyWin" 171
bool cXStr_Test(struct cXStr*);

#line 1462
__cyos "CyWin" 174

void cXStr_SaveStr(struct cXStr*);

#line 1515
__cyos "CyWin" 158

bool cXStr_proc(struct cXStr*, struct Message*);

#line 1571
__cyos "CyWin" 173

struct cSItem* cSItem_ctor(struct cSItem*, int, char*, struct Bitmap*);

#line 1607
__cyos "CyWin" 159

void cSItem_dtor(struct cSItem*, int);

#line 1681
__cyos "CyWin" 162

struct cXByte* cXByte_ctor(struct cXByte*, int, char*, char*, int, int, char, char, struct Bitmap **, char*);

#line 1732
__cyos "CyWin" 169

void cXByte_dtor(struct cXByte*, int);

#line 1781
__cyos "CyWin" 164

void cXByte_OK(struct cXByte*);

#line 1830
__cyos "CyWin" 165

void cXByte_Esc(struct cXByte*);

#line 1839
__cyos "CyWin" 166
bool cXByte_Test(struct cXByte*);

#line 16 "d:\PROGRA~1\CYBIKO\SDK/inc/form.h"
struct cText : public cObject
{

char cText_Members_STUB[12];

};

#line 30
struct cButton : public cObject
{

char cButon_Members_STUB[12];

};

#line 51
struct cCustomForm : public cClip
{

char FormNameString[30];

char Type;


char Type_PADDING;



struct cWinApp* CurrApplication;


struct cClip* ClientArea;

#line 72
int ModalResult;



int HelpContext;
};

#line 90
struct cDialog : public cCustomForm
{

char cDialog_Members_STUB[16];

};

#line 103
struct cFrameForm : public cCustomForm
{

char cFrameForm_Members_STUB[4];

};

#line 140
__cyos "CyWin" 108

struct cText* cText_ctor(struct cText*, char*, struct Font*, color_t);

#line 168
__cyos "CyWin" 209

void cText_dtor(struct cText*, int);

#line 196
__cyos "CyWin" 87

void cText_SetText(struct cText*, char*);

#line 239
__cyos "CyWin" 116

struct cButton* cButton_ctor(struct cButton*, char*, int);

#line 267
__cyos "CyWin" 111

void cButton_dtor(struct cButton*, int);

#line 293
__cyos "CyWin" 115

int cButton_GetModalResult(struct cButton*);

#line 326
__cyos "CyWin" 99

bool cButton_proc(struct cButton*, struct Message*);

#line 369
__cyos "CyWin" 88

bool cWinApp_defproc(struct cWinApp*, struct Message*);

#line 463
enum tMResults
{

mrNone,


mrOk,


mrYes,


mrNo,


mrDraw,


mrChat,


mrQuit,


mrNew = 6,


mrUpload,


mrRename,


mrDelete,


mrView,


mrPlay,


mrRestart,


mrSet,


mrLater,


mrCancel,


mrMessage,


mrUser = 32
};

#line 549
__cyos "CyWin" 89

struct cCustomForm* cCustomForm_ctor(struct cCustomForm*, struct rect_t*, char*, bool, struct cWinApp*);

#line 578
__cyos "CyWin" 112

void cCustomForm_dtor(struct cCustomForm*, int);

#line 607
__cyos "CyWin" 94

int cCustomForm_ShowModal(struct cCustomForm*);

#line 642
__cyos "CyWin" 92

bool cCustomForm_proc(struct cCustomForm*, struct Message*);

#line 694
enum tDialogStyle
{

mbNone = 0x0,

mbOk = 0x1,

mbYes = 0x2,

mbNo = 0x4,

mbDraw = 0x8,

mbChat = 0x10,

mbQuit = 0x20,


mbNew = 0x20,

mbUpload = 0x40,

mbRename = 0x80,

mbDelete = 0x100,

mbView = 0x200,

mbPlay = 0x400,

mbRestart = 0x800,


mbSet = 0x1000,


mbLater = 0x2000,

mbCancel = 0x4000,


mbEdit = 0x10000,

mbPasswd = 0x20000,

mbNoEsc = 0x40000,

mbLeft = 0x80000,

mbNoShutup = 0x100000,

mbReverseOrder = 0x200000,

mbsDefault = 0x0,


mbsNone = 0x0,


mbs0 = 0x0,

mbs1 = 0x400000,

mbs2 = 0x800000,

mbs3 = 0xC00000,

mbs4 = 0x1000000,

mbs5 = 0x1400000,

mbs6 = 0x1800000,

mbs7 = 0x1C00000,

mbsMask = 0x1C00000
};

#line 797
__cyos "CyWin" 101

struct cDialog* cDialog_ctor(struct cDialog*, char*, char*, long, int, struct cWinApp*);

#line 825
__cyos "CyWin" 109

void cDialog_dtor(struct cDialog*, int);

#line 855
__cyos "CyWin" 113

void cDialog_GetEditText(struct cDialog*, char*);

#line 886
__cyos "CyWin" 114

void cDialog_SetEditText(struct cDialog*, char*);

#line 918
__cyos "CyWin" 311

void cDialog_PlaySound(long);

#line 953
__cyos "CyWin" 104

bool cDialog_proc(struct cDialog*, struct Message*);

#line 1031
__cyos "CyWin" 96

struct cFrameForm* cFrameForm_ctor(struct cFrameForm*, char*, struct cWinApp*);

#line 11 "d:\PROGRA~1\CYBIKO\SDK/inc/resource.h"
__cyos "CyWin" 228

char* str_Your;

#line 18
__cyos "CyWin" 229

char* str_Partner;

#line 25
__cyos "CyWin" 230

char* str_Illegal;

#line 32
__cyos "CyWin" 231

char* str_move;

#line 39
__cyos "CyWin" 232

char* str_again;

#line 46
__cyos "CyWin" 233

char* str_wait;

#line 53
__cyos "CyWin" 234

char* str_please;

#line 60
__cyos "CyWin" 235

char* str_Link_off;

#line 67
__cyos "CyWin" 236

char* str_Link_off_again;

#line 74
__cyos "CyWin" 237

char* str_Really_exit;

#line 81
__cyos "CyWin" 238

char* str_Partner_surrender;

#line 88
__cyos "CyWin" 239

char* str_Waiting_link;

#line 95
__cyos "CyWin" 240

char* str_Draw;

#line 102
__cyos "CyWin" 241

char* str_Draw_suggestion;

#line 109
__cyos "CyWin" 242

char* str_Draw_waiting;

#line 116
__cyos "CyWin" 315

char* str_Draw_rejected;

#line 123
__cyos "CyWin" 243

char* str_You_win;

#line 130
__cyos "CyWin" 244

char* str_You_lose;

#line 137
__cyos "CyWin" 245

char* str_1st_win;

#line 144
__cyos "CyWin" 246

char* str_2nd_win;

#line 151
__cyos "CyWin" 247

char* str_Tie_up;

#line 158
__cyos "CyWin" 248

char* str_Enter_file_name;

#line 165
__cyos "CyWin" 249

char* str_Waiting_SyPage;

#line 172
__cyos "CyWin" 250

char* str_no_CyPage;

#line 179
__cyos "CyWin" 251

char* str_Save_Changes;

#line 186
__cyos "CyWin" 252

char* str_Score_Again;

#line 193
__cyos "CyWin" 256

char* str_Declined_To_Play;

#line 200
__cyos "CyWin" 257

char* str_Declined_To_Play_Game;

#line 12 "d:\PROGRA~1\CYBIKO\SDK/inc/round.h"
enum
{

RR_NONE = 0,

RR_ARROWUP = 0x01,

RR_ARROWDOWN = 0x02,

RR_ROUND = 4,

RR_ERASE = 8
};

#line 46
__cyos "CyWin" 253

void draw_roundrect(struct Graphics*, struct rect_t*, int, char*);

#line 24 "d:\PROGRA~1\CYBIKO\SDK/inc/utilfunc.h"
__cyos "CyWin" 290

void draw_bar(int, int, int, int, color_t, bool);

#line 43
__cyos "CyWin" 291

void rect(int, int, int, int, color_t);

#line 63
__cyos "CyWin" 292

void text(int, int, struct Font*, char*, int, color_t);

#line 84
__cyos "CyWin" 293

void textC(int, int, struct Font*, char*, int, color_t, color_t);

#line 110
__cyos "CyWin" 294

int imin(int,int);

#line 136
__cyos "CyWin" 295

int imax(int,int);

#line 160
__cyos "CyWin" 296

bool in_rect(int, int, struct rect_t*);

#line 183
__cyos "CyWin" 302

int draw_bounded_text(struct Graphics *, int, int, int, char*);

#line 203
__cyos "CyWin" 304

char* trunc_spaces(char*);

#line 224
__cyos "CyWin" 303

void memory_dump(void*, int, int);

#line 26 "d:\PROGRA~1\CYBIKO\SDK/inc/finder.h"
struct info_t
{

char i_first_name[15 + 1];

char i_last_name[15 + 1];

char i_phone[21];

char i_mail[31];

char i_addr[31];

char i_other[41];

char i_bday;

char i_bmonth;

char i_byear;

char i_first_name_visible;

char i_last_name_visible;

char i_phone_visible;

char i_mail_visible;

char i_addr_visible;

char i_other_visible;
};


struct folk_t
{

int f_cypet_gameday;
char f_cypet_name[7];
char f_cypet_info;


char f_nick[8 + 1];

char f_gender;

char f_age_visible;

char f_age;

char f_height;

char f_weight;


char f_purpose;

char f_purpose_visible;

char f_height_visible;

char f_weight_visible;

char f_hobby1_visible;

char f_hobby2_visible;

char f_hobby3_visible;

#line 100
char f_hobby1;

#line 106
char f_hobby2;

#line 112
char f_hobby3;

char f_secret1[8 + 1];

char f_secret2[8 + 1];

char f_secret3[8 + 1];

char f_seek_gender;

char f_seek_gender_degree;

char f_min_age;

char f_max_age;

char f_seek_age_degree;

char f_min_height;

char f_max_height;

char f_seek_height_degree;

char f_min_weight;

char f_max_weight;

char f_seek_weight_degree;


char f_seek_purpose;

char f_seek_purpose_degree;

#line 151
char f_seek_hobby1;

#line 157
char f_seek_hobby2;

#line 163
char f_seek_hobby3;

char f_seek_hobby1_degree;

char f_seek_hobby2_degree;

char f_seek_hobby3_degree;

char f_seek_secret1_degree;

char f_seek_secret2_degree;

char f_seek_secret3_degree;

char f_seek_secret1[8 + 1];

char f_seek_secret2[8 + 1];

char f_seek_secret3[8 + 1];
};


struct nfolk_t
{

int f_cypet_gameday;
char f_cypet_name[7];
char f_cypet_info;


char f_nick[8 + 1];

char f_gender;

char f_age_visible;

char f_age;
};


struct cyfolk_t
{

long cf_id;

struct nfolk_t cf_fk;

char cf_my_match;

char cf_match;

char cf_selected;
char cf_status;


char cf_name_ind;

char cyfolk_PADDING;

};


struct save_data_t
{
struct info_t save_mi;
struct folk_t save_mf;
char save_data_PADDING;
};

#line 252
struct Finder: public Process
{

char sort_method;
bool i_am_active;
bool my_folk_on_flash;


struct Mutex finder_mutex;

struct save_data_t save_data;
char marks[5];


char howmany_around;

char howboys_around;

char howmany_unknown;


char howmany_disap;

bool start_chat_from_people;
char start_chat_from_people_name[8+1];
long start_chat_from_people_id;


struct folk_t mf;

struct info_t mi;

struct cyfolk_t* cf;

struct Message* message;
char Finder_PADDING[3];

};

#line 316
__cyos "finder" 10

bool send_user_folk;

#line 339
__cyos "finder" 31

struct Finder finder;

#line 360
__cyos "finder" 39

char own_icq[];

#line 381
__cyos "finder" 40

char own_icq_visible;

#line 419
__cyos "finder" 7

char Finder_find_active(struct Finder* ptr_finder, cyid_t cyber_id);

#line 466
__cyos "finder" 8

char Finder_find_unknown(struct Finder* ptr_finder, cyid_t cyber_id);

#line 514
__cyos "finder" 9

char Finder_find_disap(struct Finder* ptr_finder, cyid_t cyber_id);

#line 536
__cyos "finder" 12

char Finder_age(struct Finder* ptr_finder, char day, char month, char year);

#line 578
__cyos "finder" 14

char* Finder_create_name(struct Finder* ptr_finder, char* sz_visible_name, struct cyfolk_t* person_info);

#line 617
__cyos "finder" 30

int Finder_get_best_ids(struct Finder* ptr_finder, cyid_t* ptr_cyid_buff, int buff_length);

#line 633
__cyos "finder" 38

char howmany_around_desktop(void);

#line 21 "d:\PROGRA~1\CYBIKO\SDK/inc/keybd.h"
struct DirectKeyboard
{

char DirectKeyboard_Members_STUB[4];

};

#line 46
__cyos "keybd" 0

void DirectKeyboard_dtor(struct DirectKeyboard*, int);

#line 66
__cyos "keybd" 2

struct DirectKeyboard* DirectKeyboard_get_instance(void);

#line 86
__cyos "keybd" 4

void DirectKeyboard_scan(struct DirectKeyboard*);

#line 109
__cyos "keybd" 5

bool DirectKeyboard_is_key_pressed(struct DirectKeyboard*, short);

#line 131
__cyos 654

bool get_clicks_enabled(void);

#line 154
__cyos 1102

void set_clicks_enabled(bool enable);

#line 174
__cyos 520

void disable_key_click(int* key_list,int count);

#line 193
__cyos 831

time_t last_key_time(void);

#line 214
__cyos 653

click_kind_t get_click_kind(void);

#line 235
__cyos 1101

void set_click_kind(click_kind_t kind);

#line 251
__cyos 822

bool is_sticking_keys_enabled(void);

#line 268
__cyos 540

void enable_sticking_keys(bool enable);

#line 13 "d:\PROGRA~1\CYBIKO\SDK/inc/mplayer.h"
struct MSequence
{

char MSequence_Members_STUB[12];

};

#line 47
__cyos "mplayer" 5

struct MSequence* MSequence_ctor(struct MSequence* ptr_msequence, char* resource_name);

#line 78
__cyos "mplayer" 0

bool MSequence_is_sane(struct MSequence*);

#line 101
__cyos "mplayer" 1

void MSequence_play(struct MSequence*);

#line 130
__cyos "mplayer" 2

void MSequence_stop(struct MSequence*);

#line 160
__cyos "mplayer" 3

bool MSequence_is_playing(struct MSequence*);

#line 190
__cyos "mplayer" 4

int MSequence_get_curr_pos(struct MSequence*);

#line 219
__cyos "mplayer" 6

bool MSequence_load(struct MSequence*, struct Input*);

#line 253
__cyos "mplayer" 7

void MSequence_dtor(struct MSequence*, int);

#line 282
__cyos "mplayer" 9

void MSequence_play_background(struct MSequence*);

#line 301
__cyos "mplayer" 10

void MSequence_global_mute(bool);

#line 320
__cyos "mplayer" 11

void MSequence_mute_foreground(bool);

#line 339
__cyos "mplayer" 12

void MSequence_mute_background(bool);

#line 14 "d:\PROGRA~1\CYBIKO\SDK/inc/score.h"
struct score_t
{

long score;

cyid_t cyid;

time_t time;

char nickname[8];
};


struct Score
{

struct Archive* ptr_archive;
void* reserved;
int count;
int count_PADDING;

};

#line 80
__cyos "gamelib" 3

struct Score* Score_ctor(struct Score* ptr_score, struct Module* ptr_module);

#line 130
__cyos "gamelib" 4

void Score_dtor(struct Score* ptr_score, int memory_flag);

#line 181
__cyos "gamelib" 0

bool Score_read(struct Score* ptr_score, int index, struct score_t* ptr_result);

#line 230
__cyos "gamelib" 1

bool Score_write(struct Score* ptr_score, int index, struct score_t* ptr_result);

#line 287
__cyos "gamelib" 2

bool Score_write_Ex(struct Score* ptr_score, int index, long score, char* nickname, cyid_t cyid, time_t time);

#line 13 "src/yopu.h"
void init_session();
void move_piece(int);
void show_board();
void rotate_piece();
void make_new_yopu();
void show_yopu();
void move_down();
void init_game();
int check_yopu(int, int, int, int);
int clear_counted();
int score;
int level;
int total_yopus;
int max_wait;
void show_info();

#line 33
struct board_struct {
int color;
int counted;
};

struct board_struct board[12][9];
struct board_struct scrolled[12][9];

struct module_t main_module;

struct cDialog player_dialog;

bool exit_current_game;
bool exit_game_session;

bool need_new_yopu;

int your_score;

int cursor_index;
int player_mark_type;

int move_number;

int wait_to_drop;

const int yopus [10][2] = {
{0, 0},
{1,0},
{2,0},
{3,0},
{1,1},
{2,1},
{3, 1},
{2,2},
{3, 2},
{3, 3}
};

struct oypu_sprite {
int color1;
int color2;
int bmp1_board_x;
int bmp1_board_y;
int bmp2_board_x;
int bmp2_board_y;
int orient;
} sprite;

#line 14 "src/yopu.c"
long main(int argc, char* argv[], bool start)
{
struct KeyParam* ptr_key_param;
struct DirectKeyboard* ptr_keyboard;
struct Message* ptr_message;

init_module(&main_module);

set_clicks_enabled(0);


ptr_keyboard = DirectKeyboard_get_instance();

while(!exit_game_session)
{


need_new_yopu = 1;
wait_to_drop = 0;

init_session();

init_game();

while(!exit_current_game)
{
ptr_message = Queue_get_message((char*)(main_module.m_process) + 108, (1), (1), (0x2000));

if (need_new_yopu)
{
make_new_yopu();
show_yopu();
}

max_wait = (11 - level) * 2;

if (max_wait <= 0) max_wait = 1;

if (wait_to_drop == max_wait)
{
wait_to_drop = 0;
move_down();
show_yopu();
}

switch(ptr_message->msgid)
{
case 0x41:
show_board();
break;
case 0x101A:
case 0x31:
exit_current_game = 1;
exit_game_session = 1;
break;
case 1:
ptr_key_param = ((struct KeyParam*)((ptr_message)->param));
switch(ptr_key_param->scancode)
{
case 0x107:

cDialog_ctor(&player_dialog,
((char*)0),
str_Really_exit,
mbQuit | mbCancel,
0,
main_module.m_process);

if(cCustomForm_ShowModal(&player_dialog) == mrQuit)
{
exit_current_game = 1;
exit_game_session = 1;
}
cDialog_dtor(&player_dialog, 2);

show_board();
break;
default:


cWinApp_defproc(main_module.m_process, ptr_message);
}
break;
default:

cWinApp_defproc(main_module.m_process, ptr_message);
}


Message_delete(ptr_message);


DirectKeyboard_scan(ptr_keyboard);

if(DirectKeyboard_is_key_pressed(ptr_keyboard, 0x109))
{
move_piece(0x109);
}

if(DirectKeyboard_is_key_pressed(ptr_keyboard, 0x10B))
{
move_piece(0x10B);
}

if(DirectKeyboard_is_key_pressed(ptr_keyboard, 0x108))
{
move_piece(0x108);
}

if(DirectKeyboard_is_key_pressed(ptr_keyboard, 0x10A))
{
move_piece(0x10A);
}

if(DirectKeyboard_is_key_pressed(ptr_keyboard, 0x110))
{
rotate_piece();
}

wait_to_drop = wait_to_drop + 1;

}

}



DirectKeyboard_dtor(ptr_keyboard, 3);

set_clicks_enabled(1);

return 0;
}

#line 152
void init_session()
{
int i;

exit_game_session = 0;

score = 0;
level = 1;
total_yopus = 0;

srand((int)clock());



TGraph_set_draw_mode(main_module.m_gfx, 0);

DisplayGraphics_set_page(main_module.m_gfx, 1);
TGraph_fill_screen(main_module.m_gfx, 171);


TGraph_set_color(main_module.m_gfx, 0);


TGraph_fill_rect(main_module.m_gfx, 4,0,72,96);


TGraph_fill_rect(main_module.m_gfx, 80,4,76,62);

TGraph_set_color(main_module.m_gfx, 255);
Graphics_set_font( main_module.m_gfx, cool_normal_font );
Graphics_draw_text(main_module.m_gfx, "Score", 82, 6);

Graphics_draw_text(main_module.m_gfx, "Yopus", 82, 26);

Graphics_draw_text(main_module.m_gfx, "Level", 82, 46);


DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);


DisplayGraphics_set_page(main_module.m_gfx, 0);


DisplayGraphics_show(main_module.m_gfx);

}

#line 203
void init_game()
{
int t,u;


for (t=0; t<12; t++)
{
for(u=0; u<9; u++)
{
board[t][u].color = -1;
board[t][u].counted = -1;
}
}

exit_current_game = 0;

}

bool check_left()
{
bool result;

switch(sprite.orient)
{
case 0:
if(sprite.bmp1_board_x == 0)
{
result = 0;
}
else
{
if ((board[sprite.bmp1_board_y][sprite.bmp1_board_x - 1].color == -1)
&& (board[sprite.bmp2_board_y][sprite.bmp2_board_x - 1].color == -1))
{
result = 1;
}
else
{
result = 0;
};
};
break;
case 1:
if(sprite.bmp2_board_x == 0)
{
result = 0;
}
else
{
if (board[sprite.bmp2_board_y][sprite.bmp2_board_x - 1].color == -1)
{
result = 1;
}
else
{
result = 0;
};
};
break;
case 2:
if(sprite.bmp1_board_x == 0)
{
result = 0;
}
else
{
if ((board[sprite.bmp1_board_y][sprite.bmp1_board_x - 1].color == -1)
&& (board[sprite.bmp2_board_y][sprite.bmp2_board_x - 1].color == -1))
{
result = 1;
}
else
{
result = 0;
};
};
break;
case 3:
if(sprite.bmp1_board_x == 0)
{
result = 0;
}
else
{
if (board[sprite.bmp1_board_y][sprite.bmp1_board_x - 1].color == -1)
{
result = 1;
}
else
{
result = 0;
};
};
break;
}

return result;
}

bool check_right()
{
bool result;

switch(sprite.orient)
{
case 0:
if(sprite.bmp1_board_x == 8)
{
result = 0;
}
else
{
if ((board[sprite.bmp1_board_y][sprite.bmp1_board_x + 1].color == -1)
&& (board[sprite.bmp2_board_y][sprite.bmp2_board_x + 1].color == -1))
{
result = 1;
}
else
{
result = 0;
};
};
break;
case 1:
if(sprite.bmp1_board_x == 8)
{
result = 0;
}
else
{
if (board[sprite.bmp1_board_y][sprite.bmp1_board_x + 1].color == -1)
{
result = 1;
}
else
{
result = 0;
};
};
break;
case 2:
if(sprite.bmp1_board_x == 8)
{
result = 0;
}
else
{
if ((board[sprite.bmp1_board_y][sprite.bmp1_board_x + 1].color == -1)
&& (board[sprite.bmp2_board_y][sprite.bmp2_board_x + 1].color == -1))
{
result = 1;
}
else
{
result = 0;
};
};
break;
case 3:
if(sprite.bmp2_board_x == 8)
{
result = 0;
}
else
{
if (board[sprite.bmp2_board_y][sprite.bmp2_board_x + 1].color == -1)
{
result = 1;
}
else
{
result = 0;
};
};
break;
}
return result;
}

bool check_down()
{
bool result;

switch(sprite.orient)
{
case 0:
if (sprite.bmp2_board_y == 11)
{
result = 0;
}
else
{
if (board[sprite.bmp2_board_y + 1][sprite.bmp1_board_x].color == -1)
{
result = 1;
}
else
{
result = 0;
};
};
break;
case 1:
if (sprite.bmp1_board_y == 11)
{
result = 0;
}
else
{
if ((board[sprite.bmp1_board_y + 1][sprite.bmp1_board_x].color == -1)
&& (board[sprite.bmp2_board_y + 1][sprite.bmp2_board_x].color == -1))
{
result = 1;
}
else
{
result = 0;
};
};
break;
case 2:
if(sprite.bmp1_board_y == 11)
{
result = 0;
}
else
{
if (board[sprite.bmp1_board_y + 1][sprite.bmp1_board_x].color == -1)
{
result = 1;
}
else
{
result = 0;
}
}
break;
case 3:
if(sprite.bmp1_board_y == 11)
{
result = 0;
}
else
{
if ((board[sprite.bmp1_board_y + 1][sprite.bmp1_board_x].color == -1)
&& (board[sprite.bmp2_board_y + 1][sprite.bmp2_board_x].color == -1))
{
result = 1;
}
else
{
result = 0;
}
}
break;
}
return result;
}

void flash_yopu()
{
int x, y, t;

DisplayGraphics_set_page(main_module.m_gfx, 0);
TGraph_set_draw_mode(main_module.m_gfx, 0);

for (t=0; t<3; t++)
{
TGraph_set_color(main_module.m_gfx, 85);
for(x=0; x<9; x++)
{
for(y=0; y<12; y++)
{
if(board[y][x].counted != -1)
{
TGraph_fill_rect(main_module.m_gfx, (x*8)+4,y*8,8,8);
}
}
}

show_info();

DisplayGraphics_show(main_module.m_gfx);

SystemThread_pause(main_module.m_process, 500);
DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);

show_info();
DisplayGraphics_show(main_module.m_gfx);
SystemThread_pause(main_module.m_process, 500);
}

}

void clear_yopus()
{
int x,y,t,u,v,w;
bool cleared_some;
int num_adj;
int num_cleared;
int max_num_adj;
int in_a_row;

t=1;

in_a_row = 1;

max_num_adj = 0;

for (x=0; x<9; x++)
{
for (y=0; y<12; y++)
{

if((board[y][x].color != -1) && (board[y][x].counted == -1))
{
num_adj = check_yopu(x, y, board[y][x].color, t);

if(num_adj > max_num_adj) max_num_adj = num_adj;

if(num_adj < 4)
{
for(u=0; u<12; u++)
{
for(v=0; v<9; v++)
{
if(board[u][v].counted == t)
{
board[u][v].counted = -1;
}
}
}
}

t = t + 1;
}
}
}

if(max_num_adj >= 4)
{

total_yopus = total_yopus + 1;
if((total_yopus % 5) == 0)
{
level = level + 1;
}

flash_yopu();
score = score + ((in_a_row*5)*(max_num_adj*10));
in_a_row++;

num_cleared = clear_counted();
while(num_cleared > 0)
{
num_cleared = clear_counted();
}

cleared_some=1;
while(cleared_some == 1)
{
cleared_some = 0;
for(t=0; t<12; t++)
{
for(u=0; u<9; u++)
{
if(board[t][u].color != -1)
{
num_adj = check_yopu(u,t, board[t][u].color,99);

if (num_adj >= 4)
{

total_yopus = total_yopus + 1;

if((total_yopus % 5) == 0)
{
level = level + 1;
}

flash_yopu();
score = score + ((in_a_row*5)*(num_adj*10));
in_a_row++;

cleared_some = 1;
num_cleared = clear_counted();
while(num_cleared > 0)
{
num_cleared = clear_counted();
}
}

for(v=0; v<12; v++)
{
for(w=0; w<9; w++)
{
board[v][w].counted = -1;
}
}
}
}
}

}
}

for(v=0; v<12; v++)
{
for(w=0; w<9; w++)
{
board[v][w].counted = -1;
}
}

}

void lock_block()
{
bool still_room_1;
bool still_room_2;
int num_adj;
int t,u,v,w;
int num_cleared;
bool cleared_some;

still_room_1 = 1;
still_room_2 = 1;

while((still_room_1 == 1) || (still_room_2 == 1))
{

if (sprite.orient == 0) still_room_1 = 0;
if (sprite.orient == 2) still_room_2 = 0;
if (sprite.bmp1_board_y == 11) still_room_1 == 0;
if (sprite.bmp2_board_y == 11) still_room_2 == 0;

if (still_room_1 == 1)
{
if(board[sprite.bmp1_board_y+1][sprite.bmp1_board_x].color == -1 )
{
sprite.bmp1_board_y = sprite.bmp1_board_y + 1;
}
else
{
still_room_1 = 0;
}
}

if (still_room_2 == 1)
{
if(board[sprite.bmp2_board_y+1][sprite.bmp2_board_x].color == -1 )
{
sprite.bmp2_board_y = sprite.bmp2_board_y + 1;
}
else
{
still_room_2 = 0;
}
}

SystemThread_pause(main_module.m_process, 300);
show_yopu();
}

DisplayGraphics_set_page(main_module.m_gfx, 1);
TGraph_set_draw_mode(main_module.m_gfx, 0);
draw_lib(sprite.color1,0,(sprite.bmp1_board_x*8)+4, sprite.bmp1_board_y*8, 0);
draw_lib(sprite.color2,0,(sprite.bmp2_board_x*8)+4, sprite.bmp2_board_y*8, 0);


board[sprite.bmp1_board_y][sprite.bmp1_board_x].color = sprite.color1;
board[sprite.bmp2_board_y][sprite.bmp2_board_x].color = sprite.color2;

DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);


DisplayGraphics_set_page(main_module.m_gfx, 0);


DisplayGraphics_show(main_module.m_gfx);

clear_yopus();

}

int clear_counted()
{
int y,x,v,a,z;
int cleared;
bool scroll;
cleared = 0;

for(y=11; y>0; y--)
{
for(x=0; x<9; x++)
{
scroll = 1;

if(board[y][x].counted != -1)
{
cleared = cleared + 1;

DisplayGraphics_set_page(main_module.m_gfx, 1);
TGraph_set_draw_mode(main_module.m_gfx, 0);


TGraph_scroll(main_module.m_gfx, (x*8)+4, 0, 8, (y*8)+8, 0, 8);
DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);

DisplayGraphics_set_page(main_module.m_gfx, 0);

DisplayGraphics_show(main_module.m_gfx);


for(v=y; v>0; v--)
{
z=v-1;
board[v][x].color = board[z][x].color;
board[v][x].counted = board[z][x].counted;
}

board[0][x].color = -1;
board[0][x].counted = -1;
}
}
}

return cleared;
}

void move_down()
{

wait_to_drop = 0;

if (check_down() == 1)
{
sprite.bmp1_board_y = sprite.bmp1_board_y + 1;
sprite.bmp2_board_y = sprite.bmp2_board_y + 1;
}
else
{
lock_block();
need_new_yopu = 1;
}

}

#line 755
void
move_piece(int direction)
{

switch(direction)
{
case 0x108:
if(check_left() == 1)
{
sprite.bmp1_board_x = sprite.bmp1_board_x - 1;
sprite.bmp2_board_x = sprite.bmp2_board_x - 1;
}
break;
case 0x10B:
move_down();
break;
case 0x10A:
if (check_right() == 1)
{
sprite.bmp1_board_x = sprite.bmp1_board_x + 1;
sprite.bmp2_board_x = sprite.bmp2_board_x + 1;
}
break;
default:
break;
}



switch(sprite.orient)
{


case 0:
if (sprite.bmp1_board_x < 0) sprite.bmp1_board_x = 0;
if (sprite.bmp2_board_x < 0) sprite.bmp2_board_x = 0;
if (sprite.bmp1_board_x > 8) sprite.bmp1_board_x = 8;
if (sprite.bmp2_board_x > 8) sprite.bmp2_board_x = 8;
if (sprite.bmp1_board_y > 10) sprite.bmp1_board_y = 10;
if (sprite.bmp2_board_y > 11) sprite.bmp2_board_y = 11;
break;



case 1:
if (sprite.bmp1_board_x < 1) sprite.bmp1_board_x = 1;
if (sprite.bmp2_board_x < 0) sprite.bmp2_board_x = 0;
if (sprite.bmp1_board_x > 8) sprite.bmp1_board_x = 8;
if (sprite.bmp2_board_x > 7) sprite.bmp2_board_x = 7;
if (sprite.bmp1_board_y > 11) sprite.bmp1_board_y = 11;
if (sprite.bmp2_board_y > 11) sprite.bmp2_board_y = 11;
break;



case 2:
if (sprite.bmp1_board_x < 0) sprite.bmp1_board_x = 0;
if (sprite.bmp2_board_x < 0) sprite.bmp2_board_x = 0;
if (sprite.bmp1_board_x > 8) sprite.bmp1_board_x = 8;
if (sprite.bmp2_board_x > 8) sprite.bmp2_board_x = 8;
if (sprite.bmp1_board_y > 11) sprite.bmp1_board_y = 11;
if (sprite.bmp2_board_y > 10) sprite.bmp2_board_y = 10;
break;



case 3:
if (sprite.bmp1_board_x < 0) sprite.bmp1_board_x = 0;
if (sprite.bmp2_board_x < 1) sprite.bmp2_board_x = 1;
if (sprite.bmp1_board_x > 7) sprite.bmp1_board_x = 7;
if (sprite.bmp2_board_x > 8) sprite.bmp2_board_x = 8;
if (sprite.bmp1_board_y > 11) sprite.bmp1_board_y = 11;
if (sprite.bmp2_board_y > 11) sprite.bmp2_board_y = 11;
break;

}

show_yopu();
SystemThread_pause(main_module.m_process, 3);
}

void rotate_piece()
{
switch (sprite.orient)
{
case 0:
if(check_right() == 1)
{
sprite.orient = 1;

if (sprite.bmp1_board_x == 8)
{
sprite.bmp1_board_x = 7;
sprite.bmp2_board_x = 7;
}

sprite.bmp1_board_x = sprite.bmp1_board_x + 1;
sprite.bmp1_board_y = sprite.bmp1_board_y + 1;
}
break;
case 1:
if(check_down() == 1)
{
if (sprite.bmp1_board_y == 11)
{
sprite.bmp1_board_y = 10;
sprite.bmp2_board_y = 10;
}

sprite.orient = 2;
sprite.bmp1_board_x = sprite.bmp1_board_x - 1;
sprite.bmp1_board_y = sprite.bmp1_board_y + 1;
}
break;

case 2:
if(check_left() == 1)
{
sprite.orient = 3;
if (sprite.bmp1_board_x == 0)
{
sprite.bmp1_board_x = 1;
sprite.bmp2_board_x = 1;
}

sprite.bmp1_board_x = sprite.bmp1_board_x - 1;
sprite.bmp1_board_y = sprite.bmp1_board_y - 1;
}
break;
case 3:
sprite.orient = 0;
sprite.bmp1_board_x = sprite.bmp1_board_x + 1;
sprite.bmp1_board_y = sprite.bmp1_board_y - 1;
break;

}

show_yopu();
SystemThread_pause(main_module.m_process, 80);

}

#line 901
void show_board()
{
if(Process_has_focus(main_module.m_process))
{
TGraph_set_draw_mode(main_module.m_gfx, 0);

DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);


if(!exit_current_game)
{
show_yopu();
}


DisplayGraphics_show(main_module.m_gfx);
}
}

void make_new_yopu()
{
int t;

need_new_yopu = 0;

if(board[1][4].color == -1)
{
t = (int)random(9);

sprite.color1 = yopus[t][0];
sprite.color2 = yopus[t][1];

sprite.orient = 0;

sprite.bmp1_board_x = 4;
sprite.bmp1_board_y = 0;
sprite.bmp2_board_x = 4;
sprite.bmp2_board_y = 1;
}
else
{
cDialog_ctor(&player_dialog,
((char*)0),
"Game Over!",
mbOk ,
0,
main_module.m_process);

if(cCustomForm_ShowModal(&player_dialog) == mrOk)
{
exit_current_game = 1;
}
cDialog_dtor(&player_dialog, 2);

}

}

int check_yopu(int x, int y, int color, int value)
{
int sum;

sum = 0;

if((x > 8) || (x < 0) || (y > 11)) return 0;

if((board[y][x].counted == -1) && (board[y][x].color == color))
{
sum++;
board[y][x].counted = value;
sum += check_yopu(x-1, y, color, value);
sum += check_yopu(x+1, y, color, value);
sum += check_yopu(x, y-1, color, value);
sum += check_yopu(x, y+1, color, value);

}
return sum;
}

void show_info()
{
char score_s[10];
char level_s[3];
char num_yopus_s[10];

sprintf(score_s, "%d", score);
sprintf(level_s, "%d", level);
sprintf(num_yopus_s, "%d", total_yopus);

TGraph_set_color(main_module.m_gfx, 255);
Graphics_draw_text(main_module.m_gfx, score_s, 82, 16);
Graphics_draw_text(main_module.m_gfx, num_yopus_s, 82, 36);
Graphics_draw_text(main_module.m_gfx, level_s, 82, 56);

}

void show_yopu()
{

TGraph_set_draw_mode(main_module.m_gfx, 0);

TGraph_set_color( main_module.m_gfx, 0);



DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);

show_info();

draw_lib(sprite.color1,0,(sprite.bmp1_board_x*8)+4, sprite.bmp1_board_y*8, 0);
draw_lib(sprite.color2,0,(sprite.bmp2_board_x*8)+4, sprite.bmp2_board_y*8, 0);

DisplayGraphics_show(main_module.m_gfx);

}
