static void init_music()
{
}

static void destroy_music()
{
	play_tone(-1);
    vibrate(0);
    _music(MUSIC_LOAD, 0, NULL); //free channel 0
    _music(MUSIC_LOAD, 1, NULL); //free channel 1
}


void _music(int opn, int channel, char *filename)
{
	switch(opn) {
	case MUSIC_LOAD:
		if (b2c->channel[channel])
		{
			MSequence_stop(b2c->channel[channel]);
			MSequence_dtor(b2c->channel[channel], FREE_MEMORY);
			b2c->channel[channel] = NULL;
		}
        if (filename)
        {
            b2c->channel[channel] = (struct MSequence *) malloc(sizeof(struct MSequence));
            MSequence_ctor(b2c->channel[channel], filename);
        }
		break;
	case MUSIC_PLAY:
		if (b2c->channel[channel])
		{
			if (channel==0)
                        {
				MSequence_play_background(b2c->channel[channel]);
                                b2c->background_playing = 1;
                        }
			else
				MSequence_play(b2c->channel[channel]);
		}
		break;
	case MUSIC_STOP:
		if (b2c->channel[channel])
        {
            if (channel == 0) b2c->background_playing = 0;
			MSequence_stop(b2c->channel[channel]);
        }
		break;
	}
}

void _vibrate(int n)
{
	vibrate(n);
	return;
}

/**
 ** plays a single tone, -1=stop tone
 **/
void _beep(int sound)
{
    play_tone(sound);
}



