void _load(char *filename)
{
	struct Input *in;
	struct FileOutput *out;
	struct Archive *archive = b2c->main_module.m_process->module->archive;
	int c;

	sprintf(b2c->buf, "/%s/%s", DEFAULT_DRIVE_NAME, filename);
	if (File_exists(b2c->buf)) return;

	if (!is_in_archive(filename))
	{
		char s[40];
		sprintf(s, "Missing needed file %s", filename);
		_exit_basic(s);
	}

	in = Archive_open_Ex(archive, filename);
	out = malloc(sizeof(struct FileOutput));
	FileOutput_ctor_Ex(out,filename, 1); // create the file

	while(!Input_is_eof(in))
	{
		c = Input_read_byte(in);
		FileOutput_write_byte(out, c);
	}

//	FileOutput_dtor(out, LEAVE_MEMORY);
	FileOutput_dtor(out, FREE_MEMORY);
	Input_dtor(in, FREE_MEMORY);
}