#ifndef __BMPBTN_H__
#define __BMPBTN_H__

#include "image.h"
#include "hotspace.h"
#include "gadget.h"

typedef struct {
           int ID;
           int x;
           int y;
           int state;
           int delay;
           TImageRes *img;
        } TBmpBtn;

TBmpBtn *BmpBtnCreate(int ID, int x, int y, TImageRes *img);
BOOLEAN  BmpBtnDestroy(TBmpBtn *item);
BOOLEAN  BmpBtnDraw(TBmpBtn *item);
BOOLEAN  BmpBtnMsgProcess(TBmpBtn *item, EvtType *event);
BOOLEAN  BmpBtnRegister(void *item, ObjectID formID);

//----------------------------------------------------------------------------
TBmpBtn *BmpBtnCreate (int ID, int x, int y, TImageRes *img) {
   TBmpBtn *tmp;

   tmp = (TBmpBtn *) qmalloc(sizeof(TBmpBtn));
   tmp->ID = ID;
   tmp->x = x;
   tmp->y = y;
   tmp->state = 0;
   tmp->delay = 0;
   tmp->img = img;
   return tmp;
};
//----------------------------------------------------------------------------
BOOLEAN BmpBtnDestroy(TBmpBtn *item) {
   qfree(item);
   return TRUE;
};
//----------------------------------------------------------------------------
BOOLEAN BmpBtnDraw(TBmpBtn *item) {
   ObjectBounds bnds;

   bnds.xcoord = item->x;
   bnds.ycoord = item->y;
   bnds.width = item->img->w;
   bnds.height = item->img->h;

   ImageDraw(item->img, item->x, item->y);
   if (item->state == 1) LcdInvertBox(&bnds);

   return TRUE;
};
//----------------------------------------------------------------------------
BOOLEAN BmpBtnMsgProcess(TBmpBtn *item, EvtType *event) {
   ObjectBounds bnds;
   int x, y, w, h;

   x = event->para1;
   y = event->para2;
   w = item->img->w;
   h = item->img->h;

   bnds.xcoord = item->x;
   bnds.ycoord = item->y;
   bnds.width = w;
   bnds.height = h;

   switch (event->eventType) {
      case PEN_EVENT:
         switch (event->eventID) {
            case PEN_DOWN:
               item->state = 0;
               if ((item->x < x) && (x - item->x < w) &&
                   (item->y < y) && (y - item->y < h)) {
                  item->state = 1;
                  item->delay = 15;
                  LcdInvertBox(&bnds);
                  break;
               };
               break;
            case PEN_MOVE:
               if (item->state > 0) {
                  if ((item->x < x) && (x - item->x < w) &&
                      (item->y < y) && (y - item->y < h)) {
                     if (item->state != 1) LcdInvertBox(&bnds);
                     item->state = 1;
                  } else {
                     if (item->state != 2) LcdInvertBox(&bnds);
                     item->state = 2;
                  };
               };
               break;
            case PEN_UP:
               if (item->state == 1) {
                  event->eventID = item->ID;
                  event->eventType = EVT_CONTROL_SELECT;
                  event->para1 = 0;
                  event->para2 = 0;
                  event->evtPBP = NULL;
                  SndPlaySndEffect(SNDRES5_BEEP);
                  item->state = 0;
                  ImageDraw(item->img, item->x, item->y);
                  return TRUE;
               };
               ImageDraw(item->img, item->x, item->y);
               item->state = 0;
               break;
         };
         break;
   };

   if (item->state == 1) {
       if (item->delay == 0) {
          event->eventID = item->ID;
          event->eventType = EVT_CONTROL_REPEAT;
          event->para1 = 0;
          event->para2 = 0;
          event->evtPBP = NULL;
          item->delay = 5;
          return TRUE;
       } else {
          item->delay--;
       };
   };

   return FALSE;
};
//----------------------------------------------------------------------------
BOOLEAN BmpBtnRegister(void *item, ObjectID formID) {
   return GadgetRegister(item, formID, OBJ_TYPE_BMPBTN, BmpBtnMsgProcess, BmpBtnDestroy, BmpBtnDraw);
};
//----------------------------------------------------------------------------

#endif
