#include <system.h>
#include "res\res.h"
#include "scroll.h"

#define MY_HORZ_SCROLLY_ID  1001
#define MY_VERT_SCROLLY_ID  1002

TScrollBar *horz;
TScrollBar *vert;

int px = 50;
int py = 50;

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

//-------------------------------------------------------------------------------
static BOOLEAN EH_MainHandler(EvtType *event) {
   switch (event->eventType) {
      case EVT_FORM_OPEN:
         FormDrawForm(MAIN_FORM);
         GadgetDrawForm(MAIN_FORM);
         return TRUE;
      case EVT_SCROLLBAR_REPEAT:
         switch (event->eventID) {
            case MY_HORZ_SCROLLY_ID:
               px = event->para2;
               break;
            case MY_VERT_SCROLLY_ID:
               py = event->para2;
               break;
         };
         LcdSetPixel(px+20, py+20, 15);
         break;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
static BOOLEAN AppHandleEvent(EvtType *event) {
   ObjectID formID;
   Err      found;
   void    *formPTR;
   BYTE     objectType;

   if (event->eventType == EVT_FORM_LOAD) {
      formID = event->eventID;
      found = UISearchForAddress(formID, &objectType, &formPTR);
      if (event->para1 == 1 || found != TRUE) {
         FormInitForm(formID);
         found = UISearchForAddress(formID, &objectType, &formPTR);
         if (!found) return FALSE;
      }
      switch (formID) {
         case MAIN_FORM:
            FormSetEventHandler(MAIN_FORM, (void **) &FormDispatchEvent, EH_MainHandler);
            break;
      }
      FormSetActiveForm(formID);
      return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
void EventLoop(void) {
   EvtType event;

   do {
      EvtGetEvent(&event);
      GadgetHandler(&event);
      if (!SystemHandleEvent(&event)) {
         if (!MenuHandleEvent(&event)) {
            if (!AppHandleEvent(&event)) {
               FormDispatchEvent(&event);
            }
         }
      }
   } while(event.eventType != EVT_APP_STOP);
}
//-------------------------------------------------------------------------------
void ProgramInit(void) {

   vert = ScrollCreate(MY_VERT_SCROLLY_ID, SCROLL_TYPE_VERT, 150, 20, 130);
   ScrollRegister(vert, MAIN_FORM);

   horz = ScrollCreate(MY_HORZ_SCROLLY_ID, SCROLL_TYPE_HORZ, 10, 150, 140);
   ScrollRegister(horz, MAIN_FORM);

   ScrollSetProperties(vert, 0, 100, py, 10);
   ScrollSetProperties(horz, 0, 100, px, 10);

   FormPopupForm(MAIN_FORM);
}
//-------------------------------------------------------------------------------
void ProgramExit(void) {
   GadgetDestroyAll();
}
//-------------------------------------------------------------------------------
__main(WORD cmd, void *cmd_ptr) {
   switch (cmd) {
      case LAUNCH_CMD_NORMAL_LAUNCH:
         UIApplicationInit();
         ProgramInit();
         EventLoop();
         ProgramExit();
         UIDeleteAllAppObjects();
         return TRUE;
      case LAUNCH_CMD_FIND:
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_GOTO_REC:
         if (((GotoRec*)cmd_ptr)->find_string != NULL)
            pfree(((GotoRec*)cmd_ptr)->find_string);
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_ALARM_HIT:
         pfree(cmd_ptr);
         return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------

