/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   voxmdef.h
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef _VOXDEF_H_
#define _VOXDEF_H_

#include "uifunc.h"
#include "uidef.h"
#include "mmu.h"
#include "sndmevt.h"
#include "voxlang.h"

/******************************************************************
***************** VOICE MEMO OBJECT ID DEFINES ********************
******************************************************************/
#define SNDMGR

/*============== FORM_VOXMEMO_LIST ==============================*/
#define FORM_VOXMEMO_LIST					0
#define LIST_VOXMEMO_LIST_NUM				1
#define LIST_VOXMEMO_LIST_TIME				2
#define LIST_VOXMEMO_LIST_DATE				3
#define LIST_VOXMEMO_LIST_INFO				4
#define BUTTON_VOXMEMO_NEW_RECORD			5
#define SCROLLBAR_VOXMEMO_LIST				6

/*============== FORM_VOXMEMO_REC ===============================*/
#define FORM_VOXMEMO_REC					7
#define STRING_VOXMEMO_REC_TIME				8
#define STRING_VOXMEMO_REC_DATE				9
#define STRING_VOXMEMO_REC_INFO				10
#define TEXTBOX_VOXMEMO_REC_INFO 			11
#define STRING_VOXMEMO_REC_BOX				12
#define STRING_VOXMEMO_REC_REC				13
#define STRING_VOXMEMO_REC_RECTIME			14
#define STRING_VOXMEMO_REC_REM				15
#define STRING_VOXMEMO_REC_REMTIME			16
#define BITMAP_VOXMEMO_REC_FBWDN			17
#define BITMAP_VOXMEMO_REC_FBWD				18
#define	BITMAP_VOXMEMO_REC_FFWD				19
#define BITMAP_VOXMEMO_REC_FFWDN			20
#define CONTROL_VOXMEMO_REC_PLAY			21
#define BITMAP_VOXMEMO_REC_STOP				22
#define CONTROL_VOXMEMO_REC_REC				23
#define SCROLLBAR_VOXMEMO_REC				24
#define STRING_VOXMEMO_REC_REM2				84

/*===============================================================*/
/*============== FORM_VOXMEMO_INFO ==============================*/
#define FORM_VOXMEMO_INFO					25
#define STRING_VOXMEMO_INFO_TIME			26
#define STRING_VOXMEMO_INFO_DATE			27
#define STRING_VOXMEMO_INFO_INFO			28
#define TEXTBOX_VOXMEMO_INFO_INFO			29

/*===============================================================*/
/*============== FORM_VOXMEMO_PLAY ==============================*/
#define FORM_VOXMEMO_PLAY					30
#define STRING_VOXMEMO_PLAY_NUM				31
#define STRING_VOXMEMO_PLAY_TIME			32
#define STRING_VOXMEMO_PLAY_DATE			33
#define STRING_VOXMEMO_PLAY_INFO			34
#define STRING_VOXMEMO_PLAY_BOX				35
#define STRING_VOXMEMO_PLAY_BOX2			36
#define STRING_VOXMEMO_PLAY_MIN				37
#define STRING_VOXMEMO_PLAY_VOL				38
#define STRING_VOXMEMO_PLAY_MAX				39
#define STRING_VOXMEMO_PLAY_POS				40
#define STRING_VOXMEMO_PLAY_POSTIME			41
#define STRING_VOXMEMO_PLAY_TOTAL			42
#define STRING_VOXMEMO_PLAY_TTIME			43
#define BITMAP_VOXMEMO_PLAY_FBWDN			44
#define CONTROL_VOXMEMO_PLAY_FBWD			45
#define CONTROL_VOXMEMO_PLAY_FFWD			46
#define BITMAP_VOXMEMO_PLAY_FFWDN			47
#define CONTROL_VOXMEMO_PLAY_PLAY			48
#define BITMAP_VOXMEMO_PLAY_STOP			49
#define CONTROL_VOXMEMO_PLAY_REC			50
#define BUTTON_VOXMEMO_ERASE_RECORD			51
#define SCROLLBAR_VOXMEMO_PLAY_VOL			52
#define SCROLLBAR_VOXMEMO_PLAY_TIME			53
#define BUTTON_VOXMEMO_RENAME_RECORD		79

/*===============================================================*/
/*============== FORM_VOXMEMO_DIALOG_ERASE ======================*/
#define FORM_VOXMEMO_DIALOG_ERASE			54
#define STRING_VOXMEMO_DIALOG_ERASE			55
#define STRING_VOXMEMO_DIALOG_ERASE2		56
#define CONTROL_VOXMEMO_DIALOG_ERASE_CHECK	57
#define BUTTON_VOXMEMO_DIALOG_ERASE_YES		58
#define BUTTON_VOXMEMO_DIALOG_ERASE_NO		59

/*===============================================================*/
/*============== FORM_VOXMEMO_DIALOG_LOWMEM =====================*/
#define FORM_VOXMEMO_DIALOG_LOWMEM			60
#define STRING_VOXMEMO_DIALOG_LOWMEM		61
#define STRING_VOXMEMO_DIALOG_LOWMEM2		62
#define BUTTON_VOXMEMO_DIALOG_LOWMEM_YES	63
#define BUTTON_VOXMEMO_DIALOG_LOWMEM_NO		64
/*===============================================================*/
/*============== FORM__DIALOG_VOXMEMO_SAVE ======================*/
#define FORM_VOXMEMO_DIALOG_SAVE			65
#define STRING_VOXMEMO_DIALOG_SAVE			66
#define BITMAP_VOXMEMO_DIALOG_SAVE_X		67
#define BUTTON_VOXMEMO_DIALOG_SAVE_YES		68
#define BUTTON_VOXMEMO_DIALOG_SAVE_NO		69

/*===============================================================*/
/*============== FORM_VOXMEMO_DIALOG_RECABORT ===================*/
#define FORM_VOXMEMO_DIALOG_RECABORT		70
#define STRING_VOXMEMO_DIALOG_RECABORT		71
#define STRING_VOXMEMO_DIALOG_RECABORT2		72
#define STRING_VOXMEMO_DIALOG_RECABORT3		73
#define BITMAP_VOXMEMO_DIALOG_RECABORT_X	74

/*===============================================================*/
/*============== FORM_VOXMEMO_DIALOG_EDTITLE ====================*/
#define FORM_VOXMEMO_DIALOG_EDTITLE			75
#define STRING_VOXMEMO_DIALOG_EDTITLE		76
#define BITMAP_VOXMEMO_DIALOG_EDTITLE_X		77
#define TEXTBOX_VOXMEMO_DIALOG_EDTITLE		78
#define BUTTON_VOXMEMO_RENAME_RECORD		79

/*===============================================================*/
/*============== FORM_VOXMEMO_DIALOG_LOW_BATTERY ================*/
#define FORM_VOXMEMO_DIALOG_LOW_BATTERY		80
#define BITMAP_VOXMEMO_DIALOG_LOW_BATTERY_X	81
#define STRING_VOXMEMO_DIALOG_LOW_BATTERY	82
#define STRING_VOXMEMO_DIALOG_LOW_BATTERY2	83


/*===============================================================*/
#define	DISPLAY_REC							501
#define	DISPLAY_PLAY						502

/* Assign field number for database */
#define	VOXMEMO_NUM_FIELD					4
#define	F_TIME_DATE							0
#define	F_CODEDATA							1
#define	F_SILENT_INFO						2
#define	F_INFO								3


/* Assign field number for application save in main list page */
#define	VOXMEMO_MAIN_APP_SAVE				0x80001000
#define F_REAction							0
#define F_PlayCtrlValue						1
#define F_ItemNum							2
#define F_StartFrame						3
#define F_TmrLabel							4
#define F_ActiveFormID						5
#define F_TimeString						6
#define F_DateString						7
#define F_LTimeString						8
#define F_RTimeString						9
#define F_InfoString						10
#define F_InfoCharPos						11
#define F_MemoNumString						12


/* Assign field number for application save in database page */
#define	VOXMEMO_MDB_APP_SAVE				0x80001001
#define F_VoxMemo_rec_id					0
#define F_DisplayAction						1
#define F_TotalLen							2
#define F_VoxMemoTime						3
#define F_VoxMemoTime2						4


typedef struct
{
	BYTE	yr;
	BYTE	mon;
	BYTE	day;
	BYTE	hr;
	BYTE	min;
	BYTE	sec;
} VOX_DATE;


/*===============================================================*/
BOOLEAN VoxMemoList(EvtType*);
BOOLEAN VoxMemoRec(EvtType*);
BOOLEAN VoxMemoInfo(EvtType*);
BOOLEAN VoxMemoPlay(EvtType*);
BOOLEAN VoxMemoDialogErase(EvtType*);
BOOLEAN VoxMemoDialogLowMem(EvtType*);
BOOLEAN VoxMemoDialogSave(EvtType*);
BOOLEAN VoxMemoDialogRecAbort(EvtType*);
BOOLEAN VoxMemoDialogEditTitle(EvtType*);
BOOLEAN VoxMemoDialogLowBattery(EvtType *Event);
BOOLEAN VoxMemoDialogLowMemory(EvtType *Event);

/*===============================================================*/
BOOLEAN VoxMemoMainAppSave(void);
BOOLEAN VoxMemoMDBAppSave(void);
BOOLEAN	VoxMemoInitMainGlobal(BOOLEAN is_restart);
BOOLEAN VoxMemoInitMDBGlobal(BOOLEAN is_restart);
BOOLEAN	VoxMemoDatabaseInit(BOOLEAN is_restart);
BOOLEAN VoxMemoDatabaseClose(void);
BOOLEAN VoxMemoRecordToList(SHORT item_num, SHORT *top_item_num);

BOOLEAN VoxMemoListSetScrollbar(void);
void	VoxMemoScrollbarSetList(USHORT item_num);
//void	VoxMemoScrollbarSetTime(EvtType*);
BOOLEAN	VoxMemoScrollbarSetVol(EvtType*);
BOOLEAN VoxMemoVolSetScrollbar(void);

void	VoxMemoNum2Time(USHORT, BYTE*, BOOLEAN);

BOOLEAN	VoxMemoNewRecord(void);
BOOLEAN VoxMemoOpenRecord(SHORT);
BOOLEAN VoxMemoDeleteRecord(BOOLEAN);
BOOLEAN VoxMemoRenameTitle(void);
BOOLEAN VoxMemoCheckRecordWithSound(DatabaseID dbid, RecordID rec_id, USHORT field_num);

/*===============================================================*/
BOOLEAN	VoxMemoRecClose(void);
void	VoxMemoRecReset(void);

BOOLEAN	VoxMemoPlayClose(void);
void	VoxMemoPlayReset(void);

void	VoxMemoDisplayTime(void);
void	VoxMemoDisplayRecTime(void);
void	VoxMemoDisplayPlayTime(void);
void	VoxMemoDisplayPauseTime(void);
/*===============================================================*/

#endif

