/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   menufunc.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

/********************************************************
* Function:	MenuItemSelectedAction
* Purpose: 	This fucntion is to do an action when 
an item in a menu is selected
* Scope:		application/internal
* Input:		menu_item		The item number of the selectd menu item
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void MenuItemSelectedAction(USHORT item_num)
{
	ObjectID active_form_id;
	ObjectID active_object_id;
	BOOLEAN highlighted = FALSE, insert_pt = FALSE;
	BYTE object_type;
	void *addr;
	BYTE *string_text;
	
	FormGetActiveFormID(&active_form_id);
	FormGetActiveObject(active_form_id, &active_object_id);
	if (FormGetObjectPointer(active_object_id, &object_type, (void**)&addr) == FALSE)
		return;
	
	switch(item_num)
	{
	case MENU_ITEM_COPY:
		if (active_form_id == FORM_CALCULATOR)
		{
			StringGetText(DISPLAY, &string_text);
			ClipboardPutItem(CLIP_TEXT_DATA, (void *)string_text, strlen(string_text) + 1);
		}
		else if (object_type == TEXTBOX)
			KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
		break;
	case MENU_ITEM_CUT:
		if (object_type == TEXTBOX)
			KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
		break;
	case MENU_ITEM_PASTE:
		if (object_type == TEXTBOX)
			KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
		break;
	case MENU_ITEM_UNDO:
		if (UIGetUndoStatus() != UNDO_EMPTY && object_type == TEXTBOX)
			KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
		break;
	case MENU_ITEM_COPY_RESULT:
		StringGetText(STRING_EXCHANGE_1, &string_text);
		ClipboardPutItem(CLIP_TEXT_DATA, (void *)(string_text+5), strlen((string_text + 5)) + 1);
		break;
	case MENU_ITEM_TOTAL_PAYMENT:
		StringGetText(STRING_LOAN_TOTAL_PAYMENT_RESULT, &string_text);
		ClipboardPutItem(CLIP_TEXT_DATA, (void *)(string_text), strlen((string_text)) + 1);
		break;
	case MENU_ITEM_TOTAL_INTEREST:
		StringGetText(STRING_LOAN_TOTAL_INTEREST_RESULT, &string_text);
		ClipboardPutItem(CLIP_TEXT_DATA, (void *)(string_text), strlen((string_text)) + 1);
		break;
	default: break;
	}
}
