/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   voxmain.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "platform.h"
#include "voxmemo.h"
#include "voxmdef.h"
#include "sndmgr.h"
#include "sysetup.h"
#include "system.h"
#include "dev_pwr.h"

#ifdef PC_SIM
#include "resource.h"
#include "pdaemu.h"
#include "PdaEmuDlg.h"
extern CPDAEmuDlg* m_EmuDlg;
#endif

#define SNDMGR
//#define DEBUG

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
BYTE				HardKeyOff;
SHORT				ItemNum;
UWORD				TmrLabel, TmrPauseLabel;
BOOLEAN				REAction, PlayCtrlValue;
ObjectID			active_form_id, pre_form_id;
USHORT				tmr_pause_label_counter = 0;


extern	SHORT		VoxMemoTime, VoxMemoTime2;
extern	UWORD		TotalLen;
extern	BOOLEAN		DisplayActionEnable;
extern	RecordID	VoxMemo_rec_id;
extern	DatabaseID	VoxMemo_dbid;


/*****************************************************************
* Function:	VoxMemoInitMainGlobal
* Purpose: 	This function is used to initialize the global variables
* Scope:		application/internal
* Input:		is_restart			the first time to enter the application or not
* Output:		None
* Return:		TRUE				if success
FALSE				else if otherwise
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoInitMainGlobal(BOOLEAN is_restart)
{
	BYTE	*buffer;
	UWORD	byte_read;
	
	REAction		= FALSE;
	HardKeyOff		= 1;
	PlayCtrlValue	= FALSE;
	
	if (is_restart)
	{
		ItemNum = 0;
	}
	else
	{
		if (DataFindDB(VOXDB, &VoxMemo_dbid) != TRUE)
			return FALSE;
		if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_ItemNum, &buffer, &byte_read) != TRUE)
			return FALSE;
		ItemNum = *(SHORT*)buffer;
		qfree(buffer);
		
	}
	
	return TRUE;
}


/*****************************************************************
* Function:	VoxMemoMainAppSave
* Purpose: 	This function is called to save the data in 
the voice memo database when being stopped
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE				if success
FALSE				else if otherwise
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoMainAppSave(void)
{
	BYTE		*text, charpos;
	BOOLEAN		ctrl_value;
	WORD		char_pos;
	
	if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_ItemNum, sizeof(SHORT), (BYTE*)&ItemNum) != TRUE)
		return FALSE;
	
#ifdef DEBUG
	printf("MainAppSave: active_form_id = %d\n", active_form_id);
#endif
	if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_ActiveFormID, sizeof(ObjectID), (BYTE*)&active_form_id) != TRUE)
		return FALSE;
	
	switch(active_form_id)
	{
	case FORM_VOXMEMO_REC:
	/*
	StringGetText(STRING_VOXMEMO_REC_TIME, &text);
	if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, 7*sizeof(BYTE), (BYTE*)text) != TRUE)
				return FALSE;
				StringGetText(STRING_VOXMEMO_REC_DATE, &text);
				if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, 9*sizeof(BYTE), (BYTE*)text) != TRUE)
				return FALSE;
				StringGetText(STRING_VOXMEMO_REC_RECTIME, &text);
				if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_LTimeString, 6*sizeof(BYTE), (BYTE*)text) != TRUE)
				return FALSE;
				StringGetText(STRING_VOXMEMO_REC_REMTIME, &text);
				if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_RTimeString, 6*sizeof(BYTE), (BYTE*)text) != TRUE)
				return FALSE;
		*/
#ifdef SNDMGR
		SndStop();
#endif
		FormGetControlValue(CONTROL_VOXMEMO_REC_REC, &ctrl_value);
		if (ctrl_value)
		{
			FormSetControlGroupSelection(FORM_VOXMEMO_REC, CONTROL_VOXMEMO_REC_REC);
			if (REAction)
				TmrIntDisable(TmrPauseLabel);							
		}
		HardKeyOff = 0;
		DisplayActionEnable = FALSE;
		REAction = FALSE;
		
		TextboxSetText(TEXTBOX_VOXMEMO_INFO_INFO, VOX_NO_TITLE);
		TextboxSetInsertPointOff(TEXTBOX_VOXMEMO_INFO_INFO);
		
		if (VoxMemoCheckRecordWithSound(VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA))				
		{
			if (!VoxMemoRecClose())
				return TRUE;
			ItemNum = 0;
		}
		else
		{
			VoxMemoDeleteRecord(FALSE);
			
		}
		
		InlaySetEnableStatus(TRUE);
		SystemSetMappedHardwareKeyStatus(TRUE);
		AlarmMgrEnable(TRUE);
		BatteryWarningSetEnableStatus(TRUE);
		break;
		
		
	case FORM_VOXMEMO_INFO:
	case FORM_VOXMEMO_DIALOG_SAVE:
	case FORM_VOXMEMO_DIALOG_LOWMEM:
		
	/*
	StringGetText(STRING_VOXMEMO_INFO_TIME, &text);
	if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, 7*sizeof(BYTE), (BYTE*)text) != TRUE)
				return FALSE;
				StringGetText(STRING_VOXMEMO_INFO_DATE, &text);
				if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, 9*sizeof(BYTE), (BYTE*)text) != TRUE)
				return FALSE;
		*/
		StringGetText(STRING_VOXMEMO_REC_TIME, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, 7*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_REC_DATE, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, 9*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		
		TextboxGetTextPointer(TEXTBOX_VOXMEMO_INFO_INFO, &text);
		
		if (DataWriteField(VoxMemo_dbid,VoxMemo_rec_id, F_INFO,	(strlen(text)+1), text) != TRUE)
			return FALSE;
		
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoString, 15*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		TextboxGetInsertPointPosition(TEXTBOX_VOXMEMO_INFO_INFO, &char_pos);
		charpos = (BYTE)char_pos;
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoCharPos, sizeof(BYTE), (BYTE*)&charpos) != TRUE)
			return FALSE;
		
		break;
		
	case FORM_VOXMEMO_PLAY:
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_ItemNum, sizeof(SHORT), (BYTE*)&ItemNum) != TRUE)
			return FALSE;	
#ifdef SNDMGR
		SndStop();
#endif					
		if (PlayCtrlValue)
		{
			FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
		}
		else if(REAction)
		{
			TmrIntDisable(TmrPauseLabel);
		}
		while(tmr_pause_label_counter > 0)
		{
			TmrIntDisable(TmrPauseLabel);
			tmr_pause_label_counter--;
		}
		
		DisplayActionEnable = FALSE;
		REAction = FALSE;
		HardKeyOff = 0;
		VoxMemoPlayClose();
		
		StringGetText(STRING_VOXMEMO_PLAY_NUM, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_MemoNumString, 4*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_TIME, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, 7*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_DATE, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, 9*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_POSTIME, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_LTimeString, 6*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_TTIME, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_RTimeString, 6*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_INFO, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoString, 15*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		break;
		
	case FORM_VOXMEMO_DIALOG_ERASE:
		StringGetText(STRING_VOXMEMO_PLAY_NUM, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_MemoNumString, 4*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_TIME, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, 7*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_DATE, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, 9*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_POSTIME, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_LTimeString, 6*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_TTIME, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_RTimeString, 6*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_INFO, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoString, 15*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		break;
		
	case FORM_VOXMEMO_DIALOG_EDTITLE:
		StringGetText(STRING_VOXMEMO_PLAY_NUM, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_MemoNumString, 4*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_TIME, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, 7*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_DATE, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, 9*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_POSTIME, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_LTimeString, 6*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_TTIME, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_RTimeString, 6*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		StringGetText(STRING_VOXMEMO_PLAY_INFO, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoString, 15*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		
		
		TextboxGetTextPointer(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, &text);
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoString, 15*sizeof(BYTE), (BYTE*)text) != TRUE)
			return FALSE;
		TextboxGetInsertPointPosition(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, &char_pos);
		charpos = (BYTE)char_pos;
		if (DataWriteField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoCharPos, sizeof(BYTE), (BYTE*)&charpos) != TRUE)
			return FALSE;
		
		break;
		
	default:
		break;
	}
	
	return TRUE;
}



/*****************************************************************
***************** Application Event Handle Function **************
*****************************************************************/

/*****************************************************************
* Function:	VoxMemoList
* Purpose: 	This function is the event handler for the LIST
*				page of the VoxMemo application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoList(EvtType *Event)
{
    AppID	app_id;
	SHORT	top_item_num;
	UWORD	num_rec;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
#ifdef DEBUG
		printf("\n Popup List 1: ItemNum=%d", ItemNum);
#endif
		VoxMemoRecordToList(ItemNum, &top_item_num);
#ifdef DEBUG
		printf("\n Popup List 2: top_item_num=%d", top_item_num);
#endif
		if (top_item_num > -1)
			VoxMemoScrollbarSetList(top_item_num);
#ifdef DEBUG
		printf("\n Popup List 3: FormDrawForm");
#endif
		active_form_id = FORM_VOXMEMO_LIST;
		FormDrawForm(FORM_VOXMEMO_LIST);
		return TRUE;
		
#ifdef PR31700
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
			//if (Event->eventID == EVT_IO_KEY_PRESS)
		{
			switch(Event->para2)
			{
			case IO_UP_ARROW:
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_VOXMEMO_LIST, SCROLLBAR_UP_ARROW);
				return TRUE;					
			case IO_DOWN_ARROW:
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_VOXMEMO_LIST, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			case IO_SOUND_PLAY:
				if (DataTotalRecord(VoxMemo_dbid, &num_rec) != TRUE)
					return FALSE;
				if (num_rec < 1)
					return FALSE;
				if (!VoxMemoOpenRecord(0))
					return TRUE;			
				HardKeyOff = 0;
				TmrLabel = 0;
				TmrPauseLabel = 0;
				FormPopupForm(FORM_VOXMEMO_PLAY);
				EvtAppendEvt(EVT_CONTROL_SELECT, CONTROL_VOXMEMO_PLAY_PLAY, 0, 0, NULL);				
				return TRUE;
				//case (IO_SOUND_RECORD | IO_SOUND_PLAY):
			case IO_SOUND_RECORD:
				/* reset scrollbar & timer */
				VoxMemoRecReset();
				if (VoxMemoTime2 < 3)
				{
					return TRUE;
				}
				
				if (VoxMemoNewRecord() != TRUE)
				{
					FormPopupForm(FORM_VOXMEMO_DIALOG_RECABORT);
					return TRUE;
				}
				HardKeyOff = 0;
				TmrLabel = 0;
				TmrPauseLabel = 0;
				FormPopupForm(FORM_VOXMEMO_REC);
				EvtAppendEvt(EVT_CONTROL_SELECT, CONTROL_VOXMEMO_REC_REC, 0, 0, NULL);				
				return TRUE;
			default:
				return FALSE;						 
			}
		}
		else if(Event->eventID == EVT_IO_KEY_REPEAT)
		{
	case IO_UP_ARROW:
		ScrollbarHardButtonSetScrollbar(SCROLLBAR_VOXMEMO_LIST, SCROLLBAR_UP_ARROW);
		return TRUE;					
	case IO_DOWN_ARROW:
		ScrollbarHardButtonSetScrollbar(SCROLLBAR_VOXMEMO_LIST, SCROLLBAR_DOWN_ARROW);
		return TRUE;
		}
		
		
		return FALSE;
#endif
		
	case EVT_SCROLLBAR_REPEAT:
		if (Event->para1 == Event->para2)
			return TRUE;
		VoxMemoScrollbarSetList((USHORT)Event->para2);
		ListDrawList(LIST_VOXMEMO_LIST_NUM);
		ListDrawList(LIST_VOXMEMO_LIST_TIME);
		ListDrawList(LIST_VOXMEMO_LIST_DATE);
		ListDrawList(LIST_VOXMEMO_LIST_INFO);
		ScrollbarDrawScrollbar((USHORT)Event->eventID);
		return TRUE;
		
	case EVT_SCROLLBAR_SELECT:
		VoxMemoScrollbarSetList((USHORT)Event->para2);
		ListDrawList(LIST_VOXMEMO_LIST_NUM);
		ListDrawList(LIST_VOXMEMO_LIST_TIME);
		ListDrawList(LIST_VOXMEMO_LIST_DATE);
		ListDrawList(LIST_VOXMEMO_LIST_INFO);
		ScrollbarDrawScrollbar((USHORT)Event->eventID);
		return TRUE;
		
	case EVT_LIST_SELECT:
		ItemNum = (SHORT)(Event->para1);
		if (!VoxMemoOpenRecord(ItemNum))
			return TRUE;			
		TmrLabel = 0;
		TmrPauseLabel = 0;
		FormPopupForm(FORM_VOXMEMO_PLAY);
		return TRUE;
		
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{	
		case BUTTON_VOXMEMO_NEW_RECORD:
			/* reset scrollbar & timer */
			VoxMemoRecReset();
			if (VoxMemoTime2 < 3)
			{
				FormPopupForm(FORM_VOXMEMO_DIALOG_RECABORT);
				return TRUE;
			}
			
			if (VoxMemoNewRecord() != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_DIALOG_RECABORT);
				return TRUE;
			}
			TmrLabel = 0;
			TmrPauseLabel = 0;
			
			FormPopupForm(FORM_VOXMEMO_REC);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
			case INLAY_EXIT:			
				SysGetAppID(MAINMENU, &app_id);
				EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
				EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
				return TRUE;
			default:	return FALSE;
			}
			
			default:	return FALSE;	
				
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	VoxMemoRec
* Purpose: 	This function is the event handler for the 
*				recording page of the VoxMemo application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoRec(EvtType *Event)
{
	BOOLEAN 	ctrl_value;
	UWORD		rec_num, total_num_rec;
	
	static USHORT	testing_num=0;
	BYTE		testing_buf[15];
	
	switch(Event->eventType)
	{
	case POWER_EVENT:
		if (Event->eventID == BAT_MAIN_LOW)
		{
			FormGetControlValue(CONTROL_VOXMEMO_REC_REC, &ctrl_value);
			if (!ctrl_value)
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_VOXMEMO_REC_STOP, 0, 0, NULL);
		}
		return TRUE;		
		
	case EVT_FORM_OPEN:
		pre_form_id = FORM_VOXMEMO_REC;
		REAction = FALSE;
		FormGetControlValue(CONTROL_VOXMEMO_REC_REC, &ctrl_value);
		if (!ctrl_value)
			FormSetControlGroupSelection(FORM_VOXMEMO_REC, CONTROL_VOXMEMO_REC_REC);
		active_form_id = FORM_VOXMEMO_REC;
		FormDrawForm(FORM_VOXMEMO_REC);
		BatteryWarningSetEnableStatus(TRUE);
		return TRUE;
		
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{	
		case CONTROL_VOXMEMO_REC_REC:
			FormGetControlValue(CONTROL_VOXMEMO_REC_REC, &ctrl_value);
			if (!HardKeyOff)
			{
				if (ctrl_value)
					FormSetControlGroupSelection(FORM_VOXMEMO_REC, CONTROL_VOXMEMO_REC_REC);
			}
			if (ctrl_value && HardKeyOff)
			{
				
				DisplayActionEnable = FALSE;
				TmrPauseLabel = TmrIntEnable(500, VoxMemoDisplayPauseTime);				
#ifdef SNDMGR
				SndPause();
#endif
				return TRUE;
			}
			else if(REAction)
			{
				TmrIntDisable(TmrPauseLabel);							
				DisplayActionEnable = TRUE;
#ifdef SNDMGR
				SndRERec(VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA);
#endif
				return TRUE;
			}
			else
			{
				if (CheckBatteryLow())
				{
					VoxMemoDeleteRecord(FALSE);
					FormPopupForm(FORM_VOXMEMO_DIALOG_LOW_BATTERY);
					return TRUE;
				}
				
				BatteryWarningSetEnableStatus(FALSE);
				InlaySetEnableStatus(FALSE);
				SystemSetMappedHardwareKeyStatus(FALSE);
				AlarmMgrEnable(FALSE);				            
				DisplayActionEnable = TRUE;
#ifdef SNDMGR
				SndRec(VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA);
#endif
				HardKeyOff = 1;
				REAction = TRUE;
				return TRUE;
			}
			
		default:	return FALSE;
		}
		
		case EVT_BITMAP_SELECT:
			switch(Event->eventID)
			{	
			case BITMAP_VOXMEMO_REC_STOP:
#ifdef SNDMGR
				SndStop();
#endif
				FormGetControlValue(CONTROL_VOXMEMO_REC_REC, &ctrl_value);
				if (ctrl_value)
				{
					FormSetControlGroupSelection(FORM_VOXMEMO_REC, CONTROL_VOXMEMO_REC_REC);
					if (REAction)
						TmrIntDisable(TmrPauseLabel);							
				}
				HardKeyOff = 0;
				DisplayActionEnable = FALSE;
				REAction = FALSE;
				TextboxSetText(TEXTBOX_VOXMEMO_INFO_INFO, (BYTE*)(""));
				
				if (VoxMemoCheckRecordWithSound(VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA))
				{
					FormSetFormActiveObject(FORM_VOXMEMO_INFO, TEXTBOX_VOXMEMO_INFO_INFO);
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_VOXMEMO_INFO_INFO, 0);
					TextboxSetInsertPointOn(TEXTBOX_VOXMEMO_INFO_INFO);
					FormDrawForm(FORM_VOXMEMO_REC);
					FormPopupForm(FORM_VOXMEMO_INFO);
				}
				else
				{
					VoxMemoDeleteRecord(FALSE);
					FormPopupForm(FORM_VOXMEMO_LIST);
				}
				
				InlaySetEnableStatus(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
				AlarmMgrEnable(TRUE);
				//BatteryWarningSetEnableStatus(TRUE);
				
				return TRUE;
				
			default:	return FALSE;
			}
			
#ifdef SNDMGR
			case SND_MGR_EVT:
				switch(Event->eventID)
				{
				case LOW_MEM:
					SndStop();
					FormGetControlValue(CONTROL_VOXMEMO_REC_REC, &ctrl_value);
					if (ctrl_value)
					{
						FormSetControlGroupSelection(FORM_VOXMEMO_REC, CONTROL_VOXMEMO_REC_REC);
						if (REAction)
							TmrIntDisable(TmrPauseLabel);							
					}
					HardKeyOff = 0;
					DisplayActionEnable = FALSE;
					REAction = FALSE;
					if (VoxMemoTime > 3598)
					{
						VoxMemoRecReset();
						InlaySetEnableStatus(TRUE);
						KeyboardSetKeyboardVisible();
						SystemSetMappedHardwareKeyStatus(TRUE);
						TextboxSetInsertPointPositionByCharPos(TEXTBOX_VOXMEMO_INFO_INFO, 0);
						TextboxSetInsertPointOn(TEXTBOX_VOXMEMO_INFO_INFO);
						FormPopupForm(FORM_VOXMEMO_INFO);
						AlarmMgrEnable(TRUE);				            
						BatteryWarningSetEnableStatus(TRUE);
					}
					else
						FormPopupForm(FORM_VOXMEMO_DIALOG_LOWMEM);
					
					return TRUE;
					
				case REC_TIME:
					if (Event->para1)
						VoxMemoDisplayTime();
					return TRUE;
					
				default:	return FALSE;
				}
#endif			
				
				case EVT_INLAY_SELECT:
					switch(Event->para1)
					{	
					case INLAY_OK:
						EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_VOXMEMO_REC_STOP, 0, 0, NULL);
						return TRUE;
						
					case INLAY_EXIT:
						FormGetControlValue(CONTROL_VOXMEMO_REC_REC, &ctrl_value);
#ifdef DEBUG
						printf("\n (VoxMemoRec) REC EXIT: ctrl_value = %d, REAction=%d\n", ctrl_value, REAction);
#endif
						/* if "PAUSE" button is pressed */
#ifdef SNDMGR
						SndStop();
#endif					
						if (ctrl_value)
						{
							FormSetControlGroupSelection(FORM_VOXMEMO_REC, CONTROL_VOXMEMO_REC_REC);
							if (REAction)
								TmrIntDisable(TmrPauseLabel);							
						}
						HardKeyOff = 0;
						DisplayActionEnable = FALSE;
						REAction = FALSE;
						
						//VoxMemoRecClose();
						//VoxMemoDeleteRecord(FALSE);
						//FormPopupForm(FORM_VOXMEMO_LIST);
						
						if (VoxMemoCheckRecordWithSound(VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA))				
						{
							FormDrawForm(FORM_VOXMEMO_REC);					
							FormPopupForm(FORM_VOXMEMO_DIALOG_SAVE);
						}
						else
						{
							VoxMemoDeleteRecord(FALSE);
							FormPopupForm(FORM_VOXMEMO_LIST);
						}
						
						InlaySetEnableStatus(TRUE);
						SystemSetMappedHardwareKeyStatus(TRUE);
						AlarmMgrEnable(TRUE);				            
						BatteryWarningSetEnableStatus(TRUE);
						return TRUE;
						
					default:	return FALSE;
						
					}
					
					
#ifdef PR31700
					case EVT_IO_KEY_CTRL:
						if (Event->eventID == EVT_IO_KEY_PRESS)
						{
							switch(Event->para2)
							{   
							case IO_SOUND_STOP:
								SndStop();
								FormGetControlValue(CONTROL_VOXMEMO_REC_REC, &ctrl_value);
								if (ctrl_value)
								{
									FormSetControlGroupSelection(FORM_VOXMEMO_REC, CONTROL_VOXMEMO_REC_REC);
									if (REAction)
										TmrIntDisable(TmrPauseLabel);							
								}
								HardKeyOff = 0;
								REAction = FALSE;
								DisplayActionEnable = FALSE;
								
								TextboxSetText(TEXTBOX_VOXMEMO_INFO_INFO, VOX_EXT_REC);
								TextboxSetInsertPointOff(TEXTBOX_VOXMEMO_INFO_INFO);
								if (VoxMemoCheckRecordWithSound(VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA))				
								{
									//FormPopupForm(FORM_VOXMEMO_INFO);
									if (!VoxMemoRecClose())
										return TRUE;
									ItemNum = 0;
									FormDrawForm(FORM_VOXMEMO_REC);
									FormPopupForm(FORM_VOXMEMO_LIST);
								}
								else
								{
									VoxMemoDeleteRecord(FALSE);
									FormPopupForm(FORM_VOXMEMO_LIST);
								}
								InlaySetEnableStatus(TRUE);
								SystemSetMappedHardwareKeyStatus(TRUE);
								AlarmMgrEnable(TRUE);				            
								BatteryWarningSetEnableStatus(TRUE);
								return TRUE;
								
								/*case IO_SOUND_PLAY:
								HardKeyOff = 0;
								return TRUE;*/
								
							case IO_SOUND_RECORD:
								FormGetControlValue(CONTROL_VOXMEMO_REC_REC, &ctrl_value);
#ifdef DEBUG
								printf("\n(VoxMemoRec 1) ctrl_value=%d, HardKeyOff=%d, REAction=%d\n", ctrl_value, HardKeyOff, REAction);
#endif						
								FormSetControlGroupSelection(FORM_VOXMEMO_REC, CONTROL_VOXMEMO_REC_REC);
#ifdef DEBUG
								printf("\n(VoxMemoRec 2) ctrl_value=%d, HardKeyOff=%d, REAction=%d\n", ctrl_value, HardKeyOff, REAction);
#endif						
								EvtAppendEvt(EVT_CONTROL_SELECT, CONTROL_VOXMEMO_REC_REC, 0, 0, NULL);
								return TRUE;
								
							default:
								return FALSE;						 
							}
						}
						return FALSE;
#endif
						
						
					default:	return FALSE;	
						
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	VoxMemoInfo
* Purpose: 	This function is the event handler for the 
*				information page of the VoxMemo application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoInfo(EvtType *Event)
{
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		pre_form_id = FORM_VOXMEMO_INFO;
		active_form_id = FORM_VOXMEMO_INFO;
		FormDrawForm(FORM_VOXMEMO_INFO);							
		BatteryWarningSetEnableStatus(TRUE);
		FormSetFormActiveObject(FORM_VOXMEMO_INFO, TEXTBOX_VOXMEMO_INFO_INFO);			
		return TRUE;
		
	case EVT_KEY:
		if (Event->para2 & 0x00000300)
			return TRUE;
		if (Event->para1 == '\r' || Event->para1 == '\n')
		{					
			if (!VoxMemoRecClose())
				return FALSE;
			FormPopupForm(FORM_VOXMEMO_LIST);
			return TRUE;
		}
		else
			TextboxAddKeyInChar(TEXTBOX_VOXMEMO_INFO_INFO, (BYTE)Event->para1);
		return TRUE;
		
		
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS)
		{
			switch(Event->para2)
			{   
			case IO_SOUND_STOP:
				if (!VoxMemoRecClose())
					return TRUE;
				ItemNum = 0;
				FormPopupForm(FORM_VOXMEMO_LIST);
				return FALSE;
			}
		}
		
	case EVT_INLAY_SELECT:	
		switch(Event->para1)
		{	
		case INLAY_OK:
			if (!VoxMemoRecClose())
				return TRUE;
			ItemNum = 0;
			FormPopupForm(FORM_VOXMEMO_LIST);
			return FALSE;
			
		case INLAY_EXIT:
			FormPopupForm(FORM_VOXMEMO_DIALOG_SAVE);
			return TRUE;
			
		default:	return FALSE;
		}
		
		default:	
			return FALSE;	
			
	}
	return FALSE;
}

/*****************************************************************
* Function:	VoxMemoPlay
* Purpose: 	This function is the event handler for the 
*				voice playing page of the VoxMemo application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoPlay(EvtType *Event)
{
	static USHORT	repeat_button_counter = 0;
	WORD			temp;
	
	switch(Event->eventType)
	{
	case POWER_EVENT:
		if (Event->eventID == BAT_MAIN_LOW)
		{
			FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
			if (PlayCtrlValue)
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_VOXMEMO_PLAY_STOP, 0, 0, NULL);				
		}
		return TRUE;		
		
	case EVT_FORM_OPEN:	
		REAction = FALSE;
		FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
		if (PlayCtrlValue)
			FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
		active_form_id = FORM_VOXMEMO_PLAY;
		FormDrawForm(FORM_VOXMEMO_PLAY);
		return TRUE;
		
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{	
		case INLAY_OK:
		case INLAY_EXIT:
#ifdef SNDMGR
			SndStop();
#endif					
			FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
			if (PlayCtrlValue)
			{
				FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
			}
			else if(REAction)
				TmrIntDisable(TmrPauseLabel);
			
			while(tmr_pause_label_counter > 0)
			{
				TmrIntDisable(TmrPauseLabel);
				tmr_pause_label_counter--;
			}
			
			DisplayActionEnable = FALSE;
			REAction = FALSE;
			HardKeyOff = 0;
			VoxMemoPlayClose();
			VoxMemoPlayReset();
			
			InlaySetEnableStatus(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			FormPopupForm(FORM_VOXMEMO_LIST);
			AlarmMgrEnable(TRUE);				            
			BatteryWarningSetEnableStatus(TRUE);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_CONTROL_SELECT:
			FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
			switch(Event->eventID)
			{	
			case BUTTON_VOXMEMO_ERASE_RECORD:
#ifdef SNDMGR
				SndStop();
#endif					
				if (PlayCtrlValue)
				{
					FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
				}
				else if(REAction)
					TmrIntDisable(TmrPauseLabel);
				while(tmr_pause_label_counter > 0)
				{
					TmrIntDisable(TmrPauseLabel);
					tmr_pause_label_counter--;
				}
				
				DisplayActionEnable = FALSE;
				REAction = FALSE;
				HardKeyOff = 0;
				VoxMemoPlayClose();
				FormPopupForm(FORM_VOXMEMO_DIALOG_ERASE);
				return TRUE;
				
				
			case BUTTON_VOXMEMO_RENAME_RECORD:
#ifdef SNDMGR
				SndStop();
#endif					
				if (PlayCtrlValue)
				{
					FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
				}
				else if(REAction)
					TmrIntDisable(TmrPauseLabel);
				while(tmr_pause_label_counter > 0)
				{
					TmrIntDisable(TmrPauseLabel);
					tmr_pause_label_counter--;
				}
				
				DisplayActionEnable = FALSE;
				REAction = FALSE;
				HardKeyOff = 0;
				VoxMemoPlayReset();
				//					VoxMemoPlayClose();
				InlaySetEnableStatus(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
				FormPopupForm(FORM_VOXMEMO_DIALOG_EDTITLE);
				AlarmMgrEnable(TRUE);				            
				BatteryWarningSetEnableStatus(TRUE);
				return TRUE;
				
			case CONTROL_VOXMEMO_PLAY_PLAY:
				if (VoxMemoTime2 > -1)
				{
					if (!PlayCtrlValue && !HardKeyOff)
						FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
					if ((!PlayCtrlValue) && HardKeyOff)
					{
						DisplayActionEnable = FALSE;
						TmrPauseLabel = TmrIntEnable(500, VoxMemoDisplayPauseTime);
						tmr_pause_label_counter++;
#ifdef SNDMGR
						SndPause();
#endif
					}
					else if(REAction)
					{
#ifdef DEBUG
						printf("\n(VoxMemoPlay1) SndREPlay(SF=%d, %d, %d, F_CODEDATA)", VoxMemoTime, VoxMemo_dbid, VoxMemo_rec_id);
#endif
#ifdef SNDMGR
						SndREPlay(VoxMemoTime, VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA);
#endif							
						while(tmr_pause_label_counter > 0)
						{
							TmrIntDisable(TmrPauseLabel);
							tmr_pause_label_counter--;
						}
						DisplayActionEnable = TRUE;
					}
					else
					{
						if (CheckBatteryLow())
						{
							FormPopupForm(FORM_VOXMEMO_DIALOG_LOW_BATTERY);
							return TRUE;
						}
						
						BatteryWarningSetEnableStatus(FALSE);
						InlaySetEnableStatus(FALSE);
						SystemSetMappedHardwareKeyStatus(FALSE);
						AlarmMgrEnable(FALSE);				            
						/* play voice with startframe*/
#ifdef DEBUG
						printf("\n(VoxMemoPlay2) SndPlay(SF=%d, %d, %d, F_CODEDATA)", VoxMemoTime, VoxMemo_dbid, VoxMemo_rec_id);
#endif
#ifdef SNDMGR
						SndPlay(VoxMemoTime, VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA);
#endif							
						DisplayActionEnable = TRUE;
						HardKeyOff = 1;
						REAction = TRUE;
					}
				}
				return	TRUE;
				
			case CONTROL_VOXMEMO_PLAY_FBWD:
#ifdef DEBUG
				printf("\n(VoxMemoPlay3) VoxMemoTime=%d", VoxMemoTime);
#endif
				if (PlayCtrlValue)
				{
#ifdef SNDMGR
					SndPause();
					SndREPlay(VoxMemoTime, VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA);
#endif							
					DisplayActionEnable = TRUE;
				}
				repeat_button_counter = 0;
				return	TRUE;
				
			case CONTROL_VOXMEMO_PLAY_FFWD:
#ifdef DEBUG
				printf("\n(VoxMemoPlay4) VoxMemoTime2=%d", VoxMemoTime2);
#endif
				if (PlayCtrlValue)
				{
#ifdef SNDMGR
					SndPause();
					SndREPlay(VoxMemoTime, VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA);
#endif							
					DisplayActionEnable = TRUE;
				}
				repeat_button_counter = 0;
				return TRUE;
				
			default:	return FALSE;
			}
			
		case EVT_BITMAP_SELECT:
			FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
#ifdef DEBUG
			printf("\n(VoxMemoPlay5) PLAY STOP: PlayCtrlValue=%d", PlayCtrlValue);
#endif
#ifdef SNDMGR
			SndStop();
#endif			
			if (PlayCtrlValue || REAction)
				VoxMemoPlayReset();
			
			HardKeyOff = 0;
			DisplayActionEnable = FALSE;
			switch(Event->eventID)
			{	
			case BITMAP_VOXMEMO_PLAY_STOP:
				if (PlayCtrlValue)
				{
					FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
				}
				else if(REAction)
					TmrIntDisable(TmrPauseLabel);
#ifdef DEBUG
				printf("\n(VoxMemoPlay6) tmr_pause_label_counter=%d", tmr_pause_label_counter);
#endif
				while(tmr_pause_label_counter > 0)
				{
					TmrIntDisable(TmrPauseLabel);
					tmr_pause_label_counter--;
				}
#ifdef DEBUG
				printf("\n(VoxMemoPlay7) tmr_pause_label_counter=%d", tmr_pause_label_counter);
#endif
				REAction = FALSE;
				InlaySetEnableStatus(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
				AlarmMgrEnable(TRUE);				            
				BatteryWarningSetEnableStatus(TRUE);
				return TRUE;
				
			case BITMAP_VOXMEMO_PLAY_FBWDN:
				if (CheckBatteryLow())
				{
					FormPopupForm(FORM_VOXMEMO_DIALOG_LOW_BATTERY);
					return TRUE;
				}
				if (--ItemNum < 0)
				{	
					ItemNum++;
					if (PlayCtrlValue)
					{
						FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
					}
					else if(REAction)
						TmrIntDisable(TmrPauseLabel);
					
					while(tmr_pause_label_counter > 0)
					{
						TmrIntDisable(TmrPauseLabel);
						tmr_pause_label_counter--;
					}
					
					REAction = FALSE;
					return TRUE;
				}
				VoxMemoPlayClose();
#ifdef DEBUG
				printf("\n(VoxMemoPlay8) VoxMemoOpenRecord, ItemNum=%d", ItemNum);						
#endif
				if (!VoxMemoOpenRecord(ItemNum))
				{
					return TRUE;
				}
				if (PlayCtrlValue)
				{
					FormDrawForm(FORM_VOXMEMO_PLAY);
#ifdef SNDMGR
					SndPlay(0, VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA);
#endif						
					DisplayActionEnable = TRUE;
					REAction = TRUE;
#ifdef DEBUG
					printf("(VoxMemoPlay9) FBWDN: PlayCtrlValue=%d, REAction=%d, TmrLabel=%d, TmrPauseLabel=%d\n", PlayCtrlValue, REAction, TmrLabel, TmrPauseLabel);
#endif
				}
				else
				{
					if(REAction)
						TmrIntDisable(TmrPauseLabel);
					while(tmr_pause_label_counter > 0)
					{
						TmrIntDisable(TmrPauseLabel);
						tmr_pause_label_counter--;
					}
					
					FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
					FormPopupForm(FORM_VOXMEMO_PLAY);
					EvtAppendEvt(EVT_CONTROL_SELECT, CONTROL_VOXMEMO_PLAY_PLAY, 0, 0, NULL);				
					
				}
				return TRUE;
				
			case BITMAP_VOXMEMO_PLAY_FFWDN:
				if (CheckBatteryLow())
				{
					FormPopupForm(FORM_VOXMEMO_DIALOG_LOW_BATTERY);
					return TRUE;
				}
#ifdef DEBUG
				printf("\n(VoxMemoPlay10) PLAY_FFWDN: dbid=%d, rec_id=%d", VoxMemo_dbid, VoxMemo_rec_id);
#endif
				if (DataTotalRecord(VoxMemo_dbid, &temp) != TRUE)
					return TRUE;
#ifdef DEBUG
				printf("\n(VoxMemoPlay11) PLAY_FFWDN: dbid=%d, rec_id=%d, total_rec=%ld\n", VoxMemo_dbid, VoxMemo_rec_id, temp);
#endif
				if (++ItemNum > (temp-1))
				{
					--ItemNum;
					if (PlayCtrlValue)
					{
						FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
					}
					else if(REAction)
						TmrIntDisable(TmrPauseLabel);
					while(tmr_pause_label_counter > 0)
					{
						TmrIntDisable(TmrPauseLabel);
						tmr_pause_label_counter--;
					}
					
					REAction = FALSE;
					return TRUE;
				}
				VoxMemoPlayClose();
#ifdef DEBUG
				printf("\n(VoxMemoPlay12) VoxMemoOpenRecord, ItemNum=%d", ItemNum);
#endif
				if (!VoxMemoOpenRecord(ItemNum))
				{
					return TRUE;
				}
				if (PlayCtrlValue)
				{
					FormDrawForm(FORM_VOXMEMO_PLAY);
#ifdef SNDMGR
					SndPlay(0, VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA);
#endif						
					DisplayActionEnable = TRUE;
					REAction = TRUE;
#ifdef DEBUG
					printf("\n(VoxMemoPlay13) FFWDN: PlayCtrlValue=%d, REAction=%d, TmrLabel=%d, TmrPauseLabel=%d\n", PlayCtrlValue, REAction, TmrLabel, TmrPauseLabel);
#endif
				}
				else
				{
					if(REAction)
						TmrIntDisable(TmrPauseLabel);
					while(tmr_pause_label_counter > 0)
					{
						TmrIntDisable(TmrPauseLabel);
						tmr_pause_label_counter--;
					}
					
					FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
					FormPopupForm(FORM_VOXMEMO_PLAY);
					EvtAppendEvt(EVT_CONTROL_SELECT, CONTROL_VOXMEMO_PLAY_PLAY, 0, 0, NULL);				
				}
				return TRUE;
				
			default:	return FALSE;
			}
			
		case EVT_SCROLLBAR_REPEAT:
			FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
			switch(Event->eventID)
			{
			case SCROLLBAR_VOXMEMO_PLAY_VOL:
				if (Event->para1 == Event->para2)
					return FALSE;
				ScrollbarDrawScrollbar((USHORT)Event->eventID);
				return TRUE;
				
			case SCROLLBAR_VOXMEMO_PLAY_TIME:
				if (Event->para1 != Event->para2)
				{
					SndPause();
					if (PlayCtrlValue)
						DisplayActionEnable = FALSE;
					temp = VoxMemoTime + VoxMemoTime2;
					if (Event->para2 > Event->para1)
						VoxMemoTime = (USHORT)(Event->para2*(VoxMemoTime+VoxMemoTime2)/60);
					else
						VoxMemoTime = (USHORT)(Event->para2*(VoxMemoTime+VoxMemoTime2)/60-1);
					
					VoxMemoTime2 = temp-VoxMemoTime;						
					VoxMemoDisplayPlayTime();
					ScrollbarDrawScrollbar((USHORT)Event->eventID);
					
				}
				return TRUE;
				
				
			default:	return FALSE;
			}
			
			case EVT_SCROLLBAR_SELECT:
				switch(Event->eventID)
				{
				case SCROLLBAR_VOXMEMO_PLAY_VOL:
					ScrollbarDrawScrollbar((USHORT)Event->eventID);
					VoxMemoScrollbarSetVol(Event);
					return TRUE;
					
				case SCROLLBAR_VOXMEMO_PLAY_TIME:
					{
						FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
						if (PlayCtrlValue)
						{
#ifdef SNDMGR
							SndPause();
							SndREPlay(VoxMemoTime, VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA);
#endif							
							DisplayActionEnable = TRUE;
						}							
					}
					return TRUE;
					
				default:	return FALSE;
				}
				
				
				case EVT_CONTROL_REPEAT:
					repeat_button_counter++;
					FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
					switch(Event->eventID)
					{						
					case CONTROL_VOXMEMO_PLAY_FBWD:
						if (VoxMemoTime > 0)
						{
							if (PlayCtrlValue)
							{
								if (repeat_button_counter == 1)
								{
									DisplayActionEnable = FALSE;
								}
							}
							
							VoxMemoTime -= 2;
							VoxMemoTime2 += 2;
							VoxMemoDisplayPlayTime();
						}					
						return	TRUE;
						
					case CONTROL_VOXMEMO_PLAY_FFWD:
						if (VoxMemoTime2 > 0)
						{
							if (PlayCtrlValue)
							{
								if (repeat_button_counter == 1)
								{
									DisplayActionEnable = FALSE;
								}
							}
							
							VoxMemoDisplayPlayTime();
							
						}					
						return TRUE;
						
					default:	return FALSE;
					}
					
					
#ifdef SNDMGR
					case SND_MGR_EVT:
						switch(Event->eventID)
						{
						case REC_END:
							SndStop();
							
							FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
#ifdef DEBUG
							printf("\n(VoxMemoPlay14) PLAY STOP: PlayCtrlValue=%d, REAction=%d, TmrLabel=%d, TmrPauseLabel=%d\n", PlayCtrlValue, REAction, TmrLabel, TmrPauseLabel);
#endif
							if (PlayCtrlValue)
							{
								FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
							}
							else if(REAction)
								TmrIntDisable(TmrPauseLabel);
							while(tmr_pause_label_counter > 0)
							{
								TmrIntDisable(TmrPauseLabel);
								tmr_pause_label_counter--;
							}
							
							DisplayActionEnable = FALSE;
							
							HardKeyOff = 0;
							REAction = FALSE;
							VoxMemoPlayReset();
							InlaySetEnableStatus(TRUE);
							SystemSetMappedHardwareKeyStatus(TRUE);
							AlarmMgrEnable(TRUE);				            
							BatteryWarningSetEnableStatus(TRUE);
							return TRUE;
							
						case PLAY_TIME:
							if (Event->para1)
								VoxMemoDisplayTime();
							return TRUE;
							
							
						default:	return FALSE;
						}
#endif			
						
						
#ifdef PR31700
						case EVT_IO_KEY_CTRL:
							if (Event->eventID == EVT_IO_KEY_PRESS)
							{
								switch(Event->para2)
								{   
								case IO_SOUND_STOP:
									HardKeyOff = 0;
									EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_VOXMEMO_PLAY_STOP, 0, 0, NULL);
									return TRUE;
									
								case IO_SOUND_PLAY:
									if (CheckBatteryLow())
									{
										FormPopupForm(FORM_VOXMEMO_DIALOG_LOW_BATTERY);
										return TRUE;
									}
									
									FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
									EvtAppendEvt(EVT_CONTROL_SELECT, CONTROL_VOXMEMO_PLAY_PLAY, 0, 0, NULL);				
									return TRUE;
									
								case IO_UP_ARROW:
									if (CheckBatteryLow())
									{
										FormPopupForm(FORM_VOXMEMO_DIALOG_LOW_BATTERY);
										return TRUE;
									}
									
									FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
									SndStop();
									VoxMemoPlayReset();
									HardKeyOff = 0;
									DisplayActionEnable = FALSE;
									if (--ItemNum < 0)
									{	
										ItemNum++;
										if (PlayCtrlValue)
											FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
										else if(REAction)
											TmrIntDisable(TmrPauseLabel);
										while(tmr_pause_label_counter > 0)
										{
											TmrIntDisable(TmrPauseLabel);
											tmr_pause_label_counter--;
										}
										
										REAction = FALSE;
										return TRUE;
									}
									VoxMemoPlayClose();
									if (!VoxMemoOpenRecord(ItemNum))
										return TRUE;
									if (!PlayCtrlValue)
									{
										FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
										if(REAction)
											TmrIntDisable(TmrPauseLabel);
										while(tmr_pause_label_counter > 0)
										{
											TmrIntDisable(TmrPauseLabel);
											tmr_pause_label_counter--;
										}
										
									}
									FormDrawForm(FORM_VOXMEMO_PLAY);
									SndPlay(0, VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA);
									DisplayActionEnable = TRUE;
									HardKeyOff = 1;
									REAction = TRUE;
									return TRUE;					
									
								case IO_DOWN_ARROW:
									if (CheckBatteryLow())
									{
										FormPopupForm(FORM_VOXMEMO_DIALOG_LOW_BATTERY);
										return TRUE;
									}
									
									FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
									SndStop();
									VoxMemoPlayReset();
									HardKeyOff = 0;
									DisplayActionEnable = FALSE;
									
									if (DataTotalRecord(VoxMemo_dbid, &temp) != TRUE)
										return TRUE;
									if (++ItemNum > (temp-1))
									{
										--ItemNum;
										if (PlayCtrlValue)
											FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
										else if(REAction)
											TmrIntDisable(TmrPauseLabel);
										
										while(tmr_pause_label_counter > 0)
										{
											TmrIntDisable(TmrPauseLabel);
											tmr_pause_label_counter--;
										}
										
										REAction = FALSE;
										return TRUE;
										
									}
									VoxMemoPlayClose();
									if (!VoxMemoOpenRecord(ItemNum))
										return TRUE;
									if (!PlayCtrlValue)
									{
										FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
										if(REAction)
											TmrIntDisable(TmrPauseLabel);
										while(tmr_pause_label_counter > 0)
										{
											TmrIntDisable(TmrPauseLabel);
											tmr_pause_label_counter--;
										}
										
									}
									FormDrawForm(FORM_VOXMEMO_PLAY);
									SndPlay(0, VoxMemo_dbid, VoxMemo_rec_id, F_CODEDATA);
									DisplayActionEnable = TRUE;
									HardKeyOff = 1;
									REAction = TRUE;
									return TRUE;
									
									//                    case (IO_SOUND_RECORD | IO_SOUND_PLAY):
								case IO_SOUND_RECORD:
									FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &PlayCtrlValue);
									
									SndStop();
									if (PlayCtrlValue)
									{
										FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
									}
									else if(REAction)
										TmrIntDisable(TmrPauseLabel);
									while(tmr_pause_label_counter > 0)
									{
										TmrIntDisable(TmrPauseLabel);
										tmr_pause_label_counter--;
									}
									
									VoxMemoPlayClose();
									VoxMemoPlayReset();
									HardKeyOff = 0;
									DisplayActionEnable = FALSE;
									REAction = FALSE;		
									
									VoxMemoRecReset();
									if (VoxMemoTime2 < 3)
									{
										return TRUE;
									}
									
									if (VoxMemoNewRecord() != TRUE)
									{
										FormPopupForm(FORM_VOXMEMO_DIALOG_RECABORT);
										return TRUE;
									}
									TmrLabel = 0;
									TmrPauseLabel = 0;
									FormPopupForm(FORM_VOXMEMO_REC);
									EvtAppendEvt(EVT_CONTROL_SELECT, CONTROL_VOXMEMO_REC_REC, 0, 0, NULL);				
									
									return TRUE;
								default:
									return FALSE;						 
				}
			}
			return FALSE;
#endif
			
			
		default:	return FALSE;	
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	VoxMemoDialogErase
* Purpose: 	This function is the event handler for confirming  
*				memo erase dialog box of the VoxMemo application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoDialogErase(EvtType *Event)
{
	BOOLEAN	ctrl_value;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormGetControlValue(CONTROL_VOXMEMO_DIALOG_ERASE_CHECK, &ctrl_value);
		if (ctrl_value == TRUE)
			FormSetControlGroupSelection(FORM_VOXMEMO_DIALOG_ERASE, CONTROL_VOXMEMO_DIALOG_ERASE_CHECK);
		active_form_id = FORM_VOXMEMO_DIALOG_ERASE;
		FormDrawForm(FORM_VOXMEMO_DIALOG_ERASE);
		return TRUE;
		
	case EVT_CONTROL_SELECT:
		FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
		InlaySetEnableStatus(TRUE);
		SystemSetMappedHardwareKeyStatus(TRUE);
		switch(Event->eventID)
		{	
		case BUTTON_VOXMEMO_DIALOG_ERASE_YES:
			FormGetControlValue(CONTROL_VOXMEMO_DIALOG_ERASE_CHECK, &ctrl_value);
			VoxMemoDeleteRecord(ctrl_value);
			FormPopupForm(FORM_VOXMEMO_LIST);
			AlarmMgrEnable(TRUE);				            
			BatteryWarningSetEnableStatus(TRUE);
			return TRUE;
			
		case BUTTON_VOXMEMO_DIALOG_ERASE_NO:
			FormPopupForm(FORM_VOXMEMO_LIST);
			AlarmMgrEnable(TRUE);				            
			BatteryWarningSetEnableStatus(TRUE);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				EvtAppendEvt(EVT_CONTROL_SELECT, BUTTON_VOXMEMO_DIALOG_ERASE_YES, 0, 0, NULL);
				return TRUE;
			case INLAY_EXIT:
				EvtAppendEvt(EVT_CONTROL_SELECT, BUTTON_VOXMEMO_DIALOG_ERASE_NO, 0, 0, NULL);
				return TRUE;
				
			default:	return FALSE;
			}
			default:	return FALSE;
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	VoxMemoDialogLowMem
* Purpose: 	This function is the event handler for displaying  
*				low memory dialog box of the VoxMemo application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoDialogLowMem(EvtType *Event)
{
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		active_form_id = FORM_VOXMEMO_DIALOG_LOWMEM;
		FormDrawForm(FORM_VOXMEMO_DIALOG_LOWMEM);
		return TRUE;
		// --------------------------------------------------------------------**
		/*
		case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{	
		case BUTTON_VOXMEMO_DIALOG_LOWMEM_YES:
		VoxMemoRecClose();
		VoxMemoDeleteRecord(FALSE);
		FormPopupForm(FORM_VOXMEMO_LIST);
		return TRUE;
		
		  case BUTTON_VOXMEMO_DIALOG_LOWMEM_NO:
		  VoxMemoRecReset();
		  FormPopupForm(FORM_VOXMEMO_INFO);
		  return TRUE;
		  
			default:	return FALSE;
			}
		*/
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{	
		case INLAY_OK:
		case INLAY_EXIT:			
			VoxMemoRecReset();
			InlaySetEnableStatus(TRUE);
			KeyboardSetKeyboardVisible();
			SystemSetMappedHardwareKeyStatus(TRUE);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_VOXMEMO_INFO_INFO, 0);
			TextboxSetInsertPointOn(TEXTBOX_VOXMEMO_INFO_INFO);
			FormPopupForm(FORM_VOXMEMO_INFO);
			AlarmMgrEnable(TRUE);				            
			BatteryWarningSetEnableStatus(TRUE);
			return TRUE;
			
		default:	return FALSE;
		}
		
		// --------------------------------------------------------------------**
		
		default:	return FALSE;	
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	VoxMemoDialogSave
* Purpose: 	This function is the event handler for save   
*				confirmation dialog box of the VoxMemo application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoDialogSave(EvtType *Event)
{
	BYTE	*textbox_string;
	WORD	char_pos;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		active_form_id = FORM_VOXMEMO_DIALOG_SAVE;
		FormDrawForm(FORM_VOXMEMO_DIALOG_SAVE);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{	
		case BITMAP_VOXMEMO_DIALOG_SAVE_X:
			TextboxGetTextPointer(TEXTBOX_VOXMEMO_INFO_INFO, &textbox_string);				
			char_pos = strlen(textbox_string);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_VOXMEMO_INFO_INFO, char_pos);
			FormPopupForm(FORM_VOXMEMO_INFO);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_CONTROL_SELECT:
			switch(Event->eventID)
			{	
			case BUTTON_VOXMEMO_DIALOG_SAVE_YES:
				if (pre_form_id == FORM_VOXMEMO_REC)
				{	
					TextboxSetText(TEXTBOX_VOXMEMO_INFO_INFO, (BYTE*)(""));
					
					FormSetFormActiveObject(FORM_VOXMEMO_INFO, TEXTBOX_VOXMEMO_INFO_INFO);
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_VOXMEMO_INFO_INFO, 0);
					TextboxSetInsertPointOn(TEXTBOX_VOXMEMO_INFO_INFO);
					FormDrawForm(FORM_VOXMEMO_REC);					
					FormPopupForm(FORM_VOXMEMO_INFO);
					
				}
				else
				{
					if (VoxMemoRecClose() != TRUE)
					{
						FormPopupForm(FORM_VOXMEMO_DIALOG_RECABORT);
						return TRUE;
					}
					ItemNum = 0;
					FormPopupForm(FORM_VOXMEMO_LIST);
				}
				return TRUE;
				
			case BUTTON_VOXMEMO_DIALOG_SAVE_NO:
				VoxMemoRecClose();
				VoxMemoDeleteRecord(FALSE);
				FormPopupForm(FORM_VOXMEMO_LIST);
				return TRUE;
				
			default:	return FALSE;
			}
			
			case EVT_INLAY_SELECT:
				switch(Event->para1)
				{	
				case INLAY_OK:
					EvtAppendEvt(EVT_CONTROL_SELECT, BUTTON_VOXMEMO_DIALOG_SAVE_YES, 0, 0, NULL);
					return TRUE;
				case INLAY_EXIT:
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_VOXMEMO_DIALOG_SAVE_X, 0, 0, NULL);
					return TRUE;
					
				default:	return FALSE;
				}
				default:	return FALSE;	
					
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	VoxMemoDialogRecAbort
* Purpose: 	This function is the event handler for diaplaying   
*				record abort dialog box of the VoxMemo application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoDialogRecAbort(EvtType *Event)
{
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		active_form_id = FORM_VOXMEMO_DIALOG_RECABORT;
		FormDrawForm(FORM_VOXMEMO_DIALOG_RECABORT);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{	
		case BITMAP_VOXMEMO_DIALOG_RECABORT_X:
			FormPopupForm(FORM_VOXMEMO_LIST);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
			case INLAY_EXIT:			
				FormPopupForm(FORM_VOXMEMO_LIST);
				return TRUE;
				
			default:	return FALSE;
			}
			default:	return FALSE;	
				
	}
	
	return FALSE;
}



/*****************************************************************
* Function:	VoxmemoDialogEditTitle
* Purpose: 	This function is the event handler for the edit Title
*				dialog box of the Voxmemo application
* Scope:		appliTitleion/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoDialogEditTitle(EvtType *Event)
{
	BYTE	*string_text;
	WORD	char_pos;
	
	Textbox	*textbox_ptr;
	BYTE	object_type;
	
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		StringGetText(STRING_VOXMEMO_PLAY_INFO, &string_text);
		FormSetFormActiveObject(FORM_VOXMEMO_DIALOG_EDTITLE, TEXTBOX_VOXMEMO_DIALOG_EDTITLE);
		
		if (string_text[0] != 0)
		{
			TextboxSetText(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, string_text);
			char_pos = strlen(string_text);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, char_pos);
			TextboxSetHighlightSelection(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, 0, char_pos);
			
			//				ListInsertItem(LIST_VOXMEMO_LIST_INFO, ItemNum, string_text);
		}
		else
		{
			TextboxSetText(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, string_text);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, 0);
			TextboxSetInsertPointOn(TEXTBOX_VOXMEMO_DIALOG_EDTITLE);
		}
		
		active_form_id = FORM_VOXMEMO_DIALOG_EDTITLE;
		FormDrawForm(FORM_VOXMEMO_DIALOG_EDTITLE);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{	
		case BITMAP_VOXMEMO_DIALOG_EDTITLE_X:
			FormPopupForm(FORM_VOXMEMO_PLAY);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_KEY:
			if (Event->para2 & 0x00000300)
				return TRUE;
			if (Event->eventID == SOFT_KEY)
			{
				if (Event->para1 == '\r' || Event->para1 == '\n')
				{
				/*
				StringGetText(STRING_VOXMEMO_PLAY_INFO, &string_text);
				TextboxGetTextPointer(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, &textbox_string);
				if (!strcmp(string_text, textbox_string))
				{
				FormPopupForm(FORM_VOXMEMO_PLAY);
				return TRUE;
				}
					*/
					VoxMemoRenameTitle();
					FormPopupForm(FORM_VOXMEMO_PLAY);
					return TRUE;
				}
				FormGetObjectPointer(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, &object_type, (void**)&textbox_ptr);
				
				TextboxAddKeyInChar(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, (BYTE)(Event->para1));
				return TRUE;
			}
			break;
			
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				//					StringGetText(STRING_VOXMEMO_PLAY_INFO, &string_text);
				//					TextboxGetTextPointer(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, &textbox_string);
				//					if (!strcmp(string_text, textbox_string))
				//					{
				//						FormPopupForm(FORM_VOXMEMO_PLAY);
				//						return TRUE;
				//					}
				VoxMemoRenameTitle();
				FormPopupForm(FORM_VOXMEMO_PLAY);
				return TRUE;
				
			case INLAY_EXIT:
				FormPopupForm(FORM_VOXMEMO_PLAY);
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	VoxMemoDialogLowBattery
* Purpose: 	This function is the event handler for the low battery
*				form of the Voxmemo application
* Scope:		appliTitleion/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoDialogLowBattery(EvtType *Event)
{
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_VOXMEMO_DIALOG_LOW_BATTERY);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{	
		case BITMAP_VOXMEMO_DIALOG_LOW_BATTERY_X:
			FormPopupForm(FORM_VOXMEMO_LIST);
			return TRUE;
			
		default:	return FALSE;
		}
		
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
			case INLAY_EXIT:
				FormPopupForm(FORM_VOXMEMO_LIST);
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	return FALSE;
}


