/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   voxmsave.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "voxmdef.h"
#include "voxmemo.h"
#include "sysetup.h"
#include "alaunch.h"
#include "ioconmsg.h"

extern SHORT		ItemNum;
extern UWORD		TmrLabel, TmrPauseLabel;
extern DatabaseID	VoxMemo_dbid;
extern RecordID		VoxMemo_rec_id;
extern AppID 		app_id;
extern SHORT		VoxMemoTime;
extern SHORT		VoxMemoTime2;
extern BYTE			HardKeyOff;
extern SHORT		DisplayAction;


/*****************************************************************
* Function:	VoxMemoAppSave
* Purpose: 	This function is called to save the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
BOOLEAN VoxMemoAppSave(void)
{
	
	if (!VoxMemoMainAppSave())
		return FALSE;
	if (!VoxMemoMDBAppSave())
		return FALSE;
	if (!VoxMemoDatabaseClose())
		return FALSE;
	
	return TRUE;
}


/********************************************************
* Function:	VoxMemoAppRestore
* Purpose: 	This function is called to restore the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		restart		whether the application is restart or not
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN VoxMemoAppRestore(BOOLEAN is_restart)
{
	BYTE		*buffer, *text, *num_char;
	UWORD		byte_read, rec_num;
	SHORT		top_item_num;
	
	
	FormInitAllFormObjects(FORM_VOXMEMO_LIST);
	FormInitAllFormObjects(FORM_VOXMEMO_REC);
	FormInitAllFormObjects(FORM_VOXMEMO_INFO);
	FormInitAllFormObjects(FORM_VOXMEMO_PLAY);
	FormInitAllFormObjects(FORM_VOXMEMO_DIALOG_EDTITLE);
	if (!VoxMemoDatabaseInit(is_restart))
		return FALSE;
	if (!VoxMemoInitMainGlobal(is_restart))
		return FALSE;
	if (!VoxMemoInitMDBGlobal(is_restart))
		return FALSE;
	
	if (!VoxMemoVolSetScrollbar())
		return FALSE;
	
	if (is_restart)
		FormPopupForm(FORM_VOXMEMO_LIST);
	else
	{
		if (DataFindDB(VOXDB, &VoxMemo_dbid) != TRUE)
			return FALSE;
		if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_ActiveFormID, &buffer, &byte_read) != TRUE)
			return FALSE;
		
		switch(*(ObjectID*)buffer)
		{
		case FORM_VOXMEMO_REC:
		/*
		if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, &text, &byte_read) != TRUE)
		return FALSE;
		StringSetText(STRING_VOXMEMO_REC_TIME, text);
		qfree(text);
		if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, &text, &byte_read) != TRUE)
		return FALSE;
		StringSetText(STRING_VOXMEMO_REC_DATE, text);
		qfree(text);
		if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_LTimeString, &text, &byte_read) != TRUE)
		return FALSE;
		StringSetText(STRING_VOXMEMO_REC_RECTIME, text);
		qfree(text);
		if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_RTimeString, &text, &byte_read) != TRUE)
		return FALSE;
		StringSetText(STRING_VOXMEMO_REC_REMTIME, text);
		qfree(text);
			*/
			/*
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, &text, &byte_read) != TRUE)
			return FALSE;
			StringSetText(STRING_VOXMEMO_INFO_TIME, text);
			qfree(text);			
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, &text, &byte_read) != TRUE)
			return FALSE;
			StringSetText(STRING_VOXMEMO_INFO_DATE, text);
			qfree(text);	
			*/
			/*
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MDB_APP_SAVE, F_VoxMemo_rec_id, &text, &byte_read) != TRUE)
			return FALSE;
			VoxMemo_rec_id = *(RecordID*)text;
			if (DataRecIDtoNum(VoxMemo_dbid, VoxMemo_rec_id, &rec_num) != TRUE)
			return FALSE;
			if (DataOpenRecord(VoxMemo_dbid, rec_num, &VoxMemo_rec_id, NULL) != TRUE)
			return FALSE;
			qfree(text);
			FormPopupForm(*(ObjectID*)buffer);
			*/
			FormPopupForm(FORM_VOXMEMO_LIST);
			break;
			
			
		case FORM_VOXMEMO_INFO:
		/*
		if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, &text, &byte_read) != TRUE)
		return FALSE;
		StringSetText(STRING_VOXMEMO_INFO_TIME, text);
		qfree(text);			
		if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, &text, &byte_read) != TRUE)
		return FALSE;
		StringSetText(STRING_VOXMEMO_INFO_DATE, text);
		qfree(text);	
			*/
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_REC_TIME, text);
			qfree(text);			
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_REC_DATE, text);
			qfree(text);	
			//---------------------------------------------------------------------------------------------------
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MDB_APP_SAVE, F_VoxMemo_rec_id, &text, &byte_read) != TRUE)
				return FALSE;
			VoxMemo_rec_id = *(RecordID*)text;
			qfree(text);		
			if (DataRecIDtoNum(VoxMemo_dbid, VoxMemo_rec_id, &rec_num) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			if (DataOpenRecord(VoxMemo_dbid, rec_num, &VoxMemo_rec_id, NULL) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			//---------------------------------------------------------------------------------------------------
			
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoString, &text, &byte_read) != TRUE)
				return FALSE;											
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoCharPos, &num_char, &byte_read) != TRUE)
				return FALSE;
			
			//TextboxSetInsertPointOff(TEXTBOX_VOXMEMO_INFO_INFO);
			FormSetFormActiveObject(FORM_VOXMEMO_INFO, TEXTBOX_VOXMEMO_INFO_INFO);
			TextboxSetText(TEXTBOX_VOXMEMO_INFO_INFO, text);
			if ((WORD)(*(BYTE*)num_char) > -1)
			{
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_VOXMEMO_INFO_INFO, (WORD)(*(BYTE*)num_char));
				TextboxSetInsertPointOn(TEXTBOX_VOXMEMO_INFO_INFO);
			}
			else
			{
				TextboxSetHighlightSelection(TEXTBOX_VOXMEMO_INFO_INFO, 0, strlen(text));
				TextboxSetInsertPointOff(TEXTBOX_VOXMEMO_INFO_INFO);
			}
			
			qfree(text);	
			qfree(num_char);	
			FormDrawForm(FORM_VOXMEMO_REC);
			FormPopupForm(*(ObjectID*)buffer);
			break;
			
		case FORM_VOXMEMO_DIALOG_SAVE:
		/*
		if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, &text, &byte_read) != TRUE)
		return FALSE;
		StringSetText(STRING_VOXMEMO_INFO_TIME, text);
		qfree(text);			
		if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, &text, &byte_read) != TRUE)
		return FALSE;
		StringSetText(STRING_VOXMEMO_INFO_DATE, text);
		qfree(text);	
			*/
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_REC_TIME, text);
			qfree(text);			
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_REC_DATE, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoString, &text, &byte_read) != TRUE)
				return FALSE;											
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoCharPos, &num_char, &byte_read) != TRUE)
				return FALSE;
				/*
				for(byte_read=0; byte_read<(UWORD)(*(BYTE*)num_char); byte_read++)
				TextboxAddKeyInChar(TEXTBOX_VOXMEMO_INFO_INFO, (BYTE)text[byte_read]);												
			*/
			TextboxSetText(TEXTBOX_VOXMEMO_INFO_INFO, text);
			//TextboxSetInsertPointOff(TEXTBOX_VOXMEMO_INFO_INFO);
			qfree(text);	
			qfree(num_char);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MDB_APP_SAVE, F_VoxMemo_rec_id, &text, &byte_read) != TRUE)
				return FALSE;
			VoxMemo_rec_id = *(RecordID*)text;
			qfree(text);		
			if (DataRecIDtoNum(VoxMemo_dbid, VoxMemo_rec_id, &rec_num) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			if (DataOpenRecord(VoxMemo_dbid, rec_num, &VoxMemo_rec_id, NULL) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			FormDrawForm(FORM_VOXMEMO_REC);
			FormPopupForm(FORM_VOXMEMO_INFO);
			//		FormPopupForm(*(ObjectID*)buffer);
			EvtAppendEvt(EVT_INLAY_SELECT, 0, INLAY_EXIT, 0, NULL);
			break;
			
			
		case FORM_VOXMEMO_DIALOG_LOWMEM:
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_REC_TIME, text);
			qfree(text);			
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_REC_DATE, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MDB_APP_SAVE, F_VoxMemo_rec_id, &text, &byte_read) != TRUE)
				return FALSE;
			VoxMemo_rec_id = *(RecordID*)text;
			qfree(text);		
			if (DataRecIDtoNum(VoxMemo_dbid, VoxMemo_rec_id, &rec_num) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			if (DataOpenRecord(VoxMemo_dbid, rec_num, &VoxMemo_rec_id, NULL) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			FormDrawForm(FORM_VOXMEMO_REC);
			FormPopupForm(*(ObjectID*)buffer);
			break;
			
			
			
			
		case FORM_VOXMEMO_PLAY:
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_MemoNumString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_NUM, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_TIME, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_DATE, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_LTimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_POSTIME, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_RTimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_TTIME, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_INFO, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MDB_APP_SAVE, F_VoxMemo_rec_id, &text, &byte_read) != TRUE)
				return FALSE;
			VoxMemo_rec_id = *(RecordID*)text;
			qfree(text);		
			if (DataRecIDtoNum(VoxMemo_dbid, VoxMemo_rec_id, &rec_num) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			if (DataOpenRecord(VoxMemo_dbid, rec_num, &VoxMemo_rec_id, NULL) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			//		FormPopupForm(*(ObjectID*)buffer);
			
			DisplayAction = DISPLAY_PLAY;
			VoxMemoRecordToList(ItemNum, &top_item_num);
			
			/* reset scrollbar & timer display*/
			VoxMemoPlayReset();
			
			VoxMemoOpenRecord(ItemNum);
			TmrLabel = 0;
			TmrPauseLabel = 0;
			FormPopupForm(FORM_VOXMEMO_PLAY);
			break;
			
		case FORM_VOXMEMO_DIALOG_ERASE:
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_MemoNumString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_NUM, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_TIME, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_DATE, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_LTimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_POSTIME, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_RTimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_TTIME, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_INFO, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MDB_APP_SAVE, F_VoxMemo_rec_id, &text, &byte_read) != TRUE)
				return FALSE;
			VoxMemo_rec_id = *(RecordID*)text;
			qfree(text);		
			if (DataRecIDtoNum(VoxMemo_dbid, VoxMemo_rec_id, &rec_num) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			if (DataOpenRecord(VoxMemo_dbid, rec_num, &VoxMemo_rec_id, NULL) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			FormPopupForm(FORM_VOXMEMO_PLAY);
			FormPopupForm(*(ObjectID*)buffer);
			break;
			
		case FORM_VOXMEMO_DIALOG_RECABORT:
			FormPopupForm(FORM_VOXMEMO_LIST);
			FormPopupForm(*(ObjectID*)buffer);
			break;
			
		case FORM_VOXMEMO_DIALOG_EDTITLE:
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_MemoNumString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_NUM, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_TimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_TIME, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_DateString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_DATE, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_LTimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_POSTIME, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_RTimeString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_TTIME, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoString, &text, &byte_read) != TRUE)
				return FALSE;
			StringSetText(STRING_VOXMEMO_PLAY_INFO, text);
			qfree(text);	
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MDB_APP_SAVE, F_VoxMemo_rec_id, &text, &byte_read) != TRUE)
				return FALSE;
			VoxMemo_rec_id = *(RecordID*)text;
			qfree(text);		
			if (DataRecIDtoNum(VoxMemo_dbid, VoxMemo_rec_id, &rec_num) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			if (DataOpenRecord(VoxMemo_dbid, rec_num, &VoxMemo_rec_id, NULL) != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				qfree(buffer);
				return TRUE;
			}
			
			FormPopupForm(FORM_VOXMEMO_PLAY);
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoString, &text, &byte_read) != TRUE)
				return FALSE;											
			if (DataGetField(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, F_InfoCharPos, &num_char, &byte_read) != TRUE)
				return FALSE;
			//				TextboxSetText(TEXTBOX_VOXMEMO_DIALOG_EDTITLE, text);
			qfree(text);	
			qfree(num_char);				
			FormPopupForm(*(ObjectID*)buffer);
			
			
		default:
			FormPopupForm(*(ObjectID*)buffer);
			break;
		}
		
		//		FormPopupForm(*(ObjectID*)buffer);
		qfree(buffer);
	}	
	
	return TRUE;
	
}



/********************************************************
* Function:	VoxMemoAppLaunch
* Purpose: 	This function is called to launch the 
VoxMemo application
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN VoxMemoAppLaunch(WORD cmd, void *cmd_ptr)
{
	
	RTM				modi_date;
	UBYTE			cat;
	UWORD			rec_size, rec_num;
	Attribute		secret, lock;
	UWORD			num_rec, count, byte_read;
	RecordID		rec_id;
	SHORT			top_item_num;
	BYTE			*buffer, prepare_string[31];
	BOOLEAN			ctrl_value;
	
	if (cmd == LAUNCH_CMD_GOTO_REC && DataRecordInfo(((GotoRec*)cmd_ptr)->dbid, ((GotoRec*)cmd_ptr)->rec_id, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		if (((GotoRec*)cmd_ptr)->find_string != NULL)
			pfree(((GotoRec*)cmd_ptr)->find_string);
		pfree(cmd_ptr); 
		cmd = LAUNCH_CMD_NORMAL_LAUNCH;
	}		
	
	switch(cmd)
	{
	case LAUNCH_CMD_NORMAL_LAUNCH:
		UIApplicationInit();
		if (DataFindDB(VOXDB, &VoxMemo_dbid) != TRUE)
			DataNewDB(VOXDB, 0, VOXAPP, &VoxMemo_dbid);
		DataOpenDB(VoxMemo_dbid, F_TIME_DATE, OPEN_RW);		
		
		if (DataRecordInfo(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, &rec_size, &cat,
			&secret, &lock, &modi_date) != TRUE)
			VoxMemoAppRestore(TRUE);
		else
			VoxMemoAppRestore(FALSE);
		
		EventLoop();
		VoxMemoAppSave();
		UIDeleteAllAppObjects();		
		return TRUE;
		
		
	case LAUNCH_CMD_FIND:
		app_id = SysGetActiveAppID();
		if (DataFindDB(VOXDB, &VoxMemo_dbid) != TRUE)
			return TRUE;
		if (DataOpenDB(VoxMemo_dbid, F_TIME_DATE, OPEN_RW) != TRUE)
			return TRUE;
		if (DataTotalRecord(VoxMemo_dbid, &num_rec) != TRUE)
			return TRUE;
		for (count = 0; count < num_rec; count++)
		{
			
			if (DataOpenRecord(VoxMemo_dbid, count, &rec_id, NULL) != TRUE)
				return FALSE;
			if (DataGetField(VoxMemo_dbid, rec_id, F_INFO, &buffer, &byte_read) != TRUE)
				return FALSE;
			if (GlobalFindSearchText((BYTE*)cmd_ptr, buffer) >= 0)
			{
				VoxMemoPrepareFindText(VoxMemo_dbid, rec_id, count+1, buffer, prepare_string);
				GlobalFindAddItem(app_id, VoxMemo_dbid, rec_id, (USHORT)count, prepare_string, FALSE);
			}
			DataCloseRecord(VoxMemo_dbid, rec_id);
			qfree(buffer);
		}
		pfree(cmd_ptr);
		DataRecIDtoNum(VoxMemo_dbid, VoxMemo_rec_id, &rec_num);
		DataOpenRecord(VoxMemo_dbid, rec_num, &VoxMemo_rec_id, NULL);
		return TRUE;
		
		
	case LAUNCH_CMD_VOXMEMO_LAUNCH:
		UIApplicationInit();
		FormInitAllFormObjects(FORM_VOXMEMO_LIST);
		FormInitAllFormObjects(FORM_VOXMEMO_REC);
		FormInitAllFormObjects(FORM_VOXMEMO_INFO);
		FormInitAllFormObjects(FORM_VOXMEMO_PLAY);
		FormInitAllFormObjects(FORM_VOXMEMO_DIALOG_EDTITLE);
		if (DataFindDB(VOXDB, &VoxMemo_dbid) != TRUE)
			DataNewDB(VOXDB, 0, VOXAPP, &VoxMemo_dbid);
		DataOpenDB(VoxMemo_dbid, F_TIME_DATE, OPEN_RW);		
		
		if (DataRecordInfo(VoxMemo_dbid, VOXMEMO_MAIN_APP_SAVE, &rec_size, &cat,
			&secret, &lock, &modi_date) != TRUE)
			VoxMemoDatabaseInit(TRUE);
		else
			VoxMemoDatabaseInit(FALSE);
		VoxMemoInitMainGlobal(TRUE);
		VoxMemoInitMDBGlobal(TRUE);
		VoxMemoVolSetScrollbar();
		
		switch(*(WORD*)cmd_ptr)
		{
			//case (IO_SOUND_RECORD | IO_SOUND_PLAY):
		case IO_SOUND_RECORD:
			VoxMemoRecReset();
			if (VoxMemoTime2 < 3)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				FormPopupForm(FORM_VOXMEMO_DIALOG_RECABORT);
				break;
			}
			if (VoxMemoNewRecord() != TRUE)
			{
				FormPopupForm(FORM_VOXMEMO_LIST);
				FormPopupForm(FORM_VOXMEMO_DIALOG_RECABORT);
				break;
			}
			TmrLabel = 0;
			TmrPauseLabel = 0;
			FormPopupForm(FORM_VOXMEMO_REC);
			HardKeyOff = 0;
			EvtAppendEvt(EVT_CONTROL_SELECT, CONTROL_VOXMEMO_REC_REC, 0, 0, NULL);        
			break;
			
     			case IO_SOUND_PLAY:
					FormInitAllFormObjects(FORM_VOXMEMO_DIALOG_EDTITLE);
					
					if (DataTotalRecord(VoxMemo_dbid, &num_rec) != TRUE)
					{
						FormPopupForm(FORM_VOXMEMO_LIST);
						EventLoop();
						VoxMemoAppSave();
						UIDeleteAllAppObjects();		
						return FALSE;
					}
					if (num_rec < 1)
					{
						FormPopupForm(FORM_VOXMEMO_LIST);
						EventLoop();
						VoxMemoAppSave();
						UIDeleteAllAppObjects();		
						return FALSE;
					}
					VoxMemoRecordToList(ItemNum, &top_item_num);
					if (!VoxMemoOpenRecord(0))
					{
						FormPopupForm(FORM_VOXMEMO_LIST);
						EventLoop();
						VoxMemoAppSave();
						UIDeleteAllAppObjects();		
						return TRUE;			
					}						
					TmrLabel = 0;
					TmrPauseLabel = 0;
					FormPopupForm(FORM_VOXMEMO_PLAY);
					
					HardKeyOff = 0;
					FormGetControlValue(CONTROL_VOXMEMO_PLAY_PLAY, &ctrl_value);
					if (!ctrl_value)
						FormSetControlGroupSelection(FORM_VOXMEMO_PLAY, CONTROL_VOXMEMO_PLAY_PLAY);
					EvtAppendEvt(EVT_CONTROL_SELECT, CONTROL_VOXMEMO_PLAY_PLAY, 0, 0, NULL);				
					break;
					
				default:
					return FALSE;
		}
		EventLoop();
		VoxMemoAppSave();
		UIDeleteAllAppObjects();
		return TRUE;
		
		
		case LAUNCH_CMD_GOTO_REC:
			UIApplicationInit();
			FormInitAllFormObjects(FORM_VOXMEMO_LIST);
			FormInitAllFormObjects(FORM_VOXMEMO_REC);
			FormInitAllFormObjects(FORM_VOXMEMO_INFO);
			FormInitAllFormObjects(FORM_VOXMEMO_PLAY);
			FormInitAllFormObjects(FORM_VOXMEMO_DIALOG_EDTITLE);
			VoxMemoInitMainGlobal(TRUE);
			VoxMemoInitMDBGlobal(TRUE);
			ItemNum = (SHORT)(((GotoRec*)cmd_ptr)->field_num);
			if (((GotoRec*)cmd_ptr)->find_string != NULL)
				pfree(((GotoRec*)cmd_ptr)->find_string);
			pfree(cmd_ptr);
			if (!DataFindDB(VOXDB, &VoxMemo_dbid))
				return FALSE;
			if (DataOpenDB(VoxMemo_dbid, F_TIME_DATE, OPEN_RW) != TRUE)
				return FALSE;
			if (!VoxMemoVolSetScrollbar())
				return FALSE;
			
			FormPopupForm(FORM_VOXMEMO_LIST);
			EvtAppendEvt(EVT_LIST_SELECT, (WORD)ItemNum, 0, 0, NULL);
			EventLoop();
			VoxMemoAppSave();
			UIDeleteAllAppObjects();
			return TRUE;
			
		case LAUNCH_CMD_ALARM_HIT:
			pfree(cmd_ptr);
			return TRUE;
			
		default:
			return FALSE;
	}
	return FALSE;
}
