/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   voxmscro.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "voxmemo.h"
#include "voxmdef.h"
#include "sysetup.h"

/********************************************************
* Function:	VoxMemoListSetScrollbar
* Purpose: 	This function is called in order to set the values for a scrollbar		
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE				scrollbar is erased
*				FALSE				scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN VoxMemoListSetScrollbar(void)
{
	USHORT total_num_item;
	USHORT max_num_item_display;
	USHORT top_item_num;
	USHORT current_num_item_display;
	
	WORD max_value, min_value, pagesize, total_num_lines;
	
	ListRecalculateMaxNumItemsDisplay(LIST_VOXMEMO_LIST_NUM);
	ListGetMaxNumItemsDisplay(LIST_VOXMEMO_LIST_NUM, &max_num_item_display);
	ListGetTotalItems(LIST_VOXMEMO_LIST_NUM, &total_num_item);
	ListGetTopItemNum(LIST_VOXMEMO_LIST_NUM, &top_item_num);
	ListGetNumItemsDisplay (LIST_VOXMEMO_LIST_NUM, &current_num_item_display);
	
	total_num_lines = total_num_item;
	pagesize = max_num_item_display-1;
	min_value = 0;
	max_value = total_num_lines - pagesize - 1;	
	
	if (total_num_item > max_num_item_display)
		ScrollbarSetScrollbarVisible(SCROLLBAR_VOXMEMO_LIST,TRUE);
	else
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_VOXMEMO_LIST,FALSE);
		ScrollbarEraseScrollbar(SCROLLBAR_VOXMEMO_LIST);
		return FALSE;
	}
	
	if (top_item_num > (total_num_item - max_num_item_display))
		ScrollbarSetScrollbar(SCROLLBAR_VOXMEMO_LIST, max_value, max_value, min_value, pagesize, total_num_lines);
	else
		ScrollbarSetScrollbar(SCROLLBAR_VOXMEMO_LIST, top_item_num, max_value, min_value, pagesize, total_num_lines);
	
	ScrollbarSetScrollbarDrawPagesize(SCROLLBAR_VOXMEMO_LIST, pagesize+1);
	//	ScrollbarDrawScrollbar(SCROLLBAR_VOXMEMO_LIST);
	return TRUE;
	
}

/********************************************************
* Function:	VoxMemoScrollbarSetList
* Purpose: 	This function is called to set voxmemo list
*				when the scrollbar is moved.
* Scope:		application
* Input:		item_num
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void VoxMemoScrollbarSetList(USHORT item_num)
{
	WORD max, min, value, pagesize, scroll_total_lines;
	
	ScrollbarGetScrollbar(SCROLLBAR_VOXMEMO_LIST, &value, &max, &min, &pagesize, &scroll_total_lines);
	
	ScrollbarSetScrollbar(SCROLLBAR_VOXMEMO_LIST, (WORD)item_num, max, min, pagesize, scroll_total_lines);
	ListSetTopItemNum(LIST_VOXMEMO_LIST_NUM, item_num);
	ListSetTopItemNum(LIST_VOXMEMO_LIST_TIME, item_num);
	ListSetTopItemNum(LIST_VOXMEMO_LIST_DATE, item_num);
	ListSetTopItemNum(LIST_VOXMEMO_LIST_INFO, item_num);
	
	//	ListDrawList(LIST_VOXMEMO_LIST_NUM);
	//	ListDrawList(LIST_VOXMEMO_LIST_TIME);
	//	ListDrawList(LIST_VOXMEMO_LIST_DATE);
	//	ListDrawList(LIST_VOXMEMO_LIST_INFO);
	//	ScrollbarDrawScrollbar(SCROLLBAR_VOXMEMO_LIST);		
	
	return;
}

#ifdef SSTIME
/********************************************************
* Function:	VoxMemoScrollbarSetTime
* Purpose: 	This function is called to set voxmemo start position
*				when the scrollbar is moved.
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void VoxMemoScrollbarSetTime(EvtType *Event)
{
	WORD max,min,value,pagesize;
	WORD scroll_total_lines;
	
	ScrollbarGetScrollbar(SCROLLBAR_VOXMEMO_PLAY_TIME, &value, &max, &min, &pagesize, &scroll_total_lines);
	
	//	ScrollbarSetScrollbar(SCROLLBAR_VOXMEMO_PLAY_TIME, Event->para2, max, min, pagesize, scroll_total_lines);
	//	ScrollbarDrawScrollbar(SCROLLBAR_VOXMEMO_PLAY_TIME);		
	
	return;
}
#endif

/********************************************************
* Function:	VoxMemoScrollbarSetVol
* Purpose: 	This function is called to set voxmemo volumn
*				when the scrollbar is moved.
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		TRUE				Success
FALSE				Otherwise
* Comment: 	None
*********************************************************/
BOOLEAN VoxMemoScrollbarSetVol(EvtType *Event)
{
	WORD	max, min, value, pagesize, scroll_total_lines;
	
	ScrollbarGetScrollbar(SCROLLBAR_VOXMEMO_PLAY_VOL, &value, &max, &min, &pagesize, &scroll_total_lines);
	
	ScrollbarSetScrollbar(SCROLLBAR_VOXMEMO_PLAY_VOL, Event->para2, max, min, pagesize, scroll_total_lines);
	if (!SySetupScrollbarSetVolSettings((USHORT)min, (USHORT)max, (USHORT)Event->para2))
		return FALSE;
	
	ScrollbarDrawScrollbar(SCROLLBAR_VOXMEMO_PLAY_VOL);		
	
	return TRUE;
}

/********************************************************
* Function:	VoxMemoVolSetScrollbar
* Purpose: 	This function is called to restore scrollbar settings
*				form system setup
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		TRUE				Success
FALSE				Otherwise
* Comment: 	None
*********************************************************/
BOOLEAN VoxMemoVolSetScrollbar(void)
{
	WORD	max, min, value, pagesize, scroll_total_lines;
	SoundSettings	sound;
	
	if (!SySetupGetSoundSettings(&sound))
		return FALSE;
	
	ScrollbarGetScrollbar(SCROLLBAR_VOXMEMO_PLAY_VOL, &value, &max, &min, &pagesize, &scroll_total_lines);
	if (!SySetupGetSoundSettings(&sound))
		return FALSE;
	
	ScrollbarSetScrollbar(SCROLLBAR_VOXMEMO_PLAY_VOL, (WORD)(sound.vol_curr), (WORD)(sound.vol_max), (WORD)(sound.vol_min), pagesize, scroll_total_lines);
	//	ScrollbarDrawScrollbar(SCROLLBAR_VOXMEMO_PLAY_VOL);		
	
	return TRUE;
}
