/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Henry Fok, Kenng Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   main() of application
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "system.h"
#include "system.h"
#include "app.h"
#include "alarmgr.h"

//extern UWORD _fdata, etext, _fbss, ebss;
extern UBYTE res_data[];

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */

void EventLoop();
void MMUInit();
void KernelInit();
void ResInit();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);

BOOLEAN (*FormDispatchEvent)(EvtType *Event);
BOOLEAN AlarmgrLowBattery(EvtType *Event);

extern REGISTRY app_reg[];

void AlarmAppInit();
void AlarmAppClassifyHit();
void AlarmAppShowList();
void AlarmCreateVirTable();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);
AppID app_id;
extern UWORD *sys_page, *app_page;
extern REGISTRY app_reg[];
extern UBYTE resdata[8903];

#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif


/* ==================================================================== */
/* ========================= Global Defines =========================== */
/* ==================================================================== */

/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
/********************************************************
 * Function:	ApplicationHandleEvent
 * Purpose: 	This function is used to load the specific data of
				form and set event handler of the form
 * Scope:		application/internal
 * Input:		Event		received event
 * Output:		None
 * Return:		TRUE if handled
				FALSE if not handled
 * Comment: 	None
 *********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
		{
			FormInitForm(form_id);
		}
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		switch (form_id)
		{
		case FORM_ALARMAPP: FormSetEventHandler(FORM_ALARMAPP, (void**)&FormDispatchEvent, (void*) AlarmAppMain);
			break;
		case FORM_PLAY_VOICE: FormSetEventHandler(FORM_PLAY_VOICE, (void**)&FormDispatchEvent, (void*) AlarmPlayVoice);
			break;
		case FORM_ALARM_VOICE_LOW_BATTERY: FormSetEventHandler(FORM_ALARM_VOICE_LOW_BATTERY, (void**)&FormDispatchEvent, (void*) AlarmgrLowBattery);
			break;
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	return FALSE;
}
/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EventLoop(void)
{
	EvtType event;
	do
	{
		EvtGetEvent (&event);
		if (!SystemHandleEvent(&event))
			if (!MenuHandleEvent(&event))
				if (!ApplicationHandleEvent(&event))
					FormDispatchEvent(&event);
				
	}
#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
	while (event.eventType != EVT_APP_STOP);
#endif
}
/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void AlarmAppLaunch(WORD cmd, void* cmd_ptr);

void LoadRes();

static short x;
#ifdef PC_SIM
void main()
#endif
#ifdef PR31700
void initialize_pen();
__main(WORD cmd, void *cmd_ptr)
#endif
{
#ifdef DEBUG
    printf("\nStart Alarm App");
#endif
	
    if(!AlarmHitCount())  /* no alarm in queue, show not launch alarmgr */
    {
        AppID app_id;
#ifdef DEBUG
        printf("\nNo event in alarm queue, launch mainmenu ");
#endif
		
        SysGetAppID(MAINMENU, &app_id);
        EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
    }
    else
    {
#ifdef DEBUG
		printf("\nAlarm queue not empty, show alarmgr");
#endif
		AlarmAppLaunch(cmd, (void*)cmd_ptr);
    }
	
#ifdef DEBUG
    printf("\nStop Alarm App");
#endif
}
