/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   ann.c
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              
#include "stdafx.h"
#include "uidef.h"
#include "uifunc.h"
#include "Ann.h"

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
ObjectID	pressed_object1;
ObjectID	pressed_object2, return_to;
BOOLEAN		select_goto, pen_down, valid_input, view_records, goto_highlight, result_check;
BYTE		alarm_date, sch_date, week_click, show_line, table_font, alarm_set_by;
BYTE		restart_form, date_entry_method;
WORD		field_top_line, field_insert_pt_pos;
ObjectID	low_memory_form_id;
BOOLEAN		entry_low_memory, entry_old_edit, last_wday_on;
SHORT		backup_wset_wday;
USHORT		backup_year;


/*****************************************************************
***************** Application Event Handle Function **************
*****************************************************************/
/******************************************************************
* Function:	SchedulerAnnList
* Purpose: 	This function is the event handler for the 
*			ANN LIST of the Anniversaries application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerAnnList(EvtType* Event)
{
	static	ObjectID old_column0_id, old_column1_id, old_column2_id;
	static	USHORT	old_row_num, highlight_row;
	static	BOOLEAN	not_table_clear = FALSE;
	ObjectID	cell_ui_id, control_id;
	RecordID	rec_id;
	BYTE		object_type, text_color, text_bg_color;
	BYTE		*control_text;
	USHORT		row_number, col_number, cell_number;
	Table		*table_addr;
	String		*string1_addr, *string2_addr, *string3_addr, *table_string;
   	AppID           appid;
	RTM		time;
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_NEW || Event->para1 == SLETTER_NEW)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ANN_NEW_RECORD;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_GOTO || Event->para1 == SLETTER_GOTO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ANN_GOTO;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_CATE || Event->para1 == SLETTER_CATE)
			{
#ifdef	PR31700
				ControlPopupPopupTrigger(POPUP_TRIGGER_CATEGORIES);
#endif
				return	FALSE;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		select_goto = FALSE;
		app_status.edit_mode = ANN_LIST;
		restart_form = RESTART_ANNIVER;
		
		ControlPopupSetSelectedItem(POPUP_TRIGGER_CATEGORIES, 4);
		FormDrawForm(FORM_ANN_LIST);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	PUSHBUTTON_WEEK_SETTINGS_Y1:
			ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y1, &control_text);
			app_status.selected_year = (USHORT)atol((const char *)control_text);
			view_records = TRUE;
			AnnRecordToTable(ann_dbid);
			TableDrawTable(TABLE_ANN_LIST);
			ScrollbarDrawScrollbar(SCROLLBAR_ANN_LIST);
			return TRUE;
			
		case	PUSHBUTTON_WEEK_SETTINGS_Y2:
			ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y2, &control_text);
			app_status.selected_year = (USHORT)atol((const char *)control_text);
			view_records = TRUE;
			AnnRecordToTable(ann_dbid);
			TableDrawTable(TABLE_ANN_LIST);
			ScrollbarDrawScrollbar(SCROLLBAR_ANN_LIST);
			return TRUE;
			
		case	PUSHBUTTON_WEEK_SETTINGS_Y3:					
			ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y3, &control_text);
			app_status.selected_year = (USHORT)atol((const char *)control_text);
			view_records = TRUE;
			AnnRecordToTable(ann_dbid);
			TableDrawTable(TABLE_ANN_LIST);
			ScrollbarDrawScrollbar(SCROLLBAR_ANN_LIST);
			return TRUE;
			
		case	PUSHBUTTON_WEEK_SETTINGS_Y4:
			ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y4, &control_text);
			app_status.selected_year = (USHORT)atol((const char *)control_text);
			view_records = TRUE;
			AnnRecordToTable(ann_dbid);
			TableDrawTable(TABLE_ANN_LIST);
			ScrollbarDrawScrollbar(SCROLLBAR_ANN_LIST);
			return TRUE;
			
		case	PUSHBUTTON_WEEK_SETTINGS_Y5:
			ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y5, &control_text);
			app_status.selected_year = (USHORT)atol((const char *)control_text);
			view_records = TRUE;
			AnnRecordToTable(ann_dbid);
			TableDrawTable(TABLE_ANN_LIST);
			ScrollbarDrawScrollbar(SCROLLBAR_ANN_LIST);
			///							FormPopupForm(FORM_ANN_LIST);
			return TRUE;
			
		case	BUTTON_ANN_NEW_RECORD:
#ifdef	PR31700
			if (MemoryCheckMemLow() || (entry_low_memory && entry_old_edit))
			{
#ifdef DEBUG
				printf("\n----> NEW RECORD - Low Memory <----");
#endif												
				low_memory_form_id = FORM_ANN_LIST;
				FormPopupForm(FORM_SYSTEM_LOW_MEM);	
				return TRUE;
			}											
#endif												
			view_records = FALSE;
			AnnInitFieldBuffer();
			/* Setup New Screen */
			field_top_line = 0;
			field_insert_pt_pos = 0;
			AnnNewSetUpVariable();
			FormPopupForm(FORM_ANN_NEW);
			return TRUE;
			
		case	BUTTON_ANN_GOTO:
			RtcGetTime(&time);
			app_status.selected_year = time.year;							
			app_status.selected_month = time.mon + 1;
			app_status.selected_day = time.mday;
			
			view_records = FALSE;
			AnnSetStartOfWeekScreen();
			AnnYearSettingUpdate((USHORT *)&time.year, FORM_ANN_DATE_SETTINGS);
			AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month, app_status.selected_day);
			
			select_goto = TRUE;
			pressed_object1 = FORM_ANN_LIST;
			FormPopupForm(FORM_ANN_DATE_SETTINGS);
			return TRUE;
			
		default:
			return FALSE;
		}
		return TRUE;
		
		case	EVT_CONTROL_POPUP_SELECT:
#ifdef PR31700
			AnnLaunchApplication();
#endif
			return TRUE;
			
		case	EVT_BITMAP_SELECT:
			switch (Event->eventID)
			{
			case	BITMAP_WEEK_SETTINGS_N1:
				//							app_status.selected_year -= 5;
				view_records = TRUE;
				if (AnnYearShiftUpdate(BACKWARD))
				{
					ControlGetPushedPushButton(FORM_ANN_DATE_SETTINGS, 0, &control_id);
					ControlGetLabel(control_id, &control_text);
					app_status.selected_year = (USHORT)atol((const char *)control_text);
					AnnRecordToTable(ann_dbid);
					
					TableDrawTable(TABLE_ANN_LIST);
					ScrollbarDrawScrollbar(SCROLLBAR_ANN_LIST);
				}
				///							FormPopupForm(FORM_ANN_LIST);
				return TRUE;
				
			case	BITMAP_WEEK_SETTINGS_N2:
				//							app_status.selected_year += 5;
				view_records = TRUE;
				if (AnnYearShiftUpdate(FORWARD))
				{
					ControlGetPushedPushButton(FORM_ANN_DATE_SETTINGS, 0, &control_id);
					ControlGetLabel(control_id, &control_text);
					app_status.selected_year = (USHORT)atol((const char *)control_text);
					AnnRecordToTable(ann_dbid);
					TableDrawTable(TABLE_ANN_LIST);
					ScrollbarDrawScrollbar(SCROLLBAR_ANN_LIST);
				}
				///							FormPopupForm(FORM_ANN_LIST);
				return TRUE;
				
			default:
				return FALSE;
			}
			return TRUE;
			
			case	EVT_SCROLLBAR_REPEAT:
			case	EVT_SCROLLBAR_SELECT:
				AnnScrollbarSetTable(Event);
				return TRUE;
#ifdef PR31700
			case 	EVT_IO_KEY_CTRL:
				if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
				{
					if (Event->para2 == IO_UP_ARROW)
						ScrollbarHardButtonSetScrollbar(SCROLLBAR_ANN_LIST, SCROLLBAR_UP_ARROW);
					else if (Event->para2 == IO_DOWN_ARROW)
						ScrollbarHardButtonSetScrollbar(SCROLLBAR_ANN_LIST, SCROLLBAR_DOWN_ARROW);
					return TRUE;
				}
				return FALSE;
#endif
			case	PEN_EVENT:
				if (AnnGetClickedCell(TABLE_ANN_LIST,(SHORT)(Event->para1),(SHORT)(Event->para2),
					&row_number,&col_number,&cell_number) == TRUE)
				{
					FormGetObjectPointer(TABLE_ANN_LIST, &object_type, (void **)&table_addr);
					cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell_number]))->table_item_ui_id;
					not_table_clear = FALSE;
					
					if ((cell_ui_id >= STRING_ANN_CONTENT_N1 && cell_ui_id < STRING_ANN_CONTENT_N1 + 11) ||
						(cell_ui_id >= STRING_ANN_LIST_MONTH && cell_ui_id < STRING_ANN_LIST_MONTH + 22))
					{
						if (col_number == ANN_COLUMN_0 )
						{
							FormGetObjectPointer(cell_ui_id, &object_type, (void **)&string1_addr);
							FormGetObjectPointer(cell_ui_id+11, &object_type, (void **)&string2_addr);
							FormGetObjectPointer(cell_ui_id-73, &object_type, (void **)&string3_addr);
						}
						else if (col_number == ANN_COLUMN_1 )
						{
							FormGetObjectPointer(cell_ui_id-11, &object_type, (void **)&string1_addr);
							FormGetObjectPointer(cell_ui_id, &object_type, (void **)&string2_addr);
							FormGetObjectPointer(cell_ui_id-84, &object_type, (void **)&string3_addr);
						}
						else
						{
							FormGetObjectPointer(cell_ui_id+73, &object_type, (void **)&string1_addr);
							FormGetObjectPointer(cell_ui_id+84, &object_type, (void **)&string2_addr);
							FormGetObjectPointer(cell_ui_id, &object_type, (void **)&string3_addr);
						}
						
						if (Event->eventID == PEN_DOWN && object_type == STRING)
						{
							text_color = string1_addr->string_color;
							text_bg_color = string1_addr->string_bg_color;
							
							string1_addr->string_color = COLOR_WHITE;
							string1_addr->string_bg_color = COLOR_BLACK;
							string2_addr->string_color = COLOR_WHITE;
							string2_addr->string_bg_color = COLOR_BLACK;
							string3_addr->string_color = COLOR_WHITE;
							string3_addr->string_bg_color = COLOR_BLACK;
							
							StringDrawString(string1_addr->identification.ui_object_id);
							StringDrawString(string2_addr->identification.ui_object_id);
							StringDrawString(string3_addr->identification.ui_object_id);
							
							string1_addr->string_color = text_color;
							string1_addr->string_bg_color = text_bg_color;
							string2_addr->string_color = text_color;
							string2_addr->string_bg_color = text_bg_color;
							string3_addr->string_color = text_color;
							string3_addr->string_bg_color = text_bg_color;
							/* Clear the old highlight cell */
							if ((old_column0_id >= STRING_ANN_LIST_MONTH && old_column0_id < STRING_ANN_LIST_MONTH + 11) &&
								(old_row_num != row_number))
							{
								StringDrawString(old_column0_id);
								StringDrawString(old_column1_id);
								StringDrawString(old_column2_id);
							}
							old_column0_id = string1_addr->identification.ui_object_id;
							old_column1_id = string2_addr->identification.ui_object_id;
							old_column2_id = string3_addr->identification.ui_object_id;
							old_row_num = row_number;
							highlight_row = row_number;
							pen_down = TRUE;
						}					
						else if (Event->eventID == PEN_MOVE && old_row_num != row_number && pen_down == TRUE)
						{
							StringDrawString(old_column0_id);
							StringDrawString(old_column1_id);
							StringDrawString(old_column2_id);
							
							text_color = string1_addr->string_color;
							text_bg_color = string1_addr->string_bg_color;
							
							string1_addr->string_color = COLOR_WHITE;
							string1_addr->string_bg_color = COLOR_BLACK;
							string2_addr->string_color = COLOR_WHITE;
							string2_addr->string_bg_color = COLOR_BLACK;
							string3_addr->string_color = COLOR_WHITE;
							string3_addr->string_bg_color = COLOR_BLACK;
							
							old_column0_id = string1_addr->identification.ui_object_id;
							old_column1_id = string2_addr->identification.ui_object_id;
							old_column2_id = string3_addr->identification.ui_object_id;
							
							StringDrawString(old_column0_id);
							StringDrawString(old_column1_id);
							StringDrawString(old_column2_id);
							
							string1_addr->string_color = text_color;
							string1_addr->string_bg_color = text_bg_color;
							string2_addr->string_color = text_color;
							string2_addr->string_bg_color = text_bg_color;
							string3_addr->string_color = text_color;
							string3_addr->string_bg_color = text_bg_color;
							
							old_row_num = row_number;
							highlight_row = row_number;
						}					
						else if (Event->eventID == PEN_UP && pen_down == TRUE)
						{
							row_number += anniver_list.top_row_num;
							
							if (AnnDisplayGetRecordID(&anniver_list,row_number,&rec_id,&ann_dbid) == FALSE)
								return FALSE; /* Exit if clicked on empty row */
							app_status.rec_id = rec_id;
							view_records = FALSE;
							field_top_line = 0;
							field_insert_pt_pos = 0;
							AnnRecordToVariable();
							AnnViewingSetUpScreen();
							/* Disable the field object */
							show_line = FALSE;
							goto_highlight = FALSE;
							pen_down = FALSE;
#ifdef	PR31700
							SndPlaySndEffect(SNDRES5_BEEP);
#endif
							FormPopupForm(FORM_ANN_VIEWING);
							return TRUE;
						}
					}
					else
					{
						/* Clear the old highlight cell */
						if (old_column0_id >= STRING_ANN_LIST_MONTH && old_column0_id < STRING_ANN_LIST_MONTH + 11)
						{
							if (row_number == highlight_row)
							{
								StringDrawString(old_column0_id);
								StringDrawString(old_column1_id);
								StringDrawString(old_column2_id);
								highlight_row = -1;
							}
						}
					}
				}
				else
				{
					/* Clear the old highlight cell */
					if ((old_column0_id >= STRING_ANN_LIST_MONTH && old_column0_id < STRING_ANN_LIST_MONTH + 11) &&
						(anniver_list.total_num_rows != 0))
					{
						if (not_table_clear == FALSE)
						{
							StringDrawString(old_column0_id);
							StringDrawString(old_column1_id);
							StringDrawString(old_column2_id);
							not_table_clear = TRUE;
						}
					}
				}
				return TRUE;
				
        case	EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			{
				SysGetAppID(MAINMENU, &appid);
				EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
				EvtAppendEvt(EVT_APP_LAUNCH, appid, 0, 0, NULL);
			}
			return TRUE;
			
		case	EVT_MENU_SELECT_ITEM:
			FormGetObjectPointer(STRING_ANN_CONTENT_N1, &object_type, (void **)&table_string);
			if (table_string->text_font == SMALL_FONT)
				table_font = MEDIUM_FONT;
			else
				table_font = SMALL_FONT;
			
			AnnSetTableFont();
			AnnTableDisplayDraw(&anniver_list);
			AnnTableSetScrollbar();
			TableDrawTable(TABLE_ANN_LIST);
			return TRUE;
			
		default:
			return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerToDoViewing
* Purpose: 	This function is the event handler for the 
*			TO DO VIEWING screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerAnnViewing(EvtType* Event)
{
	Control	*ctl_addr;
	Field	*fld_addr;
	BYTE	object_type, original_font;
	USHORT	num_items, count;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_ALARM || Event->para1 == SLETTER_ALARM)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ANN_ALARM;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_DEL || Event->para1 == SLETTER_DEL)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ANN_DEL;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		app_status.edit_mode = ANN_VIEWING;
		restart_form = RESTART_ANN_VIEWING;
		
		FormGetObjectPointer(FIELD_ANN_VIEWING, &object_type, (void **)&fld_addr);
		
		if (show_line == FALSE)
		{
			fld_addr->field_attr.field_insert_pt_visible = FALSE;
			fld_addr->field_attr.field_enable = FALSE;
			fld_addr->field_back_line = NO_LINE;
			
			MenuGetNumOfItems(ANN_MENU, &num_items);
			
			for (count =0; count < num_items; count++)
				MenuDeleteItem(ANN_MENU, 0);
			
			FieldGetFont(FIELD_ANN_VIEWING, &original_font);
			
			if (original_font == SMALL_FONT)
				MenuInsertItem(ANN_MENU, 0, ANNLFONT);
			else
				MenuInsertItem(ANN_MENU, 0, ANNSFONT);
		}
		else
		{
			FormSetFormActiveObject(FORM_ANN_VIEWING, FIELD_ANN_VIEWING);
			fld_addr->field_attr.field_insert_pt_visible = TRUE;
			fld_addr->field_attr.field_enable = TRUE;
			fld_addr->field_attr.field_active = TRUE;
			fld_addr->field_back_line = GREY_LINE;
			
			MenuDeleteItem(ANN_MENU, 4);
			FieldGetFont(FIELD_ANN_VIEWING, &original_font);
			if (original_font == SMALL_FONT)
				MenuInsertItem(ANN_MENU, 4, ANNLFONT);
			else
				MenuInsertItem(ANN_MENU, 4, ANNSFONT);
		}
		/* Highlight the selection text */
		if (goto_highlight == FALSE)
		{
			fld_addr->field_attr.field_highlight = FALSE;
			fld_addr->field_highlight_length = 0;
		}
		FieldSetTopLineNum(FIELD_ANN_VIEWING, field_top_line);
		FieldSetInsertPointPositionByCharPos(FIELD_ANN_VIEWING, field_insert_pt_pos);
		AnnFindOutAlarmSetBy();
		AnnSetUpFieldScreen(FORM_ANN_VIEWING);
		AnnFieldSetScrollbar(FIELD_ANN_VIEWING, SCROLLBAR_ANN_VIEWING);
		FormDrawForm(FORM_ANN_VIEWING);
		return TRUE;
		
	case	EVT_KEYBOARD_STATUS:
		AnnSetUpFieldScreen(FORM_ANN_VIEWING);
		AnnEditSetField(FORM_ANN_VIEWING, FIELD_ANN_VIEWING);
		AnnFieldSetScrollbar(FIELD_ANN_VIEWING, SCROLLBAR_ANN_VIEWING);
		FieldGetTopLineNum(FIELD_ANN_VIEWING, &field_top_line);
		FieldEraseField(FIELD_ANN_VIEWING);
		FieldDrawField(FIELD_ANN_VIEWING);
		return TRUE;
		
	case	EVT_SCROLLBAR_REPEAT:
		if (show_line == TRUE)
		{
			FormSetFormActiveObject(FORM_ANN_VIEWING, FIELD_ANN_VIEWING);
			FormGetObjectPointer(FIELD_ANN_VIEWING, &object_type, (void **)&fld_addr);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
				FieldGetInsertPointPosition(FIELD_ANN_VIEWING, &field_insert_pt_pos);
		}
		AnnScrollbarSetField(FIELD_ANN_VIEWING, SCROLLBAR_ANN_VIEWING, Event);
		
		if (show_line == TRUE)
		{
			if (!fld_addr->field_attr.field_highlight)
				FieldSetInsertPointPositionByCharPos(FIELD_ANN_VIEWING, field_insert_pt_pos);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
			{
				if (!fld_addr->field_attr.field_highlight)
					FieldSetInsertPointOn(FIELD_ANN_VIEWING);
			}
			else
				FieldSetInsertPointOff(FIELD_ANN_VIEWING);
		}
		return TRUE;
		
	case	EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_ANN_VIEWING);
		return TRUE;
#ifdef PR31700
	case 	EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_ANN_VIEWING, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_ANN_VIEWING, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
#endif
	case	EVT_KEY:
		if (Event->eventID == SOFT_KEY)
		{
			FormGetObjectPointer(FIELD_ANN_VIEWING, &object_type, (void **)&fld_addr);
			AnnEditSetField(FORM_ANN_VIEWING, FIELD_ANN_VIEWING);
			AnnFieldSetScrollbar(FIELD_ANN_VIEWING, SCROLLBAR_ANN_VIEWING);
			if (fld_addr->field_attr.field_enable == TRUE && (fld_addr->field_attr.field_insert_pt_visible == TRUE ||
				fld_addr->field_attr.field_highlight == TRUE))
			{
#ifdef	PR31700
				if (MemoryCheckMemLow() || (entry_low_memory && entry_old_edit))
				{
#ifdef DEBUG
					printf("\n----> VIEW RECORD - Low Memory <----");
#endif																			
					low_memory_form_id = FORM_ANN_VIEWING;
					FormPopupForm(FORM_SYSTEM_LOW_MEM);	
					return TRUE;
				}											
#endif												
				FieldAddKeyInChar(FIELD_ANN_VIEWING,(BYTE)(Event->para1));
			}
			return TRUE;
		}
		return TRUE;
		
	case	EVT_FIELD_CHANGED:
		AnnFieldSetScrollbar(FIELD_ANN_VIEWING, SCROLLBAR_ANN_VIEWING);
		return TRUE;
		
	case	EVT_FIELD_MODIFIED:
		chk_status.field_change = TRUE;
		FieldGetTopLineNum(FIELD_ANN_VIEWING, &field_top_line);
		FieldGetInsertPointPosition(FIELD_ANN_VIEWING, &field_insert_pt_pos);
		return TRUE;
		
	case	PEN_EVENT:
		if (Event->eventID == PEN_DOWN)
		{
			FieldGetTopLineNum(FIELD_ANN_VIEWING, &field_top_line);
			FieldGetInsertPointPosition(FIELD_ANN_VIEWING, &field_insert_pt_pos);
			FormGetObjectPointer(FIELD_ANN_VIEWING, &object_type, (void **)&fld_addr);
			
			if ((Event->para1 >= fld_addr->bounds.xcoord && Event->para1 < fld_addr->bounds.xcoord + fld_addr->bounds.width &&
				Event->para2 >= fld_addr->bounds.ycoord && Event->para2 < fld_addr->bounds.ycoord + fld_addr->bounds.height) &&
				fld_addr->field_attr.field_enable == FALSE)
			{
				MenuDeleteItem(ANN_MENU, 0);
				MenuInsertItem(ANN_MENU, 0, ANNCOPY);
				MenuInsertItem(ANN_MENU, 1, ANNCUT);
				MenuInsertItem(ANN_MENU, 2, ANNPASTE);
				MenuInsertItem(ANN_MENU, 3, ANNUNDO);
				
				FieldGetFont(FIELD_ANN_VIEWING, &original_font);
				if (original_font == SMALL_FONT)
					MenuInsertItem(ANN_MENU, 4, ANNLFONT);
				else
					MenuInsertItem(ANN_MENU, 4, ANNSFONT);
				
				fld_addr->field_attr.field_insert_pt_visible = TRUE;
				fld_addr->field_attr.field_enable = TRUE;
				fld_addr->field_attr.field_active = TRUE;
				fld_addr->field_attr.field_highlight = FALSE;
				fld_addr->field_highlight_length = 0;
				fld_addr->field_back_line = GREY_LINE;
				
				show_line = TRUE;
				/* Set the  Insert Point Positino by pen's X &Y */
				FieldSetInsertPointPositionByXY(FIELD_ANN_VIEWING, (SHORT)Event->para1, (SHORT)Event->para2);
				FormSetFormActiveObject(FORM_ANN_VIEWING, FIELD_ANN_VIEWING);
				FormDrawForm(FORM_ANN_VIEWING);
			}
		}
		return TRUE;				
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	BUTTON_ANN_ALARM:
			pressed_object1 = FORM_ANN_VIEWING;
			AnnFieldToFieldBuffer();
			AnnAlarmSetUpScreen();
			FormPopupForm(FORM_ALARM_SETTINGS);
			return TRUE;
			
		case	BUTTON_ANN_DEL:
			FormPopupForm(FORM_ITEM_ERASE);
			return TRUE;
			
		case	BUTTON_ANN_VIEWING_DATE:
			pressed_object1 = FORM_ANN_VIEWING;
			AnnFieldToFieldBuffer();
			FormGetObjectPointer(CHECKBOX_YEARLY_SETTINGS, &object_type, (void **)&ctl_addr);
			
			if (app_status.yearly_repeat == TRUE)
				((ControlTemplateCheckBox *) ((ctl_addr->control_template)))->control_value = TRUE;
			else
				((ControlTemplateCheckBox *) ((ctl_addr->control_template)))->control_value = FALSE;
			
			FormPopupForm(FORM_YEARLY_SETTINGS);
			return	TRUE;
			
		default:
			return FALSE;
		}
		return	TRUE;
		
		
		case	EVT_MENU_SELECT_ITEM:
			MenuGetNumOfItems(ANN_MENU, &num_items);
			
			if (num_items == 1)
				AnnViewingSelectedLargeFontOnly();
			else
				AnnMenuSelectedAction((USHORT)(Event->para1));
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			switch (Event->para1)
			{
			case	INLAY_OK:
				AnnFieldToFieldBuffer();
				AnnFieldUpdateRecord();
				AnnChangeUpdateRecord();
				AnnSetTableFont();
				AnnRecordToTable(ann_dbid);
				/* Disable the field for next use */
				show_line = FALSE;
				FieldSetInsertPointOff(FIELD_ANN_VIEWING);
				FormPopupForm(FORM_ANN_LIST);
				return TRUE;
				
			case	INLAY_EXIT:
				AnnFieldToFieldBuffer();
				FieldSetInsertPointOff(FIELD_ANN_VIEWING);
				pressed_object1 = FORM_ANN_LIST;			
				pressed_object2 = FORM_ANN_VIEWING;
				
				if (AnnCheckAnyChange() == TRUE)
					FormPopupForm(FORM_SAVE_CHANGES);
				else
				{
					/* Disable the field for next use */
					show_line = FALSE;
					AnnSetTableFont();
					AnnRecordToTable(ann_dbid);
					FormPopupForm(FORM_ANN_LIST);
				}
				return TRUE;
				
			default:
				return FALSE;
			}
			return	TRUE;
			
			default:
				return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerAnnNew
* Purpose: 	This function is the event handler for the 
*			TO DO NEW edit screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerAnnNew(EvtType* Event)
{	
	Bitmap	*bmp_addr;
	Control	*ctl_addr;
	Field	*fld_addr;
	BYTE	object_type, original_font;
	USHORT	num_items;
	
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_ALARM || Event->para1 == SLETTER_ALARM)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ANN_ALARM;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		/* Set up the edit mode */
		app_status.edit_mode = ANN_NEW;
		restart_form = RESTART_ANN_NEW;
		show_line = TRUE;
		
		MenuGetNumOfItems(ANN_MENU, &num_items);
		if (num_items == 1)
		{
			MenuDeleteItem(ANN_MENU, 0);
			MenuInsertItem(ANN_MENU, 0, ANNCOPY);
			MenuInsertItem(ANN_MENU, 1, ANNCUT);
			MenuInsertItem(ANN_MENU, 2, ANNPASTE);
			MenuInsertItem(ANN_MENU, 3, ANNUNDO);
		}
		FieldGetFont(FIELD_ANN_NEW, &original_font);
		MenuDeleteItem(ANN_MENU, 4);
		if (original_font == SMALL_FONT)
			MenuInsertItem(ANN_MENU, 4, ANNLFONT);
		else
			MenuInsertItem(ANN_MENU, 4, ANNSFONT);
		
		FormSetFormActiveObject(FORM_ANN_NEW, FIELD_ANN_NEW);
		FieldSetTopLineNum(FIELD_ANN_NEW, field_top_line);
		FieldSetInsertPointOn(FIELD_ANN_NEW);
		FieldSetInsertPointPositionByCharPos(FIELD_ANN_NEW, field_insert_pt_pos);
		
		AnnFindOutAlarmSetBy();
		AnnSetUpFieldScreen(FORM_ANN_NEW);
		AnnFieldSetScrollbar(FIELD_ANN_NEW, SCROLLBAR_ANN_VIEWING);
		FormDrawForm(FORM_ANN_NEW);
		
		if (sch_date == NO_SCH_DATE)
		{
			FormGetObjectPointer(BITMAP_YEARLY_REPEAT_DIALOG_EXIT, &object_type, (void **)&bmp_addr);
			bmp_addr->bitmap_attr.bitmap_visible = FALSE;
			
			FormGetObjectPointer(CHECKBOX_YEARLY_SETTINGS, &object_type, (void **)&ctl_addr);
			((ControlTemplateCheckBox *) ((ctl_addr->control_template)))->control_value = TRUE;
			app_status.yearly_repeat = TRUE;
			
			pressed_object1 = FORM_ANN_NEW;
			FormPopupForm(FORM_YEARLY_SETTINGS);
		}
		return TRUE;
		
	case	EVT_KEYBOARD_STATUS:
		AnnSetUpFieldScreen(FORM_ANN_NEW);
		AnnEditSetField(FORM_ANN_NEW, FIELD_ANN_NEW);
		AnnFieldSetScrollbar(FIELD_ANN_NEW, SCROLLBAR_ANN_VIEWING);
		FieldGetTopLineNum(FIELD_ANN_NEW, &field_top_line);
		FieldEraseField(FIELD_ANN_NEW);
		FieldDrawField(FIELD_ANN_NEW);
		return TRUE;
		
	case	EVT_SCROLLBAR_REPEAT:
		if (show_line == TRUE)
		{
			FormSetFormActiveObject(FORM_ANN_NEW, FIELD_ANN_NEW);
			FormGetObjectPointer(FIELD_ANN_NEW, &object_type, (void **)&fld_addr);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
				FieldGetInsertPointPosition(FIELD_ANN_NEW, &field_insert_pt_pos);
		}
		AnnScrollbarSetField(FIELD_ANN_NEW, SCROLLBAR_ANN_VIEWING, Event);
		
		if (show_line == TRUE)
		{
			FieldSetInsertPointPositionByCharPos(FIELD_ANN_NEW, field_insert_pt_pos);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
				FieldSetInsertPointOn(FIELD_ANN_NEW);
			else
				FieldSetInsertPointOff(FIELD_ANN_NEW);
		}
		return TRUE;
		
		
	case	EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_ANN_VIEWING);
		return TRUE;
#ifdef PR31700
	case 	EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_ANN_VIEWING, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_ANN_VIEWING, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
#endif
	case	EVT_KEY:
		if (Event->eventID == SOFT_KEY)
		{
			// ===========================================================================
			// new at 30062000
			AnnSetUpFieldScreen(FORM_ANN_NEW);
			AnnEditSetField(FORM_ANN_NEW, FIELD_ANN_NEW);
			AnnFieldSetScrollbar(FIELD_ANN_NEW, SCROLLBAR_ANN_VIEWING);
			// ===========================================================================
			FieldAddKeyInChar(FIELD_ANN_NEW,(BYTE)(Event->para1));
			return TRUE;
		}
		
	case	EVT_FIELD_CHANGED:
		AnnFieldSetScrollbar(FIELD_ANN_NEW, SCROLLBAR_ANN_VIEWING);
		return TRUE;
		
	case	EVT_FIELD_MODIFIED:
		chk_status.field_change = TRUE;
		FieldGetTopLineNum(FIELD_ANN_NEW, &field_top_line);
		FieldGetInsertPointPosition(FIELD_ANN_NEW, &field_insert_pt_pos);
		return TRUE;
		
	case	PEN_EVENT:
		if (Event->eventID == PEN_DOWN)
		{
			FieldGetTopLineNum(FIELD_ANN_NEW, &field_top_line);
			FieldGetInsertPointPosition(FIELD_ANN_NEW, &field_insert_pt_pos);
		}
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	BUTTON_ANN_ALARM:
			pressed_object1 = FORM_ANN_NEW;
			AnnFieldToFieldBuffer();
			AnnAlarmSetUpScreen();
			FormPopupForm(FORM_ALARM_SETTINGS);
			return TRUE;
			
		case	BUTTON_ANN_NEW_DATE:
			pressed_object1 = FORM_ANN_NEW;
			chk_status.new_entry_hit = TRUE;
			AnnFieldToFieldBuffer();
			FormPopupForm(FORM_YEARLY_SETTINGS);
			return	TRUE;
			
		default:
			return FALSE;
		}
		return	TRUE;
		
		case	EVT_MENU_SELECT_ITEM:
			AnnMenuSelectedAction((USHORT)(Event->para1));
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			switch (Event->para1)
			{
			case	INLAY_OK:
#ifdef	PR31700
				if (chk_status.new_entry_hit == TRUE ||chk_status.field_change == TRUE)
#else
					chk_status.new_entry_hit = TRUE;
				
				if (chk_status.new_entry_hit == TRUE)
#endif
				{
					AnnFieldToFieldBuffer();
					AnnFieldUpdateRecord();
					AnnChangeUpdateRecord();
				}
				else
				{
					if(app_status.edit_mode == ANN_NEW)
					{
						if (ann_field_buffer[0] !=NULL)
						{
							strcpy(ann_field_buffer[0],(BYTE*)(""));
							AnnFieldBufferToField();
							AnnClearFieldBuffer();
						}
						DataCloseRecord(ann_dbid, app_status.rec_id);
						DataDeleteRecord(ann_dbid, app_status.rec_id, FALSE);
					}
				}
				AnnSetTableFont();
				AnnRecordToTable(ann_dbid);
				FieldSetInsertPointOff(FIELD_ANN_NEW);
				FormPopupForm(FORM_ANN_LIST);
				return TRUE;
				
			case	INLAY_EXIT:
				AnnFieldToFieldBuffer();
				pressed_object1 = FORM_ANN_LIST;
				pressed_object2 = FORM_ANN_NEW;
				FieldSetInsertPointOff(FIELD_ANN_NEW);
#ifdef	PR31700
				if (chk_status.new_entry_hit == TRUE ||chk_status.field_change == TRUE)
#else
					if (chk_status.new_entry_hit == TRUE)
#endif
					{
						// =============================================================================
						// modified at 30062000
						AnnSetUpFieldScreen(FORM_ANN_NEW);
						AnnEditSetField(FORM_ANN_NEW, FIELD_ANN_NEW);
						AnnFieldSetScrollbar(FIELD_ANN_NEW, SCROLLBAR_ANN_VIEWING);
						FormDrawForm(FORM_ANN_NEW);
						// =============================================================================
						FormPopupForm(FORM_SAVE_CHANGES);
					}
					else
					{
						if(app_status.edit_mode == ANN_NEW)
						{
							if (ann_field_buffer[0] !=NULL)
							{
								strcpy(ann_field_buffer[0],(BYTE*)(""));
								AnnFieldBufferToField();
								AnnClearFieldBuffer();
							}
							DataCloseRecord(ann_dbid, app_status.rec_id);
							DataDeleteRecord(ann_dbid, app_status.rec_id, FALSE);
						}
						AnnSetTableFont();
						AnnRecordToTable(ann_dbid);
						FormPopupForm(FORM_ANN_LIST);
					}
					return TRUE;
					
			default:
				return FALSE;
			}
			default:
				return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerAlarmSettings
* Purpose: 	This function is the event handler for the
*			ALARM SETTINGS screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerAlarmSettings(EvtType* Event)
{
	BOOLEAN	ctl_enable,	ctl_drawn, ctl_save_behind;
	BOOLEAN	ctl_active,	ctl_visible;
	BYTE	buffer[20];
	BYTE	*ptr = buffer;
	SHORT	temp_month;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_DATE || Event->para1 == SLETTER_DATE)
			{
#ifdef	PR31700
				ControlPopupPopupTrigger(POPUP_TRIGGER_ALARM_DATE);
#endif
				return	FALSE;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_ALARM_SETTINGS);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		chk_status.new_entry_hit = TRUE;
		
		switch (Event->eventID)
		{
		case	PUSHBUTTON_ALARM_ON:
			ControlGetAttributes(POPUP_TRIGGER_ALARM_DATE, &ctl_enable, &ctl_drawn, 
				&ctl_save_behind, &ctl_active, &ctl_visible);
			ControlSetAttributes(POPUP_TRIGGER_ALARM_DATE, TRUE, ctl_drawn, ctl_save_behind, 
				ctl_active, ctl_visible);
			app_status.alarm_status = TONE_ALARM;
			alarm_date = NO_ALARM_DATE;
			return TRUE;
			
		case	PUSHBUTTON_ALARM_OFF:
			/* Delete all the Alarm Manager's settings */
			AnnDelAnAlarm();
			
			ControlGetAttributes(POPUP_TRIGGER_ALARM_DATE, &ctl_enable, &ctl_drawn, 
				&ctl_save_behind, &ctl_active, &ctl_visible);
			ControlSetAttributes(POPUP_TRIGGER_ALARM_DATE, FALSE, ctl_drawn, ctl_save_behind, 
				ctl_active, ctl_visible);
			
			strcpy((char *)buffer, ANNSTR1);
			ControlSetLabel(POPUP_TRIGGER_ALARM_DATE,buffer);
			ControlDrawControl(POPUP_TRIGGER_ALARM_DATE);
			app_status.alarm_year = 0;
			app_status.alarm_month = 0;
			app_status.alarm_day = 0;
			app_status.alarm_status = NO_ALARM;
			alarm_date = NO_ALARM_DATE;
			return TRUE;
			
		default:
			return FALSE;
		}
		
		case	EVT_CONTROL_POPUP_SELECT:
			if (Event->para1 == ALARM_EXACT_DATE)
			{
				alarm_date = ALARM_EXACT_DATE;
				app_status.alarm_year = app_status.sch_year;
				app_status.alarm_month = app_status.sch_month;
				app_status.alarm_day = app_status.sch_day;
			}
			else
			{
				alarm_date = ALARM_BEFORE_EXACT_DATE;
				app_status.alarm_year = app_status.sch_year;
				app_status.alarm_month = app_status.sch_month;
				app_status.alarm_day = app_status.sch_day;
				temp_month = app_status.alarm_month - 1;
				/* Call Function to get one day before due date */
				RtcDaysShift((SHORT *)&app_status.alarm_year, &temp_month,(SHORT *)&app_status.alarm_day,-1);
				app_status.alarm_month = temp_month + 1;
			}
#ifdef	DEBUG
			printf("\n---> Alarm Setting Checking %d <---", alarm_date);
#endif				
			DataWriteField(ann_dbid,app_status.rec_id,10,1,&alarm_date);
			return TRUE;
			
		case	EVT_BITMAP_SELECT:
			if (app_status.alarm_status == TONE_ALARM && alarm_date != ALARM_EXACT_DATE && alarm_date != ALARM_BEFORE_EXACT_DATE)
				FormPopupForm(FORM_INVALID_ALARM_DATE);
			else
			{
				FormEraseForm(FORM_ALARM_SETTINGS);
				if (pressed_object1 == FORM_ANN_VIEWING)
					AnnViewingSetUpScreen();
				FormPopupForm(pressed_object1);
			}
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			switch (Event->para1)
			{
			case	INLAY_OK:
			case	INLAY_EXIT:
				if (app_status.alarm_status == TONE_ALARM && alarm_date != ALARM_EXACT_DATE && alarm_date != ALARM_BEFORE_EXACT_DATE)
					FormPopupForm(FORM_INVALID_ALARM_DATE);
				else
				{
					FormEraseForm(FORM_ALARM_SETTINGS);
					
					if (pressed_object1 == FORM_ANN_VIEWING)
						AnnViewingSetUpScreen();
					
					FormPopupForm(pressed_object1);
				}
				return TRUE;
				
			default:
				return FALSE;
			}
			return TRUE;
			
			default:
				return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerItemErase
* Purpose: 	This function is the event handler for the 
*			CONFIRM ITEM ERASE screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerItemErase(EvtType* Event)
{
	BOOLEAN control_value;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ITEM_ERASE_YES;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ITEM_ERASE_NO;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_ITEM_ERASE);
#ifdef	DEBUG
		FormGetControlValue(CHECKBOX_ITEM_ERASE, &control_value);
		printf("\n----> Check Box Value %d <----", control_value);
#endif
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_ITEM_ERASE_YES)
		{
			/* Check the check box's setting and delete the record */ 
			FormGetControlValue(CHECKBOX_ITEM_ERASE, &control_value);
			DataCloseRecord(ann_dbid, app_status.rec_id);
			DataDeleteRecord(ann_dbid, app_status.rec_id, control_value);
			AnnRecordToTable(ann_dbid);
			/* Del the coorersponding Alarm Event */
#ifdef	PR31700
			if (app_status.alarm_status != NO_ALARM)
				AnnDelAnAlarm(app_status.rec_id);
#endif
			FormPopupForm(FORM_ANN_LIST);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_ITEM_ERASE_NO)
		{
			FormPopupForm(FORM_ANN_VIEWING);
			return TRUE;
		}
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerSaveChanges
* Purpose: 	This function is the event handler for the 
*			Save Changes screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerSaveChanges(EvtType* Event)
{
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_SAVE_CHANGES_YES;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_SAVE_CHANGES_NO;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_SAVE_CHANGES);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(pressed_object2);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	BUTTON_SAVE_CHANGES_YES:
			AnnFieldUpdateRecord();
			/* Save changes to record */
			AnnChangeUpdateRecord();
			/* Update the total number of rows in the Table Display */
			AnnSetTableFont();
			AnnRecordToTable(ann_dbid);
			/* Records update Table */
			FormPopupForm(pressed_object1);
			return TRUE;
			
		case	BUTTON_SAVE_CHANGES_NO:
			if (app_status.edit_mode == ANN_NEW)
			{
				if (ann_field_buffer[0] !=NULL)
				{
					strcpy(ann_field_buffer[0],(BYTE*)(""));
					AnnFieldBufferToField();
					AnnClearFieldBuffer();
				}
				DataCloseRecord(ann_dbid, app_status.rec_id);
				DataDeleteRecord(ann_dbid, app_status.rec_id, FALSE);
			}
			AnnSetTableFont();
			AnnRecordToTable(ann_dbid);
			FormPopupForm(pressed_object1);
			return TRUE;
			
		default:
			return FALSE;
		}
		return TRUE;
		
		default:
			return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerYearlySettings
* Purpose: 	This function is the event handler for the 
*			CONFIRM ITEM ERASE screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerYearlySettings(EvtType* Event)
{
	BOOLEAN control_value;
	String	*string_addr;
	Textbox	*text_addr;
	Bitmap	*bmp_addr;
	BYTE	object_type;
	WORD	num_chars;
	RTM		pDate;
	CountrySettings	country;
	SHORT	result_week_num, year_roundoff;
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_YEAR_1 || Event->para1 == SLETTER_YEAR_1)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_YEARLY_SETTINGS_N1;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_YEAR_2 || Event->para1 == SLETTER_YEAR_2)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_YEARLY_SETTINGS_N2;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_YEARLY_SETTINGS);
		
		if (sch_date == NO_SCH_DATE)
		{
			sch_date = SCH_DATE;
			FormGetObjectPointer(BITMAP_YEARLY_REPEAT_DIALOG_EXIT, &object_type, (void **)&bmp_addr);
			bmp_addr->bitmap_attr.bitmap_visible = TRUE;
		}
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(pressed_object1);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_YEARLY_SETTINGS_N1)
		{
			date_entry_method = 0;
			/* Set up the specified day */
			AnnSetStartOfWeekScreen();
			AnnYearSettingUpdate(&app_status.sch_year, FORM_ANN_DATE_SETTINGS);
			AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
			FormPopupForm(FORM_ANN_DATE_SETTINGS);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_YEARLY_SETTINGS_N2)
		{
			AnnYearSettingUpdate(&app_status.sch_year, FORM_ANN_WEEK_SETTINGS);
			///					save_wset_week_num = wset_week_num;
			AnnUpperWeekSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
			
#ifdef	PC_SIM
			{
				result_week_num = Dt_Date_YWeek(app_status.sch_year, app_status.sch_month-1, app_status.sch_day, 0, &year_roundoff);
			}
#else
			{					
				SySetupGetCountrySettings(&country);
				result_week_num = Dt_Date_YWeek(app_status.sch_year, app_status.sch_month-1, app_status.sch_day, country.start_of_week, &year_roundoff);
			}						
#endif
			
			if (year_roundoff == app_status.sch_year)
				AnnLowerWeekSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
			else
			{
				SySetupGetCountrySettings(&country);
				Dt_YWeek_Date (year_roundoff, result_week_num, wset_wday, country.start_of_week, &pDate);
				AnnLowerWeekSettingsUpdate(pDate.year, pDate.mon+1, pDate.mday);
				AnnYearSettingUpdate((USHORT *)&year_roundoff, FORM_ANN_WEEK_SETTINGS);
			}
			if (date_entry_method != 2)
			{
				date_entry_method = 1;
				week_click = TRUE;
				
				FormGetObjectPointer(STRING_WEEK_SETTINGS_N1, &object_type, (void **)&string_addr);
				string_addr->string_bg_color = COLOR_GREY1;
				FormGetObjectPointer(STRING_WEEK_SETTINGS_N2, &object_type, (void **)&string_addr);
				string_addr->string_bg_color = COLOR_WHITE;
				
				FormGetObjectPointer(TEXTBOX_WEEK_SETTINGS, &object_type, (void **)&text_addr);
				text_addr->textbox_background_color = COLOR_GREY1;
			}
			else
			{
				date_entry_method = 2;
				week_click = FALSE;
				
				FormGetObjectPointer(STRING_WEEK_SETTINGS_N1, &object_type, (void **)&string_addr);
				string_addr->string_bg_color = COLOR_WHITE;
				FormGetObjectPointer(STRING_WEEK_SETTINGS_N2, &object_type, (void **)&string_addr);
				string_addr->string_bg_color = COLOR_GREY1;
				
				FormGetObjectPointer(TEXTBOX_WEEK_SETTINGS, &object_type, (void **)&text_addr);
				text_addr->textbox_background_color = COLOR_WHITE;
			}
			
			text_addr->textbox_font_color = COLOR_BLACK;
			text_addr->textbox_attr.textbox_insert_pt_visible = FALSE;
			
			TextboxGetNumOfChars(TEXTBOX_WEEK_SETTINGS, &num_chars);
			text_addr->textbox_attr.textbox_highlight = FALSE;
			text_addr->textbox_highlight_start_char = 0;
			text_addr->textbox_highlight_end_char = num_chars;
			FormPopupForm(FORM_ANN_WEEK_SETTINGS);
			return TRUE;
		}
		else
		{	/* Check the check box's setting */ 
			FormGetControlValue(CHECKBOX_YEARLY_SETTINGS, &control_value);
			app_status.yearly_repeat = (BYTE)control_value;
			return TRUE;
		}
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerWeekSettings
* Purpose: 	This function is the event handler for the 
*			DATE SETTINGS screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerWeekSettings(EvtType* Event)
{
	String	*string1_addr, *string2_addr;
	SHORT	result_month, result_day, temp_month, display_week_num, year_roundoff, check_roundoff;
	SHORT	display_nth_wday, display_wset_wday, display_sch_month, display_sch_year;
	SHORT	week_num;
	BYTE	*control_text, buffer[20], object_type;
	BYTE	*ptr = buffer, *text_buffer;
	RTM		pDate;
	ObjectID	clicked_id;
	CountrySettings	country;
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_WEEK_1 || Event->para1 == SLETTER_WEEK_1)
			{
#ifdef	PR31700
				ControlPopupPopupTrigger(POPUP_TRIGGER_WEEK_SETTINGS_N1);
#endif
				return	FALSE;
			}
			else if(Event->para1 == LLETTER_WEEK_2 || Event->para1 == SLETTER_WEEK_2)
			{
#ifdef	PR31700
				ControlPopupPopupTrigger(POPUP_TRIGGER_WEEK_SETTINGS_N2);
#endif
				return	FALSE;
			}
			else if(Event->para1 == LLETTER_WEEK_3 || Event->para1 == SLETTER_WEEK_3)
			{
#ifdef	PR31700
				ControlPopupPopupTrigger(POPUP_TRIGGER_WEEK_SETTINGS_N3);
#endif
				return	FALSE;
			}
		}	
	}
	
	SySetupGetCountrySettings(&country);
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		/* Check the setting of the Start Of Week and update the week num of the display */
		if (wset_week_num >= 1 && wset_week_num < 55 && date_entry_method == 1)
		{
			///					if (country.start_of_week == SYSETUP_SUN)
			///						valid_input = RtcWday4ToYMD(app_status.sch_year, wset_week_num, wset_wday, &result_month, &result_day);
			///					else
			///						valid_input = RtcWday5ToYMD(app_status.sch_year, wset_week_num, wset_wday, &result_month, &result_day);
			if (valid_input == TRUE)
			{
				wset_week_num = Dt_Date_YWeek (app_status.sch_year, app_status.sch_month-1, app_status.sch_day, country.start_of_week, &year_roundoff);
				valid_input = Dt_YWeek_Date (year_roundoff, wset_week_num, wset_wday, country.start_of_week, &pDate);
				
				if (year_roundoff != app_status.sch_year)
					date_entry_method = 0;
				
				app_status.sch_year = pDate.year;
				result_month = pDate.mon;
				result_day = pDate.mday;
				/* Update New Month & Day by Week Setting */
				app_status.sch_month = result_month+1;
				app_status.sch_day = result_day;
			}
		}
		///				if (valid_input == TRUE)
		///					RtcYMDToWday4(app_status.sch_year, app_status.sch_month-1, app_status.sch_day, &wset_wday, &wset_week_num);
		
		backup_wset_wday = wset_wday;
		restart_form = RESTART_ANN_WEEK_SETTINGS;
		app_status.edit_mode = ANN_WEEK_SETTINGS;
		KeyboardSetKeyboardInvisible();
		FormDrawForm(FORM_ANN_WEEK_SETTINGS);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		week_click = TRUE;
		
		switch (Event->eventID)
		{
		case	BITMAP_WEEK_SETTINGS_N1:
			app_status.sch_year -= 5;
			AnnYearShiftUpdate(BACKWARD);
			return TRUE;
			
		case	BITMAP_WEEK_SETTINGS_N2:
			app_status.sch_year += 5;
			AnnYearShiftUpdate(FORWARD);
			return TRUE;
			
		default:
			return FALSE;
		}
		
		case	EVT_CONTROL_SELECT:
			week_click = TRUE;
			
			switch (Event->eventID)
			{
			case	PUSHBUTTON_WEEK_SETTINGS_Y1:
				ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y1, &control_text);
				app_status.sch_year = (USHORT)atol((const char *)control_text);
				AnnYearUpdateDayMonth(country.start_of_week);
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_Y2:
				ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y2, &control_text);
				app_status.sch_year = (USHORT)atol((const char *)control_text);
				AnnYearUpdateDayMonth(country.start_of_week);
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_Y3:
				ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y3, &control_text);
				app_status.sch_year = (USHORT)atol((const char *)control_text);
				AnnYearUpdateDayMonth(country.start_of_week);
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_Y4:
				ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y4, &control_text);
				app_status.sch_year = (USHORT)atol((const char *)control_text);
				AnnYearUpdateDayMonth(country.start_of_week);
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_Y5:
				ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y5, &control_text);
				app_status.sch_year = (USHORT)atol((const char *)control_text);
				AnnYearUpdateDayMonth(country.start_of_week);
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_N1:
				AnnSetUpWeekNumber('1');
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_N2:
				AnnSetUpWeekNumber('2');
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_N3:
				AnnSetUpWeekNumber('3');
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_N4:
				AnnSetUpWeekNumber('4');
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_N5:
				AnnSetUpWeekNumber('5');
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_N6:
				AnnSetUpWeekNumber('6');
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_N7:
				AnnSetUpWeekNumber('7');
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_N8:
				AnnSetUpWeekNumber('8');
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_N9:
				AnnSetUpWeekNumber('9');
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_N10:
				AnnSetUpWeekNumber('0');
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_SUN:
				ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 0, &clicked_id);
				ControlGetLabel(clicked_id, &control_text);
				display_sch_year = (SHORT)atol((const char *)control_text);
				
				TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &text_buffer);
				display_week_num = (SHORT)atol((const char *)text_buffer);
				////
				wset_week_num = display_week_num;
				////
				valid_input = Dt_YWeek_Date (display_sch_year, display_week_num, 0, country.start_of_week, &pDate);
				
				if (valid_input == OUT_OF_YEAR_BOUNDARY)
				{
#ifdef	PC_SIM
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, 0, &check_roundoff);
#else
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, country.start_of_week, &check_roundoff);
#endif
					/* Check Date No RoundOff */
					if (check_roundoff != display_sch_year)
						valid_input = FALSE;
					else
						valid_input = TRUE;
				}
				
				if (valid_input == TRUE)
					app_status.sch_year = pDate.year;
				
				result_month = pDate.mon;
				app_status.sch_day = pDate.mday;
				app_status.sch_month = result_month + 1;
				date_entry_method = 1;
				wset_wday = 0;
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_MON:
				ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 0, &clicked_id);
				ControlGetLabel(clicked_id, &control_text);
				display_sch_year = (SHORT)atol((const char *)control_text);
				
				TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &text_buffer);
				display_week_num = (SHORT)atol((const char *)text_buffer);
				////
				wset_week_num = display_week_num;
				////
				valid_input = Dt_YWeek_Date (display_sch_year, display_week_num, 1, country.start_of_week, &pDate);
				
				if (valid_input == OUT_OF_YEAR_BOUNDARY)
				{
#ifdef	PC_SIM
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, 0, &check_roundoff);
#else
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, country.start_of_week, &check_roundoff);
#endif
					/* Check Date No RoundOff */
					if (check_roundoff != display_sch_year)
						valid_input = FALSE;
					else
						valid_input = TRUE;
				}
				
				if (valid_input == TRUE)
					app_status.sch_year = pDate.year;
				
				result_month = pDate.mon;
				app_status.sch_day = pDate.mday;
				app_status.sch_month = result_month + 1;
				date_entry_method = 1;
				wset_wday = 1;
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_TUE:
				ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 0, &clicked_id);
				ControlGetLabel(clicked_id, &control_text);
				display_sch_year = (SHORT)atol((const char *)control_text);
				
				TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &text_buffer);
				display_week_num = (SHORT)atol((const char *)text_buffer);
				////
				wset_week_num = display_week_num;
				////
				valid_input = Dt_YWeek_Date (display_sch_year, display_week_num, 2, country.start_of_week, &pDate);
				
				if (valid_input == OUT_OF_YEAR_BOUNDARY)
				{
#ifdef	PC_SIM
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, 0, &check_roundoff);
#else
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, country.start_of_week, &check_roundoff);
#endif
					/* Check Date No RoundOff */
					if (check_roundoff != display_sch_year)
						valid_input = FALSE;
					else
						valid_input = TRUE;
				}
				
				if (valid_input == TRUE)
					app_status.sch_year = pDate.year;
				
				result_month = pDate.mon;
				app_status.sch_day = pDate.mday;
				app_status.sch_month = result_month + 1;
				date_entry_method = 1;
				wset_wday = 2;
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_WED:
				ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 0, &clicked_id);
				ControlGetLabel(clicked_id, &control_text);
				display_sch_year = (SHORT)atol((const char *)control_text);
				
				TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &text_buffer);
				display_week_num = (SHORT)atol((const char *)text_buffer);
				////
				wset_week_num = display_week_num;
				////
				valid_input = Dt_YWeek_Date (display_sch_year, display_week_num, 3, country.start_of_week, &pDate);
				
				if (valid_input == OUT_OF_YEAR_BOUNDARY)
				{
#ifdef	PC_SIM
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, 0, &check_roundoff);
#else
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, country.start_of_week, &check_roundoff);
#endif
					/* Check Date No RoundOff */
					if (check_roundoff != display_sch_year)
						valid_input = FALSE;
					else
						valid_input = TRUE;
				}
				
				if (valid_input == TRUE)
					app_status.sch_year = pDate.year;
				
				result_month = pDate.mon;
				app_status.sch_day = pDate.mday;
				app_status.sch_month = result_month + 1;
				date_entry_method = 1;
				wset_wday = 3;
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_THU:
				ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 0, &clicked_id);
				ControlGetLabel(clicked_id, &control_text);
				display_sch_year = (SHORT)atol((const char *)control_text);
				
				TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &text_buffer);
				display_week_num = (SHORT)atol((const char *)text_buffer);
				////
				wset_week_num = display_week_num;
				////
				valid_input = Dt_YWeek_Date (display_sch_year, display_week_num, 4, country.start_of_week, &pDate);
				
				if (valid_input == OUT_OF_YEAR_BOUNDARY)
				{
#ifdef	PC_SIM
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, 0, &check_roundoff);
#else
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, country.start_of_week, &check_roundoff);
#endif
					/* Check Date No RoundOff */
					if (check_roundoff != display_sch_year)
						valid_input = FALSE;
					else
						valid_input = TRUE;
				}
				
				if (valid_input == TRUE)
					app_status.sch_year = pDate.year;
				
				result_month = pDate.mon;
				app_status.sch_day = pDate.mday;
				
				app_status.sch_month = result_month + 1;
				date_entry_method = 1;
				wset_wday = 4;
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_FRI:
				ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 0, &clicked_id);
				ControlGetLabel(clicked_id, &control_text);
				display_sch_year = (SHORT)atol((const char *)control_text);
				
				TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &text_buffer);
				display_week_num = (SHORT)atol((const char *)text_buffer);
				////
				wset_week_num = display_week_num;
				////
				valid_input = Dt_YWeek_Date (display_sch_year, display_week_num, 5, country.start_of_week, &pDate);
				
				if (valid_input == OUT_OF_YEAR_BOUNDARY)
				{
#ifdef	PC_SIM
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, 0, &check_roundoff);
#else
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, country.start_of_week, &check_roundoff);
#endif
					/* Check Date No RoundOff */
					if (check_roundoff != display_sch_year)
						valid_input = FALSE;
					else
						valid_input = TRUE;
				}
				
				if (valid_input == TRUE)
					app_status.sch_year = pDate.year;
				
				result_month = pDate.mon;
				app_status.sch_day = pDate.mday;
				
				app_status.sch_month = result_month + 1;
				date_entry_method = 1;
				wset_wday = 5;
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_SAT:
				ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 0, &clicked_id);
				ControlGetLabel(clicked_id, &control_text);
				display_sch_year = (SHORT)atol((const char *)control_text);
				
				TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &text_buffer);
				display_week_num = (SHORT)atol((const char *)text_buffer);
				////
				wset_week_num = display_week_num;
				////
				valid_input = Dt_YWeek_Date (display_sch_year, display_week_num, 6, country.start_of_week, &pDate);
				
				if (valid_input == OUT_OF_YEAR_BOUNDARY)
				{
#ifdef	PC_SIM
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, 0, &check_roundoff);
#else
					Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, country.start_of_week, &check_roundoff);
#endif
					/* Check Date No RoundOff */
					if (check_roundoff != display_sch_year)
						valid_input = FALSE;
					else
						valid_input = TRUE;
				}
				
				if (valid_input == TRUE)
					app_status.sch_year = pDate.year;
				
				///							if (valid_input == OUT_OF_YEAR_BOUNDARY && display_week_num >= 53)
				///								valid_input = FALSE;
				///							else if (valid_input == TRUE || (valid_input == OUT_OF_YEAR_BOUNDARY && display_week_num <= 52))
				///							{
				///								app_status.sch_year = pDate.year;
				///								valid_input = TRUE;
				///							}
				
				result_month = pDate.mon;
				app_status.sch_day = pDate.mday;
				
				app_status.sch_month = result_month + 1;
				date_entry_method = 1;
				wset_wday = 6;
				return TRUE;
				
			default:
				return FALSE;
				}
				
		case	EVT_CONTROL_POPUP_SELECT:
			AnnUpperWeekSettingsOnOff(FALSE);
			week_click = FALSE;
			backup_wset_wday = wset_wday;
			ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 0, &clicked_id);
			ControlGetLabel(clicked_id, &control_text);
			display_sch_year = (SHORT)atol((const char *)control_text);
			
			ControlGetLabel(POPUP_TRIGGER_WEEK_SETTINGS_N1, &control_text);
			if (strcmp((char *)control_text, ANNFIRST) == 0)
				display_nth_wday = 1;
			else if (strcmp((char *)control_text, ANNSECOND) == 0)
				display_nth_wday = 2;
			else if (strcmp((char *)control_text, ANNTHIRD) == 0)
				display_nth_wday = 3;
			else if (strcmp((char *)control_text, ANNFORTH) == 0)
				display_nth_wday = 4;
			else if (strcmp((char *)control_text, ANNFIFTH) == 0)
				display_nth_wday = 5;
			else
				display_nth_wday = 6;
			
			ControlGetLabel(POPUP_TRIGGER_WEEK_SETTINGS_N2, &control_text);
			if (strcmp((char *)control_text, ANNSUN) == 0)
				display_wset_wday = 0;
			else if (strcmp((char *)control_text, ANNMON) == 0)
				display_wset_wday = 1;
			else if (strcmp((char *)control_text, ANNTUE) == 0)
				display_wset_wday = 2;
			else if (strcmp((char *)control_text, ANNWED) == 0)
				display_wset_wday = 3;
			else if (strcmp((char *)control_text, ANNTHU) == 0)
				display_wset_wday = 4;
			else if (strcmp((char *)control_text, ANNFRI) == 0)
				display_wset_wday = 5;
			else
				display_wset_wday = 6;
			
			ControlGetLabel(POPUP_TRIGGER_WEEK_SETTINGS_N3, &control_text);
			if (strcmp((char *)control_text, ANNJAN) == 0)
				display_sch_month = 1;
			else if (strcmp((char *)control_text, ANNFEB) == 0)
				display_sch_month = 2;
			else if (strcmp((char *)control_text, ANNMAR) == 0)
				display_sch_month = 3;
			else if (strcmp((char *)control_text, ANNAPR) == 0)
				display_sch_month = 4;
			else if (strcmp((char *)control_text, ANNMAY) == 0)
				display_sch_month = 5;
			else if (strcmp((char *)control_text, ANNJUN) == 0)
				display_sch_month = 6;
			else if (strcmp((char *)control_text, ANNJUL) == 0)
				display_sch_month = 7;
			else if (strcmp((char *)control_text, ANNAUG) == 0)
				display_sch_month = 8;
			else if (strcmp((char *)control_text, ANNSEP) == 0)
				display_sch_month = 9;
			else if (strcmp((char *)control_text, ANNOCT) == 0)
				display_sch_month = 10;
			else if (strcmp((char *)control_text, ANNNOV) == 0)
				display_sch_month = 11;
			else
				display_sch_month = 12;
			
			switch (Event->eventID)
			{
			case	POPUP_TRIGGER_WEEK_SETTINGS_N1:
				wset_nth_wday = Event->para1 + 1;
#ifdef DEBUG
				printf("\nYear check Year %d", display_sch_year);
				printf("\nYear check Month %d", display_sch_month-1);
				printf("\nYear check display_nth_wday %d", display_nth_wday);
				printf("\nYear check display_wset_wday %d", display_wset_wday);
				printf("\nYear check Week %d", country.start_of_week);
#endif
				
				if (wset_nth_wday == 6)
				{								
					valid_input = Dt_M7day_Date (display_sch_year, display_sch_month-1, -1, display_wset_wday, &pDate);
					last_wday_on = TRUE;
				}
				else
				{
					valid_input = Dt_M7day_Date (display_sch_year, display_sch_month-1, display_nth_wday, display_wset_wday, &pDate);
					last_wday_on = FALSE;
				}
				// ----------------- 12082000 ---------------
				if (display_sch_month == (pDate.mon + 1))
				{
					app_status.sch_year = pDate.year;
					app_status.sch_month = pDate.mon+1;
					app_status.sch_day = pDate.mday;
					date_entry_method = 2;
				}
				else valid_input = FALSE;
				// -------------------------------------------
				return TRUE;
				
			case	POPUP_TRIGGER_WEEK_SETTINGS_N2:
				wset_wday = (SHORT)Event->para1;
				
				if (last_wday_on)
				{
					wset_nth_wday = 6;
					valid_input = Dt_M7day_Date (display_sch_year, display_sch_month-1, -1, display_wset_wday, &pDate);
				}
				else
					valid_input = Dt_M7day_Date (display_sch_year, display_sch_month-1, display_nth_wday, display_wset_wday, &pDate);
				
				// ----------------- 12082000 ---------------
				if (display_sch_month == (pDate.mon + 1))
				{
					app_status.sch_year = pDate.year;
					app_status.sch_month = pDate.mon+1;
					app_status.sch_day = pDate.mday;
					date_entry_method = 2;
				}
				else valid_input = FALSE;
				// ------------------------------------------
				return TRUE;
				
			case	POPUP_TRIGGER_WEEK_SETTINGS_N3:
				app_status.sch_month = Event->para1 + 1;
				
				if (last_wday_on)
				{
					wset_nth_wday = 6;
					valid_input = Dt_M7day_Date (display_sch_year, display_sch_month-1, -1, display_wset_wday, &pDate);
				}
				else
					valid_input = Dt_M7day_Date (display_sch_year, display_sch_month-1, display_nth_wday, display_wset_wday, &pDate);
				
				// ----------------- 12082000 ---------------
				if (display_sch_month == (pDate.mon + 1))
				{
					app_status.sch_year = pDate.year;
					app_status.sch_month = pDate.mon+1;
					app_status.sch_day = pDate.mday;
				}
				else valid_input = FALSE;
				date_entry_method = 2;
				// ------------------------------------------
				return TRUE;
			}
			return TRUE;
			
			case	PEN_EVENT:		
				if (Event->eventID == PEN_DOWN)
				{	
					FormGetObjectPointer(STRING_WEEK_SETTINGS_N1, &object_type, (void **)&string1_addr);
					FormGetObjectPointer(STRING_WEEK_SETTINGS_N2, &object_type, (void **)&string2_addr);
					
					ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 0, &clicked_id);
					ControlGetLabel(clicked_id, &control_text);
					display_sch_year = (SHORT)atol((const char *)control_text);
					
					if (Event->para1 >= string1_addr->bounds.xcoord && 
						Event->para1 < string1_addr->bounds.xcoord + string1_addr->bounds.width &&
						Event->para2 >= string1_addr->bounds.ycoord &&
						Event->para2 < string1_addr->bounds.ycoord + string1_addr->bounds.height)
					{
						AnnUpperWeekSettingsOnOff(TRUE);
						/* Revert */
						TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &text_buffer);
						wset_week_num = (SHORT)atol((const char *)text_buffer);
						///						display_sch_year = app_status.sch_year;
						
						if (wset_week_num < 1 || wset_week_num >54)
							valid_input = FALSE;
						else
						{
							valid_input = Dt_YWeek_Date (display_sch_year, wset_week_num, backup_wset_wday, country.start_of_week, &pDate);
							app_status.sch_year = pDate.year;
							result_month = pDate.mon;
							app_status.sch_day = pDate.mday;
							
							if (valid_input == OUT_OF_YEAR_BOUNDARY && wset_week_num >= 53)
								valid_input = FALSE;
							else if (valid_input == TRUE || (valid_input == OUT_OF_YEAR_BOUNDARY && wset_week_num <= 52))
								valid_input = TRUE;
						}
						
						app_status.sch_month = result_month + 1;
						date_entry_method = 1;
					}
					else if (Event->para1 >= string2_addr->bounds.xcoord && 
						Event->para1 < string2_addr->bounds.xcoord + string2_addr->bounds.width &&
						Event->para2 >= string2_addr->bounds.ycoord &&
						Event->para2 < string2_addr->bounds.ycoord + string2_addr->bounds.height)
					{
						AnnUpperWeekSettingsOnOff(FALSE);
						ControlPopupGetSelectedItem(POPUP_TRIGGER_WEEK_SETTINGS_N2, &wset_wday);
						ControlPopupGetSelectedItem(POPUP_TRIGGER_WEEK_SETTINGS_N3, (SHORT*)&app_status.sch_month);
						
						ControlGetLabel(POPUP_TRIGGER_WEEK_SETTINGS_N1, &control_text);
						if (strcmp((char *)control_text, ANNFIRST) == 0)
							wset_nth_wday = 1;
						else if (strcmp((char *)control_text, ANNSECOND) == 0)
							wset_nth_wday = 2;
						else if (strcmp((char *)control_text, ANNTHIRD) == 0)
							wset_nth_wday = 3;
						else if (strcmp((char *)control_text, ANNFORTH) == 0)
							wset_nth_wday = 4;
						else if (strcmp((char *)control_text, ANNFIFTH) == 0)
							wset_nth_wday = 5;
						else
							wset_nth_wday = 6;
						
						valid_input = Dt_M7day_Date (display_sch_year, app_status.sch_month, wset_nth_wday, wset_wday, &pDate);
						app_status.sch_year = pDate.year;
						app_status.sch_day = pDate.mday;
						app_status.sch_month = pDate.mon + 1;
						date_entry_method = 2;
					}
				}
				return TRUE;
				
			case	EVT_INLAY_SELECT:
				// ----------------- 12082000 ---------------
				TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &text_buffer);
				week_num = atol((const char *)text_buffer);
				if (week_num < 1 || week_num > 54)
					valid_input = FALSE;
				// ------------------------------------------
				
				if ((Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT) && (valid_input == TRUE || valid_input == OUT_OF_YEAR_BOUNDARY))
				{
					ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 0, &clicked_id);
					ControlGetLabel(clicked_id, &control_text);
					/* Should the year entry it should be */
					app_status.input_year = (SHORT)atol((const char *)control_text);
					
					if (pressed_object1 == FORM_ANN_VIEWING)
					{
						if (alarm_set_by == ALARM_EXACT_DATE)
						{
							app_status.alarm_year = app_status.sch_year;
							app_status.alarm_month = app_status.sch_month;
							app_status.alarm_day = app_status.sch_day;
						}
						else if (alarm_set_by == ALARM_BEFORE_EXACT_DATE)
						{
							app_status.alarm_year = app_status.sch_year;
							temp_month = app_status.sch_month -1;
							app_status.alarm_day = app_status.sch_day;
							
							RtcDaysShift((SHORT *)&app_status.alarm_year, &temp_month,(SHORT *)&app_status.alarm_day,-1);
							app_status.alarm_month = temp_month + 1;
						}
						AnnViewingSetUpScreen();
						FormPopupForm(FORM_ANN_VIEWING);
					}
					else if (pressed_object1 == FORM_ANN_NEW)
					{								
						AnnPackDueDate(ptr, app_status.sch_year, app_status.sch_month, app_status.sch_day);
						ControlSetLabel(BUTTON_ANN_NEW_DATE, buffer);
						
						if (alarm_set_by == ALARM_EXACT_DATE)
						{
							app_status.alarm_year = app_status.sch_year;
							app_status.alarm_month = app_status.sch_month;
							app_status.alarm_day = app_status.sch_day;
						}
						else if (alarm_set_by == ALARM_BEFORE_EXACT_DATE)
						{
							app_status.alarm_year = app_status.sch_year;
							temp_month = app_status.sch_month -1;
							app_status.alarm_day = app_status.sch_day;
							
							RtcDaysShift((SHORT *)&app_status.alarm_year, &temp_month,(SHORT *)&app_status.alarm_day,-1);
							app_status.alarm_month = temp_month + 1;
						}
						FormPopupForm(FORM_ANN_NEW);
					}
				}
				else if ((Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT) && valid_input != TRUE)
				{
					return_to = FORM_ANN_WEEK_SETTINGS;
					FormPopupForm(FORM_INVALID_INPUT);
				}				
				KeyboardSetKeyboardVisible();
				return TRUE;	
				
			default:
				return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerDateSettings
* Purpose: 	This function is the event handler for the 
*			DATE SETTINGS screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerDateSettings(EvtType* Event)
{
	BYTE		*control_text, *table_text;
	RTM			time;
	BYTE		buffer[20];
	BYTE		*ptr = buffer;
	SHORT		temp_month;
	ObjectID	control_id;
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_TODAY || Event->para1 == SLETTER_TODAY)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_DATE_SETTINGS_TODAY;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		result_check = TRUE;
		FormDrawForm(FORM_ANN_DATE_SETTINGS);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		switch (Event->eventID)
		{
		case	BITMAP_WEEK_SETTINGS_N1:
			if (select_goto == FALSE)
			{
				backup_year = app_status.sch_year;
				//								app_status.sch_year -= 5;
				if (AnnYearShiftUpdate(BACKWARD) == TRUE)
				{
					ControlGetPushedPushButton(FORM_ANN_DATE_SETTINGS, 0, &control_id);
					ControlGetLabel(control_id, &control_text);
					app_status.sch_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
				}
				result_check = RtcCheckYMDValid(app_status.sch_year, app_status.sch_month-1, app_status.sch_day);
			}
			else
			{
				//								app_status.selected_year -= 5;
				if (AnnYearShiftUpdate(BACKWARD) == TRUE)
				{
					ControlGetPushedPushButton(FORM_ANN_DATE_SETTINGS, 0, &control_id);
					ControlGetLabel(control_id, &control_text);
					app_status.selected_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month, app_status.selected_day);
				}
			}
			return TRUE;
			
		case	BITMAP_WEEK_SETTINGS_N2:
			if (select_goto == FALSE)
			{
				backup_year = app_status.sch_year;
				//								app_status.sch_year += 5;
				if (AnnYearShiftUpdate(FORWARD) == TRUE)
				{
					ControlGetPushedPushButton(FORM_ANN_DATE_SETTINGS, 0, &control_id);
					ControlGetLabel(control_id, &control_text);
					app_status.sch_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
				}
				result_check = RtcCheckYMDValid(app_status.sch_year, app_status.sch_month-1, app_status.sch_day);
			}
			else
			{
				//								app_status.selected_year += 5;
				if (AnnYearShiftUpdate(FORWARD) == TRUE)
				{
					ControlGetPushedPushButton(FORM_ANN_DATE_SETTINGS, 0, &control_id);
					ControlGetLabel(control_id, &control_text);
					app_status.selected_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month, app_status.selected_day);
				}
			}
			return TRUE;
			
		default:
			return FALSE;
		}
		return TRUE;
		
		case	EVT_CONTROL_SELECT:
			switch (Event->eventID)
			{
			case	PUSHBUTTON_WEEK_SETTINGS_Y1:
				ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y1, &control_text);
				if (select_goto == FALSE)
				{
					backup_year = app_status.sch_year;
					app_status.sch_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
					result_check = RtcCheckYMDValid(app_status.sch_year, app_status.sch_month-1, app_status.sch_day);
				}
				else
				{
					app_status.selected_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_Y2:
				ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y2, &control_text);
				if (select_goto == FALSE)
				{
					backup_year = app_status.sch_year;
					app_status.sch_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
					result_check = RtcCheckYMDValid(app_status.sch_year, app_status.sch_month-1, app_status.sch_day);
				}
				else
				{
					app_status.selected_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_Y3:
				ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y3, &control_text);
				if (select_goto == FALSE)
				{
					backup_year = app_status.sch_year;
					app_status.sch_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
					result_check = RtcCheckYMDValid(app_status.sch_year, app_status.sch_month-1, app_status.sch_day);
				}
				else
				{
					app_status.selected_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_Y4:
				ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y4, &control_text);
				if (select_goto == FALSE)
				{
					backup_year = app_status.sch_year;
					app_status.sch_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
					result_check = RtcCheckYMDValid(app_status.sch_year, app_status.sch_month-1, app_status.sch_day);
				}
				else
				{
					app_status.selected_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_WEEK_SETTINGS_Y5:
				ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y5, &control_text);
				if (select_goto == FALSE)
				{
					backup_year = app_status.sch_year;
					app_status.sch_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
					result_check = RtcCheckYMDValid(app_status.sch_year, app_status.sch_month-1, app_status.sch_day);
				}
				else
				{
					app_status.selected_year = (USHORT)atol((const char *)control_text);
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_JAN:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 1;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 1;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_FEB:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 2;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 2;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_MAR:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 3;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 3;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_APR:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 4;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 4;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_MAY:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 5;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 5;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_JUN:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 6;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 6;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_JUL:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 7;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 7;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_AUG:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 8;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 8;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_SEP:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 9;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 9;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_OCT:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 10;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 10;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_NOV:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 11;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 11;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTINGS_DEC:
				if (select_goto == FALSE)
				{
					app_status.sch_month = 12;
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_month = 12;
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			case	BUTTON_DATE_SETTINGS_TODAY:
				RtcGetTime(&time);
				FormSetControlGroupSelection(FORM_ANN_DATE_SETTINGS,PUSHBUTTON_DATE_SETTINGS_JAN + time.mon);
				
				if (select_goto == FALSE)
				{
					app_status.sch_year = time.year;
					app_status.sch_month = time.mon + 1;
					app_status.sch_day = time.mday;
					AnnYearSettingUpdate(&app_status.sch_year, FORM_ANN_DATE_SETTINGS);
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
				}
				else
				{
					app_status.selected_year = time.year;
					app_status.selected_month = time.mon + 1;
					app_status.selected_day = time.mday;
					AnnYearSettingUpdate(&app_status.selected_year, FORM_ANN_DATE_SETTINGS);
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month,
						app_status.selected_day);
				}
				return TRUE;
				
			default:
				return FALSE;
				}
				return TRUE;
				
		case	EVT_TABLE_SELECT:
			TableGetItemText (TABLE_DATE_SETTINGS, (USHORT)Event->para1, (USHORT)Event->para2, &table_text);
			if (table_text[0] != 0)
			{
				if (select_goto == FALSE)
				{
					app_status.sch_day = (USHORT)atol((const char *)table_text);
					AnnDateSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
				}
				else
				{
					app_status.selected_day = (USHORT)atol((const char *)table_text);
					AnnDateSettingsUpdate(app_status.selected_year, app_status.selected_month, app_status.selected_day);
				}
			}
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			{
				if (pressed_object1 == FORM_ANN_VIEWING)
				{
					if (result_check != TRUE)
						app_status.sch_year = backup_year;
					
					if (alarm_set_by == ALARM_EXACT_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						app_status.alarm_month = app_status.sch_month;
						app_status.alarm_day = app_status.sch_day;
					}
					else if (alarm_set_by == ALARM_BEFORE_EXACT_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						temp_month = app_status.sch_month -1;
						app_status.alarm_day = app_status.sch_day;
						
						RtcDaysShift((SHORT *)&app_status.alarm_year, &temp_month,(SHORT *)&app_status.alarm_day,-1);
						app_status.alarm_month = temp_month + 1;
					}
					AnnViewingSetUpScreen();
					FormPopupForm(FORM_ANN_VIEWING);
				}
				else if (pressed_object1 == FORM_ANN_NEW)
				{
					result_check = RtcCheckYMDValid(app_status.sch_year, app_status.sch_month-1, app_status.sch_day);
					/* Invalid Date Settings */
					if (result_check != TRUE)
					{
						return_to = FORM_ANN_DATE_SETTINGS;
						FormPopupForm(FORM_INVALID_INPUT);
						return TRUE;
					}
					AnnPackDueDate(ptr, app_status.sch_year, app_status.sch_month, app_status.sch_day);
					ControlSetLabel(BUTTON_ANN_NEW_DATE, buffer);
					
					if (alarm_set_by == ALARM_EXACT_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						app_status.alarm_month = app_status.sch_month;
						app_status.alarm_day = app_status.sch_day;
					}
					else if (alarm_set_by == ALARM_BEFORE_EXACT_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						temp_month = app_status.sch_month -1;
						app_status.alarm_day = app_status.sch_day;
						
						RtcDaysShift((SHORT *)&app_status.alarm_year, &temp_month,(SHORT *)&app_status.alarm_day,-1);
						app_status.alarm_month = temp_month + 1;
					}
					FormPopupForm(FORM_ANN_NEW);
				}
				else if (pressed_object1 == FORM_ANN_LIST)
				{
					AnnRecordToTable(ann_dbid);
					
					if (anniver_list.total_num_rows == 0)
						FormPopupForm(FORM_NO_RECORD);
					else
						FormPopupForm(FORM_ANN_LIST);
				}
			}
			return TRUE;	
			
		default:
			return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerInvalidInput
* Purpose: 	This function is the event handler for the 
*			Save Changes screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerInvalidInput(EvtType* Event)
{
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_INVALID_INPUT);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(return_to);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerNoRecord
* Purpose: 	This function is the event handler for the 
*			Save Changes screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerNoRecord(EvtType* Event)
{
	RTM			time;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_NO_RECORD);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		RtcGetTime(&time);				
		app_status.selected_year = (USHORT)time.year;
		select_goto = FALSE; 
		AnnRecordToTable(ann_dbid);
		FormPopupForm(FORM_ANN_LIST);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerSysLowMem
* Purpose: 	This function is called to handle the event for the form
*			NO MEMORY
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerSysLowMem(EvtType *Event)
{
	BYTE	object_type;
	Form	*form_addr;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch	(Event->eventType)
	{
	case	EVT_FORM_OPEN:
		if (FormGetObjectPointer(FORM_SYSTEM_LOW_MEM, &object_type, (void **)&form_addr)
			== ERR_UI_RES_NOT_FOUND)
			FormInitAllFormObjects(FORM_SYSTEM_LOW_MEM);
		
		FormDrawForm(FORM_SYSTEM_LOW_MEM);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(low_memory_form_id);
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			FormPopupForm(low_memory_form_id);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerInvalidAlarmDate
Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerInvalidAlarmDate(EvtType* Event)
{
	Form	*form_addr;
	BYTE	object_type;
	
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		if (FormGetObjectPointer(FORM_INVALID_ALARM_DATE, &object_type, (void **)&form_addr)
			== ERR_UI_RES_NOT_FOUND)
			FormInitAllFormObjects(FORM_INVALID_ALARM_DATE);
		FormDrawForm(FORM_INVALID_ALARM_DATE);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormEraseForm(FORM_INVALID_ALARM_DATE);
		FormPopupForm(FORM_ALARM_SETTINGS);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}
