/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   anndb.c
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/


#include "stdafx.h"
#include "Ann.h"
#include "AnnFunc.h"
#include "alarmgr.h"
#ifdef	PC_SIM
#include "tdlann.h"
#endif
//#define DEBUG
//#define DEBUG_MICH

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
DatabaseID	ann_dbid;
BYTE **		ann_field_buffer;
BYTE 		ann_text_buffer[5];


TableDisplay	anniver_list = {TABLE_ANN_LIST,0,0,0,NULL};
AppStatus		app_status = {0,0,0,0,0,0,0,0,0,0,0,0,0,ANN_LIST};
/*	rec_id,				alarm_status,			sch_year,
sch_month,			sch_day,				alarm_year,
alarm_month,		alarm_day,				selected_year,
selected_month,		selected_day,			yearly_repeat
edit_mode
*/
CheckStatus     chk_status = {0,0,0,0,0,0,0,0,0,0};
/*	alarm_status,		sch_year,				sch_month,
sch_day,			alarm_year,				alarm_month,
alarm_day,			yearly_repeat			field_change
*/

/********************************************************
* Function:	ToDoListAppRestore
* Purpose: 	This function is called to restore the data 
*			in the application when it is called to stopped
* Scope:	application/Internal 
* Input:	restart			whether the application is restart or not
* Output:	None
* Return:	TRUE			if handled
*			FALSE			if not handled
* Comment: 	None
*********************************************************/
void AnnAppRestore(BOOLEAN restart)
{
	String	*string_addr;
	Textbox	*text_addr;
	UWORD	byte_read, rec_num;
	SHORT	ann_week;
	WORD	num_chars;
	BYTE	application_status, object_type;
	BYTE	*buffer, text_buffer[15], temp_buffer[10];
	BYTE	*ptr = text_buffer;
	CountrySettings	country;
	Err 	ret;
	SySetupGetCountrySettings(&country);
	/* Allocate global variable */
	pressed_object1 = FALSE;
	pressed_object2 = FALSE;
	select_goto = FALSE;
	table_font = SMALL_FONT;
	pen_down = FALSE;
    ann_text_buffer[0]= 0;
	view_records = FALSE;
	
	/* Check the database & setup the selected y/m/d */
	AnnDatabaseChecking();
	if (restart == TRUE)
		application_status = RESTART_ANNIVER;
	else
	{
		DataGetField(ann_dbid, ANN_STATUS, 0, &buffer, &byte_read);
		application_status = *buffer;
		qfree(buffer);
	}
	
	/* Allocate global variable */
	ann_field_buffer = (BYTE**)qmalloc(1*sizeof(BYTE*));
	ann_field_buffer[0] = NULL;
	
	/* Initialisation all the Forms */
	FormInitAllFormObjects(FORM_ANN_LIST);
	FormInitAllFormObjects(FORM_ANN_VIEWING);
	FormInitAllFormObjects(FORM_ANN_NEW);
	FormInitAllFormObjects(FORM_ANN_WEEK_SETTINGS);
	FormInitAllFormObjects(FORM_ALARM_SETTINGS);
	FormInitAllFormObjects(FORM_ANN_DATE_SETTINGS);
	FormInitAllFormObjects(FORM_YEARLY_SETTINGS);
	FormInitAllFormObjects(FORM_SAVE_CHANGES);
	FormInitAllFormObjects(FORM_ITEM_ERASE);
	FormInitAllFormObjects(FORM_INVALID_INPUT);
	FormInitAllFormObjects(FORM_NO_RECORD);
	
	DataGetField(ann_dbid, ANN_EDIT_INFO, 32, &buffer, &byte_read);
	table_font = (BYTE)(*buffer);
	qfree(buffer);
	
    if (MemoryCheckMemLow())
		entry_low_memory = TRUE;
    else
		entry_low_memory = FALSE;
	
    if (application_status == RESTART_ANN_NEW)
		entry_old_edit = TRUE;
	else 
		entry_old_edit = FALSE;
	
	if (application_status == RESTART_ANNIVER)
	{
		DataGetField(ann_dbid, ANN_EDIT_INFO, 2, &buffer, &byte_read);	/* 01-02-2000 */
		app_status.sch_year = *(SHORT*)buffer;
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 3, &buffer, &byte_read);
		app_status.sch_month = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 4, &buffer, &byte_read);	/* 01-02-2000 */
		app_status.sch_day = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 8, &buffer, &byte_read);
		app_status.selected_year = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 9, &buffer, &byte_read);
		app_status.selected_month = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 10, &buffer, &byte_read);
		app_status.selected_day = *(SHORT*)(buffer);
		qfree(buffer);
		
		AnnSetTableFont();
		AnnRecordToTable(ann_dbid);
		FormPopupForm(FORM_ANN_LIST);
	}
	else if (application_status == RESTART_ANN_VIEWING || 
		application_status == RESTART_ANN_NEW ||
		application_status == RESTART_ANN_WEEK_SETTINGS)
	{
		/* Restore application status */
		DataGetField(ann_dbid, ANN_EDIT_INFO, 0, &buffer, &byte_read);
		app_status.rec_id = *(RecordID*)buffer;
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 1, &buffer, &byte_read);
		app_status.alarm_status = (BYTE)(*buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 2, &buffer, &byte_read);
		app_status.sch_year = *(SHORT*)buffer;
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 3, &buffer, &byte_read);
		app_status.sch_month = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 4, &buffer, &byte_read);
		app_status.sch_day = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 5, &buffer, &byte_read);
		app_status.alarm_year = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 6, &buffer, &byte_read);
		app_status.alarm_month = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 7, &buffer, &byte_read);
		app_status.alarm_day = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 8, &buffer, &byte_read);
		app_status.selected_year = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 9, &buffer, &byte_read);
		app_status.selected_month = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 10, &buffer, &byte_read);
		app_status.selected_day = *(SHORT*)(buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 11, &buffer, &byte_read);
		app_status.yearly_repeat = (BYTE)(*buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 12, &buffer, &byte_read);
		app_status.edit_mode = (BYTE)(*buffer);
		qfree(buffer);
		
		/* Restore Global Variables */
		DataGetField(ann_dbid, ANN_EDIT_INFO, 13, &buffer, &byte_read);
		pressed_object1 = (BYTE)(*buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 14, &buffer, &byte_read);
		pressed_object2 = (BYTE)(*buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 15, &buffer, &byte_read);
		alarm_date = (BYTE)(*buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 16, &buffer, &byte_read);
		sch_date = (BYTE)(*buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 17, &buffer, &byte_read);
		week_click = (BYTE)(*buffer);
		qfree(buffer);
		
		/* Restore field_buffers */
		DataGetField(ann_dbid, ANN_EDIT_INFO, 18, &buffer, &byte_read);
		ann_field_buffer[0] = (BYTE*)qmalloc((strlen(buffer) + 1)*sizeof(BYTE));
		strcpy(ann_field_buffer[0], buffer);
		qfree(buffer);	
		/* Restore textbox_buffers */
		DataGetField(ann_dbid, ANN_EDIT_INFO, 19, &buffer, &byte_read);
		strcpy(ann_text_buffer, buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 20, &buffer, &byte_read);
		date_entry_method = (BYTE)(*buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 29, &buffer, &byte_read);
		chk_status.field_change = (BOOLEAN)(*buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 33, &buffer, &byte_read);
		field_top_line = *(UWORD*)buffer;
		qfree(buffer);
		
		DataGetField(ann_dbid, ANN_EDIT_INFO, 34, &buffer, &byte_read);
		field_insert_pt_pos = *(UWORD*)buffer;
		qfree(buffer);
		
		if (DataRecIDtoNum(ann_dbid, app_status.rec_id, &rec_num) != TRUE)
		{
			application_status = RESTART_ANN_NEW;
			field_top_line = 0;
			field_insert_pt_pos = 0;
			strcpy(ann_field_buffer[0],"");
			AnnNewSetUpVariable();
		}
		
		if (application_status == RESTART_ANN_VIEWING)
		{
			DataGetField(ann_dbid, ANN_EDIT_INFO, 21, &buffer, &byte_read);
			chk_status.alarm_status = (BYTE)(*buffer);
			qfree(buffer);
			
			DataGetField(ann_dbid, ANN_EDIT_INFO, 22, &buffer, &byte_read);
			chk_status.sch_year = *(SHORT*)(buffer);
			qfree(buffer);
			
			DataGetField(ann_dbid, ANN_EDIT_INFO, 23, &buffer, &byte_read);
			chk_status.sch_month = *(SHORT*)(buffer);
			qfree(buffer);
			
			DataGetField(ann_dbid, ANN_EDIT_INFO, 24, &buffer, &byte_read);
			chk_status.sch_day = *(SHORT*)(buffer);
			qfree(buffer);
			
			DataGetField(ann_dbid, ANN_EDIT_INFO, 25, &buffer, &byte_read);
			chk_status.alarm_year = *(SHORT*)(buffer);
			qfree(buffer);
			
			DataGetField(ann_dbid, ANN_EDIT_INFO, 26, &buffer, &byte_read);
			chk_status.alarm_month = *(SHORT*)(buffer);
			qfree(buffer);
			
			DataGetField(ann_dbid, ANN_EDIT_INFO, 27, &buffer, &byte_read);
			chk_status.alarm_day = *(SHORT*)(buffer);
			qfree(buffer);
			
			DataGetField(ann_dbid, ANN_EDIT_INFO, 28, &buffer, &byte_read);
			chk_status.yearly_repeat = (BYTE)(*buffer);
			qfree(buffer);
			
			DataGetField(ann_dbid, ANN_EDIT_INFO, 30, &buffer, &byte_read);
			show_line = (BYTE)(*buffer);
			qfree(buffer);
			
			AnnViewingSetUpScreen();
			FormPopupForm(FORM_ANN_VIEWING);
		}
		else if (application_status == RESTART_ANN_NEW)
		{
			ret = DataGetField(ann_dbid, ANN_EDIT_INFO, 35, &buffer, &byte_read);	/* 01-02-2000 */
			wset_week_num = *(SHORT*)buffer;
			qfree(buffer);
			
			if (date_entry_method == 0)
				ann_week = 0;
			else if (date_entry_method == 1)
				ann_week = wset_week_num;
			else
				ann_week = 63;
			
			sprintf((char*)temp_buffer,"%d",ann_week);
			DataWriteField(ann_dbid,app_status.rec_id,8,(strlen(temp_buffer)+1),temp_buffer);
			
			DataGetField(ann_dbid, ANN_EDIT_INFO, 31, &buffer, &byte_read);
			chk_status.new_entry_hit = (BYTE)(*buffer);
			qfree(buffer);
			
			if (sch_date == NO_SCH_DATE)
				strcpy(text_buffer, DATESET);
			else
				AnnPackDueDate(ptr, app_status.sch_year, app_status.sch_month, app_status.sch_day);
			
			ControlSetLabel(BUTTON_ANN_NEW_DATE, text_buffer);
			FieldSetText(FIELD_ANN_NEW, ann_field_buffer[0]);
			/* Set up Field Size */
			FieldSetFont(FIELD_ANN_NEW, table_font);
			FormPopupForm(FORM_ANN_NEW);
			if (entry_low_memory)
			{
				low_memory_form_id = FORM_ANN_LIST;
				FormPopupForm(FORM_SYSTEM_LOW_MEM);	
			}
		}
		else
		{
			wset_nth_wday = Dt_Date_M7day (app_status.sch_year, app_status.sch_month-1, app_status.sch_day);	//	date update
			wset_wday = Dt_Date_WDay (app_status.sch_year, app_status.sch_month-1, app_status.sch_day);
			wset_week_num = Dt_Date_YWeek (app_status.sch_year, app_status.sch_month-1, app_status.sch_day, country.start_of_week, NULL);
			
			valid_input = RtcCheckYMDValid(app_status.sch_year, app_status.sch_month-1, app_status.sch_day);
			
			AnnYearSettingUpdate(&app_status.sch_year, FORM_ANN_LIST);
			AnnUpperWeekSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
			AnnLowerWeekSettingsUpdate(app_status.sch_year, app_status.sch_month, app_status.sch_day);
			
			if (week_click == TRUE)
			{
				FormGetObjectPointer(STRING_WEEK_SETTINGS_N1, &object_type, (void **)&string_addr);
				string_addr->string_bg_color = COLOR_GREY1;
				FormGetObjectPointer(STRING_WEEK_SETTINGS_N2, &object_type, (void **)&string_addr);
				string_addr->string_bg_color = COLOR_WHITE;
				
				FormGetObjectPointer(TEXTBOX_WEEK_SETTINGS, &object_type, (void **)&text_addr);
				text_addr->textbox_background_color = COLOR_GREY1;
			}
			else
			{
				FormGetObjectPointer(STRING_WEEK_SETTINGS_N1, &object_type, (void **)&string_addr);
				string_addr->string_bg_color = COLOR_WHITE;
				FormGetObjectPointer(STRING_WEEK_SETTINGS_N2, &object_type, (void **)&string_addr);
				string_addr->string_bg_color = COLOR_GREY1;
				
				FormGetObjectPointer(TEXTBOX_WEEK_SETTINGS, &object_type, (void **)&text_addr);
				text_addr->textbox_background_color = COLOR_WHITE;
			}
			text_addr->textbox_font_color = COLOR_BLACK;
			text_addr->textbox_attr.textbox_insert_pt_visible = FALSE;
			
			TextboxGetNumOfChars(TEXTBOX_WEEK_SETTINGS, &num_chars);
			text_addr->textbox_attr.textbox_highlight = FALSE;
			text_addr->textbox_highlight_start_char = 0;
			text_addr->textbox_highlight_end_char = num_chars;
			
			FormPopupForm(FORM_ANN_WEEK_SETTINGS);
		}
	}
}

/********************************************************
* Function:	ToDoListAppSave()
* Purpose: 	This function is called to save the data in 
*			the application when it is called to stopped
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
void AnnAppSave()
{	
	BYTE	*temp_field_buffer, *temp_textbox_buffer;
	SHORT	temp_month;
	
	AnnDatabaseChecking();
	
	if (DataRecordInfo(ann_dbid, ANN_STATUS, NULL, NULL, NULL, NULL, NULL) != TRUE)
		DataNewRecordWithID(ann_dbid, ANN_STATUS, 0, 1);
	if (DataRecordInfo(ann_dbid, ANN_EDIT_INFO, NULL, NULL, NULL, NULL, NULL) != TRUE)
		DataNewRecordWithID(ann_dbid, ANN_EDIT_INFO, 0, 36);
	
	DataWriteField(ann_dbid, ANN_STATUS, 0, 1, &restart_form);
	if (app_status.alarm_status == TONE_ALARM)
	{
		if (alarm_date == NO_ALARM_DATE)
		{
			app_status.alarm_status = NO_ALARM;
		}
	}
	
	/* Update the alarm date */
	if (alarm_set_by == ALARM_EXACT_DATE)
	{
		app_status.alarm_year = app_status.sch_year;
		app_status.alarm_month = app_status.sch_month;
		app_status.alarm_day = app_status.sch_day;
	}
	else if (alarm_set_by == ALARM_BEFORE_EXACT_DATE)
	{
		if (pressed_object1 != FORM_ANN_VIEWING)
		{
			app_status.alarm_year = app_status.sch_year;
			temp_month = app_status.sch_month -1;
			app_status.alarm_day = app_status.sch_day;
			
			
			RtcDaysShift((SHORT *)&app_status.alarm_year, &temp_month,(SHORT *)&app_status.alarm_day,-1);
			app_status.alarm_month = temp_month + 1;
		}
	}
	
	/* app_status */
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 0, 4, (BYTE*)&app_status.rec_id);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 1, 1, (BYTE*)&app_status.alarm_status);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 2, 2, (BYTE*)&app_status.sch_year);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 3, 2, (BYTE*)&app_status.sch_month);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 4, 2, (BYTE*)&app_status.sch_day);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 5, 2, (BYTE*)&app_status.alarm_year);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 6, 2, (BYTE*)&app_status.alarm_month);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 7, 2, (BYTE*)&app_status.alarm_day);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 8, 2, (BYTE*)&app_status.selected_year);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 9, 2, (BYTE*)&app_status.selected_month);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 10, 2, (BYTE*)&app_status.selected_day);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 11, 1, (BYTE*)&app_status.yearly_repeat);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 12, 1, (BYTE*)&app_status.edit_mode);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 13, 1, (BYTE*)&pressed_object1);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 14, 1, (BYTE*)&pressed_object2);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 15, 1, (BYTE*)&alarm_date);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 16, 1, (BYTE*)&sch_date);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 17, 1, (BYTE*)&week_click);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 20, 1, (BYTE*)&date_entry_method);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 30, 1, (BYTE*)&show_line);
	
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 21, 1, (BYTE*)&chk_status.alarm_status);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 22, 2, (BYTE*)&chk_status.sch_year);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 23, 2, (BYTE*)&chk_status.sch_month);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 24, 2, (BYTE*)&chk_status.sch_day);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 25, 2, (BYTE*)&chk_status.alarm_year);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 26, 2, (BYTE*)&chk_status.alarm_month);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 27, 2, (BYTE*)&chk_status.alarm_day);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 28, 1, (BYTE*)&app_status.yearly_repeat);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 29, 1, (BYTE*)&chk_status.field_change);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 31, 1, (BYTE*)&chk_status.new_entry_hit);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 32, 1, (BYTE*)&table_font);
	
	/* Save field buffer */
	if (ann_field_buffer[0] != NULL)
		qfree(ann_field_buffer[0]);
	
	if (restart_form == RESTART_ANN_NEW)
		FieldGetTextPointer(FIELD_ANN_NEW, &temp_field_buffer);
	else
		FieldGetTextPointer(FIELD_ANN_VIEWING, &temp_field_buffer);
	
	ann_field_buffer[0] = (BYTE*)qmalloc((strlen(temp_field_buffer) + 1)*sizeof(BYTE));
	strcpy(ann_field_buffer[0],temp_field_buffer);
	
	if (ann_field_buffer == NULL)
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 18, 1, (BYTE*)(""));
	else
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 18, (strlen(ann_field_buffer[0]) + 1), ann_field_buffer[0]);
	
	/* Save textbox buffer */
	if (ann_text_buffer[0] != 0)
		ann_text_buffer[0] = 0;
	
	TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &temp_textbox_buffer);
	if (temp_textbox_buffer == NULL)
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 19, 1, (BYTE*)(""));
	else
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 19, (strlen(temp_textbox_buffer) + 1), temp_textbox_buffer);
	
	if (restart_form == RESTART_ANN_VIEWING)
	{
		FieldGetTopLineNum(FIELD_ANN_VIEWING, &field_top_line);
		FieldGetInsertPointPosition(FIELD_ANN_VIEWING, &field_insert_pt_pos);
	}
	else if (restart_form == RESTART_ANN_NEW)
	{
		FieldGetTopLineNum(FIELD_ANN_NEW, &field_top_line);
		FieldGetInsertPointPosition(FIELD_ANN_NEW, &field_insert_pt_pos);
	}
	
	if (field_top_line < 0)
		field_top_line = 0;
	if (field_insert_pt_pos < 0)
		field_insert_pt_pos =0;
	
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 33, 4, (BYTE*)&field_top_line);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 34, 4, (BYTE*)&field_insert_pt_pos);
	DataWriteField(ann_dbid, ANN_EDIT_INFO, 35, 2, (BYTE*)&wset_week_num);
	DataCloseDB(ann_dbid);
}

/********************************************************
* Function:	AnnSetFontPageMonth
* Purpose: 	
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AnnSetFontPageMonth(USHORT sch_month, RecordID rec_id, Table *table_addr,
						 ObjectID cell_ui_id, USHORT max_rows_on_display)
{
	String		*string_addr;
	BYTE		object_type, buffer1[10];
	
	
	if (sch_month == 1)
		strcpy(buffer1, ANNJAN1);
	else if (sch_month == 2)
		strcpy(buffer1, ANNFEB1);
	else if (sch_month == 3)
		strcpy(buffer1, ANNMAR1);
	else if (sch_month == 4)
		strcpy(buffer1, ANNAPR1);
	else if (sch_month == 5)
		strcpy(buffer1, ANNMAY1);
	else if (sch_month == 6)
		strcpy(buffer1, ANNJUN1);
	else if (sch_month == 7)
		strcpy(buffer1, ANNJUL1);
	else if (sch_month == 8)
		strcpy(buffer1, ANNAUG1);
	else if (sch_month == 9)
		strcpy(buffer1,ANNSEP1);
	else if (sch_month == 10)
		strcpy(buffer1, ANNOCT1);
	else if (sch_month == 11)
		strcpy(buffer1, ANNNOV1);
	else if (sch_month == 12)
		strcpy(buffer1, ANNDEC1);
	
	FormGetObjectPointer(cell_ui_id, &object_type, (void **)&string_addr);
	string_addr->string_attr.string_visible = TRUE;
	string_addr->bounds.height = table_addr->table_row_height[1];
	
	if (max_rows_on_display == ANN_SFONT_NUM_OF_ROW)
	{
		string_addr->text_font = SMALL_FONT;
		string_addr->bounds.width = ANN_SCOLUMN_1;
	}
	else
	{
		string_addr->text_font = MEDIUM_FONT;
		string_addr->bounds.width = ANN_LCOLUMN_1;
	}
	
	StringSetText(cell_ui_id,buffer1);
	return;
}
/********************************************************
* Function:	AnnSetFontPageDate
* Purpose: 	
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AnnSetFontPageDate(USHORT sch_day, RecordID rec_id, Table *table_addr,
						ObjectID cell_ui_id, USHORT max_rows_on_display, USHORT check_entry)
{
	String		*string_addr;
	UWORD		byte_read;
	BYTE		*buffer, object_type, buffer1[10], *ptr;
	
	FormGetObjectPointer(cell_ui_id, &object_type, (void **)&string_addr);
	string_addr->string_attr.string_visible = TRUE;
	string_addr->bounds.height = table_addr->table_row_height[1];
	
	if (max_rows_on_display == ANN_SFONT_NUM_OF_ROW)
	{
		string_addr->text_font = SMALL_FONT;
		string_addr->bounds.width = ANN_SCOLUMN_2;
	}
	else
	{
		string_addr->text_font = MEDIUM_FONT;
		string_addr->bounds.width = ANN_LCOLUMN_2;
	}
	
	if (check_entry == 0)
	{
		DataGetField(ann_dbid, rec_id, 2, &buffer, &byte_read);
		buffer[0] = buffer[3];
		buffer[1] = buffer[4];
		buffer[2] = 0;
		StringSetText(cell_ui_id,buffer);
		qfree(buffer);
	}
	else
	{
		ptr = buffer1;
		
		if (sch_day < 10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr, "%d", sch_day);
		}
		else
			sprintf((char*)ptr, "%d", sch_day);
		
		StringSetText(cell_ui_id,buffer1);
	}
	return;
}

/********************************************************
* Function:	AnnTableDisplayDraw
* Purpose: 	This function is called to draw the content of
*			in the anntable_display to a table object
* Scope:	application
* Input:	anntable_display	table-display structure
*			dbid				DatabaseID
* Output:	None
* Return:	TRUE    handled
*			FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN AnnTableDisplayDraw(TableDisplay *table_display)
{
	ObjectID	cell_ui_id;
	RecordID	rec_id;
	Table		*table_addr;
	Bitmap		*bmp_addr;
	String		*string_addr;
	USHORT		total_num_rows, max_rows_on_display;
	USHORT		top_row_num, num_rows_to_display, erase_cell_num;
	USHORT		rec_nth_wday, rec_wday, rec_week_num, check_entry;
	UWORD		rec_num, byte_read;
	BYTE		*buffer, object_type;
	USHORT		sch_month, sch_day, count =0, cell =0;
	RecordIDBlock	*temp = table_display->record_id_block;
	RTM			pDate;
	CountrySettings country;
	
	SySetupGetCountrySettings(&country);	
	
	FormGetObjectPointer(TABLE_ANN_LIST, &object_type, (void **)&table_addr);
	
	AnnFindRoundOff(&anniver_list);
	
	total_num_rows = table_display->total_num_rows;
	top_row_num = table_display->top_row_num;
	/* Calculate maximum num of row can be display on screen */
	max_rows_on_display = table_addr->bounds.height / table_addr->table_row_height[1];
	
	if ((top_row_num + max_rows_on_display) <= total_num_rows)
		table_display->num_rows_displayed = max_rows_on_display;
	else 
		table_display->num_rows_displayed = total_num_rows - top_row_num;
	
	num_rows_to_display = table_display->num_rows_displayed;
	
	if (max_rows_on_display == ANN_SFONT_NUM_OF_ROW)
	{
		if (country.date_fmt == SYSETUP_DMY)
		{
			TableSetColumnWidth(TABLE_ANN_LIST, 0, ANN_SCOLUMN_2);
			TableSetColumnWidth(TABLE_ANN_LIST, 1, ANN_SCOLUMN_1);
		}
		else
		{
			TableSetColumnWidth(TABLE_ANN_LIST, 0, ANN_SCOLUMN_1);
			TableSetColumnWidth(TABLE_ANN_LIST, 1, ANN_SCOLUMN_2);
		}
	}
	else
	{
		if (country.date_fmt == SYSETUP_DMY)
		{
			TableSetColumnWidth(TABLE_ANN_LIST, 0, ANN_LCOLUMN_2);
			TableSetColumnWidth(TABLE_ANN_LIST, 1, ANN_LCOLUMN_1);
		}
		else
		{
			TableSetColumnWidth(TABLE_ANN_LIST, 0, ANN_LCOLUMN_1);
			TableSetColumnWidth(TABLE_ANN_LIST, 1, ANN_LCOLUMN_2);
		}
	}
	
	while (temp != NULL && num_rows_to_display > 0)
	{		
		if (top_row_num >= count && top_row_num < count + ANN_BLOCK_SIZE)
		{
			DataRecIDtoNum(ann_dbid, temp->record_id[top_row_num - count], &rec_num);
			DataOpenRecord(ann_dbid, rec_num, &rec_id, NULL);
			
			/* Check the specify schedule date is entried by date settings/week settings */
			DataGetField(ann_dbid, rec_id, 8, &buffer, &byte_read);
			check_entry = (USHORT)atol((const char *)buffer);
			qfree(buffer);
			
			if (check_entry == 0)
			{
				DataGetField(ann_dbid, rec_id, 2, &buffer, &byte_read);
				buffer[2] = 0;
				sch_month = (USHORT)atol((const char *)buffer);
				qfree(buffer);
			}
			else if (check_entry >= 1 && check_entry < 55)
			{				
				DataGetField(ann_dbid, rec_id, 7, &buffer, &byte_read);
				rec_wday = (USHORT)atol((const char *)buffer);
				qfree(buffer);
				
				DataGetField(ann_dbid, rec_id, 8, &buffer, &byte_read);
				rec_week_num = (USHORT)atol((const char *)buffer);
				qfree(buffer);
				
				/* Check Date No RoundOff */
				if (temp->round_off[top_row_num - count] == YEAR_FIND_BY_WEEK_NUMBER)
				{
#ifdef	PC_SIM
					valid_input = Dt_YWeek_Date (app_status.selected_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
					valid_input = Dt_YWeek_Date (app_status.selected_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
				}
				else if (temp->round_off[top_row_num - count] == YEAR_ROUNDUP_FROM_LAST_YEAR)
				{
#ifdef	PC_SIM
					Dt_YWeek_Date (app_status.selected_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
					Dt_YWeek_Date (app_status.selected_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
				}
				else if (temp->round_off[top_row_num - count] == YEAR_ROUNDUP_FROM_NEXT_YEAR)
				{
#ifdef	PC_SIM
					Dt_YWeek_Date (app_status.selected_year+1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
					Dt_YWeek_Date (app_status.selected_year+1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
				}
				else if (temp->round_off[top_row_num - count] == YEAR_FIND_BY_NEXT_YEAR_ROUNDUP)
					Dt_M7day_Date (app_status.selected_year, 11, -1, rec_wday, &pDate);
				
				sch_month = pDate.mon;
				sch_day = pDate.mday;
				sch_month++;
			}
			else
			{
				DataGetField(ann_dbid, rec_id, 6, &buffer, &byte_read);
				sch_month = (USHORT)atol((const char *)buffer);
				qfree(buffer);
				
				DataGetField(ann_dbid, rec_id, 7, &buffer, &byte_read);
				rec_wday = (USHORT)atol((const char *)buffer);
				qfree(buffer);
				
				DataGetField(ann_dbid, rec_id, 9, &buffer, &byte_read);
				rec_nth_wday = (USHORT)atol((const char *)buffer);
				qfree(buffer);
				
				if (rec_nth_wday == 6)
					Dt_M7day_Date(app_status.selected_year, (SHORT)sch_month-1, -1, rec_wday, &pDate);
				else
				{
					Dt_M7day_Date(app_status.selected_year, (SHORT)sch_month-1, rec_nth_wday, rec_wday, &pDate);
					
					if (sch_month-1 != pDate.mon)
						Dt_M7day_Date(app_status.selected_year, (SHORT)sch_month-1, -1, rec_wday, &pDate);
				}
				sch_day = pDate.mday;
			}
			
			if (temp->round_off[top_row_num - count] != YEAR_ROUNDUP)
			{
				if (country.date_fmt == SYSETUP_DMY)
				{
					/* Set the Schedule Day */
					cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
					AnnSetFontPageDate(sch_day, rec_id, table_addr, cell_ui_id, max_rows_on_display, check_entry);
					cell++;
					/* Set the Schedule Month */
					cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
					AnnSetFontPageMonth(sch_month, rec_id, table_addr, cell_ui_id, max_rows_on_display);
					cell++;
				}
				else
				{
					/* Set the Schedule Month */
					cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
					AnnSetFontPageMonth(sch_month, rec_id, table_addr, cell_ui_id, max_rows_on_display);
					cell++;
					/* Set the Schedule Day */
					cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
					AnnSetFontPageDate(sch_day, rec_id, table_addr, cell_ui_id, max_rows_on_display, check_entry);
					cell++;
				}
				/* Get the Text Contents */
				DataGetField(ann_dbid, rec_id, 1, &buffer, &byte_read);
				cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
				FormGetObjectPointer(cell_ui_id, &object_type, (void **)&string_addr);
				string_addr->string_attr.string_visible = TRUE;
				string_addr->bounds.height = table_addr->table_row_height[1];
				
				if (max_rows_on_display == ANN_SFONT_NUM_OF_ROW)
				{
					string_addr->text_font = SMALL_FONT;
					string_addr->bounds.width = ANN_SCOLUMN_3;
				}
				else
				{
					string_addr->text_font = MEDIUM_FONT;
					string_addr->bounds.width = ANN_LCOLUMN_3;
				}
				
				if (byte_read > MAX_TEXT_ON_DISPLAY)
					buffer[MAX_TEXT_ON_DISPLAY] = '\0';
				
				StringSetText(cell_ui_id,buffer);
				qfree(buffer);
				cell++;
				
				/* Get the Alarm Status */
				DataGetField(ann_dbid, rec_id, 0, &buffer, &byte_read);
				cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
				if (UISearchForAddress(cell_ui_id,&object_type,(void**)&bmp_addr) != TRUE) return ERR_UI_RES_NOT_FOUND;
				FormGetObjectPointer(cell_ui_id, &object_type, (void **)&bmp_addr);
				if (*buffer == TONE_ALARM)
				{
					bmp_addr->bitmap_attr.bitmap_enable = FALSE;
					bmp_addr->bitmap_attr.bitmap_visible = TRUE;
					bmp_addr->bitmap_attr.bitmap_active = TRUE;
				}
				else
				{
					bmp_addr->bitmap_attr.bitmap_enable = FALSE;
					bmp_addr->bitmap_attr.bitmap_visible = FALSE;
					bmp_addr->bitmap_attr.bitmap_active = FALSE;
				}
				qfree(buffer);
				cell++;
			}
			/* For Next Record */
			top_row_num++;
			num_rows_to_display--;
			DataCloseRecord(ann_dbid, rec_id);
		}
		else
		{
			count += ANN_BLOCK_SIZE;
			temp = temp->next;
		}
	}
	
	if (max_rows_on_display == ANN_SFONT_NUM_OF_ROW)
		erase_cell_num = ANN_SFONT_NUM_OF_CELL;
	else
		erase_cell_num = ANN_LFONT_NUM_OF_CELL;
	
	while(cell < erase_cell_num)
	{
		/* Disable column 0 */
		cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
		if (UISearchForAddress(cell_ui_id,&object_type,(void**)&string_addr) != TRUE)return ERR_UI_RES_NOT_FOUND;
		string_addr->string_attr.string_visible = FALSE;
		cell++;
		/* Disable column 1 */
		cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
		if (UISearchForAddress(cell_ui_id,&object_type,(void**)&string_addr) != TRUE)return ERR_UI_RES_NOT_FOUND;
		string_addr->string_attr.string_visible = FALSE;
		cell++;
		/* Disable column 2 */
		cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
		if (UISearchForAddress(cell_ui_id,&object_type,(void**)&string_addr) != TRUE)return ERR_UI_RES_NOT_FOUND;
		string_addr->string_attr.string_visible = FALSE;
		cell++;
		/* Disable column 4 */
		cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
		if (UISearchForAddress(cell_ui_id,&object_type,(void**)&bmp_addr) != TRUE) return ERR_UI_RES_NOT_FOUND;
		bmp_addr->bitmap_attr.bitmap_enable = FALSE;
		bmp_addr->bitmap_attr.bitmap_visible = FALSE;
		bmp_addr->bitmap_attr.bitmap_active = FALSE;
		cell++;
	}
	
	/* Update the years bar */
	if (view_records != TRUE)
		AnnYearSettingUpdate(&app_status.selected_year, FORM_ANN_LIST);
	
	TableSetTopRowNum(table_display->table_id, 0);
	/* Number of rows displayed equals to Total number of rows */
	table_addr->table_num_row_display = table_display->num_rows_displayed;
	///	table_addr->table_num_row = table_display->num_rows_displayed;
	return TRUE;
}

/********************************************************
* Function:	ToDoRecordToList
* Purpose: 	This function is used to show the correct records to 
*			the table objects in the TO DO LIST page of the application
* Scope:	application
* Input:	dbid			The database ID
*			starting_char	The starting character
*			starting_string	
* Output:	None
* Return:	TRUE		Complete
*			FALSE		Error
* Comment: 	The table object must be initialised first
*			The database must be opened first
*			The function will update the scrollbar too
**********************************************************/
void AnnRecordToTable(DatabaseID dbid)
{
	RecordID	rec_id;
	BYTE		*buffer1, *buffer2, *buffer3, *buffer4, object_type;
	BYTE		year_buffer[10], month_buffer[10], day_buffer[10];
	UWORD		top_record, rec_num, byte_read, total_num_rec, i, display_count= 0;
	SHORT		rec_year, rec_month, rec_day, check_roundoff;
	USHORT		rec_nth_wday, rec_wday, rec_week_num, check_entry;
	BOOLEAN		check_valid, date_exist, allow_added_record;
	Table		*table_addr;
	RTM			pDate;
	CountrySettings	country;
	
	USHORT		return_val; 
	
	SySetupGetCountrySettings(&country);
	DataCloseDB(ann_dbid);
#ifdef	PR31700
	DataOpenDB(ann_dbid, SORT_TEXT_MODE | 2, OPEN_RW);
#else
	DataOpenDB(ann_dbid, 2, OPEN_RW);
#endif
	
	TableDisplayDeleteAllRecordID(&anniver_list);
	DataTotalRecord(ann_dbid, &total_num_rec);
	
	if (total_num_rec != 0)
	{
		for (i=0; i <total_num_rec; i++)
		{
			DataOpenRecord(ann_dbid, i, &rec_id, NULL);
			DataGetField(ann_dbid, rec_id, 4, &buffer1, &byte_read);
			/* Check to see the specify schedule date is entried by date settings or week settings */
			byte_read = 0;
			DataGetField(ann_dbid, rec_id, 8, &buffer3, &byte_read);
			check_entry = (USHORT)atol((const char *)buffer3);
			qfree(buffer3);
			/* Use Extract Date */
			if (check_entry == 0)
			{				
				DataGetField(ann_dbid, rec_id, 2, &buffer2, &byte_read);
				year_buffer[0] = buffer2[6];
				year_buffer[1] = buffer2[7];
				year_buffer[2] = buffer2[8];
				year_buffer[3] = buffer2[9];
				year_buffer[4] = 0;
				rec_year = (SHORT)atol((const char *)year_buffer);
				
				month_buffer[0] = buffer2[0];
				month_buffer[1] = buffer2[1];
				month_buffer[2] = 0;
				rec_month = (SHORT)atol((const char *)month_buffer);
				
				day_buffer[0] = buffer2[3];
				day_buffer[1] = buffer2[4];
				day_buffer[2] = 0;
				
				rec_day = (SHORT)atol((const char *)day_buffer);
				qfree(buffer2);
				
				if (select_goto)
					if (*buffer1 == YEARLY_REPEAT)
					{
						if (rec_year <= app_status.selected_year)
							rec_year = app_status.selected_year;
					}
			}
			else if (check_entry >= 1 && check_entry < 55)
			{
				DataGetField(ann_dbid, rec_id, 2, &buffer2, &byte_read);
				year_buffer[0] = buffer2[6];
				year_buffer[1] = buffer2[7];
				year_buffer[2] = buffer2[8];
				year_buffer[3] = buffer2[9];
				year_buffer[4] = 0;
				rec_year = (SHORT)atol((const char *)year_buffer);
				
				if (rec_year <= app_status.selected_year)
				{
					Dt_Date_YWeek (app_status.sch_year, app_status.sch_month-1, app_status.sch_day, country.start_of_week, &check_roundoff);
					
					if (select_goto)
						if (*buffer1 == YEARLY_REPEAT)
							rec_year = app_status.selected_year;
						
						/* Check Date No RoundOff */
						if (check_roundoff == app_status.sch_year)
						{
							// -------------------------------------------------------------------
							// modified at 18/07/2000
							if (*buffer1 == YEARLY_REPEAT)
								rec_year = app_status.selected_year;
							else
								rec_year = app_status.sch_year;
							
							// -------------------------------------------------------------------
							DataGetField(ann_dbid, rec_id, 7, &buffer4, &byte_read);
							rec_wday = (USHORT)atol((const char *)buffer4);
							qfree(buffer4);
							
							DataGetField(ann_dbid, rec_id, 8, &buffer4, &byte_read);
							rec_week_num = (USHORT)atol((const char *)buffer4);
							qfree(buffer4);
							check_valid = Dt_YWeek_Date ((SHORT)rec_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
							
							/* Check if first belong to year before */
							if (check_valid == OUT_OF_YEAR_BOUNDARY && rec_week_num == 1)
							{
								Dt_YWeek_Date ((SHORT)rec_year, (SHORT)rec_week_num+1, (SHORT)rec_wday, country.start_of_week, &pDate);
								rec_year = pDate.year;
							}
							rec_month = pDate.mon;
							rec_day = pDate.mday;
							rec_month++;
						}
				}
				else
				{
					DataGetField(ann_dbid, rec_id, 2, &buffer2, &byte_read);
					year_buffer[0] = buffer2[6];
					year_buffer[1] = buffer2[7];
					year_buffer[2] = buffer2[8];
					year_buffer[3] = buffer2[9];
					year_buffer[4] = 0;
					rec_year = (SHORT)atol((const char *)year_buffer);
					
					month_buffer[0] = buffer2[0];
					month_buffer[1] = buffer2[1];
					month_buffer[2] = 0;
					rec_month = (SHORT)atol((const char *)month_buffer);
					
					day_buffer[0] = buffer2[3];
					day_buffer[1] = buffer2[4];
					day_buffer[2] = 0;
					rec_day = (SHORT)atol((const char *)day_buffer);
					qfree(buffer2);
				}
			}
			else
			{
				rec_year = app_status.selected_year;
				
				DataGetField(ann_dbid, rec_id, 6, &buffer4, &byte_read);
				rec_month = (SHORT)atol((const char *)buffer4);
				qfree(buffer4);
				
				DataGetField(ann_dbid, rec_id, 7, &buffer4, &byte_read);
				rec_wday = (USHORT)atol((const char *)buffer4);
				qfree(buffer4);
				
				DataGetField(ann_dbid, rec_id, 9, &buffer4, &byte_read);
				rec_nth_wday = (USHORT)atol((const char *)buffer4);
				qfree(buffer4);
				
				if (wset_nth_wday == 6)
					Dt_M7day_Date ((SHORT)rec_year, (SHORT)rec_month-1, -1, rec_wday, &pDate);
				else
				{
					Dt_M7day_Date ((SHORT)rec_year, (SHORT)rec_month-1, rec_nth_wday, rec_wday, &pDate);
					
					if (rec_month-1 != pDate.mon)
						Dt_M7day_Date ((SHORT)rec_year, (SHORT)rec_month-1, -1, rec_wday, &pDate);
				}
				
				rec_day = pDate.mday;
				
				DataGetField(ann_dbid, rec_id, 2, &buffer2, &byte_read);
				year_buffer[0] = buffer2[6];
				year_buffer[1] = buffer2[7];
				year_buffer[2] = buffer2[8];
				year_buffer[3] = buffer2[9];
				year_buffer[4] = 0;
				rec_year = (SHORT)atol((const char *)year_buffer);
				if (select_goto)
				{
					if (*buffer1 == YEARLY_REPEAT)
						if (rec_year <= app_status.selected_year)
							rec_year = app_status.selected_year;
				}
				
			}
			
			if ((select_goto == FALSE && ((*buffer1 == YEARLY_REPEAT && app_status.selected_year >= rec_year)||
				(*buffer1 != YEARLY_REPEAT && rec_year == app_status.selected_year)))||
				(select_goto == TRUE && rec_year == app_status.selected_year && rec_month == app_status.selected_month &&
				rec_day == app_status.selected_day))
			{
				/* Test the specify date is exist or not e.g 29-02-XXXX */
				if (select_goto == FALSE)
				{
					date_exist = RtcCheckYMDValid(app_status.selected_year, rec_month-1, rec_day);
				}
				else
					date_exist = TRUE;
				
				/* Test the specify date is exist or not e.g 01-01-XXXX */
				if (check_entry >= 1 && check_entry < 55)
				{
					return_val = ToDoAnnFindDate(app_status.selected_year, rec_id);
					
					if (return_val != YEAR_ROUNDUP)
						allow_added_record = TRUE;
					else
						allow_added_record = FALSE;
				}
				else
					allow_added_record = TRUE;
				
				if (date_exist == TRUE && allow_added_record == TRUE)
				{
					TableDisplayInsertRecordID(&anniver_list, rec_id, ann_dbid, FALSE);
					display_count++;
				}
			}
			
			DataCloseRecord(ann_dbid,rec_id);
			qfree(buffer1);
		}
		
		if (app_status.rec_id != 0)
		{
			DataRecIDtoNum(ann_dbid, app_status.rec_id, &rec_num);
			
			if (display_count < ANN_NUM_OF_ROW)
				top_record = 0;
			else
			{	/* If the record place in the last page */
				if ((rec_num+1) + ANN_NUM_OF_ROW > display_count)
					top_record = display_count - ANN_NUM_OF_ROW;
				else
					top_record = rec_num;
			}
		}
		else top_record = 0;
		
		if (select_goto == TRUE && anniver_list.total_num_rows == 0)
			return;
		else
			AnnSetTableTopRowNum(top_record);
	}
	else
	{
		if (view_records != TRUE)
			AnnYearSettingUpdate(&app_status.selected_year, FORM_ANN_LIST);
		
		FormGetObjectPointer(TABLE_ANN_LIST, &object_type, (void **)&table_addr);
		table_addr->table_attr.table_visible = FALSE;
		ScrollbarSetScrollbarVisible(SCROLLBAR_ANN_LIST,FALSE);
		ScrollbarEraseScrollbar(SCROLLBAR_ANN_LIST);
	}
}

/********************************************************
* Function:	TableDisplayDelete
* Purpose: 	This function is called in order to insert a record ID	
* Scope:	application
* Input:	table_display	table_display structure
*			record_id		record_id being inserted
* Output:	None
* Return:	TRUE    handled
*			FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN TableDisplayDeleteAllRecordID(TableDisplay *table_display)
{
	RecordIDBlock *temp = table_display->record_id_block;
	RecordIDBlock *temp1 = NULL;
	
	if (temp != NULL)
	{
		temp1 = temp->next;
		if (temp1 == NULL)
		{
			qfree(temp);
			table_display->num_rows_displayed = 0;
			table_display->total_num_rows = 0;
			table_display->top_row_num = 0;
			table_display->record_id_block = NULL;
			return TRUE;
		}
		while (temp1 != NULL)
		{
			qfree(temp);
			temp = temp1;
			temp1 = temp->next;
		}
		if (temp1 == NULL)
			qfree(temp);
	}
	table_display->num_rows_displayed = 0;
	table_display->total_num_rows = 0;
	table_display->top_row_num = 0;
	table_display->record_id_block = NULL;
	return TRUE;
}

/********************************************************
* Function:	TableDisplayInsertRecordID
* Purpose: 	This function is called in order to insert a record ID
*			to the Table Display	
* Scope:	application
* Input:	table_display	table_display structure
*			record_id		record_id being inserted
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void TableDisplayInsertRecordID(TableDisplay *table_display, RecordID record_id, DatabaseID dbid, USHORT write_roundoff)
{
	USHORT i;
	BOOLEAN create = FALSE;
	RecordIDBlock *temp;
	
	if (table_display->record_id_block == NULL)
	{
		table_display->record_id_block = (RecordIDBlock*)qmalloc(sizeof(RecordIDBlock));
		temp = table_display->record_id_block;
		create = TRUE;
	}
	else
	{
		temp = table_display->record_id_block;
		
		while (temp != NULL)
		{	/* if the current block is full, create another one and pointer to the new block */
			if (temp->num_records != ANN_BLOCK_SIZE)
				break;
			if (temp->next == NULL)
			{	
				create = TRUE;
				temp ->next = (RecordIDBlock*)qmalloc(sizeof(RecordIDBlock));
				temp = temp->next;
				break;
			}
			else temp = temp->next;
		}
	}
	
	if (create == TRUE)
	{
		temp->next = NULL;
		temp->num_records = 0;
		for (i = 0; i<20; i++)
			temp->record_id[i] = 0;
	}	
	temp->num_records++;
	table_display->total_num_rows++;
	temp->record_id[temp->num_records - 1] = record_id;
	temp->dbid[temp->num_records -1] = dbid;
	
	if (write_roundoff == YEAR_ROUNDUP_FROM_LAST_YEAR)
		temp->round_off[temp->num_records - 1] = FALSE;
	else if (write_roundoff == YEAR_ROUNDUP_FROM_NEXT_YEAR)
		temp->round_off[temp->num_records - 1] = YEAR_ROUNDUP_FROM_NEXT_YEAR;
}

/******************************************************************
* Function:	AnnChangeUpdateRecord
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnChangeUpdateRecord()
{
	UWORD	rec_num;
	SHORT	ann_week;
	BYTE	temp_buffer[10];
	
	DataRecIDtoNum(ann_dbid, app_status.rec_id, &rec_num);
	DataOpenRecord(ann_dbid, rec_num, &app_status.rec_id, NULL);
	/* Write Field 0 of To Do List Record */
	DataWriteField(ann_dbid,app_status.rec_id,0,1,&app_status.alarm_status);
	/* Write Field 2 of To Do List Record */
	AnnDateUpdateRecord(app_status.sch_year, app_status.sch_month, app_status.sch_day, 2);
	/* Write Field 3 of To Do List Record */
	AnnDateUpdateRecord(app_status.alarm_year, app_status.alarm_month, app_status.alarm_day, 3);
	/* Write Field 4 of To Do List Record */
	DataWriteField(ann_dbid,app_status.rec_id,4,1,&app_status.yearly_repeat);
	/* Write Field 5 of To Do List Record */
	sprintf((char*)temp_buffer,"%d",app_status.sch_year);
	DataWriteField(ann_dbid,app_status.rec_id,5,(strlen(temp_buffer)+1),temp_buffer);
	/* Write Field 6 of To Do List Record */
	sprintf((char*)temp_buffer,"%d",app_status.sch_month);
	DataWriteField(ann_dbid,app_status.rec_id,6,(strlen(temp_buffer)+1),temp_buffer);
	/* Write Field 7 of To Do List Record */
	sprintf((char*)temp_buffer,"%d",wset_wday);
	DataWriteField(ann_dbid,app_status.rec_id,7,(strlen(temp_buffer)+1),temp_buffer);
	
	/* Write Field 8 of To Do List Record */
	if (date_entry_method == 0)
		ann_week = 0;
	else if (date_entry_method == 1)
		ann_week = wset_week_num;
	else
		ann_week = 63;
	sprintf((char*)temp_buffer,"%d",ann_week);
	DataWriteField(ann_dbid,app_status.rec_id,8,(strlen(temp_buffer)+1),temp_buffer);
	/* Write Field 9 of To Do List Record */
	sprintf((char*)temp_buffer,"%d",wset_nth_wday);
	DataWriteField(ann_dbid,app_status.rec_id,9,(strlen(temp_buffer)+1),temp_buffer);
	/* Write Field 10 of To Do List Record */
	DataWriteField(ann_dbid, app_status.rec_id, 10, 1, &alarm_date);
	/* Write Field 11 of To Do List Record */
	DataWriteField(ann_dbid,app_status.rec_id,11,2,(BYTE *)&app_status.input_year);
	
	AnnSetAllRecordsAlarm(FALSE);
	/* Close Record */
	DataCloseRecord(ann_dbid,app_status.rec_id);
}

/******************************************************************
* Function:	AnnDateUpdateRecord
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnDateUpdateRecord(SHORT new_year, SHORT new_month, SHORT new_day, USHORT field_num)
{	
	BYTE	schedule_date[11];
	BYTE	*ptr = schedule_date;
	
	if (field_num == 2)
	{
		/* Load month to buffer */
		if (new_month < 10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",new_month);
			ptr++;
		}
		else
		{
			sprintf((char*)ptr,"%d",new_month);
			ptr += 2;
		}
		*(ptr++) = '/';
		/* Load day to buffer */
		if (new_day < 10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",new_day);
			ptr++;
		}
		else
		{
			sprintf((char*)ptr,"%d",new_day);
			ptr += 2;
		}
		*(ptr++) = '/';
		/* Load year to buffer */
		sprintf((char*)ptr,"%d",new_year);
	}
	else
	{
		/* Load year to buffer */
		sprintf((char*)ptr,"%d",new_year);
		ptr += 4;
		*(ptr++) = '/';
		/* Load month to buffer */
		if (new_month < 10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",new_month);
			ptr++;
		}
		else
		{
			sprintf((char*)ptr,"%d",new_month);
			ptr += 2;
		}
		*(ptr++) = '/';
		/* Load day to buffer */
		if (new_day < 10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",new_day);
		}
		else
			sprintf((char*)ptr,"%d",new_day);
	}
	DataWriteField(ann_dbid, app_status.rec_id, field_num, (strlen(schedule_date) + 1), schedule_date);
}

/********************************************************
* Function:	AnnDatabaseInit
* Purpose: 	This function is used to simulate and initialse the 
*			the datebase in the PDA.Try to preset some records in 
*			the database
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	This function should be called in the StartApplication() function.
*********************************************************/
void AnnDatabaseInit()
{
#ifdef	xxxxxxxxxxxxxxxxxxx
	RecordID rec_id;
	SHORT i;
	
	BYTE alarm_status[1];
	BYTE yearly_repeat[1];
	BYTE *ann_contents[1];
	BYTE *schedule_date[1];
	BYTE *alarm_date[1];
	BYTE *set_wday[1];
	BYTE *set_week_num[1];
	BYTE temp_buffer[1];
	
	for (i = 0; i <1; i++)
	{
		alarm_status[i] = TONE_ALARM;
		yearly_repeat[i] = YEARLY_REPEAT;
		temp_buffer[i] = 0;
	}
	
	for (i = 0; i <1; i++)
	{	
		ann_contents[i] = (BYTE*)qmalloc(500*sizeof(BYTE));
		schedule_date[i]  = (BYTE*)qmalloc(16*sizeof(BYTE));
		alarm_date[i]  = (BYTE*)qmalloc(16*sizeof(BYTE));
		set_wday[i]  = (BYTE*)qmalloc(5*sizeof(BYTE));
		set_week_num[i]  = (BYTE*)qmalloc(5*sizeof(BYTE));
	}
	
	strcpy(ann_contents[0], ANNSTR2);
	strcpy(schedule_date[0],"01/01/2000");
	strcpy(alarm_date[0],"1999/12/31");
	strcpy(set_wday[0],"6");
	strcpy(set_week_num[0],"52");
	
	/* New Database */
	DataNewDB(ANNDB, 1, ANNAPP, &ann_dbid);
	/* Open Database and sort by schedule date */
#ifdef	PR31700
	DataOpenDB(ann_dbid,SORT_TEXT_MODE | 2,OPEN_RW);
#else
	DataOpenDB(ann_dbid,2,OPEN_RW);
#endif
	/* Open Database */
	for (i= 0;i<1;i++)
	{
		DataNewRecord(ann_dbid, 0x00, ANN_NUM_FIELD, &rec_id);
		DataWriteField(ann_dbid,rec_id,0,1,(BYTE*) &alarm_status[i]);
		DataWriteField(ann_dbid,rec_id,1,(strlen(ann_contents[i]) + 1),ann_contents[i]);
		DataWriteField(ann_dbid,rec_id,2,(strlen(schedule_date[i]) + 1),schedule_date[i]);
		DataWriteField(ann_dbid,rec_id,3,(strlen(alarm_date[i]) + 1),alarm_date[i]);
		DataWriteField(ann_dbid,rec_id,4,1,(BYTE*) &yearly_repeat[i]);
		DataWriteField(ann_dbid,rec_id,5,1,(BYTE*) &temp_buffer[i]);
		DataWriteField(ann_dbid,rec_id,6,1,(BYTE*) &temp_buffer[i]);
		DataWriteField(ann_dbid,rec_id,7,(strlen(set_wday[i]) + 1),set_wday[i]);
		DataWriteField(ann_dbid,rec_id,8,(strlen(set_week_num[i]) + 1),set_week_num[i]);
		DataWriteField(ann_dbid,rec_id,9,1,(BYTE*) &temp_buffer[i]);
		DataWriteField(ann_dbid,rec_id,10,1,(BYTE*) &temp_buffer[i]);
		DataCloseRecord(ann_dbid,rec_id);
	}
	for (i= 0; i <1; i++)
	{
		qfree(ann_contents[i]);
		qfree(schedule_date[i]);
		qfree(alarm_date[i]);
		qfree(set_wday[i]);
		qfree(set_week_num[i]);
	}
#endif
}

/********************************************************
* Function:	AnnSetAllRecordsAlarm()
* Purpose: 	This function is called to set up the alarm 
*			manager
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
void AnnSetAllRecordsAlarm(UWORD rec_num)
{
	RecordID	rec_id;
	UWORD		byte_read, total_num_rec;
	BYTE		*alarm_buffer, alarm_date[11];
	BYTE		*text_buffer, *alarm_type, *repeat_alarm;
	AlarmEvent 	alarm_evt;
	AppID		app_id;
	
	app_id = SysGetActiveAppID();
	DataCloseDB(ann_dbid);
	DataOpenDB(ann_dbid, SORT_TEXT_MODE | 3, OPEN_RW);
	DataTotalRecord(ann_dbid, &total_num_rec);
	
	AlarmDelAppEvent(app_id);
	while (rec_num < total_num_rec)
	{
		DataOpenRecord(ann_dbid, rec_num, &rec_id, NULL);
		DataGetField(ann_dbid, rec_id, 0, &alarm_type, &byte_read);
		if (*alarm_type == TONE_ALARM)
		{
			DataGetField(ann_dbid, rec_id, 3, &alarm_buffer, &byte_read);
			strcpy(alarm_date, alarm_buffer);
			alarm_date[0] = alarm_date[0];
			alarm_date[1] = alarm_date[1];
			alarm_date[2] = alarm_date[2];
			alarm_date[3] = alarm_date[3];
			alarm_date[4] = 0;
			alarm_evt.hit_time.year = (SHORT)atol((const char *)alarm_date);
			
			strcpy(alarm_date, alarm_buffer);
			alarm_date[0] = alarm_date[5];
			alarm_date[1] = alarm_date[6];
			alarm_date[2] = 0;
			alarm_evt.hit_time.mon = (SHORT)atol((const char *)alarm_date) - 1;
			
			strcpy(alarm_date, alarm_buffer);
			alarm_date[0] = alarm_date[8];
			alarm_date[1] = alarm_date[9];
			alarm_date[2] = 0;
			alarm_evt.hit_time.mday = (SHORT)atol((const char *)alarm_date);
			
			if (AnnCompareAlarmDay(alarm_evt.hit_time.year, alarm_evt.hit_time.mon,
				alarm_evt.hit_time.mday) == TRUE)
			{
				alarm_evt.app = app_id;
				alarm_evt.rec_id = rec_id;
				alarm_evt.reference = 0;
				
				AlarmSetEventType(&alarm_evt, 0);
				AlarmSetEventClass(&alarm_evt, ALARM_ONDAY);
				
				DataGetField(ann_dbid, rec_id, 1, &text_buffer, &byte_read);
				if (byte_read >= ANN_ALARM_MAX_TEXT)
					text_buffer[200] = 0;
				alarm_evt.alert_msg = text_buffer;
				alarm_evt.extra_info = NULL;
				AlarmAddEvent(alarm_evt);
			}
			else
			{
				rec_num++;
				qfree(alarm_type);
				continue;
			}
		}
		rec_num++;
		qfree(alarm_type);
	}
	DataCloseDB(ann_dbid);
}

/********************************************************
* Function:	ToDoDelAnAlarm()
* Purpose: 	This function is called to del an alarm 
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
void AnnDelAnAlarm()
{
	AlarmEvent 	alarm_evt;
	AppID		app_id;
	
	
	app_id = SysGetActiveAppID();
	alarm_evt.app = app_id;
	alarm_evt.reference = 0;
	AlarmSetEventType(&alarm_evt, 0);
	AlarmSetEventClass(&alarm_evt, ALARM_ONDAY);
	
	alarm_evt.rec_id = app_status.rec_id;
	AlarmDelEvent(alarm_evt);
}

/********************************************************
* Function:	AnnSetNextRecordAlarm()
* Purpose: 	This function is called to set up the alarm 
*			manager
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
void AnnSetNextRecordAlarm(RecordID alarmhit_rec_id)
{
	RecordID	rec_id, *record_table;
	BYTE		*buffer, *repeat_buffer, alarm_date_check;
	BYTE		*alarm_buffer, alarm_date[11], backup_buffer[11], new_alarm_status;
	BYTE		year_buffer[10], month_buffer[10], day_buffer[10];
	BOOLEAN		valid_input, date_exist;
	UWORD		byte_read, rec_num, hit_rec_num,total_num_rec;
	USHORT		rec_nth_wday, rec_wday, rec_week_num, check_entry;
	USHORT		alarm_current_year, alarm_next_year, alarm_next_month, alarm_next_day, rec_count;
	SHORT		find_year, find_month, find_day, check_roundoff;
	Err		result;
	CountrySettings	country;
	RTM		pDate;
	RTM		time;
	
	
	SySetupGetCountrySettings(&country);
	DataCloseDB(ann_dbid);
#ifdef	PR31700		
	DataOpenDB(ann_dbid, SORT_TEXT_MODE | 3, OPEN_RW);
#else
	DataOpenDB(ann_dbid, 3, OPEN_RW);
#endif
	DataTotalRecord(ann_dbid, &total_num_rec);
	
	if (DataRecIDtoNum(ann_dbid, alarmhit_rec_id, &rec_num) != ERR_DATA_INV_RECID)
	{
		hit_rec_num = rec_num;
		
		/* Update the current alarm */	
#ifdef	PR31700
		DataOpenDB(ann_dbid, SORT_TEXT_MODE | 3, OPEN_RW);
#else
		DataOpenDB(ann_dbid, 3, OPEN_RW);
#endif
		
		result = DataOpenRecord(ann_dbid, hit_rec_num, &rec_id, NULL);
		result = DataGetField(ann_dbid, rec_id, 4, &repeat_buffer, &byte_read);
		
		if (*repeat_buffer == NO_REPEAT)
		{
			new_alarm_status = NO_ALARM;
			DataWriteField(ann_dbid, rec_id, 0, 1, &new_alarm_status);
		}
		else	/* Here need to check the edit mode and update new alarm year/month/day */
		{
			RtcGetTime(&time);
			
			DataGetField(ann_dbid, rec_id, 8, &buffer, &byte_read);
			check_entry = (USHORT)atol((const char *)buffer);
			qfree(buffer);
			
			/* Calc Next Alarm Year */
			DataGetField(ann_dbid, rec_id, 3, &alarm_buffer, &byte_read);
			strcpy(backup_buffer, alarm_buffer);
			strcpy(alarm_date, alarm_buffer);
			alarm_date[0] = alarm_date[0];
			alarm_date[1] = alarm_date[1];
			alarm_date[2] = alarm_date[2];
			alarm_date[3] = alarm_date[3];
			alarm_date[4] = 0;
			alarm_current_year = (SHORT)atol((const char *)alarm_date);
			
			strcpy(alarm_date, alarm_buffer);
			alarm_date[0] = alarm_date[5];
			alarm_date[1] = alarm_date[6];
			alarm_date[2] = 0;
			alarm_next_month = (SHORT)atol((const char *)alarm_date);
			strcpy(alarm_date, alarm_buffer);
			alarm_date[0] = alarm_date[8];
			alarm_date[1] = alarm_date[9];
			alarm_date[2] = 0;
			alarm_next_day = (SHORT)atol((const char *)alarm_date);
			/* Alarm Date early than Current Time */
			if(time.year >= alarm_current_year + 1)
			{
				if(time.mon >= alarm_next_month-1)
				{
					if(time.mon > alarm_next_month-1)
						alarm_next_year = time.year + 1;
					else
					{
						if(time.mday >= alarm_next_day)
							alarm_next_year = time.year + 1;
						else
							alarm_next_year = time.year;
					}
				}
				else
					alarm_next_year = time.year;
			}
			else
				alarm_next_year = alarm_current_year + 1;
			
			if (check_entry == 0)
			{
				DataGetField(ann_dbid, rec_id, 10, &buffer, &byte_read);
				alarm_date_check = (USHORT)atol((const char *)buffer);
				qfree(buffer);
				if (alarm_date_check == ALARM_EXACT_DATE)
				{
					valid_input = TRUE;
				}
				else
				{
					DataGetField(ann_dbid, rec_id, 2, &buffer, &byte_read);
					year_buffer[0] = buffer[6];
					year_buffer[1] = buffer[7];
					year_buffer[2] = buffer[8];
					year_buffer[3] = buffer[9];
					year_buffer[4] = 0;
					find_year = (SHORT)atol((const char *)year_buffer);
					
					month_buffer[0] = buffer[0];
					month_buffer[1] = buffer[1];
					month_buffer[2] = 0;
					find_month = (SHORT)atol((const char *)month_buffer);
					
					day_buffer[0] = buffer[3];
					day_buffer[1] = buffer[4];
					day_buffer[2] = 0;
					find_day = (SHORT)atol((const char *)day_buffer);
					qfree(buffer);
#ifdef	PC_SIM
					Dt_Date_YWeek (find_year, 0, 1, 0, &check_roundoff);
#else
					Dt_Date_YWeek (find_year, 0, 1, country.start_of_week, &check_roundoff);
#endif
					/* Check Date No RoundOff */
					if (check_roundoff >= find_year)
					{
						valid_input = TRUE;
					}
					else
					{
						DataGetField(ann_dbid, rec_id, 7, &buffer, &byte_read);
						rec_wday = (USHORT)atol((const char *)buffer);
						qfree(buffer);
						DataGetField(ann_dbid, rec_id, 8, &buffer, &byte_read);
						rec_week_num = (USHORT)atol((const char *)buffer);
						qfree(buffer);
#ifdef	PC_SIM
						Dt_YWeek_Date (alarm_next_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
						Dt_YWeek_Date (alarm_next_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
						alarm_next_month = pDate.mon;
						alarm_next_day = pDate.mday;
						RtcDaysShift((SHORT *)&alarm_next_year, (SHORT *)&alarm_next_month,(SHORT *)&alarm_next_day,-1);
						alarm_next_month++;
						
						valid_input = TRUE;
					}
				}
			}
			else if (check_entry >= 1 && check_entry < 55)
			{
				result = DataGetField(ann_dbid, rec_id, 10, &buffer, &byte_read);
				alarm_date_check = *buffer;
				qfree(buffer);
				
				DataGetField(ann_dbid, rec_id, 7, &buffer, &byte_read);
				rec_wday = (USHORT)atol((const char *)buffer);
				qfree(buffer);
				
				DataGetField(ann_dbid, rec_id, 8, &buffer, &byte_read);
				rec_week_num = (USHORT)atol((const char *)buffer);
				qfree(buffer);
				
				valid_input = Dt_YWeek_Date (alarm_next_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
				alarm_next_month = pDate.mon;
				alarm_next_day = pDate.mday;
				if (alarm_date_check == ALARM_EXACT_DATE)
					alarm_next_month++;
				else
				{
					RtcDaysShift((SHORT *)&alarm_next_year, (SHORT *)&alarm_next_month,(SHORT *)&alarm_next_day,-1);
					alarm_next_month++;
					valid_input = TRUE;
				}
			}
			else
			{
				DataGetField(ann_dbid, rec_id, 7, &buffer, &byte_read);
				rec_wday = (USHORT)atol((const char *)buffer);
				qfree(buffer);
				
				DataGetField(ann_dbid, rec_id, 9, &buffer, &byte_read);
				rec_nth_wday = (USHORT)atol((const char *)buffer);
				qfree(buffer);
				
				if (rec_nth_wday == 6)	// 01032000
					valid_input = Dt_M7day_Date (alarm_next_year, (SHORT)alarm_next_month-1, -1, rec_wday, &pDate);
				else
				{
					valid_input = Dt_M7day_Date (alarm_next_year, (SHORT)alarm_next_month-1, rec_nth_wday, rec_wday, &pDate);
					
					if (alarm_next_month-1 != pDate.mon)
						valid_input = Dt_M7day_Date (alarm_next_year, (SHORT)alarm_next_month-1, -1, rec_wday, &pDate);
				}
				
				alarm_next_day = pDate.mday;
			}
			
			date_exist = RtcCheckYMDValid(alarm_next_year, alarm_next_month-1, alarm_next_day);
			
			/* Update the Alarm Date */
			if (valid_input == TRUE /*&& alarm_current_year <= time.year*/)
			{
				if (date_exist == TRUE)
					AnnUpdateNextAlarmDate(alarm_next_year, alarm_next_month, alarm_next_day, 3, rec_id);
				else
				{
					new_alarm_status = NO_ALARM;
					DataWriteField(ann_dbid, rec_id, 0, 1, &new_alarm_status);
				}
			}
			qfree(alarm_buffer);
		}
		qfree(repeat_buffer);
		/* Search record alarm on different schedule */
		if (total_num_rec == 1)
			AnnSetAllRecordsAlarm(rec_num);
		else if (rec_num == total_num_rec-1)
			AnnSetAllRecordsAlarm(0);
		else
			AnnSetAllRecordsAlarm(0);
	}
	else
		AnnSetAllRecordsAlarm(FALSE);
	DataCloseDB(ann_dbid);
	return;
}

/********************************************************
* Function:	AnnDatabaseChecking
* Purpose: 	This function is called to check whether the required database 
*				is already exist or not. If not, it will creat it
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void AnnDatabaseChecking()
{
	BYTE	application_status, temp_month, create_font = SMALL_FONT;
	RTM		time;
	
	if (DataFindDB(ANNDB, &ann_dbid) != TRUE)
	{
		/* New Database */
		DataNewDB(ANNDB, 1, ANNAPP, &ann_dbid);
#ifdef	PR31700
		DataOpenDB(ann_dbid,SORT_TEXT_MODE | 2,OPEN_RW);
#else
		DataOpenDB(ann_dbid, 2,OPEN_RW);
#endif
		/* Create status record */
		DataNewRecordWithID(ann_dbid, ANN_EDIT_INFO, 0, 36);
		RtcGetTime(&time);
		temp_month = time.mon+1;
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 2, 2, (BYTE*)&time.year);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 3, 2, (BYTE*)&temp_month);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 4, 2, (BYTE*)&time.mday);
		
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 8, 2, (BYTE*)&time.year);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 9, 2, (BYTE*)&temp_month);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 10, 2, (BYTE*)&time.mday);
		
		DataNewRecordWithID(ann_dbid, ANN_STATUS, 0, 1);
		application_status = RESTART_ANNIVER;
		DataWriteField(ann_dbid, ANN_STATUS, 0, 1, &application_status);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 32, 1, (BYTE*)&create_font);
	}
	else if (DataIsDBOpen(ann_dbid, NULL, NULL) == FALSE)
	{
#ifdef	PR31700
		DataOpenDB(ann_dbid,SORT_TEXT_MODE | 2,OPEN_RW);
#else
		DataOpenDB(ann_dbid, 2,OPEN_RW);
#endif
	}
	if (DataRecordInfo(ann_dbid, ANN_STATUS, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		DataNewRecordWithID(ann_dbid, ANN_STATUS, 0, 1);
		application_status = RESTART_ANNIVER;
		DataWriteField(ann_dbid, ANN_STATUS, 0, 1, &application_status);
	}
	
	if (DataRecordInfo(ann_dbid, ANN_EDIT_INFO, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		DataNewRecordWithID(ann_dbid, ANN_EDIT_INFO, 0, 36);
		
		RtcGetTime(&time);
		temp_month = time.mon+1;
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 2, 2, (BYTE*)&time.year);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 3, 2, (BYTE*)&temp_month);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 4, 2, (BYTE*)&time.mday);
		
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 8, 2, (BYTE*)&time.year);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 9, 2, (BYTE*)&temp_month);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 10, 2, (BYTE*)&time.mday);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 32, 1, (BYTE*)&create_font);
	}
}

/********************************************************
* Function:	AnnCompareAlarmDay()
* Purpose: 	This function is called to set up the alarm 
*			manager
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN AnnCompareAlarmDay(USHORT input_year, USHORT input_month, USHORT input_day)
{
	RTM			time;
	
	RtcGetTime(&time);
	
	if (input_year < time.year)
		return FALSE;
	else if (input_year > time.year)
		return TRUE;
	else
	{
		if (input_month < time.mon)
			return FALSE;
		else if (input_month > time.mon)
			return TRUE;
		else
		{
			if (input_day < time.mday)
				return FALSE;
			else
				return TRUE;
		}
	}
}

/******************************************************************
* Function:	AnnUpdateNextAlarmDate
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnUpdateNextAlarmDate(SHORT new_year, SHORT new_month, SHORT new_day, USHORT field_num, RecordID rec_id)
{	
	BYTE	schedule_date[11];
	BYTE	*ptr = schedule_date;
	Err	result;
	
	/* Load year to buffer */
	sprintf((char*)ptr,"%d",new_year);
	ptr += 4;
	*(ptr++) = '/';
	/* Load month to buffer */
	if (new_month < 10)
	{
		*ptr = '0';
		ptr++;
		sprintf((char*)ptr,"%d",new_month);
		ptr++;
	}
	else
	{
		sprintf((char*)ptr,"%d",new_month);
		ptr += 2;
	}
	*(ptr++) = '/';
	/* Load day to buffer */
	if (new_day < 10)
	{
		*ptr = '0';
		ptr++;
		sprintf((char*)ptr,"%d",new_day);
	}
	else
		sprintf((char*)ptr,"%d",new_day);
	
	result = DataWriteField(ann_dbid, rec_id, field_num, (strlen(schedule_date) + 1), schedule_date);
}


/******************************************************************
* Function:	AnnAddRecord
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
SHORT AnnAddRecord(TableDisplay *table_display, RecordID	rec_id, USHORT insert_row_num, USHORT count, USHORT cell)
{
	ObjectID	cell_ui_id;
	Table		*table_addr;
	Bitmap		*bmp_addr;
	String		*string_addr;
	USHORT		max_rows_on_display;
	USHORT		rec_wday, rec_week_num, check_entry;
	UWORD		rec_num, byte_read;
	BYTE		*buffer, object_type;
	USHORT		sch_month, sch_day;
	RecordIDBlock	*temp = table_display->record_id_block;
	RTM			pDate;
	BYTE		year_buffer[10], month_buffer[10], day_buffer[10];
	CountrySettings country;
	
	SySetupGetCountrySettings(&country);
	
	FormGetObjectPointer(TABLE_ANN_LIST, &object_type, (void **)&table_addr);
	/* Calculate maximum num of row can be display on screen */
	max_rows_on_display = table_addr->bounds.height / table_addr->table_row_height[1];
	
	if (insert_row_num >= count && insert_row_num < count + ANN_BLOCK_SIZE)
	{
		DataRecIDtoNum(ann_dbid, temp->record_id[insert_row_num - count], &rec_num);
		DataOpenRecord(ann_dbid, rec_num, &rec_id, NULL);
		
		/* Check the specify schedule date is entried by date settings/week settings */
		DataGetField(ann_dbid, rec_id, 8, &buffer, &byte_read);
		check_entry = (USHORT)atol((const char *)buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, rec_id, 2, &buffer, &byte_read);
		year_buffer[0] = buffer[6];
		year_buffer[1] = buffer[7];
		year_buffer[2] = buffer[8];
		year_buffer[3] = buffer[9];
		year_buffer[4] = 0;
		app_status.sch_year = (SHORT)atol((const char *)year_buffer);
		
		month_buffer[0] = buffer[0];
		month_buffer[1] = buffer[1];
		month_buffer[2] = 0;
		app_status.sch_month = (SHORT)atol((const char *)month_buffer);
		
		day_buffer[0] = buffer[3];
		day_buffer[1] = buffer[4];
		day_buffer[2] = 0;
		app_status.sch_day = (SHORT)atol((const char *)day_buffer);
		
		DataGetField(ann_dbid, rec_id, 7, &buffer, &byte_read);
		rec_wday = (USHORT)atol((const char *)buffer);
		qfree(buffer);
		
		DataGetField(ann_dbid, rec_id, 8, &buffer, &byte_read);
		rec_week_num = (USHORT)atol((const char *)buffer);
		qfree(buffer);
		
#ifdef	PC_SIM
		Dt_YWeek_Date (app_status.selected_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
		Dt_YWeek_Date (app_status.selected_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
		sch_month = pDate.mon;
		sch_day = pDate.mday;
		sch_month++;
		
		if (country.date_fmt == SYSETUP_DMY)
		{	
			/* Set the Schedule Day */
			cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
			AnnSetFontPageDate(sch_day, rec_id, table_addr, cell_ui_id, max_rows_on_display, check_entry);
			cell++;
			/* Set the Schedule Month */
			cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
			AnnSetFontPageMonth(sch_month, rec_id, table_addr, cell_ui_id, max_rows_on_display);
			cell++;
		}
		else
		{
			/* Set the Schedule Month */
			cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
			AnnSetFontPageMonth(sch_month, rec_id, table_addr, cell_ui_id, max_rows_on_display);
			cell++;
			/* Set the Schedule Day */
			cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
			AnnSetFontPageDate(sch_day, rec_id, table_addr, cell_ui_id, max_rows_on_display, check_entry);
			cell++;
		}
		/* Get the Text Contents */
		DataGetField(ann_dbid, rec_id, 1, &buffer, &byte_read);
		cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
		FormGetObjectPointer(cell_ui_id, &object_type, (void **)&string_addr);
		string_addr->string_attr.string_visible = TRUE;
		string_addr->bounds.height = table_addr->table_row_height[1];
		
		if (max_rows_on_display == ANN_SFONT_NUM_OF_ROW)
		{
			string_addr->text_font = SMALL_FONT;
			string_addr->bounds.width = ANN_SCOLUMN_3;
		}
		else
		{
			string_addr->text_font = MEDIUM_FONT;
			string_addr->bounds.width = ANN_LCOLUMN_3;
		}
		
		if (byte_read > MAX_TEXT_ON_DISPLAY)
			buffer[MAX_TEXT_ON_DISPLAY] = '\0';
		
		StringSetText(cell_ui_id,buffer);
		qfree(buffer);
		cell++;
		
		/* Get the Alarm Status */
		DataGetField(ann_dbid, rec_id, 0, &buffer, &byte_read);
		cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell]))->table_item_ui_id;
		
		if (UISearchForAddress(cell_ui_id,&object_type,(void**)&bmp_addr) != TRUE) return ERR_UI_RES_NOT_FOUND;
		FormGetObjectPointer(cell_ui_id, &object_type, (void **)&bmp_addr);
		if (*buffer == TONE_ALARM)
		{
			bmp_addr->bitmap_attr.bitmap_enable = FALSE;
			bmp_addr->bitmap_attr.bitmap_visible = TRUE;
			bmp_addr->bitmap_attr.bitmap_active = TRUE;
		}
		else
		{
			bmp_addr->bitmap_attr.bitmap_enable = FALSE;
			bmp_addr->bitmap_attr.bitmap_visible = FALSE;
			bmp_addr->bitmap_attr.bitmap_active = FALSE;
		}
		qfree(buffer);
		cell++;
		/* For Next Record */
		DataCloseRecord(ann_dbid, rec_id);
	}
	else
	{
		count += ANN_BLOCK_SIZE;
		temp = temp->next;
	}
	return cell;
}

/******************************************************************
* Function:	AnnFindRoundOff
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnFindRoundOff(TableDisplay *table_display)
{
#ifdef	PC_SIM	// Testing Purpose
	RecordID	tdl_recid, ann_recid;
	BYTE		tdl_alarm, ann_alarm, todo_hit, ann_hit;
	BYTE		month_state;
	USHORT		num_days;
#endif
	
	RecordID	rec_id;
	USHORT		rec_wday, rec_week_num;
	USHORT		row_num =0, new_row_num =0;
	USHORT		check_entry, count =0, return_val;
	RTM			pDate;
	UWORD		total_num_rec, rec_num, byte_read;
	SHORT		check_roundoff;
	BYTE		*buffer;
	BYTE		yr_repeat;
	CountrySettings country;
	RecordIDBlock	*temp = table_display->record_id_block;
	
	SySetupGetCountrySettings(&country);
	total_num_rec = table_display->total_num_rows; //01032000
	
	while (temp != NULL && total_num_rec > 0)
	{
		if (row_num >= count && row_num < count + ANN_BLOCK_SIZE)
		{			
			DataRecIDtoNum(ann_dbid, temp->record_id[row_num - count], &rec_num);
			DataOpenRecord(ann_dbid, rec_num, &rec_id, NULL);
			
			/* Check the specify schedule date is entried by date settings/week settings */
			DataGetField(ann_dbid, rec_id, 8, &buffer, &byte_read);
			check_entry = (USHORT)atol((const char *)buffer);
			qfree(buffer);
			
			// ---------------------------------------------------------------------------
			// modified at 18/07/2000
			DataGetField(ann_dbid, rec_id, 4, &buffer, &byte_read);
			yr_repeat = *buffer;
			qfree(buffer);
			// ---------------------------------------------------------------------------
			
			if (check_entry >= 1 && check_entry < 55)
			{			
				return_val = ToDoAnnFindDate(app_status.selected_year, rec_id);
				
				if (return_val == YEAR_FIND_BY_WEEK_NUMBER)
					temp->round_off[row_num - count] = YEAR_FIND_BY_WEEK_NUMBER;
				else if (return_val == YEAR_ROUNDUP_FROM_LAST_YEAR)
					temp->round_off[row_num - count] = YEAR_ROUNDUP_FROM_LAST_YEAR;
				else if (return_val == YEAR_FIND_BY_WEEK_AND_LAST_YEAR)
				{
					temp->round_off[row_num - count] = YEAR_ROUNDUP_FROM_LAST_YEAR;
					/* Add a record by XX week num with current year */
					// ---------------------------------------------------------------------------
					// modified at 18/07/2000
					if (yr_repeat == YEARLY_REPEAT)
						TableDisplayInsertRecordID(&anniver_list, rec_id, ann_dbid, YEAR_ROUNDUP_FROM_LAST_YEAR);
					// ---------------------------------------------------------------------------
				}
				else if (return_val == YEAR_ROUNDUP_FROM_NEXT_YEAR)
					temp->round_off[row_num - count] = YEAR_ROUNDUP_FROM_NEXT_YEAR;
				else if (return_val == YEAR_FIND_BY_WEEK_AND_NEXT_YEAR)
				{
					temp->round_off[row_num - count] = FALSE;
					/* Add a record by XX week num with current year */
					// ---------------------------------------------------------------------------
					// modified at 18/07/2000
					if (yr_repeat == YEARLY_REPEAT)
						TableDisplayInsertRecordID(&anniver_list, rec_id, ann_dbid, YEAR_ROUNDUP_FROM_NEXT_YEAR);
					// ---------------------------------------------------------------------------
				}
				else if (return_val == YEAR_FIND_BY_NEXT_YEAR_ROUNDUP)
					temp->round_off[row_num - count] = YEAR_FIND_BY_NEXT_YEAR_ROUNDUP;
				else
					temp->round_off[row_num - count] = YEAR_ROUNDUP;
			}
			else
				temp->round_off[row_num - count] = YEAR_FIND_BY_WEEK_NUMBER;
			/* For Next Record */
			total_num_rec--;
			row_num++;
			DataCloseRecord(ann_dbid, rec_id);
		}
		else
		{
			count += ANN_BLOCK_SIZE;
			temp = temp->next;
		}
	}
}

/********************************************************
* Function:	ToDoAnnFindDate()
* Purpose: 	
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
USHORT ToDoAnnFindDate(SHORT search_year, RecordID	rec_id)
{
	USHORT		rec_wday, rec_week_num, return_val, check_input_year;
	SHORT		rec_year, check_roundoff, check_roundup, output;
	BYTE		*buffer, year_buffer[10];
	UWORD		byte_read;
	RTM			pDate, current, last;
	CountrySettings country;
	
	SySetupGetCountrySettings(&country);
	
	
	DataGetField(ann_dbid, rec_id, 7, &buffer, &byte_read);
	rec_wday = (USHORT)atol((const char *)buffer);
	qfree(buffer);
	
	DataGetField(ann_dbid, rec_id, 8, &buffer, &byte_read);
	rec_week_num = (USHORT)atol((const char *)buffer);
	qfree(buffer);
	
	if (rec_week_num == 1)
	{
		DataGetField(ann_dbid, rec_id, 11, &buffer, &byte_read);
		check_input_year = *(USHORT *)buffer;
		qfree(buffer);
		
#ifdef	PC_SIM
		Dt_YWeek_Date (search_year, 1, (SHORT)rec_wday, 0, &current);
		Dt_YWeek_Date (search_year+1, 1, (SHORT)rec_wday, 0, &pDate);
#else
		Dt_YWeek_Date (search_year, 1, (SHORT)rec_wday, country.start_of_week, &current);
		
		Dt_YWeek_Date (search_year+1, 1, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
		/* Check Date No RoundUp */
		if (current.year == search_year && pDate.year == search_year) /* Current date No Round up && Next date Round Up */
		{
			if (current.year < check_input_year)
				return_val = YEAR_ROUNDUP_FROM_NEXT_YEAR;
			else
				return_val = YEAR_FIND_BY_WEEK_AND_NEXT_YEAR;
		}
		else if (current.year != search_year && pDate.year == search_year) /* Current date Round up && Next date Round Up */
			return_val = YEAR_ROUNDUP_FROM_NEXT_YEAR;
		else if (current.year != search_year && pDate.year != search_year) /* Current date Round up && Next date No Round Up */
			return_val = YEAR_ROUNDUP;	// 29022000
		///			return_val = YEAR_FIND_BY_NEXT_YEAR_ROUNDUP;
		else // current.year == search_year && pDate.year != search_year
			return_val = YEAR_FIND_BY_WEEK_NUMBER; /* No RoundUp of Both Current and Next year Happen !!! */
	}
	else if (rec_week_num >= 52)
	{
#ifdef	PC_SIM
		Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &current);
		output = Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &last);
#else
		Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &current);
		Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &last);
#endif
		/* Check Date No RoundUp */
		if (current.year == search_year && last.year == search_year) /* Current date No Round up && Next date Round Up */
			return_val = YEAR_FIND_BY_WEEK_AND_LAST_YEAR;
		else if (current.year != search_year && last.year == search_year) /* Current date Round up && Next date Round Up */
			return_val = YEAR_ROUNDUP_FROM_LAST_YEAR;
		else if (current.year != search_year && pDate.year != search_year) /* Current date Round up && Next date No Round Up */
			return_val = YEAR_ROUNDUP;
		else // current.year == search_year && pDate.year != search_year
			return_val = YEAR_FIND_BY_WEEK_NUMBER; /* No RoundUp of Both Current and last year Happen !!! */
		// Check if last year without week 53
		if (return_val == YEAR_ROUNDUP_FROM_LAST_YEAR || return_val == YEAR_FIND_BY_WEEK_AND_LAST_YEAR)
		{ 
#ifdef	PC_SIM
			Dt_Date_YWeek (search_year, last.mon, last.mday, 0, &check_roundoff);
#else
			Dt_Date_YWeek (search_year, last.mon, last.mday, country.start_of_week, &check_roundoff);
#endif
			if (check_roundoff != search_year-1)
			{
				if (return_val == YEAR_ROUNDUP_FROM_LAST_YEAR)
					return_val = YEAR_ROUNDUP;
				else	// return_val == YEAR_FIND_BY_WEEK_AND_LAST_YEAR
					return_val = YEAR_FIND_BY_WEEK_NUMBER;
			}
		}
#ifdef	xxxxxxxxxxxxxxx
#ifdef	PC_SIM
		Dt_Date_YWeek (search_year, 0, 1, 0, &check_roundoff);
		
#else
		Dt_Date_YWeek (search_year, 0, 1, country.start_of_week, &check_roundoff);
#endif
		/* Check Date No RoundOff */
		if (check_roundoff >= search_year)
			return_val = YEAR_FIND_BY_WEEK_NUMBER;
		else if (check_roundoff < search_year)
		{
#ifdef	PC_SIM
			Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
			Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
			/* Check Current Year RoundUp with 52 week Sat XXXX */
			if (search_year == pDate.year)
			{
				DataGetField(ann_dbid, rec_id, 11, &buffer, &byte_read);
				check_input_year = *(USHORT *)buffer;
				qfree(buffer);
				/* Omit the date bring before the input year */
				if (check_input_year == search_year)
					return_val = YEAR_FIND_BY_WEEK_NUMBER;
				else if (check_input_year != search_year && rec_week_num >= 52)
					return_val = YEAR_FIND_BY_WEEK_AND_LAST_YEAR;
				else
					return_val = YEAR_FIND_BY_WEEK_NUMBER;
			}
			else /* Omit the date which is round up to next year */
			{
#ifdef	PC_SIM
				Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
				Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
				/* Check "52 week Sat Year Before" RoundUp to selected year*/
				if (pDate.year == search_year)
					return_val = YEAR_ROUNDUP_FROM_LAST_YEAR;
				else
					return_val = YEAR_ROUNDUP;
			}
		}
#endif
	}
	else
		return_val = YEAR_FIND_BY_WEEK_NUMBER;
	
	return return_val;
}