/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   annfunc.c
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#include "stdafx.h"
#include "AnnFunc.h"
#include "SySetup.h"
//#define	DEBUG  

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
SHORT		wset_nth_wday, wset_wday, wset_week_num;

/********************************************************
* Function:	AnnSetTableTopRowNum
* Purpose: 	This function is called to set the top row number
*			of the table object
* Scope:	application
* Input:	BYTE				the starting_char
* Output:	None
* Return:	TRUE			display of table is on
*			FALSE			display of table is off
* Comment: 	The top row number of the table objects are set
*********************************************************/
BOOLEAN AnnSetTableTopRowNum(UWORD top_record)
{
	USHORT	total_num_rows;
	BOOLEAN	enable,drawn, active,visible, set_scroll;
	
	
	total_num_rows = anniver_list.total_num_rows;
	anniver_list.top_row_num = (USHORT)top_record;
	AnnTableDisplayDraw(&anniver_list);
	TableGetAttributes(TABLE_ANN_LIST, &enable, &drawn, &active, &visible, &set_scroll);
	TableSetAttributes(TABLE_ANN_LIST, enable, drawn, active, TRUE, set_scroll);
	AnnSetScrollbar();
	return TRUE;
}

/********************************************************
* Function:	ToDoListSetScrollbar
* Purpose: 	This function is called in order to set the values for a scrollbar		
* Scope:	application
* Input:	BYTE				the starting_char
* Output:	None
* Return:	TRUE		scrollbar is erased
*			FALSE		scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
*			If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN AnnSetScrollbar()
{
	Scrollbar *scroll_ptr;
	BYTE object_type;
	USHORT max_num_rows_display;
	USHORT top_row_num;
	WORD max_value, min_value, pagesize, total_num_rows;
	max_num_rows_display = anniver_list.num_rows_displayed;
	total_num_rows = anniver_list.total_num_rows;
	top_row_num = anniver_list.top_row_num;
	
	pagesize = max_num_rows_display;
	min_value = 0;
	max_value = total_num_rows - pagesize;	
	
	if (total_num_rows > max_num_rows_display)
		ScrollbarSetScrollbarVisible(SCROLLBAR_ANN_LIST,TRUE);
	else
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_ANN_LIST,FALSE);
		ScrollbarEraseScrollbar(SCROLLBAR_ANN_LIST);
		return FALSE;
	}
	
	if (top_row_num > (total_num_rows - max_num_rows_display))
		ScrollbarSetScrollbar(SCROLLBAR_ANN_LIST, max_value, max_value, min_value,
		pagesize, total_num_rows);
	else
		ScrollbarSetScrollbar(SCROLLBAR_ANN_LIST, top_row_num, max_value, min_value,
		pagesize, total_num_rows);
	
	FormGetObjectPointer(SCROLLBAR_ANN_LIST, &object_type, (void**)&scroll_ptr);
	scroll_ptr->scrollbar_draw_pagesize = pagesize;
	
	ScrollbarDrawScrollbar(SCROLLBAR_ANN_LIST);
	return TRUE;
}

/********************************************************
* Function:	AnnGetClickedCell
* Purpose:	To get the row, column & cell number of the
*			particular position
* Scope:	Application
* Input:	table_id			DBID of table object
*			x_coord				pen x-coordinate
*			y_coord				pen y-coordinate
* Output:	row_number			the row number
*			col_number			the column number
*			cell_number			the cell number
* Output:	None
* Return:	TRUE if no error
*			ErrUIResNotFound
* Comment:    None
*********************************************************/
Err AnnGetClickedCell(ObjectID table_id,SHORT x_coord,SHORT y_coord,USHORT *row_number,
					  USHORT *col_number,USHORT *cell_number)
{
	Table	*addr;
	BYTE	object_type;
	USHORT	i,j,temp_height = 0,top_row,count=0,draw_height=0;
	ObjectBounds temp;
	
	if (UISearchForAddress(table_id,&object_type,(void **)&addr) != TRUE) return ERR_UI_RES_NOT_FOUND;
	if (addr->table_attr.table_drawn == FALSE) return FALSE;
	if (addr->table_attr.table_enable == FALSE) return FALSE;
	
	count = (addr->table_top_row_num*addr->table_num_column);
	
	for (i=0; i< (addr->table_num_row-addr->table_top_row_num); i++)
		draw_height += addr->table_row_height[i+addr->table_top_row_num];
	/* If table fully display on screen */
	if (draw_height < addr->bounds.height)
	{
		if (x_coord >= addr->bounds.xcoord && x_coord < addr->bounds.xcoord+addr->bounds.width &&
			y_coord >= addr->bounds.ycoord && y_coord < addr->bounds.ycoord+addr->bounds.height)
		{
			temp.xcoord = addr->bounds.xcoord;
			temp.ycoord = addr->bounds.ycoord;
			
			for (i=addr->table_top_row_num; i< addr->table_num_row; i++)
			{
				for (j=0; j< addr->table_num_column; j++)
				{
					if (x_coord >= temp.xcoord && x_coord <= temp.xcoord+addr->table_column_width[j] &&
						y_coord >= temp.ycoord && y_coord <= temp.ycoord+addr->table_row_height[i])
					{
						*row_number = i;
						*col_number = j;
						*cell_number = count;
						return TRUE;
					}
					temp.xcoord = temp.xcoord+addr->table_column_width[j];
					count++;
				}
				temp.xcoord = addr->bounds.xcoord;
				temp.ycoord = temp.ycoord+addr->table_row_height[i];
			}
		}
		else
			return ERR_UI_INV_INPUT_COORD;
	}
	/* The table cannot fully display on screen */
	else
	{
		/* Get the top row of the display table */
		top_row = addr->table_top_row_num;
		
		for (i=0; i< addr->table_num_row_display; i++)
			temp_height = temp_height+addr->table_row_height[i+top_row];
		/* Pen within the display region */
		if (x_coord >= addr->bounds.xcoord && x_coord < addr->bounds.xcoord+addr->bounds.width &&
			y_coord >= addr->bounds.ycoord && y_coord < addr->bounds.ycoord+temp_height)
		{
			temp.xcoord = addr->bounds.xcoord;
			temp.ycoord = addr->bounds.ycoord;
			
			for (i=addr->table_top_row_num; i< addr->table_num_row; i++)
			{
				for (j=0; j< addr->table_num_column; j++)
				{
					if (x_coord >= temp.xcoord && x_coord <= temp.xcoord+addr->table_column_width[j] &&
						y_coord >= temp.ycoord && y_coord <= temp.ycoord+addr->table_row_height[i])
					{
						*row_number = i;
						*col_number = j;
						*cell_number = count;
						return TRUE;
					}
					count++;
					temp.xcoord = temp.xcoord+addr->table_column_width[j];
				}
				temp.xcoord = addr->bounds.xcoord;
				temp.ycoord = temp.ycoord+addr->table_row_height[i];
			}
		}
		else
			return ERR_UI_INV_INPUT_COORD;
	}
	return FALSE;
}

/******************************************************************
* Function:	AnnScrollbarSetTable
* Purpose: 	This function is called to set the To Do List
*			when the scrollbar is moved.
* Scope:	application
* Input:	Event		
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AnnScrollbarSetTable(EvtType *Event)
{
	WORD		max,min,value,pagesize;
	WORD		scroll_total_lines;
	BYTE		object_type;
	Scrollbar*	scroll_ptr;
	
	ScrollbarGetScrollbar(SCROLLBAR_ANN_LIST, &value, &max, &min, &pagesize, &scroll_total_lines);	
	
	if ((Event->para2 - Event->para1) >= pagesize)
	{
		ScrollbarSetScrollbar(SCROLLBAR_ANN_LIST, (Event->para2 - 1), max, min, pagesize, scroll_total_lines);
		anniver_list.top_row_num = (USHORT)(Event->para2) - 1;
	}
	else if ((Event->para1 - Event->para2) >= pagesize)
	{
		ScrollbarSetScrollbar(SCROLLBAR_ANN_LIST, (Event->para2 + 1), max, min, pagesize, scroll_total_lines);
		anniver_list.top_row_num = (USHORT)(Event->para2) + 1;
	}
	else
	{	
		ScrollbarSetScrollbar(SCROLLBAR_ANN_LIST, Event->para2, max, min, pagesize, scroll_total_lines);
		anniver_list.top_row_num = (USHORT)(Event->para2);
	}	
	
	if (Event->para2 != Event->para1)
	{
		AnnTableDisplayDraw(&anniver_list);
		
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y1);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y2);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y3);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y4);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y5);
		
		TableDrawTable(TABLE_ANN_LIST);
	}
	
    FormGetObjectPointer(SCROLLBAR_ANN_LIST, &object_type, (void**)&scroll_ptr);
    scroll_ptr->scrollbar_draw_pagesize = pagesize;
    ScrollbarDrawScrollbar(SCROLLBAR_ANN_LIST);    
}

/********************************************************
* Function:	AnnDisplayGetRecordID
* Purpose: 	This function is called in order to get the record ID 
*			of a particular table item in the Table object
* Scope:	application
* Input:	table_display	table-display structure
*			item_num		item number
* Output:	rec_id			Pointer to record ID of the list object
* Return:	TRUE    handled
*			FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN AnnDisplayGetRecordID(TableDisplay *table_display, USHORT row_num, RecordID *rec_id, DatabaseID *dbid)
{
	RecordIDBlock *temp = table_display->record_id_block;
	USHORT count = 0;
	
	if (row_num >= table_display->total_num_rows) return FALSE;
	if (table_display->record_id_block == NULL) return FALSE;
	
	while (temp != NULL)
	{
		if ((row_num >= count) && (row_num < (count + 20)))
		{
			*rec_id = temp->record_id[row_num - count];
			*dbid = temp->dbid[row_num - count];
			
			///			if (temp->round_off[row_num - count] == YEAR_NOT_SHOW_DATE)
			///				return FALSE;
			///			else
			return TRUE;
		}
		else
		{
			count += 20;
			temp = temp->next;
		}
	}
	return FALSE;
}

/********************************************************
* Function:	AnnSetUpFieldScreen
* Purpose: 	This function is called in order to set the layout of the 
*			To Do New screen
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE		Success
*			FALSE		NotHandled
* Comment: 	None
*********************************************************/
BOOLEAN AnnSetUpFieldScreen(ObjectID form_id)
{
	BYTE		object_type;
	Field		*field_ptr;
	Scrollbar	*scroll_ptr;
	
	if (form_id == FORM_ANN_NEW || form_id == FORM_ANN_VIEWING)
	{
		if (form_id == FORM_ANN_NEW)
			FormGetObjectPointer(FIELD_ANN_NEW, &object_type, (void**)&field_ptr);
		else
			FormGetObjectPointer(FIELD_ANN_VIEWING, &object_type, (void**)&field_ptr);
		
		FormGetObjectPointer(SCROLLBAR_ANN_VIEWING, &object_type, (void**)&scroll_ptr);
		
		if (KeyboardCheckKeyboardStatus())
		{
			if (form_id == FORM_ANN_NEW)
				field_ptr->bounds.height = FIELD_NEW_HEIGHT_KEYBOARD_ON;
			else
				field_ptr->bounds.height = FIELD_VIEWING_HEIGHT_KEYBOARD_ON;
			
			scroll_ptr->bounds.height = SCROLLBAR_HEIGHT_KEYBOARD_ON;
		}
		else
		{
			field_ptr->bounds.height = FIELD_HEIGHT_KEYBOARD_OFF;
			scroll_ptr->bounds.height = SCROLLBAR_HEIGHT_KEYBOARD_OFF;
		}
		return TRUE;
	}		
	return FALSE;	
}

/********************************************************
* Function:	AnnFieldSetScrollbar
* Purpose: 	This function is called in order to set the 
*			values for a scrollbar		
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE				scrollbar is erased
*			FALSE				scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
*			If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN AnnFieldSetScrollbar(ObjectID field_id, ObjectID scrollbar_id)
{
	Field		*field_ptr;
	Scrollbar	*scroll_ptr;
	BYTE		font_id;
	BYTE		object_type;
	WORD		max_num_lines;
	WORD		max_value, min_value, pagesize;
	
	
	FormGetObjectPointer(field_id, &object_type, (void**)&field_ptr);
	
	FieldGetFont(field_id, &font_id);
    max_num_lines = field_ptr->bounds.height/(SysGetFontHeight(font_id) + SPACE_LINE);
	
	pagesize = max_num_lines  - 1;
	min_value = 0;	
	max_value = field_ptr->field_total_num_lines - pagesize - 1;	
	
	if (field_ptr->field_total_num_lines > max_num_lines)
		ScrollbarSetScrollbarVisible(scrollbar_id, TRUE);
	else
	{
		ScrollbarSetScrollbarVisible(scrollbar_id, FALSE);
		ScrollbarEraseScrollbar(scrollbar_id);
		return FALSE;
	}
	
	FormGetObjectPointer(scrollbar_id, &object_type, (void**)&scroll_ptr);		
	scroll_ptr->scrollbar_draw_pagesize = max_num_lines;
	
	if (field_ptr->field_top_line_num > (field_ptr->field_total_num_lines - max_num_lines))
		ScrollbarSetScrollbar(scrollbar_id, max_value, max_value, min_value,
		pagesize, field_ptr->field_total_num_lines);
	else
		ScrollbarSetScrollbar(scrollbar_id, field_ptr->field_top_line_num, max_value, min_value,
		pagesize, field_ptr->field_total_num_lines);
	
	ScrollbarDrawScrollbar(scrollbar_id);
	return TRUE;
}

/******************************************************************
* Function:	AnnViewingSetUpScreen
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnViewingSetUpScreen()
{
	Control	*ctl_addr;
	Bitmap	*bmp_addr;
	BYTE	object_type, text_buffer[12];
	BYTE	*ptr = text_buffer;
	
	
	/* Set up Field Size */
	FieldSetFont(FIELD_ANN_VIEWING, table_font);
	/* Set up Field contents */
	FieldSetText(FIELD_ANN_VIEWING, ann_field_buffer[0]);
	
	AnnPackDueDate(ptr, app_status.sch_year, app_status.sch_month, app_status.sch_day);
	ControlSetLabel(BUTTON_ANN_VIEWING_DATE, text_buffer);
	
	FormGetObjectPointer(BUTTON_ANN_VIEWING_DATE, &object_type, (void **)&ctl_addr);
	ctl_addr->bounds.width = StrGetWidth(text_buffer, SMALL_FONT);
	/* Set up Alarm status */
	FormGetObjectPointer(BITMAP_ANN_VIEWING, &object_type, (void **)&bmp_addr);
	bmp_addr->bitmap_attr.bitmap_enable = FALSE;
	bmp_addr->bounds.xcoord = ctl_addr->bounds.xcoord + ctl_addr->bounds.width + 2;
	
	if (app_status.alarm_status == TONE_ALARM)
		bmp_addr->bitmap_attr.bitmap_visible = TRUE;
	else
		bmp_addr->bitmap_attr.bitmap_visible = FALSE;
}

/******************************************************************
* Function:	ToDoRecordToVariable
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnRecordToVariable()
{
	UWORD	rec_num, byte_read;
	BYTE	*buffer;
	BYTE	year_buffer[5], month_buffer[3], day_buffer[3];
	
	
	DataRecIDtoNum(ann_dbid, app_status.rec_id, &rec_num);
	DataOpenRecord(ann_dbid, rec_num, &app_status.rec_id, NULL);
	/* Get Field 0 of To Do List Record */
	DataGetField(ann_dbid, app_status.rec_id, 0, &buffer, &byte_read);
	if (*buffer == TONE_ALARM)
		app_status.alarm_status = TONE_ALARM;
	else
		app_status.alarm_status = NO_ALARM;
	qfree(buffer);
	/* Get Field 1 of To Do List Record */
	DataGetField(ann_dbid, app_status.rec_id, 1, &buffer, &byte_read);
	
	if (ann_field_buffer[0] != NULL)
		qfree(ann_field_buffer[0]);
	
	ann_field_buffer[0] = (BYTE*)qmalloc((strlen(buffer) + 1)*sizeof(BYTE));
	strcpy(ann_field_buffer[0], buffer);
	qfree(buffer);
	/* Get Field 2 of To Do List Record */
	DataGetField(ann_dbid, app_status.rec_id, 2, &buffer, &byte_read);
	/* Set up the specified day */
	day_buffer[0] = buffer[3];
	day_buffer[1] = buffer[4];
	day_buffer[2] = 0;
	app_status.sch_day = (USHORT)atol((const char *)day_buffer);
	/* Set up the specified month */
	month_buffer[0] = buffer[0];
	month_buffer[1] = buffer[1];
	month_buffer[2] = 0;
	app_status.sch_month = (USHORT)atol((const char *)month_buffer);
	/* Set up the specified year */
	year_buffer[0] = buffer[6];
	year_buffer[1] = buffer[7];
	year_buffer[2] = buffer[8];
	year_buffer[3] = buffer[9];
	year_buffer[4] = 0;
	app_status.sch_year = (USHORT)atol((const char *)year_buffer);
	qfree(buffer);
	/* Get Field 3 of To Do List Record */
	DataGetField(ann_dbid, app_status.rec_id, 3, &buffer, &byte_read);
	day_buffer[0] = buffer[8];
	day_buffer[1] = buffer[9];
	day_buffer[2] = 0;
	app_status.alarm_day = (USHORT)atol((const char *)day_buffer);
	/* Set up the specified alarm */
	month_buffer[0] = buffer[5];
	month_buffer[1] = buffer[6];
	month_buffer[2] = 0;
	app_status.alarm_month = (USHORT)atol((const char *)month_buffer);
	/* Set up the specified alarm */
	year_buffer[0] = buffer[0];
	year_buffer[1] = buffer[1];
	year_buffer[2] = buffer[2];
	year_buffer[3] = buffer[3];
	year_buffer[4] = 0;
	app_status.alarm_year = (USHORT)atol((const char *)year_buffer);
	qfree(buffer);
	/* Get Field 4 of To Do List Record */
	DataGetField(ann_dbid, app_status.rec_id, 4, &buffer, &byte_read);
	app_status.yearly_repeat = *buffer;
	qfree(buffer);
	/* Get Field 7 of To Do List Record */
	DataGetField(ann_dbid, app_status.rec_id, 7, &buffer, &byte_read);
	wset_wday = (USHORT)atol((const char *)buffer);
	qfree(buffer);
	/* Get Field 8 of To Do List Record */
	DataGetField(ann_dbid, app_status.rec_id, 8, &buffer, &byte_read);
	wset_week_num = (USHORT)atol((const char *)buffer);
	qfree(buffer);
	/* Get Field 9 of To Do List Record */
	DataGetField(ann_dbid, app_status.rec_id, 9, &buffer, &byte_read);
	wset_nth_wday = (USHORT)atol((const char *)buffer);
	qfree(buffer);
	/* Get Field 10 of To Do List Record */
	DataGetField(ann_dbid, app_status.rec_id, 10, &buffer, &byte_read);
	alarm_date = *buffer;
	qfree(buffer);
	
	if (wset_week_num == 0)
		date_entry_method = 0;
	else if (wset_week_num >= 1 && wset_week_num < 55)
		date_entry_method = 1;
	else
		date_entry_method = 2;
	/* Get Field 11 of To Do List Record */
	DataGetField(ann_dbid, app_status.rec_id, 11, &buffer, &byte_read);
	app_status.input_year = *(USHORT *)buffer;
	qfree(buffer);
	
	/* Save application status */
	chk_status.alarm_status = app_status.alarm_status;
	chk_status.sch_year		= app_status.sch_year;
	chk_status.sch_month	= app_status.sch_month;
	chk_status.sch_day		= app_status.sch_day;
	chk_status.alarm_year	= app_status.alarm_year;
	chk_status.alarm_month	= app_status.alarm_month;
	chk_status.alarm_day	= app_status.alarm_day;
	chk_status.yearly_repeat= app_status.yearly_repeat;
	chk_status.field_change = FALSE;
	
	DataCloseRecord(ann_dbid,app_status.rec_id);
}

/********************************************************
* Function:	AnnEditSetField
* Purpose: 	This function is called in order to set up 
*			the field in the To DO New screen when the 
*			data is first put to Field or the keyboard 
*			is popuped up and down
* Scope:	application
* Input:	form_id		ID value of the form that the field is on
*			field_id	ID value of field object to be scrolled
* Output:	None
* Return:	TRUE		Success
*			FALSE		NotHandled
* Comment: 	None
*********************************************************/
BOOLEAN AnnEditSetField(ObjectID form_id, ObjectID field_id)
{
	Field	*field_ptr;
	BOOLEAN insert_pt_on = FALSE;
	BOOLEAN highlight_pt_on = FALSE;
	BYTE	object_type, font_id;
	SHORT	line_height, acc_height = 0;
	WORD	first_visible_char, last_visible_char, count = 0;
	WORD	line_num, insert_pos;
	WORD	temp;
	
	
	FormGetObjectPointer(field_id, &object_type, (void**)&field_ptr);		
	insert_pt_on = field_ptr->field_attr.field_insert_pt_visible;
	highlight_pt_on = field_ptr->field_attr.field_highlight;
	
	FieldGetFont(field_id, &font_id);
    line_height = SysGetFontHeight(font_id) + SPACE_LINE;
	
	StrAnalyzeLine(field_ptr);
	FieldGetFirstVisibleChar(field_id, &first_visible_char);
	FieldGetLastVisibleChar(field_id, &last_visible_char);
	
	if (insert_pt_on == TRUE || highlight_pt_on == TRUE)
	{
		if (insert_pt_on)
		{
			for (count = 0; count < field_ptr->field_total_num_lines; count++)
			{
				if (field_ptr->field_insert_pt_char_pos >= field_ptr->field_lineinfo[count].start &&
					field_ptr->field_insert_pt_char_pos <= field_ptr->field_lineinfo[count].start + field_ptr->field_lineinfo[count].length)
					break;
			}
			
			if (field_ptr->field_insert_pt_char_pos < first_visible_char)
				field_ptr->field_top_line_num = count;
			else if (field_ptr->field_insert_pt_char_pos > last_visible_char)
				field_ptr->field_top_line_num = count - field_ptr->field_num_lines_displayed;
			
			if (field_ptr->field_num_lines_displayed < (field_ptr->bounds.height/(line_height)))
			{
				if (field_ptr->field_top_line_num > (field_ptr->field_total_num_lines - (field_ptr->bounds.height/(line_height))))
					field_ptr->field_top_line_num = (field_ptr->field_total_num_lines - (field_ptr->bounds.height/(line_height)));
				
				if (field_ptr->field_top_line_num < 0)
					field_ptr->field_top_line_num = 0;
			}
		}
		StrAnalyzeLine(field_ptr);
		StrCharPosToXY(field_ptr, field_ptr->field_insert_pt_char_pos,&(field_ptr->field_insert_pt_x), &(field_ptr->field_insert_pt_y));
		/* Set up the correct insert pt position when keyboard on */
		FieldGetInsertPointPosition(field_id, &insert_pos);
		FieldGetFirstVisibleChar (field_id, &first_visible_char);
		FieldGetLastVisibleChar (field_id, &last_visible_char);
		
		if (insert_pt_on)
		{
			if(insert_pos > last_visible_char)
			{
				FieldCharPosToLineNum (field_ptr, insert_pos, &line_num);
				FieldSetTopLineNum(field_id, line_num - (field_ptr->bounds.height/(line_height)) + 1);
			}
			FieldSetInsertPointPositionByCharPos(field_id, insert_pos);
		}
		else
		{
			temp = field_ptr->field_highlight_start_char;
			if (temp < field_ptr->field_highlight_end_char)
				temp = field_ptr->field_highlight_end_char;
			if (temp >= last_visible_char)
			{
				FieldCharPosToLineNum(field_ptr, temp, &line_num);
				if ((line_num - (field_ptr->bounds.height/(line_height)) + 1) < 0)
					FieldSetTopLineNum(field_id, 0);
				else
					FieldSetTopLineNum(field_id, line_num - (field_ptr->bounds.height/(line_height)) + 1);
			}
			// ------------------------------------------------------------
			// ------------- add at 19052000 ------------------------------
			else
			{
				FieldGetNumOfChars(field_id, &temp);
				FieldCharPosToLineNum(field_ptr, temp, &line_num);
				if ((field_ptr->field_top_line_num + (field_ptr->bounds.height/(line_height))) >= line_num)
					if ((line_num - (field_ptr->bounds.height/(line_height)) + 1) < 0)
						FieldSetTopLineNum(field_id, 0);
					else
						FieldSetTopLineNum(field_id, line_num - (field_ptr->bounds.height/(line_height)) + 1);
			}
			// ------------------------------------------------------------
		}
	}
	else
	{
		FieldCharPosToLineNum(field_ptr, last_visible_char, &line_num);
		if ((field_ptr->field_top_line_num + (field_ptr->bounds.height/(line_height))) >= line_num)
			if ((line_num - (field_ptr->bounds.height/(line_height)) + 1) < 0)
				FieldSetTopLineNum(field_id, 0);
			else
				FieldSetTopLineNum(field_id, line_num - (field_ptr->bounds.height/(line_height)) + 1);
	}
	
	return TRUE;
}

/********************************************************
* Function:	AnnScrollbarSetField
* Purpose: 	This function is called to set up the field
*			object when the scrollbar is moved.
* Scope:	application
* Input:	Event		
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AnnScrollbarSetField(ObjectID field_id, ObjectID scrollbar_id, EvtType *Event)
{
	WORD max,min,value,pagesize;
	WORD scroll_total_lines;
	
	ScrollbarGetScrollbar(scrollbar_id, &value, &max, &min, &pagesize, &scroll_total_lines);
	ScrollbarSetScrollbar(scrollbar_id, Event->para2, max, min, pagesize, scroll_total_lines);
	
	FieldSetTopLineNum(field_id, (USHORT)(Event->para2));
	FieldDrawField(field_id);
	
	ScrollbarDrawScrollbar(scrollbar_id);		
	return;
}

/********************************************************
* Function:	AnnFieldtoFieldBuffer
* Purpose: 	This function is called in order to put the data
*			in the field object to field buffer
* Scope:	application
* Input:	dbid			The ID of the database
*			record_id		The ID of the record that is required to be 
*							put in the field objects
* Output:	None
* Return:	TRUE			Success
*			FALSE			FALSE
* Comment: 	None
*********************************************************/
void AnnFieldToFieldBuffer()
{
	BYTE *temp;
	
	if (ann_field_buffer[0] != NULL)
		qfree(ann_field_buffer[0]);
	
	if (app_status.edit_mode == ANN_NEW)
		FieldGetTextPointer(FIELD_ANN_NEW, &temp);
	else
		FieldGetTextPointer(FIELD_ANN_VIEWING, &temp);
	
	ann_field_buffer[0] = (BYTE*)qmalloc((strlen(temp) + 1)*sizeof(BYTE));
	strcpy(ann_field_buffer[0],temp);
}

/******************************************************************
* Function:	AnnSetOfWeekScreen
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnSetStartOfWeekScreen()
{
	CountrySettings	country;
	BYTE	day_buffer[60];
	
	
	SySetupGetCountrySettings(&country);
	
	if (country.start_of_week == SYSETUP_SUN)
		strcpy(day_buffer, ANNSTR3);
	else
		strcpy(day_buffer, ANNSTR4);
	
	StringSetText(STRING_DATE_SETTINGS,day_buffer);
}

/******************************************************************
* Function:	AnnDateSettingYearUpdate
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnDateSettingsUpdate(USHORT year, USHORT month, USHORT day)
{	
	CountrySettings country;
	BYTE	day_buffer[5];
	USHORT	row, col, count=1;
	SHORT	wday, num_days, start_cell;
	
	/* Set up the specified month */
	FormSetControlGroupSelection(FORM_ANN_DATE_SETTINGS,PUSHBUTTON_DATE_SETTINGS_JAN+month-1);
	/* Clear the table */
	day_buffer[0] = 0;
	for (row=0; row<6; row++)
		for (col=0; col<7; col++)
		{
			TableSetItemText(TABLE_DATE_SETTINGS, row, col, day_buffer);
			TableSetHighlightCell(TABLE_DATE_SETTINGS, row, col, FALSE);
		}
		/* Set up the days on the specified table */
		///#ifdef	PC_SIM
		///	RtcYMDToWday1(year, month-1, 1, &wday, &nth_week);
		///#endif
		wday = Dt_Date_WDay (year, month-1, 1);
		
		num_days = RtcGetDaysInMonth(year, month-1);
		SySetupGetCountrySettings(&country);
		
		/* Find out the day of month */
		start_cell = wday - country.start_of_week;
		if (start_cell < 0)
			start_cell = 7 + start_cell;
		
		for (row=0; row<6; row++)
		{
			for (col=start_cell; col<7; col++)
			{
				if (count > num_days)
					break;
				if (count == day)
					TableSetHighlightCell(TABLE_DATE_SETTINGS, row, col, TRUE);
				
				ltoa((long)count, (char *)day_buffer, 10);
				TableSetItemText(TABLE_DATE_SETTINGS, row, col, day_buffer);
				count++;
			}
			start_cell = 0;
		}
		///	DataCloseRecord(ann_dbid,app_status.rec_id);
		
		TableEraseTable(TABLE_DATE_SETTINGS);
		TableDrawTable(TABLE_DATE_SETTINGS);
}

/******************************************************************
* Function:	AnnAlarmSetUpScreen
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnAlarmSetUpScreen()
{
	Control	*ctl_addr;
	BYTE	object_type, buffer[20];
	BYTE	*ptr = buffer;
	SHORT	wlen;
	
	
	if (app_status.alarm_status == TONE_ALARM)
		FormSetControlGroupSelection(FORM_ALARM_SETTINGS,PUSHBUTTON_ALARM_ON);
	else
	{
		FormSetControlGroupSelection(FORM_ALARM_SETTINGS,PUSHBUTTON_ALARM_OFF);
		/* Disable the Alarm Date button */
		FormGetObjectPointer(POPUP_TRIGGER_ALARM_DATE, &object_type, (void **)&ctl_addr);
		ctl_addr->control_attr.control_enable = FALSE;
	}
	
	if (app_status.alarm_status == TONE_ALARM && alarm_date != NO_ALARM_DATE)
	{
		AnnAlarmSetUpButton(ptr, app_status.alarm_year, app_status.alarm_month, app_status.alarm_day, &wlen);
		ptr += wlen;
		AnnPackDueDate(ptr, app_status.alarm_year, app_status.alarm_month, app_status.alarm_day);
		ControlSetLabel(POPUP_TRIGGER_ALARM_DATE,buffer);
		ControlDrawControl(POPUP_TRIGGER_ALARM_DATE);
	}
	else
	{
		strcpy((char *)buffer, ANNSTR1);
		ControlSetLabel(POPUP_TRIGGER_ALARM_DATE,buffer);
	}
}

/******************************************************************
* Function:	AnnAlarmSetUpButton
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnAlarmSetUpButton(BYTE *ptr, SHORT year, SHORT month, SHORT day, SHORT *len)
{
	SHORT	wday, nth_week;
	
#ifdef	PC_SIM
	RtcYMDToWday1(year, month-1, day, &wday, &nth_week);
#endif
	wday = Dt_Date_WDay (year, month-1, day);
	
	if (wday == SYSETUP_SUN)
	{
		strcpy(ptr, ANNSUN1);
		*len = strlen(ANNSUN1);
	}
	else if (wday == SYSETUP_MON)
	{
		strcpy(ptr, ANNMON1);
		*len = strlen(ANNMON1);
	}
	else if (wday == SYSETUP_TUE)
	{
		strcpy(ptr, ANNTUE1);
		*len = strlen(ANNTUE1);
	}
	else if (wday == SYSETUP_WED)
	{
		strcpy(ptr, ANNWED1);
		*len = strlen(ANNWED1);
	}
	else if (wday == SYSETUP_THU)
	{
		strcpy(ptr, ANNTHU1);
		*len = strlen(ANNTHU1);
	}
	else if (wday == SYSETUP_FRI)
	{
		strcpy(ptr, ANNFRI1);
		*len = strlen(ANNFRI1);
	}
	else if (wday == SYSETUP_SAT)
	{
		strcpy(ptr, ANNSAT1);
		*len = strlen(ANNSAT1);
	}
}
/********************************************************
* Function:	AnnFieldBufferToField
* Purpose: 	This function is called to send data from field buffer to 
*			corresponding FIELD objects
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE			success
*			FALSE			error occure
* Comment: 	
*********************************************************/
void AnnFieldBufferToField()
{	
	if (app_status.edit_mode == ANN_NEW)
		FieldSetText(FIELD_ANN_NEW, ann_field_buffer[0]);
	else
		FieldSetText(FIELD_ANN_VIEWING, ann_field_buffer[0]);
}

/********************************************************
* Function:	AnnClearFieldBuffer
* Purpose: 	This function is used to clear the field 
*			buffer of the To Do List Application
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AnnClearFieldBuffer()
{
	if (ann_field_buffer[0] !=NULL)
	{
		qfree(ann_field_buffer[0]);
		ann_field_buffer[0] = NULL;
	}
}

/********************************************************
* Function:	AnnFieldUpdateRecord
* Purpose: 	This function is called in order to save the edited record
*			back into database.
* Scope:	application
* Input:	dbid			The ID of the database
*			record_id		The ID of the record that is required to be 
*							put in the field object
*			new_record		BOOLENA variable to show whether new record or 
*							old record 
* Output:	None
* Return:	TRUE			Success
*			FALSE			FALSE
* Comment: 	None
*********************************************************/
BOOLEAN AnnFieldUpdateRecord()
{
	UWORD	rec_num;
	BYTE	read_status = FALSE;
	
	
	if (app_status.edit_mode == ANN_VIEWING || app_status.edit_mode == ANN_NEW)
	{
		DataRecIDtoNum(ann_dbid, app_status.rec_id, &rec_num);
		DataOpenRecord(ann_dbid, rec_num, &app_status.rec_id, NULL);
		DataWriteField(ann_dbid, app_status.rec_id, 1, (strlen(ann_field_buffer[0]) + 1), ann_field_buffer[0]);
		DataCloseRecord(ann_dbid, app_status.rec_id);
	}	
	/* Clear the field buffer and the corresponding Field object */
	strcpy(ann_field_buffer[0],(BYTE*)(""));
	AnnFieldBufferToField();
	AnnClearFieldBuffer();
	return TRUE;
}

/******************************************************************
* Function:	AnnWeekSettingYearUpdate
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnUpperWeekSettingsUpdate(USHORT input_year, USHORT input_month, USHORT input_day)
{	
	WORD	num_chars;
	SHORT	result_week_num;
	ObjectID	control_id;
	Control		*control_ptr;
	BYTE		object_type;
	CountrySettings	country;
	
	SySetupGetCountrySettings(&country);
	/* Set up the specified week number */
#ifdef	PC_SIM
	result_week_num = Dt_Date_YWeek(input_year, input_month-1, input_day, 0, NULL);
#else
	result_week_num = Dt_Date_YWeek(input_year, input_month-1, input_day, country.start_of_week, NULL);
#endif
	
	///	RtcYMDToWday4(input_year, input_month-1, input_day, &wset_wday, &wset_week_num);
	wset_wday = Dt_Date_WDay(input_year, input_month-1, input_day);
	
	sprintf((char*)ann_text_buffer,"%d", result_week_num);
	TextboxSetText(TEXTBOX_WEEK_SETTINGS, ann_text_buffer);
	TextboxGetNumOfChars(TEXTBOX_WEEK_SETTINGS, &num_chars);
	TextboxSetInsertPointPositionByCharPos(TEXTBOX_WEEK_SETTINGS, num_chars);
	TextboxDrawTextbox(TEXTBOX_WEEK_SETTINGS);
	
	//14082000
	ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 1, &control_id);
	
	if (control_id >= PUSHBUTTON_WEEK_SETTINGS_N1 && control_id <= PUSHBUTTON_WEEK_SETTINGS_N10)
	{
		FormGetObjectPointer(control_id, &object_type, (void**)&control_ptr);
		((ControlTemplatePushButton*)(control_ptr->control_template))->control_value = FALSE;
	}
	
	FormSetControlGroupSelection(FORM_ANN_WEEK_SETTINGS, PUSHBUTTON_WEEK_SETTINGS_SUN+wset_wday);
}

/******************************************************************
* Function:	AnnLowerWeekSettingUpdate
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnLowerWeekSettingsUpdate(USHORT input_year, USHORT input_month, USHORT input_day)
{	
	BYTE	text_buffer[20];
	CountrySettings	country;
	USHORT result_month;
	
	SySetupGetCountrySettings(&country);
	/* Set up the specified week number */
	wset_nth_wday = Dt_Date_M7day (input_year, input_month-1, input_day);		
	result_month = input_month;
	wset_wday = Dt_Date_WDay (input_year, input_month-1, input_day);
	if (wset_nth_wday == 1)
		strcpy(text_buffer, ANNFIRST);
	else if (wset_nth_wday == 2)
		strcpy(text_buffer, ANNSECOND);
	else if (wset_nth_wday == 3)
		strcpy(text_buffer, ANNTHIRD);
	else if (wset_nth_wday == 4)
		strcpy(text_buffer, ANNFORTH);
	else if (wset_nth_wday == 5)
		strcpy(text_buffer, ANNFIFTH);
	else
		strcpy(text_buffer, ANNLAST);
	
	ControlSetLabel(POPUP_TRIGGER_WEEK_SETTINGS_N1, text_buffer);
	ControlDrawControl(POPUP_TRIGGER_WEEK_SETTINGS_N1);
	///	ControlPopupSetSelectedItem(POPUP_TRIGGER_WEEK_SETTINGS_N1, result_nth_wday-1);
	ControlPopupSetSelectedItem(POPUP_TRIGGER_WEEK_SETTINGS_N1, wset_nth_wday-1);
	
	
	if (wset_wday == 0)
		strcpy(text_buffer, ANNSUN);
	else if (wset_wday == 1)
		strcpy(text_buffer, ANNMON);
	else if (wset_wday == 2)
		strcpy(text_buffer, ANNTUE);
	else if (wset_wday == 3)
		strcpy(text_buffer, ANNWED);
	else if (wset_wday == 4)
		strcpy(text_buffer, ANNTHU);
	else if (wset_wday == 5)
		strcpy(text_buffer, ANNFRI);
	else
		strcpy(text_buffer, ANNSAT);
	
	ControlSetLabel(POPUP_TRIGGER_WEEK_SETTINGS_N2, text_buffer);
	ControlDrawControl(POPUP_TRIGGER_WEEK_SETTINGS_N2);
	ControlPopupSetSelectedItem(POPUP_TRIGGER_WEEK_SETTINGS_N2, wset_wday);
	
	if (result_month == 1)
		strcpy(text_buffer, ANNJAN1);
	else if (result_month == 2)
		strcpy(text_buffer, ANNFEB1);
	else if (result_month == 3)
		strcpy(text_buffer, ANNMAR1);
	else if (result_month == 4)
		strcpy(text_buffer, ANNAPR1);
	else if (result_month == 5)
		strcpy(text_buffer, ANNMAY1);
	else if (result_month == 6)
		strcpy(text_buffer, ANNJUN1);
	else if (result_month == 7)
		strcpy(text_buffer, ANNJUL1);
	else if (result_month == 8)
		strcpy(text_buffer, ANNAUG1);
	else if (result_month == 9)
		strcpy(text_buffer, ANNSEP1);
	else if (result_month == 10)
		strcpy(text_buffer, ANNOCT1);
	else if (result_month == 11)
		strcpy(text_buffer, ANNNOV1);
	else if (result_month == 12)
		strcpy(text_buffer, ANNDEC1);
	
	ControlSetLabel(POPUP_TRIGGER_WEEK_SETTINGS_N3, text_buffer);
	ControlDrawControl(POPUP_TRIGGER_WEEK_SETTINGS_N3);
	ControlPopupSetSelectedItem(POPUP_TRIGGER_WEEK_SETTINGS_N3, result_month-1);
}

/******************************************************************
* Function:	AnnYearSettingUpdate
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnYearSettingUpdate(USHORT *input_year, ObjectID form_id)
{
	BYTE		year_buffer[10];
	ObjectID	active_form_id;
	
#ifdef DEBUG
	printf("\n input_year = %ld", *input_year);
	printf("\n form_id = %ld", form_id);
#endif
	
	/* Set up the specified year */
	year_buffer[0] = 0;
	/* Clear all push buttons */
	ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y1, year_buffer);
	ControlEraseControl(PUSHBUTTON_WEEK_SETTINGS_Y1);
	ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y2, year_buffer);
	ControlEraseControl(PUSHBUTTON_WEEK_SETTINGS_Y2);
	ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y3, year_buffer);
	ControlEraseControl(PUSHBUTTON_WEEK_SETTINGS_Y3);
	ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y4, year_buffer);
	ControlEraseControl(PUSHBUTTON_WEEK_SETTINGS_Y4);
	ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y5, year_buffer);
	ControlEraseControl(PUSHBUTTON_WEEK_SETTINGS_Y5);
	
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_DISABLE);
	FormSetControlGroupSelection(form_id,PUSHBUTTON_WEEK_SETTINGS_Y3);
	
	// -------------------------------------------------------------------
	// 28072000
	if (*input_year > 2097)
	{
		sprintf((char*)year_buffer, "%s", "2095");
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y1, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y1);
		
		sprintf((char*)year_buffer, "%s", "2096");
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y2, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y2);
		
		sprintf((char*)year_buffer, "%s", "2097");
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y3, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y3);
		
		sprintf((char*)year_buffer, "%s", "2098");
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y4, year_buffer);
		if (*input_year == 2098)
			FormSetControlGroupSelection(form_id,PUSHBUTTON_WEEK_SETTINGS_Y4);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y4);
		
		sprintf((char*)year_buffer, "%s", "2099");
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y5, year_buffer);
		if (*input_year == 2099)
			FormSetControlGroupSelection(form_id,PUSHBUTTON_WEEK_SETTINGS_Y5);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y5);
	}
	else if (*input_year < 1907)
	{
		sprintf((char*)year_buffer, "%s", "1905");
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y1, year_buffer);
		if (*input_year == 1905)
			FormSetControlGroupSelection(form_id,PUSHBUTTON_WEEK_SETTINGS_Y1);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y1);
		
		sprintf((char*)year_buffer, "%s", "1906");
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y2, year_buffer);
		if (*input_year == 1906)
			FormSetControlGroupSelection(form_id,PUSHBUTTON_WEEK_SETTINGS_Y2);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y2);
		
		sprintf((char*)year_buffer, "%s", "1907");
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y3, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y3);
		
		sprintf((char*)year_buffer, "%s", "1908");
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y4, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y4);
		
		sprintf((char*)year_buffer, "%s", "1909");
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y5, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y5);
	}
	else
	{
		sprintf((char*)year_buffer,"%d", *input_year - 2);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y1, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y1);
		
		sprintf((char*)year_buffer,"%d", *input_year - 1);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y2, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y2);
		
		sprintf((char*)year_buffer,"%d", *input_year);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y3, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y3);
		
		sprintf((char*)year_buffer,"%d", *input_year + 1);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y4, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y4);
		
		sprintf((char*)year_buffer,"%d", *input_year + 2);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y5, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y5);
	}
	// -------------------------------------------------------------------
}

/******************************************************************
* Function:	AnnYearSettingUpdate
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN AnnYearShiftUpdate(BOOLEAN shift)
{
	BYTE		year_buffer[10], *year_label;
	USHORT		input_year;
	
	ControlGetLabel(PUSHBUTTON_WEEK_SETTINGS_Y1, &year_label);
	input_year = (USHORT)atol((const char *)year_label);
	
	// ===================================================================
	// modified at 28072000
	/* Set range from 1905 ~ 2095 */
	if((input_year < 1905 && shift == BACKWARD) || (input_year + 5 > 2099 && shift == FORWARD))
		return FALSE;
	if (input_year > 2090 && shift == FORWARD)
		input_year = 2090;
	
	if (input_year < 1910 && shift == BACKWARD)
		input_year = 1910;
	// ===================================================================
	
	/* Set up the specified year */
	year_buffer[0] = 0;
	/* Clear all push buttons */
	ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y1, year_buffer);
	ControlEraseControl(PUSHBUTTON_WEEK_SETTINGS_Y1);
	ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y2, year_buffer);
	ControlEraseControl(PUSHBUTTON_WEEK_SETTINGS_Y2);
	ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y3, year_buffer);
	ControlEraseControl(PUSHBUTTON_WEEK_SETTINGS_Y3);
	ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y4, year_buffer);
	ControlEraseControl(PUSHBUTTON_WEEK_SETTINGS_Y4);
	ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y5, year_buffer);
	ControlEraseControl(PUSHBUTTON_WEEK_SETTINGS_Y5);
	
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_DISABLE);
	
	if (shift == FORWARD)
	{
		sprintf((char*)year_buffer,"%d", input_year + 5);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y1, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y1);
		
		sprintf((char*)year_buffer,"%d", input_year + 6);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y2, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y2);
		
		sprintf((char*)year_buffer,"%d", input_year + 7);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y3, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y3);
		
		sprintf((char*)year_buffer,"%d", input_year + 8);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y4, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y4);
		
		sprintf((char*)year_buffer,"%d", input_year + 9);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y5, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y5);	
	}
	else
	{
		sprintf((char*)year_buffer,"%d", input_year - 5);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y1, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y1);
		
		sprintf((char*)year_buffer,"%d", input_year - 4);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y2, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y2);
		
		sprintf((char*)year_buffer,"%d", input_year - 3);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y3, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y3);
		
		sprintf((char*)year_buffer,"%d", input_year - 2);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y4, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y4);
		
		sprintf((char*)year_buffer,"%d", input_year - 1);
		ControlSetLabel(PUSHBUTTON_WEEK_SETTINGS_Y5, year_buffer);
		ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_Y5);	
	}
	return	TRUE;
}

/******************************************************************
* Function:	AnnWeekSettingYearOn
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnUpperWeekSettingsOnOff(BOOLEAN case_on)
{	
	Textbox		*text_addr;
	String		*string1_addr, *string2_addr;
	BYTE		object_type;
	
	
	FormGetObjectPointer(STRING_WEEK_SETTINGS_N1, &object_type, (void **)&string1_addr);
	FormGetObjectPointer(STRING_WEEK_SETTINGS_N2, &object_type, (void **)&string2_addr);
	FormGetObjectPointer(TEXTBOX_WEEK_SETTINGS, &object_type, (void **)&text_addr);
	
	if (case_on == TRUE)
	{
		string1_addr->string_bg_color = COLOR_GREY1;
		string2_addr->string_bg_color = COLOR_WHITE;
		text_addr->textbox_background_color = COLOR_GREY1;
		week_click = TRUE;
	}
	else
	{
		string1_addr->string_bg_color = COLOR_WHITE;
		string2_addr->string_bg_color = COLOR_GREY1;
		text_addr->textbox_background_color = COLOR_WHITE;
		week_click = FALSE;
	}
	/* The following objects belong to the upper region */
	StringDrawString(STRING_WEEK_SETTINGS_N1);
	TextboxDrawTextbox(TEXTBOX_WEEK_SETTINGS);
	
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_N1);
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_N2);
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_N3);
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_N4);
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_N5);
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_N6);
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_N7);
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_N8);
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_N9);
	ControlDrawControl(PUSHBUTTON_WEEK_SETTINGS_N10);
	
	/* The following objects belong to the lower region */
	StringDrawString(STRING_WEEK_SETTINGS_N2);
	ControlDrawControl(POPUP_TRIGGER_WEEK_SETTINGS_N1);
	ControlDrawControl(POPUP_TRIGGER_WEEK_SETTINGS_N2);
	ControlDrawControl(POPUP_TRIGGER_WEEK_SETTINGS_N3);
}

/******************************************************************
* Function:	AnnSetUpWeekNumber
* Purpose: 	This function is the event handler for the 
*			DATE SETTINGS screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnSetUpWeekNumber(BYTE add_key)
{
	ObjectID	clicked_id;
	SHORT	result_month, display_sch_year, check_roundoff;
	BYTE	object_type, *text_buffer, *control_text;
	WORD	num_chars;
	Textbox	*text_addr;
	CountrySettings	country;
	RTM		pDate;
	
	
	SySetupGetCountrySettings(&country);
	AnnUpperWeekSettingsOnOff(TRUE);
	FormSetFormActiveObject(FORM_ANN_WEEK_SETTINGS, TEXTBOX_WEEK_SETTINGS);
	TextboxSetInsertPointOn(TEXTBOX_WEEK_SETTINGS);
	
	FormGetObjectPointer(TEXTBOX_WEEK_SETTINGS, &object_type, (void**)&text_addr);
	TextboxGetNumOfChars(TEXTBOX_WEEK_SETTINGS, &num_chars);
	
	if (num_chars >= text_addr->textbox_max_chars)
	{
		TextboxSetInsertPointPositionByCharPos(TEXTBOX_WEEK_SETTINGS, 0);
		TextboxSetText(TEXTBOX_WEEK_SETTINGS, (BYTE*)(""));
	}
	else
		TextboxSetInsertPointPositionByCharPos(TEXTBOX_WEEK_SETTINGS, num_chars);
	
	TextboxAddKeyInChar(TEXTBOX_WEEK_SETTINGS, add_key);
	TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &text_buffer);
	wset_week_num = (SHORT)atol((const char *)text_buffer);
	
	if (wset_week_num < 1 || wset_week_num >54)
		valid_input = FALSE;
	else
	{
		///#ifdef	PC_SIM
		///		if (country.start_of_week == SYSETUP_SUN)
		///			valid_input = RtcWday4ToYMD(app_status.sch_year, wset_week_num, wset_wday, &result_month,(SHORT *)&app_status.sch_day);
		///		else
		///			valid_input = RtcWday5ToYMD(app_status.sch_year, wset_week_num, wset_wday, &result_month,(SHORT *)&app_status.sch_day);
		///#endif
		ControlGetPushedPushButton(FORM_ANN_WEEK_SETTINGS, 0, &clicked_id);
		ControlGetLabel(clicked_id, &control_text);
		display_sch_year = (SHORT)atol((const char *)control_text);
		
		valid_input = Dt_YWeek_Date (display_sch_year, wset_week_num, wset_wday, country.start_of_week, &pDate);
		result_month = pDate.mon;
		app_status.sch_day = pDate.mday;
		
#ifdef	PC_SIM
		Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, 0, &check_roundoff);
#else
		Dt_Date_YWeek (pDate.year, pDate.mon, pDate.mday, country.start_of_week, &check_roundoff);
#endif
		
		if (check_roundoff != display_sch_year)
			valid_input = FALSE;
	}
	app_status.sch_month = result_month + 1;
	date_entry_method = 1;
}

/******************************************************************
* Function:	AnnPackDueDate
* Purpose: 	This function is the event handler for the 
*			DATE SETTINGS screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void AnnPackDueDate(BYTE *ptr, SHORT year, SHORT month, SHORT day)
{
	CountrySettings country;
	
	/* Set up Due Date */
	SySetupGetCountrySettings(&country);
	
	
	if (country.date_fmt == SYSETUP_YMD)
	{
		sprintf((char*)ptr,"%d",year);
		ptr +=4;
		*(ptr++) = '/';
		sprintf((char*)ptr,"%d",month);
		if (month < 10)
			ptr++;
		else
			ptr +=2;
		*(ptr++) = '/';
		if (day < 10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr, "%d", day);
		}
		else
			sprintf((char*)ptr, "%d", day);			
	}
	else if (country.date_fmt == SYSETUP_DMY)
	{
		if (day < 10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",day);
			ptr++;
		}
		else
		{
			sprintf((char*)ptr,"%d",day);
			ptr +=2;
		}
		*(ptr++) = '/';
		sprintf((char*)ptr,"%d",month);
		if (month < 10)
			ptr++;
		else
			ptr +=2;
		*(ptr++) = '/';
		sprintf((char*)ptr,"%d",year);		
	}
	else 
	{
		sprintf((char*)ptr,"%d",month);
		if (month < 10)
			ptr++;
		else
			ptr +=2;
		*(ptr++) = '/';
		if (day < 10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",day);
			ptr++;
		}
		else
		{
			sprintf((char*)ptr,"%d",day);
			ptr +=2;
		}
		*(ptr++) = '/';
		sprintf((char*)ptr,"%d",year);		
	}
}

/********************************************************
* Function:	AnnInitFieldBuffer
* Purpose: 	This function is used to init the field buffer
*			of the To Do List Application
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AnnInitFieldBuffer()
{
	
	if (ann_field_buffer[0] !=NULL)
		qfree(ann_field_buffer[0]);
	ann_field_buffer[0] = (BYTE*)qmalloc(sizeof(BYTE));
	strcpy(ann_field_buffer[0],(BYTE*)(""));
}

/********************************************************
* Function:	AnnMenuSelectedAction
* Purpose: 	This fucntion is to do an action when 
*			an item in a menu is selected
* Scope:	application/internal
* Input:	item_num	The item number of the selectd menu item
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AnnMenuSelectedAction(USHORT item_num)
{
	ObjectID active_form_id;
	ObjectID active_object_id;
	BOOLEAN highlighted = FALSE, insert_pt = FALSE;
	BYTE object_type;
	void *addr;
	Field *field_ptr;
	Textbox *textbox_ptr;
	
	
	FormGetActiveFormID(&active_form_id);
	FormGetActiveObject(active_form_id, &active_object_id);
	if (FormGetObjectPointer(active_object_id, &object_type, (void**)&addr) == FALSE)
		return;
	if (object_type != FIELD && object_type != TEXTBOX && item_num != MENU_ITEM_ZOOM)
		return;
	else if (object_type == FIELD)
	{
		field_ptr = (Field*)addr;
		highlighted = field_ptr->field_attr.field_highlight;
		insert_pt = field_ptr->field_attr.field_insert_pt_visible;
	}
	else if (object_type == TEXTBOX)
	{
		textbox_ptr = (Textbox*)addr;
		highlighted = textbox_ptr->textbox_attr.textbox_highlight;
		insert_pt = textbox_ptr->textbox_attr.textbox_insert_pt_visible;
	}
	
	switch(item_num)
	{
	case	MENU_ITEM_COPY:
		KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
		break;
		
	case	MENU_ITEM_CUT:
		KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
		break;
		
	case	MENU_ITEM_PASTE:
		KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
		break;
		
	case	MENU_ITEM_UNDO:
		if (UIGetUndoStatus() != UNDO_EMPTY)
			KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
		break;
		
	case	MENU_ITEM_ZOOM:
		AnnChangeFont();
		break;
		
	default: break;
	}
}

/********************************************************
* Function:	AnnChangeFont
* Purpose: 	This function is called in order to change the font size fo the 
*			font in each field object
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE		Success
*			FALSE		NotHandled
* Comment: 	None
**********************************************************/
BOOLEAN AnnChangeFont()
{
	ObjectID	fld_id, scrollbar_id, form_id;	
	BYTE		original_font;
	BYTE		object_type;
	Field		*fld_addr;
	
	
	if (app_status.edit_mode == ANN_VIEWING)
	{
		FormGetObjectPointer(FIELD_ANN_VIEWING, &object_type, (void **)&fld_addr);
		FieldGetFont(FIELD_ANN_VIEWING, &original_font);
		scrollbar_id = SCROLLBAR_ANN_VIEWING;
		fld_id = FIELD_ANN_VIEWING;
		form_id = FORM_ANN_VIEWING;
	}
	else 
	{
		FormGetObjectPointer(FIELD_ANN_NEW, &object_type, (void **)&fld_addr);
		FieldGetFont(FIELD_ANN_NEW, &original_font);
		scrollbar_id = SCROLLBAR_ANN_VIEWING;
		fld_id = FIELD_ANN_NEW;
	}
	
	switch (original_font)
	{
	case	SMALL_FONT:
		MenuDeleteItem(ANN_MENU, 4);
		MenuInsertItem(ANN_MENU, 4, ANNSFONT);
		original_font = MEDIUM_FONT;
		break;
		
	case	MEDIUM_FONT:
		MenuDeleteItem(ANN_MENU, 4);
		MenuInsertItem(ANN_MENU, 4, ANNLFONT);
		original_font = SMALL_FONT;
		break;
		
	default: 
		return FALSE;
	}
	
	FieldSetFont(FIELD_ANN_VIEWING, original_font);
	FieldSetFont(FIELD_ANN_NEW, original_font);
	table_font = original_font;
	
	if (show_line == TRUE)
	{
		if (fld_addr->field_attr.field_highlight == TRUE && 
			fld_addr->field_attr.field_insert_pt_visible == FALSE)
			FieldSetInsertPointOff(fld_id);
		else
			FieldSetInsertPointOn(fld_id);
	}
	else
		FieldSetInsertPointOff(fld_id);
	
	AnnEditSetField(form_id, fld_id);
	FieldEraseField(fld_id);
	FieldDrawField(fld_id);
	/* Field update scrollbar */
	AnnFieldSetScrollbar(fld_id, scrollbar_id);
	
	return TRUE;
}

/********************************************************
* Function:	AnnCheckAnyChange
* Purpose: 	This function is called to check any entry change
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE		Updated
*			FALSE		No change
* Comment: 	None
**********************************************************/
BOOLEAN	AnnCheckAnyChange ()
{
	if ((chk_status.alarm_status != app_status.alarm_status) ||
		(chk_status.sch_year != app_status.sch_year) ||
		(chk_status.sch_month != app_status.sch_month) ||
		(chk_status.sch_day != app_status.sch_day) ||
		(chk_status.alarm_year != app_status.alarm_year) ||
		(chk_status.alarm_month	!= app_status.alarm_month) ||
		(chk_status.alarm_day != app_status.alarm_day) ||
		(chk_status.yearly_repeat != app_status.yearly_repeat) ||
		(chk_status.field_change != FALSE))
		return TRUE;
	else
		return FALSE;
}

/********************************************************
* Function:	AnnNewSetUpVariable()
* Purpose: 	
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE		Updated
*			FALSE		No change
* Comment: 	None
**********************************************************/
void AnnNewSetUpVariable()
{
	RTM		time;
	BYTE	temp_buffer[15];
	BYTE	object_type;
	Field	*field_addr;
	CountrySettings	country;
	
	SySetupGetCountrySettings(&country);
	
	RtcGetTime(&time);
	app_status.sch_year = time.year;
	app_status.sch_month = time.mon + 1;
	app_status.sch_day = time.mday;
	strcpy(temp_buffer, DATESET);
	ControlSetLabel(BUTTON_ANN_NEW_DATE, temp_buffer);
	
	alarm_date = NO_ALARM_DATE;
	sch_date = NO_SCH_DATE;
	app_status.alarm_status = NO_ALARM;
	valid_input = TRUE;
	
	///#ifdef	PC_SIM
	///	RtcYMDToWday2(app_status.sch_year, app_status.sch_month-1, app_status.sch_day, &wset_wday, &wset_nth_wday);
	///	RtcYMDToWday4(app_status.sch_year, app_status.sch_month-1, app_status.sch_day, &wset_wday, &wset_week_num);
	///#endif
	wset_nth_wday = Dt_Date_M7day (app_status.sch_year, app_status.sch_month-1, app_status.sch_day);	//	date update
	wset_week_num = Dt_Date_YWeek (app_status.sch_year, app_status.sch_month-1, app_status.sch_day, country.start_of_week, NULL);
	wset_wday = Dt_Date_WDay (app_status.sch_year, app_status.sch_month-1, app_status.sch_day);
	
	chk_status.field_change = FALSE;
	chk_status.new_entry_hit = FALSE;
	FieldSetFont(FIELD_ANN_NEW, table_font);
	FieldSetHighlightSelection(FIELD_ANN_NEW, 0, 0);
	FormGetObjectPointer(FIELD_ANN_NEW, &object_type, (void **)&field_addr);
	field_addr->field_attr.field_highlight = FALSE;
	/* Create a new record */
	DataNewRecord(ann_dbid, 0, ANN_NUM_FIELD, &app_status.rec_id);
}

/********************************************************
* Function:	ToDoListTableSetScrollbar
* Purpose: 	This function is called in order to set the values for a scrollbar		
* Scope:	application
* Input:	BYTE				the starting_char
* Output:	None
* Return:	TRUE		scrollbar is erased
*			FALSE		scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
*			If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN AnnTableSetScrollbar()
{
	WORD temp_value, max_value, min_value, pagesize, total_num_rows;
	
	ScrollbarGetScrollbar(SCROLLBAR_ANN_LIST, &temp_value, &max_value, &min_value, &pagesize, &total_num_rows);
	
	if (anniver_list.total_num_rows > anniver_list.num_rows_displayed)
		ScrollbarSetScrollbarVisible(SCROLLBAR_ANN_LIST,TRUE);
	else
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_ANN_LIST,FALSE);
		ScrollbarEraseScrollbar(SCROLLBAR_ANN_LIST);
		return FALSE;
	}
	ScrollbarDrawScrollbar(SCROLLBAR_ANN_LIST);
	return TRUE;
}

/********************************************************
* Function:	ToDoMenuSelectedAction
* Purpose: 	This fucntion is to do an action when 
*			an item in a menu is selected
* Scope:	application/internal
* Input:	item_num	The item number of the selectd menu item
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
BOOLEAN AnnViewingSelectedLargeFontOnly()
{
	BYTE	original_font;
	
	
	FieldGetFont(FIELD_ANN_VIEWING, &original_font);
	
	switch (original_font)
	{
	case	SMALL_FONT:
		MenuDeleteItem(ANN_MENU, 0);
		MenuInsertItem(ANN_MENU, 0, ANNSFONT);
		original_font = MEDIUM_FONT;
		break;
		
	case	MEDIUM_FONT:
		MenuDeleteItem(ANN_MENU, 0);
		MenuInsertItem(ANN_MENU, 0, ANNLFONT);
		original_font = SMALL_FONT;
		break;
		
	default: 
		return FALSE;
	}
	
	FieldSetFont(FIELD_ANN_VIEWING, original_font);
	FieldSetFont(FIELD_ANN_NEW, original_font);
	table_font = original_font;
	
	if (show_line == TRUE)
		FieldSetInsertPointOn(FIELD_ANN_VIEWING);
	else
		FieldSetInsertPointOff(FIELD_ANN_VIEWING);
	
	AnnEditSetField(FORM_ANN_VIEWING, FIELD_ANN_VIEWING);
	FieldEraseField(FIELD_ANN_VIEWING);
	FieldDrawField(FIELD_ANN_VIEWING);
	/* Field update scrollbar */
	AnnFieldSetScrollbar(FIELD_ANN_VIEWING, SCROLLBAR_ANN_VIEWING);
	return	TRUE;
}

/********************************************************
* Function:	ToDoMenuSelectedAction
* Purpose: 	This fucntion is to do an action when 
*			an item in a menu is selected
* Scope:	application/internal
* Input:	item_num	The item number of the selectd menu item
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AnnSetTableFont()
{
	BYTE		object_type, font_height;
	USHORT		row_number;
	String		*string_addr;
	Scrollbar	*scroll_addr;
	
				
	if (table_font == MEDIUM_FONT)
	{
		FormGetObjectPointer(STRING_ANN_CONTENT_N1, &object_type, (void **)&string_addr);
		if (string_addr->text_font == MEDIUM_FONT) return;
		MenuDeleteItem(MENU_CHANGE_FONT, 0);
		MenuInsertItem(MENU_CHANGE_FONT, 0, ANNSFONT);
		font_height = SysGetFontHeight(MEDIUM_FONT);
		/* Set Large Row Height */
		for (row_number =0; row_number < ANN_LFONT_NUM_OF_ROW; row_number++)
			TableSetRowHeight(TABLE_ANN_LIST, row_number, font_height+3);
		/* Set Large Column Width */
		TableSetColumnWidth(TABLE_ANN_LIST, 0, ANN_LCOLUMN_1);
		TableSetColumnWidth(TABLE_ANN_LIST, 1, ANN_LCOLUMN_2);
		TableSetColumnWidth(TABLE_ANN_LIST, 2, ANN_LCOLUMN_3);
		
		FormGetObjectPointer(SCROLLBAR_ANN_LIST, &object_type, (void**)&scroll_addr);
		scroll_addr->scrollbar_pagesize = ANN_LFONT_NUM_OF_ROW;
		scroll_addr->scrollbar_draw_pagesize = ANN_LFONT_NUM_OF_ROW;
		scroll_addr->scrollbar_total_num_lines = anniver_list.total_num_rows;
		scroll_addr->scrollbar_value = anniver_list.top_row_num;
		scroll_addr->scrollbar_max = scroll_addr->scrollbar_total_num_lines - scroll_addr->scrollbar_pagesize;
	}
	else
	{
		FormGetObjectPointer(STRING_ANN_CONTENT_N1, &object_type, (void **)&string_addr);
		if (string_addr->text_font == SMALL_FONT) return;
		MenuDeleteItem(MENU_CHANGE_FONT, 0);
		MenuInsertItem(MENU_CHANGE_FONT, 0, ANNLFONT);
		font_height = SysGetFontHeight(SMALL_FONT);
		/* Set Small Row Height */
		for (row_number =0; row_number < ANN_SFONT_NUM_OF_ROW; row_number++)
			TableSetRowHeight(TABLE_ANN_LIST, row_number, font_height+1);
		/* Set Small Column Width */
		TableSetColumnWidth(TABLE_ANN_LIST, 0, ANN_SCOLUMN_1);
		TableSetColumnWidth(TABLE_ANN_LIST, 1, ANN_SCOLUMN_2);
		TableSetColumnWidth(TABLE_ANN_LIST, 2, ANN_SCOLUMN_3);
		
		FormGetObjectPointer(SCROLLBAR_ANN_LIST, &object_type, (void**)&scroll_addr);
		scroll_addr->scrollbar_pagesize = ANN_SFONT_NUM_OF_ROW;
		scroll_addr->scrollbar_draw_pagesize = ANN_SFONT_NUM_OF_ROW;
		scroll_addr->scrollbar_total_num_lines = anniver_list.total_num_rows;
		scroll_addr->scrollbar_value = anniver_list.top_row_num;
		scroll_addr->scrollbar_max = scroll_addr->scrollbar_total_num_lines - scroll_addr->scrollbar_pagesize;
		
		if (scroll_addr->scrollbar_value < (ANN_SFONT_NUM_OF_ROW - ANN_LFONT_NUM_OF_ROW))
			anniver_list.top_row_num = 0;
		else if (scroll_addr->scrollbar_value == anniver_list.total_num_rows - anniver_list.num_rows_displayed) /* Last row */
			anniver_list.top_row_num = scroll_addr->scrollbar_value - (ANN_SFONT_NUM_OF_ROW - ANN_LFONT_NUM_OF_ROW);
		else
			anniver_list.top_row_num = scroll_addr->scrollbar_value - (ANN_SFONT_NUM_OF_ROW - ANN_LFONT_NUM_OF_ROW -1);
	}
}

/********************************************************
* Function:	AnnFindOutAlarmSetBy
* Purpose: 	
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AnnFindOutAlarmSetBy()
{
	if (app_status.alarm_status != NO_ALARM)
	{
		if (app_status.sch_year == app_status.alarm_year && 
			app_status.sch_month == app_status.alarm_month &&
			app_status.sch_day == app_status.alarm_day)
			alarm_set_by = ALARM_EXACT_DATE;
		else
			alarm_set_by = ALARM_BEFORE_EXACT_DATE;
	}
	else
		alarm_set_by = NO_ALARM_DATE;
	
	return;
}

/********************************************************
* Function:	AnnYearUpdateDayMonth
* Purpose: 	
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AnnYearUpdateDayMonth(BYTE start_of_week)
{
	SHORT	result_month, result_day;
	BYTE	*text_buffer;
	CountrySettings	country;
	RTM		pDate;
	
	SySetupGetCountrySettings(&country);
	/* Upper Settings */
	if (date_entry_method == 1)
	{
		///#ifdef	PC_SIM
		///		if (start_of_week == SYSETUP_SUN)
		///			valid_input = RtcWday4ToYMD(app_status.sch_year, wset_week_num, wset_wday, &result_month, &result_day);
		///		else
		///			valid_input = RtcWday5ToYMD(app_status.sch_year, wset_week_num, wset_wday, &result_month, &result_day);
		///#endif
		TextboxGetTextPointer(TEXTBOX_WEEK_SETTINGS, &text_buffer);
		wset_week_num = (SHORT)atol((const char *)text_buffer);
		
		valid_input = Dt_YWeek_Date (app_status.sch_year, wset_week_num, wset_wday, country.start_of_week, &pDate);
		
		if (valid_input == OUT_OF_YEAR_BOUNDARY && wset_week_num >= 53)
			valid_input = FALSE;
		else if (valid_input == TRUE || (valid_input == OUT_OF_YEAR_BOUNDARY && wset_week_num <= 52))
		{
			valid_input = TRUE;
			app_status.sch_year = pDate.year;
		}
		result_month = pDate.mon;
		result_day = pDate.mday;
		/* Update New Month & Day by Week Setting */
		app_status.sch_month = result_month+1;
		app_status.sch_day = result_day;
	}
	else if (date_entry_method == 2)
	{
		if (wset_nth_wday == 6)
			Dt_M7day_Date (app_status.sch_year, app_status.sch_month-1, -1, wset_wday, &pDate);
		else
		{
			Dt_M7day_Date (app_status.sch_year, app_status.sch_month-1, wset_nth_wday, wset_wday, &pDate);
			
			if (app_status.sch_month-1 != pDate.mon)
				Dt_M7day_Date (app_status.sch_year, app_status.sch_month-1, -1, wset_wday, &pDate);
		}		
		app_status.sch_day = pDate.mday;
	}
}
