/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   ann.h
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __ANN_H_
#define __ANN_H_

#include "uifunc.h"
#include "ui.h"
#include "mmu.h"
#include "AnnFunc.h"
#include "AnnDB.h"
#include "date.h"
#include "annlang.h"

#ifdef PR31700
#include "ioconmsg.h"
#endif

//#include "tdlann.h"

/*****************************************************************
********************** Anniversaries Application *****************
*****************************************************************/
BOOLEAN SchedulerAnnList(EvtType* Event);
BOOLEAN SchedulerAnnViewing(EvtType* Event);
BOOLEAN SchedulerAnnNew(EvtType* Event); 
BOOLEAN SchedulerAlarmSettings(EvtType* Event); 
BOOLEAN SchedulerWeekSettings(EvtType* Event);
BOOLEAN SchedulerDateSettings(EvtType* Event); 
BOOLEAN SchedulerYearlySettings(EvtType* Event);
BOOLEAN SchedulerSaveChanges(EvtType* Event);
BOOLEAN SchedulerItemErase(EvtType* Event);
BOOLEAN SchedulerInvalidInput(EvtType* Event);
BOOLEAN SchedulerNoRecord(EvtType* Event);
BOOLEAN SchedulerSysLowMem(EvtType *Event);
BOOLEAN SchedulerInvalidAlarmDate(EvtType* Event);

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern DatabaseID	ann_dbid;
extern AppStatus	app_status;
extern TableDisplay	anniver_list;
extern BYTE **		ann_field_buffer;
extern BYTE 		ann_text_buffer[5];
extern SHORT		wset_nth_wday, wset_wday, wset_week_num;

/*****************************************************************
*********************** Global Defines ***************************
*****************************************************************/
#define	ANN_LIST							0
#define ANN_VIEWING							1
#define ANN_NEW								2
#define	ANN_WEEK_SETTINGS					3

#define	ANN_NUM_FIELD						12
#define	ANN_BLOCK_SIZE						20
#define ANN_SFONT_NUM_OF_ROW				11
#define ANN_LFONT_NUM_OF_ROW				8
#define	ANN_LCOLUMN_1						22
#define	ANN_LCOLUMN_2						16
#define	ANN_LCOLUMN_3						94
#define	ANN_SCOLUMN_1						20
#define	ANN_SCOLUMN_2						16
#define	ANN_SCOLUMN_3						96
#define ANN_NUM_OF_ROW						11
#define ANN_SFONT_NUM_OF_CELL					44
#define ANN_LFONT_NUM_OF_CELL					32
#define	MAX_TEXT_ON_DISPLAY					50
#define SAME_ALARM_DATE						0

#define BACKWARD							0
#define FORWARD								1
#define	NO_REPEAT							0
#define	YEARLY_REPEAT						1

#define	ANN_COLUMN_0						0
#define	ANN_COLUMN_1						1
#define	ANN_COLUMN_2						2
#define	ANN_COLUMN_01_DIFF					73
#define	ANN_COLUMN_02_DIFF					84

#define FIELD_VIEWING_HEIGHT_KEYBOARD_ON			66
#define FIELD_NEW_HEIGHT_KEYBOARD_ON				68
///#define FIELD_HEIGHT_KEYBOARD_ON			66
#define FIELD_HEIGHT_KEYBOARD_OFF			108
#define SCROLLBAR_HEIGHT_KEYBOARD_ON		81
#define SCROLLBAR_HEIGHT_KEYBOARD_OFF		123

#define NO_ALARM_DATE						-1
#define ALARM_EXACT_DATE					0
#define	ALARM_BEFORE_EXACT_DATE				1

#define NO_SCH_DATE							0
#define SCH_DATE							1

/*==================== Menu Item ===========================*/

#define MENU_ITEM_COPY						0
#define MENU_ITEM_CUT						1
#define MENU_ITEM_PASTE						2
#define MENU_ITEM_UNDO						3
#define MENU_ITEM_ZOOM						4
#define ANN_MENU						137

/*==================== Menu Large Text ===========================*/
#define MENU_SMALL_TEXT						0
#define MENU_LARGE_TEXT						1

#define	ANN_ALARM_MAX_TEXT					200
#define	NO_ACTIVITY							-1
#define	NO_ALARM							0
#define	TONE_ALARM							1

#define	OUT_OF_YEAR_BOUNDARY				-1
#define YEAR_FIND_BY_WEEK_NUMBER			0
#define	YEAR_ROUNDUP						2
#define YEAR_ROUNDUP_FROM_LAST_YEAR			3
#define	YEAR_FIND_BY_WEEK_AND_LAST_YEAR		4
#define	YEAR_FIND_BY_WEEK_AND_NEXT_YEAR		5
#define YEAR_ROUNDUP_FROM_NEXT_YEAR			6
#define YEAR_FIND_BY_NEXT_YEAR_ROUNDUP		7

/*======================= Anniversaries Database ==============*/
#define ANN_STATUS							0x80001002
#define ANN_EDIT_INFO						0x80001003

//======================= Anniversaries Status Define (Close Application) ========================
#define RESTART_ANNIVER						0
#define RESTART_ANN_VIEWING					1
#define RESTART_ANN_NEW						2
#define	RESTART_ANN_WEEK_SETTINGS			3

/******************************************************************
********************** OBJECT ID Defines **************************
******************************************************************/
/*		FORM ANNIVERSARIES LIST (Form 1)	*/
#define FORM_ANN_LIST						0
#define	POPUP_TRIGGER_CATEGORIES			1
#define	PUSHBUTTON_WEEK_SETTINGS_DISABLE	2
#define	PUSHBUTTON_WEEK_SETTINGS_Y1			3
#define	PUSHBUTTON_WEEK_SETTINGS_Y2			4
#define	PUSHBUTTON_WEEK_SETTINGS_Y3			5
#define	PUSHBUTTON_WEEK_SETTINGS_Y4			6
#define	PUSHBUTTON_WEEK_SETTINGS_Y5			7
#define	BITMAP_WEEK_SETTINGS_N1				8
#define	BITMAP_WEEK_SETTINGS_N2				9
#define TABLE_ANN_LIST						12
#define	STRING_ANN_CONTENT_N1				13
#define	SCROLLBAR_ANN_LIST					35
#define	BUTTON_ANN_NEW_RECORD				36
#define	BUTTON_ANN_GOTO						37
#define STRING_ANN_LIST_MONTH				86
#define	MENU_CHANGE_FONT					142

/*		FORM ANNIVERSARIES VIEWING (Form 2)	*/
#define	FORM_ANN_VIEWING					38
#define	SCROLLBAR_ANN_VIEWING				39
#define	BUTTON_ANN_ALARM					40
#define	BUTTON_ANN_DEL						41
#define	BUTTON_ANN_VIEWING_DATE				42
#define	BITMAP_ANN_VIEWING					43
#define	FIELD_ANN_VIEWING					44
#define	STRING_ANN_VIEWING_TITLE			45

/*		FORM ANNIVERSARIES NEW (Form 3)		*/
#define	FORM_ANN_NEW						46
#define BUTTON_ANN_NEW_DATE					47
#define	FIELD_ANN_NEW						48

/*		FORM ANNIVERSARIES WEEK SETTINGS (Form 4)*/
#define	FORM_ANN_WEEK_SETTINGS				49
#define	PUSHBUTTON_WEEK_SETTINGS_N1			50
#define	PUSHBUTTON_WEEK_SETTINGS_N2			51
#define	PUSHBUTTON_WEEK_SETTINGS_N3			52
#define	PUSHBUTTON_WEEK_SETTINGS_N4			53
#define	PUSHBUTTON_WEEK_SETTINGS_N5			54
#define	PUSHBUTTON_WEEK_SETTINGS_N6			55
#define	PUSHBUTTON_WEEK_SETTINGS_N7			56
#define	PUSHBUTTON_WEEK_SETTINGS_N8			57
#define	PUSHBUTTON_WEEK_SETTINGS_N9			58
#define	PUSHBUTTON_WEEK_SETTINGS_N10		59
#define	PUSHBUTTON_WEEK_SETTINGS_SUN		60
#define	PUSHBUTTON_WEEK_SETTINGS_MON		61
#define	PUSHBUTTON_WEEK_SETTINGS_TUE		62
#define	PUSHBUTTON_WEEK_SETTINGS_WED		63
#define	PUSHBUTTON_WEEK_SETTINGS_THU		64
#define	PUSHBUTTON_WEEK_SETTINGS_FRI		65
#define	PUSHBUTTON_WEEK_SETTINGS_SAT		66
#define	POPUP_TRIGGER_WEEK_SETTINGS_N1		67
#define	POPUP_TRIGGER_WEEK_SETTINGS_N2		68
#define	POPUP_TRIGGER_WEEK_SETTINGS_N3		69
#define	STRING_WEEK_SETTINGS_N1				70
#define TEXTBOX_WEEK_SETTINGS				71
#define	STRING_WEEK_SETTINGS_N2				72

/*		FORM ANNIVERSARIES ALARM SETTINGS (Form 5)*/
#define	FORM_ALARM_SETTINGS					73
#define	PUSHBUTTON_ALARM_ON					74
#define	PUSHBUTTON_ALARM_OFF				75
#define	POPUP_TRIGGER_ALARM_DATE			76
#define	BITMAP_DIALOG_EXIT					79

/*		FORM ANNIVERSARIES YEARLY SETTINGS (Form 6)*/
#define	FORM_YEARLY_SETTINGS				80
#define BUTTON_YEARLY_SETTINGS_N1			81
#define BUTTON_YEARLY_SETTINGS_N2			82
#define	CHECKBOX_YEARLY_SETTINGS			83
#define	BITMAP_YEARLY_REPEAT_DIALOG_EXIT	85

/*		FORM DATE SETTINGS (Form 7)			*/
#define	FORM_ANN_DATE_SETTINGS				108
#define	BUTTON_DATE_SETTINGS_TODAY			110
#define	PUSHBUTTON_DATE_SETTINGS_JAN		111
#define	PUSHBUTTON_DATE_SETTINGS_FEB		112
#define	PUSHBUTTON_DATE_SETTINGS_MAR		113
#define	PUSHBUTTON_DATE_SETTINGS_APR		114
#define	PUSHBUTTON_DATE_SETTINGS_MAY		115
#define	PUSHBUTTON_DATE_SETTINGS_JUN		116
#define	PUSHBUTTON_DATE_SETTINGS_JUL		117
#define	PUSHBUTTON_DATE_SETTINGS_AUG		118
#define	PUSHBUTTON_DATE_SETTINGS_SEP		119
#define	PUSHBUTTON_DATE_SETTINGS_OCT		120
#define	PUSHBUTTON_DATE_SETTINGS_NOV		121
#define	PUSHBUTTON_DATE_SETTINGS_DEC		122
#define	STRING_DATE_SETTINGS				123
#define	TABLE_DATE_SETTINGS					124

/*		FORM SAVE CHANGE (Form 8)			*/
#define	FORM_SAVE_CHANGES					125
#define	BITMAP_SAVE_EXIT					126
#define	STRING_SAVE_CHANGES					127
#define	BUTTON_SAVE_CHANGES_YES				128
#define	BUTTON_SAVE_CHANGES_NO				129

/*		FORM ITEM ERASE (Form 9)			*/
#define	FORM_ITEM_ERASE						130
#define	STRING_ITEM_ERASE_N1				131
#define	STRING_ITEM_ERASE_N2				132
#define	CHECKBOX_ITEM_ERASE					133
#define	BUTTON_ITEM_ERASE_YES				134
#define	BUTTON_ITEM_ERASE_NO				135

/*		FORM DATE SETTINGS (Form 10)		*/
//#define	FORM_ANN_ALARM_DATE_SETTINGS		136

/*		FORM INVALID INPUT (Form 11)		*/
#define	FORM_INVALID_INPUT					138
#define	BITMAP_INVALID_INPUT_EXIT			136

/*		FORM NO RECORD (Form 12)		*/
#define	FORM_NO_RECORD						140

/*		FORM NO RECORD (Form 13)		*/
#define	FORM_SYSTEM_LOW_MEM					143

/*		FORM INVALID ALARM DATE (Form 14)	*/
#define	FORM_INVALID_ALARM_DATE				147

#endif
