/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   anndb.h
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __ANNDB_H_
#define __ANNDB_H_

#include "uifunc.h"
#include "ui.h"
#include "mmu.h"
#include "Ann.h"
#include "AnnFunc.h"
#include "alarmgr.h"
#include "date.h"

/*==================== App Status ===========================*/
typedef struct _AppStatus
{
	RecordID	rec_id;				/* the rec_id */
	BYTE		alarm_status;
	USHORT		sch_year;
	USHORT		sch_month;
	USHORT		sch_day;
	USHORT		alarm_year;
	USHORT		alarm_month;
	USHORT		alarm_day;
	USHORT		selected_year;
	USHORT		selected_month;
	USHORT		selected_day;
	USHORT		input_year;
	BYTE		yearly_repeat;
	BYTE		edit_mode;			/* 0= TO_DO_NEW, 1= TO_DO_VIEWING */
}AppStatus;

typedef struct _CheckStatus
{
	BYTE		alarm_status;
	USHORT		sch_year;
	USHORT		sch_month;
	USHORT		sch_day;
	USHORT		alarm_year;
	USHORT		alarm_month;
	USHORT		alarm_day;
	BYTE		yearly_repeat;
	BOOLEAN		field_change;
	BYTE		new_entry_hit;
}CheckStatus;

/*==================== Anniversaries Records =========================*/
typedef	struct _RecordIDBlock
{
	BYTE		num_records;
	USHORT		round_off[20];
	RecordID	record_id[20];
	DatabaseID	dbid[20];
	struct		_RecordIDBlock *next;
}RecordIDBlock;

typedef	struct _TableDisplay
{	
	ObjectID	table_id;
	USHORT		num_rows_displayed;
	USHORT		total_num_rows;
	USHORT		top_row_num;
	RecordIDBlock *record_id_block;
}TableDisplay;

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern ObjectID		pressed_object1;
extern ObjectID		pressed_object2;
extern BOOLEAN		select_goto, view_records;
extern BOOLEAN		pen_down, valid_input;
extern BYTE			alarm_date;
extern BYTE			sch_date;
extern BYTE			week_click;
extern BYTE			show_line;
extern BYTE			restart_form;
extern BYTE			date_entry_method;
extern BYTE			table_font;
extern WORD			field_top_line, field_insert_pt_pos;
extern ObjectID		low_memory_form_id;
extern BOOLEAN		entry_low_memory, entry_old_edit;

/*****************************************************************
********************** To Do List Application ********************
*****************************************************************/
BOOLEAN TableDisplayDeleteAllRecordID(TableDisplay *table_display);
BOOLEAN AnnTableDisplayDraw(TableDisplay *table_display);
BOOLEAN AnnFieldUpdateRecord();
BOOLEAN AnnCompareAlarmDay(USHORT input_year, USHORT input_month, USHORT input_day);
void AnnAppRestore(BOOLEAN restart);
void AnnAppSave();
void AnnRecordToTable(DatabaseID dbid);
void AnnChangeUpdateRecord();
void AnnDateUpdateRecord(SHORT new_year, SHORT new_month, SHORT new_day, USHORT field_num);
void AnnUpdateNextAlarmDate(SHORT new_year, SHORT new_month, SHORT new_day, USHORT field_num, RecordID rec_id);
void TableDisplayInsertRecordID(TableDisplay *table_display, RecordID record_id, DatabaseID dbid, USHORT write_roundoff);
void AnnDatabaseInit();
void AnnSetAllRecordsAlarm(UWORD rec_num);
void AnnSetNextRecordAlarm(RecordID alarmhit_rec_id);
void AnnDelAnAlarm();
void AnnDatabaseChecking();
void AnnSetFontPageMonth(USHORT sch_month, RecordID rec_id, Table *table_addr, ObjectID cell_ui_id, USHORT max_rows_on_display);
void AnnSetFontPageDate(USHORT sch_day, RecordID rec_id, Table *table_addr, ObjectID cell_ui_id, USHORT max_rows_on_display, USHORT check_entry);
SHORT AnnAddRecord(TableDisplay *table_display, RecordID	rec_id, USHORT insert_row_num, USHORT count, USHORT cell);
void AnnFindRoundOff(TableDisplay *table_display);
USHORT ToDoAnnFindDate(SHORT search_year, RecordID	rec_id);
#endif
