/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   annlch.h
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __ANNLCD_H_
#define __ANNLCD_H_

#include "Ann.h"
#include "AnnFunc.h"
#include "AnnDB.h"
#include "AnnLch.h"
#include "gf.h"
#include "gotorec.h"

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern	AppID		app_id;
extern	BOOLEAN		restore_status, view_records, goto_highlight;
extern	BYTE		show_line;
extern	BOOLEAN		entry_low_memory, entry_old_edit;

//======================== Launch Command ===========================
#define LAUNCH_CMD_NORMAL_LAUNCH	0
#define LAUNCH_CMD_FIND				1
#define LAUNCH_CMD_GOTO_REC			2
#define LAUNCH_CMD_ALARM_HIT		3

/*****************************************************************
********************** To Do List Application ********************
*****************************************************************/
void EventLoop();
void AnnPrepareFindText(DatabaseID dbid, RecordID rec_id, BYTE **prepare_string);
void AnnGotoItem(DatabaseID dbid, RecordID rec_id, USHORT field_num, BYTE *search_string);

BOOLEAN AnnAppLaunch(WORD cmd, void *cmd_ptr);
void AnnLaunchApplication();

#endif
