/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/


#include "stdafx.h"
#include "datatype.h"
#include "App.h"
#include "exrate.h"

//#define DEBUG
//#define DEBUG_UNDO

AppID app_id, appid;
ObjectID enter_form_id = 0;

//================== Calculator Global ===================/
BYTE        comma_type;
BYTE        operation = NO_OPERATION;
BYTE        last_input_type = CAL_EMPTY;

BOOLEAN     has_memory_content = FALSE;
BOOLEAN     error_occured = FALSE;
BOOLEAN     negative = FALSE;
double      input_buffer = 0, memory_buffer = 0,
temp_buffer = 0, temp_buffer1 = 0, result_buffer = 0; 
double      display_value = 0;

BYTE        *display_buffer = NULL;
BYTE        *temp_string;

BYTE        displaying_buffer = 0;
WORD        num_digits = 0;

BOOLEAN     operator_pressed = FALSE;
BOOLEAN     has_decimal = FALSE;

double      temp_value, temp_value1;

BYTE        cal_icon_display = NO_OPERATION;
ObjectID    invalid_paste_id;
BOOLEAN     percent_pressed = FALSE;

//================== Low Memory ===================/
BOOLEAN     low_memory = FALSE;


//================== Metric Global ===================/
/*double	Length[7], Area[9], Volume[5], Weight[7], 
Capacity[5], Velocity[3]/*, Temperature[2]*/;
double Length[7][7], Area[9][9], Volume[5][5], Weight[7][7], 
Capacity[5], Velocity[3]/*, Temperature[2]*/;

MetricInsertPtInfo metric_insert_pt;
BYTE metric_enter_pressed = 0;
BYTE bitmap_entry = 0;


//================== Exchange Global ===================/
MetricInsertPtInfo metric_insert_pt1;
//USHORT exchange_rate_mapping[100];
BYTE exchange_enter_pressed = 0;
//USHORT first_exchange_old_popup_item = 0;
//USHORT second_exchange_old_popup_item = 0;
BYTE        try_exchange = 1;

ObjectID        low_memory_form_id;


//================== Loan Global ===================/
MetricInsertPtInfo	metric_insert_pt2;
BYTE				calculating_item = -1;
BYTE loan_enter_pressed = 0;
BYTE loan_error =  LOAN_NO_ERROR;

/********************************************************
* Function:	CalculatorMain
* Purpose: 	This function is the event handler for the first
page of the calculator application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN CalculatorMain(EvtType *Event)
{
    Bitmap      *bitmap_ptr;
    BYTE        object_type;
    ObjectID    i;
    Control     *control_ptr;
    double      temp;
    WORD        pra2;
	
	if (error_occured == TRUE && Event->eventType == EVT_BITMAP_SELECT &&
		Event->eventID != BITMAP_C && Event->eventID != BITMAP_CE)
		return TRUE;
	
    if (last_input_type == PERCENT)
    {
        if (Event->eventType == EVT_BITMAP_SELECT)
        {
            if (Event->eventID == BITMAP_MR ||
                Event->eventID == BITMAP_0  ||
                Event->eventID == BITMAP_1  ||
                Event->eventID == BITMAP_2  ||
                Event->eventID == BITMAP_3  ||
                Event->eventID == BITMAP_4  ||
                Event->eventID == BITMAP_5  ||
                Event->eventID == BITMAP_6  ||
                Event->eventID == BITMAP_7  ||
                Event->eventID == BITMAP_8  ||  
                Event->eventID == BITMAP_9  ||
                Event->eventID == BITMAP_DOT||
                Event->eventID == BITMAP_COMMA)
            {
                temp = input_buffer;
                input_buffer = result_buffer;
                last_input_type = OPERATOR;
                operator_pressed = TRUE;
                result_buffer = temp;
            }
            else if (Event->eventID == BITMAP_PLUS  ||
				Event->eventID == BITMAP_DIVIDE  ||
				Event->eventID == BITMAP_TIMES  ||
				Event->eventID == BITMAP_MINUS)
            {
                operator_pressed = TRUE;
				
                if (Event->eventID == BITMAP_PLUS)
                {
                    operation = ADD;
                    cal_icon_display = ADD;
                }
                else if (Event->eventID == BITMAP_TIMES)
                {
                    operation = TIMES;
                    cal_icon_display = TIMES;
                }
                else if (Event->eventID == BITMAP_MINUS)
                {
                    operation = SUB;
                    cal_icon_display = SUB;
                }
                else
                {
                    operation = DIV;
                    cal_icon_display = DIV;
                }
                BitmapEraseBitmap(BITMAP_CAL_PLUS);
                BitmapEraseBitmap(BITMAP_CAL_DIV);
                BitmapEraseBitmap(BITMAP_CAL_SUB);
                BitmapEraseBitmap(BITMAP_CAL_MUL);
                CalculatorDrawSymbol();
                last_input_type = OPERATOR;
                return TRUE;
            }               
            else if (Event->eventID == BITMAP_PERCENT)
                return TRUE;
        }
    }
	
	
	switch (Event->eventType)
	{
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY && ((Event->para2 & 0x100) == 0) &&
			((Event->para2 & 0x200) == 0))
		{
			switch (Event->para1)
			{
			case '0':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_0, 0, 0, NULL);
				return TRUE;
			case '1':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_1, 0, 0, NULL);
				return TRUE;
			case '2':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_2, 0, 0, NULL);
				return TRUE;
			case '3':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_3, 0, 0, NULL);
				return TRUE;
			case '4':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_4, 0, 0, NULL);
				return TRUE;
			case '5':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_5, 0, 0, NULL);
				return TRUE;
			case '6':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_6, 0, 0, NULL);
				return TRUE;
			case '7':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_7, 0, 0, NULL);
				return TRUE;
			case '8':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_8, 0, 0, NULL);
				return TRUE;
			case '9':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_9, 0, 0, NULL);
				return TRUE;
			case '.':
				FormGetObjectPointer(BITMAP_DOT, &object_type, (void**)&bitmap_ptr);
				if (bitmap_ptr->bitmap_attr.bitmap_visible)
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_DOT, 0, 0, NULL);
				else EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_COMMA, 0, 0, NULL);
				return TRUE;
			case '%':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_PERCENT, 0, 0, NULL);
				return TRUE;
			case '*':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_TIMES, 0, 0, NULL);
				return TRUE;
			case 'x':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_TIMES, 0, 0, NULL);
				return TRUE;
			case 13:
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EQUAL, 0, 0, NULL);
				return TRUE;
			case '=':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EQUAL, 0, 0, NULL);
				return TRUE;
			case '+':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_PLUS, 0, 0, NULL);
				return TRUE;
			case '-':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_MINUS, 0, 0, NULL);
				return TRUE;
			case '/':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_DIVIDE, 0, 0, NULL);
				return TRUE;
			case 247:
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_DIVIDE, 0, 0, NULL);
				return TRUE;
			case 8:
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_CE, 0, 0, NULL);
				return TRUE;
			case 'c':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_C, 0, 0, NULL);
				return TRUE;
			case 'C':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_C, 0, 0, NULL);
				return TRUE;
			case 'S':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_SQUROOT, 0, 0, NULL);
				return TRUE;
			case 's':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_SQUROOT, 0, 0, NULL);
				return TRUE;
			case 9:
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_POS_NEG, 0, 0, NULL);
				return TRUE;
			case 'Q':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_MC, 0, 0, NULL);
				return TRUE;
			case 'q':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_MC, 0, 0, NULL);
				return TRUE;
			case 'W':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_MR, 0, 0, NULL);
				return TRUE;
			case 'w':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_MR, 0, 0, NULL);
				return TRUE;
			case 'E':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_MPLUS, 0, 0, NULL);
				return TRUE;
			case 'e':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_MPLUS, 0, 0, NULL);
				return TRUE;
			case 'R':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_MMINUS, 0, 0, NULL);
				return TRUE;
			case 'r':
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_MMINUS, 0, 0, NULL);
				return TRUE;
			default: return FALSE;
                  }
            }
            else if (Event->eventType   == EVT_KEY &&
				Event->eventID     == SOFT_KEY &&
				(Event->para2 & 0x200))
            {
                if (Event->para1 == '0')
                {
                    ControlPopupPopupTrigger(MODE_SELECTOR);
                    return TRUE;
                }
            }
			
            break;
        case EVT_INLAY_SELECT:
            if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
            {
                //SysGetAppID((BYTE*)("Mainmenu"), &app_id);
                SysGetAppID(MAINMENU, &app_id);
                EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
                EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
            }
            return TRUE;
		case EVT_MENU_SELECT_ITEM:
            if (Event->para1 == 1)
                Event->para1 = MENU_ITEM_CALCULATOR_PASTE;
			MenuItemSelectedAction((USHORT)(Event->para1));
			return TRUE;
		case EVT_CONTROL_POPUP_SELECT:
			if (Event->para1 == 1)
			{
				MathsAppPartialRestore(FORM_METRIC);
				MetricExchangeSetKeypadPos(FORM_METRIC);
				metric_insert_pt.insert_pt_on = TRUE;
				metric_insert_pt.textbox_id = TEXTBOX_METRIC_0;
				TextboxSetInsertPointOn(TEXTBOX_METRIC_0);
				FormSetFormActiveObject(FORM_METRIC, TEXTBOX_METRIC_0);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_METRIC_0, 0);
				TextboxSetInsertPointOff(TEXTBOX_METRIC_1);
				FormPopupForm(FORM_METRIC);
			}
			else if (Event->para1 == 2)
			{
                low_memory_form_id = FORM_CALCULATOR;
                if (MemoryLow)
                {
					MetricExchangeSetKeypadPos(FORM_EXCHANGE);
					FormPopupForm(FORM_EXCHANGE);
					return TRUE;
				}
				if (MathsAppPartialRestore(FORM_EXCHANGE) == FALSE)
				{
					ExchangeDisplayExchangeRate();
					ExchangeSetStringExchange0Text();
					ExchangeSetStringExchange1Text();
				}
				MetricExchangeSetKeypadPos(FORM_EXCHANGE);
				FormPopupForm(FORM_EXCHANGE);
			}
			else if (Event->para1 == 3)
			{
				MathsAppPartialRestore(FORM_LOAN);
				MetricExchangeSetKeypadPos(FORM_LOAN);
				metric_insert_pt2.insert_pt_on = FALSE;
				metric_insert_pt2.textbox_id = 0;
				TextboxSetInsertPointOff(TEXTBOX_LOAN_NUM_YEARS);
				TextboxSetInsertPointOff(TEXTBOX_LOAN_INTEREST_RATE);
				TextboxSetInsertPointOff(TEXTBOX_LOAN_LOAN_AMOUNT);
				TextboxSetInsertPointOff(TEXTBOX_LOAN_MONTHLY_PAYMENT);
                if (calculating_item != 0)
				{
					metric_insert_pt2.insert_pt_on = TRUE;
					metric_insert_pt2.textbox_id = TEXTBOX_LOAN_NUM_YEARS;
					TextboxSetInsertPointOn(TEXTBOX_LOAN_NUM_YEARS);
					FormSetFormActiveObject(FORM_LOAN, TEXTBOX_LOAN_NUM_YEARS);
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_LOAN_NUM_YEARS, 0);
				}
				else
				{
					metric_insert_pt2.insert_pt_on = TRUE;
					metric_insert_pt2.textbox_id = TEXTBOX_LOAN_INTEREST_RATE;
					TextboxSetInsertPointOn(TEXTBOX_LOAN_INTEREST_RATE);
					FormSetFormActiveObject(FORM_LOAN, TEXTBOX_LOAN_INTEREST_RATE);
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_LOAN_INTEREST_RATE, 0);
				}
                for (i = CHECKBOX_LOAN_NUM_YEARS; i <= CHECKBOX_LOAN_MONTHLY_PAYMENT; i ++)
                {
                    FormGetObjectPointer((ObjectID)(i), &object_type, (void**)&control_ptr);
                    if (calculating_item == NO_SELECTION)
                    {
                        control_ptr->control_attr.control_enable = FALSE;
                        ((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
                    }
                    else if (i == (calculating_item + CHECKBOX_LOAN_NUM_YEARS))
                    {
                        control_ptr->control_attr.control_enable = FALSE;
                        ((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = TRUE;
                    }
                    else
                    {
                        control_ptr->control_attr.control_enable = TRUE;
                        ((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
                    }
                }
				FormPopupForm(FORM_LOAN);
			}
			return TRUE;
		case EVT_BITMAP_SELECT:
			{
				switch (Event->eventID)
				{
				case BITMAP_MC:	//has_decimal = FALSE;
					memory_buffer = 0;
					has_memory_content = FALSE;
					CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					break;
				case BITMAP_MR:	has_decimal = FALSE;
					if (last_input_type == EQUAL || last_input_type == MPLUS ||
						last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					if (has_memory_content == TRUE)
					{
						dtoa(memory_buffer, (char*)display_buffer, 20);
						display_value = memory_buffer;
					}
					else
					{
						memory_buffer = 0;
						CalculatorClearDisplayBuffer();
					}
					CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					if (displaying_buffer == INPUT)
					{
						input_buffer = display_value;
						last_input_type = MR;
					}
					else if (displaying_buffer == RESULT)
					{
						input_buffer = display_value;
						if (last_input_type == EQUAL)
						{
							result_buffer = 0;
							last_input_type = DIGITS;
							operation = ADD;
							operator_pressed = FALSE;
						}
						else last_input_type = MR;
					}		
					
					percent_pressed = FALSE;
					break;
				case BITMAP_MPLUS: has_decimal = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS ||
						last_input_type == OPERATOR || last_input_type == EQUAL ||
						last_input_type == SQUROOT_R)
					{
						temp_value1 = memory_buffer;
						temp_value = display_value;
						
						//memory_buffer += temp_value;
						memory_buffer = add(memory_buffer, temp_value);
						if (fabs(memory_buffer) >= 1e+12) /* || fabs(memory_buffer) <= 1e-11) */
						{	
							error_occured = TRUE;
							CalculatorClearDisplayBuffer();
							memory_buffer = temp_value1;
						}
						temp_value = 0;
						temp_value1 = 0;
					}
					else
					{
						cal_icon_display = NO_OPERATION;
						temp_value1 = memory_buffer;
						CalculatorCalculation(EQUAL);
						dtoa(result_buffer, (char*)display_buffer,20);
						display_value = result_buffer;
						//memory_buffer += result_buffer;
						memory_buffer = add(memory_buffer, result_buffer);
						if (fabs(memory_buffer) >= 1e+12)
						{	
							error_occured = TRUE;
							CalculatorClearDisplayBuffer();
							memory_buffer = temp_value1;
						}
						temp_value1 = 0;
					}
					if (fabs(memory_buffer) <= 1e-11)
						has_memory_content = FALSE;
					else has_memory_content = TRUE;
					last_input_type = MPLUS;
					CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					break;
				case BITMAP_POS_NEG:   	if (display_value == 0)
											break;
					temp_value = display_value;
					temp_value = -temp_value;
					if (displaying_buffer == INPUT)
						input_buffer = temp_value;
					else if (displaying_buffer == RESULT)
						result_buffer = temp_value;
					if (temp_value < 0 && display_buffer[0] != '-')
					{
						temp_string = (BYTE*)qmalloc((strlen(display_buffer) + 2) * sizeof(BYTE));
						strcpy((temp_string + 1), display_buffer);
						temp_string[0] = '-';
						strcpy(display_buffer, temp_string);
						qfree(temp_string);
					}
					else if (temp_value >= 0 && display_buffer[0] == '-')
					{
						temp_string = (BYTE*)qmalloc((strlen(display_buffer) + 2) * sizeof(BYTE));
						strcpy(temp_string, (display_buffer + 1));
						strcpy(display_buffer, temp_string);
						qfree(temp_string);
					}
					display_value = temp_value;
					CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					break;
				case BITMAP_MMINUS: has_decimal = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS ||
						last_input_type == OPERATOR || last_input_type == EQUAL ||
						last_input_type == SQUROOT_R)
					{
						temp_value1 = memory_buffer;
						temp_value = display_value;
						memory_buffer = subtract(memory_buffer,temp_value);
						if (fabs(memory_buffer) >= 1e+12)/* || fabs(memory_buffer) <= 1e-11)*/
						{
							error_occured = TRUE;
							CalculatorClearDisplayBuffer();
							memory_buffer = temp_value1;
						}
						temp_value1 = 0;
						temp_value = 0;
					}
					else
					{
						cal_icon_display = NO_OPERATION;
						temp_value1 = memory_buffer;
						CalculatorCalculation(EQUAL);
						dtoa(result_buffer, (char*)display_buffer,20);
						display_value = result_buffer;
						memory_buffer = subtract(memory_buffer,result_buffer);
						if (fabs(memory_buffer) >= 1e+12)
						{
							error_occured = TRUE;
							CalculatorClearDisplayBuffer();
							memory_buffer = temp_value1;
						}
						temp_value1 = 0;
					}
					if (fabs(memory_buffer) <= 1e-11)
						has_memory_content = FALSE;
					else has_memory_content = TRUE;
					last_input_type = MPLUS;
					CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					break;
				case BITMAP_C:	/* initialising all variables */
					has_decimal = FALSE;
					operation = ADD;
					displaying_buffer = INPUT;
					operator_pressed = FALSE;
					negative = FALSE;
					error_occured = FALSE;
					input_buffer = 0;
					result_buffer = 0;
					cal_icon_display = NO_OPERATION;
					
					/* draw 0 to DISPLAY */
					CalculatorClearDisplayBuffer();	
					CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					
					percent_pressed = FALSE;
					break;
				case BITMAP_7:	if (last_input_type != DIGITS ||last_input_type == MR)
									CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('7');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;
				case BITMAP_8:  if (last_input_type != DIGITS ||last_input_type == MR)
									CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('8');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;			
				case BITMAP_9:	if (last_input_type != DIGITS ||last_input_type == MR)
									CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('9');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;
				case BITMAP_PERCENT: has_decimal = FALSE;
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					else if (last_input_type == DIGITS && operator_pressed == FALSE)
					{
						num_digits = 0;
						input_buffer = 0;
						strcpy(display_buffer, (BYTE*)(""));
						display_value = input_buffer;
						displaying_buffer = INPUT;
						cal_icon_display = NO_OPERATION;
						CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					}
					else if (last_input_type == OPERATOR && (operation == TIMES || operation == DIV) && operator_pressed == TRUE)
					{
						temp_buffer = input_buffer;
						temp_buffer = temp_buffer/(double)100;
						input_buffer = temp_buffer;
						dtoa(input_buffer, (char*)display_buffer, 20);
						display_value = input_buffer;
						displaying_buffer = INPUT;
						cal_icon_display = NO_OPERATION;
						CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
						last_input_type = DIGITS;
						percent_pressed = TRUE;
					}
					else if ((last_input_type == DIGITS || last_input_type == UNKNOWN ||
						last_input_type == SQUROOT_I ||
						last_input_type == MR) && operator_pressed == TRUE)
					{
						CalculatorCalculation(PERCENT);
						if (operation == ADD || operation == SUB ||
							operation == TIMES || operation == DIV)
						{
							//dtoa(input_buffer, (char*)display_buffer, 20);
							//display_value = input_buffer;
							dtoa(result_buffer, (char*)display_buffer, 20);
							display_value = result_buffer;
							last_input_type = PERCENT;
						}
						//displaying_buffer = INPUT;
						cal_icon_display = NO_OPERATION;
						CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					}
					else if ((last_input_type == SQUROOT_R) && operator_pressed == TRUE)
					{
						result_buffer = 0;
						dtoa(result_buffer, (char*)display_buffer, 20);
						display_value =  result_buffer;
						displaying_buffer = RESULT;
						cal_icon_display = NO_OPERATION;
						CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
						input_buffer = display_value;
					}
					break;
				case BITMAP_CE:	has_decimal = FALSE;
					if (displaying_buffer == INPUT)
					{
						last_input_type = UNKNOWN;
						input_buffer = 0;
						dtoa(input_buffer, (char*)display_buffer, 20);
						display_value = input_buffer;
						displaying_buffer = INPUT;
						CalculatorClearDisplayBuffer();
						CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					}
					else EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_C, 0, 0, NULL);
					
					percent_pressed = FALSE;
					break;
				case BITMAP_4:	if (last_input_type != DIGITS ||last_input_type == MR)
									CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('4');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;
				case BITMAP_5:	if (last_input_type != DIGITS ||last_input_type == MR)
									CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('5');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;
					break;
				case BITMAP_6:	if (last_input_type != DIGITS ||last_input_type == MR)
									CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('6');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;
				case BITMAP_MINUS:  has_decimal = FALSE;
					operator_pressed = TRUE;
					if (last_input_type == CAL_EMPTY)
					{
						operation = SUB;
						last_input_type = OPERATOR;
						cal_icon_display = SUB;
						CalculatorDrawSymbol();
						
					}
					else if (last_input_type == OPERATOR)
					{
						operation = SUB;
						cal_icon_display = SUB;
						CalculatorDrawSymbol();
					}
					else if (last_input_type == EQUAL || last_input_type == UNKNOWN ||
						last_input_type == MPLUS || last_input_type == MMINUS)
					{
						operation = SUB;
						last_input_type = OPERATOR;
						cal_icon_display = SUB;
						CalculatorDrawSymbol();
					}
					else if (last_input_type == DIGITS || last_input_type == PERCENT ||
						last_input_type == MR || last_input_type == SQUROOT_I)
					{
						last_input_type = OPERATOR;
						CalculatorCalculation(SUB);
						dtoa(result_buffer, (char*)display_buffer, 20);
						display_value = result_buffer;
						displaying_buffer = RESULT;
						cal_icon_display = SUB;
						CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					}
					else if (last_input_type == SQUROOT_R)
					{
						last_input_type = OPERATOR;
						operation = SUB;
						cal_icon_display = SUB;
						CalculatorDrawSymbol();
					}
					
					percent_pressed = FALSE;
					break;
				case BITMAP_SQUROOT: 
					has_decimal = FALSE;
					if (((last_input_type == MR) && (displaying_buffer == INPUT)) || last_input_type == DIGITS ||
						last_input_type == SQUROOT_I/* || last_input_type == PERCENT*/)
					{
						if (input_buffer < 0)
							error_occured = TRUE;
						else
						{
							CalculatorCalculation(SQUROOT);
							dtoa(input_buffer, (char*)display_buffer, 20);
							display_value = input_buffer;
							displaying_buffer = INPUT;
							last_input_type = SQUROOT_I;
						}
					}
					else if (last_input_type == OPERATOR || last_input_type == PERCENT ||
						last_input_type == SQUROOT_R || last_input_type == EQUAL ||
						last_input_type == MPLUS || last_input_type == MMINUS ||
						(last_input_type == MR && displaying_buffer == RESULT))
					{
						if (result_buffer < 0)
							error_occured = TRUE;
						else
						{
							CalculatorCalculation(SQUROOT);
							dtoa(result_buffer, (char*)display_buffer, 20);
							display_value = result_buffer;
							displaying_buffer = RESULT;
							last_input_type = SQUROOT_R;
							cal_icon_display = NO_OPERATION;
						}
					}
					CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					
					percent_pressed = FALSE;
					break;
				case BITMAP_1:if (last_input_type != DIGITS ||last_input_type == MR)
								  CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('1');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;
				case BITMAP_2:	if (last_input_type != DIGITS ||last_input_type == MR)
									CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('2');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;
				case BITMAP_3:	if (last_input_type != DIGITS ||last_input_type == MR)
									CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('3');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;
				case BITMAP_PLUS: operator_pressed= TRUE;
					has_decimal = FALSE;
					if (last_input_type == CAL_EMPTY)
					{
						operation = ADD;
						last_input_type = OPERATOR;
						cal_icon_display = ADD;
						CalculatorDrawSymbol();
					}
					else if (last_input_type == OPERATOR)
					{
						operation = ADD;
						cal_icon_display = ADD;
						CalculatorDrawSymbol();
					}
					else if (last_input_type == EQUAL || last_input_type == UNKNOWN ||
						last_input_type == MPLUS || last_input_type == MMINUS)
					{
						operation = ADD;
						last_input_type = OPERATOR;
						cal_icon_display = ADD;
						CalculatorDrawSymbol();
					}
					else if (last_input_type == DIGITS || last_input_type == PERCENT ||
						last_input_type == MR || last_input_type == SQUROOT_I)
					{
						last_input_type = OPERATOR;
						CalculatorCalculation(ADD);
						dtoa(result_buffer, (char*)display_buffer, 20);
						display_value = result_buffer;
						displaying_buffer = RESULT;
						cal_icon_display = ADD;
						CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					}
					else if (last_input_type == SQUROOT_R)
					{
						last_input_type = OPERATOR;
						operation = ADD;
						cal_icon_display = ADD;
						CalculatorDrawSymbol();
					}
					
					percent_pressed = FALSE;
					break;
				case BITMAP_DIVIDE: has_decimal = FALSE;
					operator_pressed = TRUE;
					if (last_input_type == CAL_EMPTY)
					{
						operation = DIV;
						last_input_type = OPERATOR;
						cal_icon_display = DIV;
						CalculatorDrawSymbol();
					}
					else if (last_input_type == OPERATOR)
					{
						operation = DIV;
						cal_icon_display = DIV;
						CalculatorDrawSymbol();
					}
					else if (last_input_type == EQUAL || last_input_type == UNKNOWN ||
						last_input_type == MPLUS || last_input_type == MMINUS)
					{
						operation = DIV;
						last_input_type = OPERATOR;
						cal_icon_display = DIV;
						CalculatorDrawSymbol();
					}
					else if (last_input_type == DIGITS || last_input_type == PERCENT ||
						last_input_type == MR || last_input_type == SQUROOT_I)
					{
						last_input_type = OPERATOR;
						CalculatorCalculation(DIV);
						dtoa(result_buffer, (char*)display_buffer, 20);
						display_value = result_buffer;
						displaying_buffer = RESULT;
						cal_icon_display = DIV;
						CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					}
					else if (last_input_type == SQUROOT_R)
					{
						last_input_type = OPERATOR;
						operation = DIV;
						cal_icon_display = DIV;
						CalculatorDrawSymbol();
					}
					
					percent_pressed = FALSE;
					break;			
				case BITMAP_0:if (last_input_type != DIGITS ||last_input_type == MR)
								  CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('0');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;
				case BITMAP_DOT: if (last_input_type != DIGITS ||last_input_type == MR)
									 CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('.');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;
				case BITMAP_EQUAL: cal_icon_display = NO_OPERATION;
					has_decimal = FALSE;
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type == OPERATOR)
					{
						switch (operation)
						{
						case ADD: input_buffer = result_buffer;
							result_buffer = add(result_buffer, result_buffer);
							dtoa(result_buffer, (char*)display_buffer, 20);	      
							display_value = result_buffer;
							displaying_buffer = RESULT;
							CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
							break;
						case SUB: input_buffer = result_buffer;
							result_buffer = 0;
							dtoa(result_buffer, (char*)display_buffer, 20);
							display_value = result_buffer;
							CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
							displaying_buffer = RESULT;
							break;
						case TIMES: 
							input_buffer = result_buffer;
							result_buffer *= result_buffer;
							dtoa(result_buffer, (char*)display_buffer, 20);
							display_value = result_buffer;
							CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
							displaying_buffer = RESULT;
							break;
						case DIV: 
							input_buffer = result_buffer;
							if (result_buffer)
							{	
								result_buffer = result_buffer/result_buffer;
								dtoa(result_buffer, (char*)display_buffer, 20);
							}
							else
							{
								result_buffer = 0;
								strcpy(display_buffer, (BYTE*)("E"));
								error_occured = TRUE;
							}	
							display_value = result_buffer;
							CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
							displaying_buffer = RESULT;
							break;
						default:  operation = NO_OPERATION;
							break;
						}
						last_input_type = EQUAL;
					}
					else if (last_input_type == DIGITS || last_input_type == PERCENT ||
						last_input_type == EQUAL || last_input_type == UNKNOWN ||
						last_input_type == MR || last_input_type == SQUROOT_I ||
						last_input_type == MPLUS || last_input_type == MMINUS)
					{	
						if (operator_pressed == TRUE)
						{
							last_input_type = EQUAL;
							CalculatorCalculation(EQUAL);
							dtoa(result_buffer, (char*)display_buffer, 20);
							display_value = result_buffer;
							CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
							displaying_buffer = RESULT;
						}		 
						else if (last_input_type == DIGITS && operator_pressed == FALSE)
						{
							CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
							result_buffer = input_buffer;
						}
						else if (operator_pressed == FALSE && last_input_type == SQUROOT_I)
						{
							result_buffer = input_buffer;
						}
					}
					else if (last_input_type == SQUROOT_R)
					{
						last_input_type = EQUAL;
						CalculatorCalculation(EQUAL);
						dtoa(result_buffer, (char*)display_buffer, 20);
						display_value = result_buffer;
						displaying_buffer = RESULT;
						CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					}
					last_input_type = EQUAL;
					
					percent_pressed = FALSE;
					break;
				case BITMAP_TIMES:  operator_pressed = TRUE;
					has_decimal = FALSE;
					if (last_input_type == CAL_EMPTY)
					{
						operation = TIMES;
						last_input_type = OPERATOR;
						cal_icon_display = TIMES;
						CalculatorDrawSymbol();
					}
					else if (last_input_type == OPERATOR)
					{
						operation = TIMES;
						cal_icon_display = TIMES;
						CalculatorDrawSymbol();
					}
					else if (last_input_type == EQUAL || last_input_type == UNKNOWN ||
						last_input_type == MPLUS || last_input_type == MMINUS)
					{	
						operation = TIMES;
						last_input_type = OPERATOR;
						cal_icon_display = TIMES;
						CalculatorDrawSymbol();
					}
					else if (last_input_type == DIGITS || last_input_type == PERCENT ||
						last_input_type == MR || last_input_type == SQUROOT_I)
					{
						last_input_type = OPERATOR;	
						CalculatorCalculation(TIMES);
						dtoa(result_buffer, (char*)display_buffer, 20);
						display_value = result_buffer;
						displaying_buffer = RESULT;
						cal_icon_display = TIMES;
						CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
					}
					else if (last_input_type == SQUROOT_R)
					{
						last_input_type = OPERATOR;
						operation = TIMES;
						cal_icon_display = TIMES;
						CalculatorDrawSymbol();
					}
					
					percent_pressed = FALSE;
					break;
				case BITMAP_COMMA:  if (last_input_type != DIGITS ||last_input_type == MR)
										CalculatorClearDisplayBuffer();
					if (last_input_type == CAL_EMPTY)
						operation = ADD;
					if (last_input_type != DIGITS)
						negative = FALSE;
					if (last_input_type == MPLUS || last_input_type == MMINUS)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						operation = ADD;
					}
					else if (last_input_type == EQUAL)
					{
						CalculatorClearDisplayBuffer();
						result_buffer = 0;
						last_input_type = DIGITS;
						operation = ADD;
						operator_pressed = FALSE;
					}
					else if (percent_pressed)
						CalculatorClearDisplayBuffer();
					last_input_type = DIGITS;
					CalculatorNewDigitToDisplayBuffer('.');
					input_buffer = display_value;
					displaying_buffer = INPUT;
					break;
				default: break;
		  }
		}
		break;
		case EVT_FORM_OPEN:
			if (cal_icon_display == NO_OPERATION)
			{
				FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			}
			FormDrawForm(FORM_CALCULATOR);
			FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			break;
		case EVT_FORM_CLOSE:
			break;
	}
	return TRUE;
}

/********************************************************
* Function:	MetricMain
* Purpose: 	This function is the event handler for the FORM_METRIC
page of the calculator application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN MetricMain(EvtType *Event)
{
	Textbox     *textbox_ptr;
	ObjectID    active_object, current_control_id;
	BYTE        object_type;
	EvtType     new_event;
	BYTE        *textbox_text, *temp_text;
    WORD        i;
    ObjectID    tempID;
    Control     *control_ptr;
    SHORT 	    selected_item;
    ObjectID    pushed_button;
	
	
    if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
    {
        if (((Event->para2 & 0x100) == 0) && ((Event->para2 & 0x200) == 0))
        {
            if (Event->para1 == LLETTER_METRIC_C || Event->para1 == SLETTER_METRIC_C)
            {
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_METRIC_C;
            }
        }
        else if (Event->para2 & 0x200)
        {
            if (Event->para1 == 9)
            {
                ControlGetPushedPushButton(FORM_METRIC, 1, &pushed_button);
				
                pushed_button ++;
                if (pushed_button == 40)
                    pushed_button = 33;
                
                FormSetControlGroupSelection(FORM_METRIC, pushed_button);
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = pushed_button;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == '1')
            {
                ControlPopupPopupTrigger(POPUP_TRIGGER_FIRST);
                return TRUE;
            }
            else if (Event->para1 == '2')
            {
                ControlPopupPopupTrigger(POPUP_TRIGGER_SECOND);
                return TRUE;
            }                                                            
            else if (Event->para1 == '0')
            {
                ControlPopupPopupTrigger(MODE_SELECTOR);
                return TRUE;
            }
        }
    }
	
	
	
    switch(Event->eventType)
	{	
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			SysGetAppID(MAINMENU, &app_id);
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
			EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
		}
		return TRUE;        
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction((USHORT)(Event->para1));
		return TRUE;
	case EVT_CONTROL_POPUP_SELECT:
		if (Event->eventID == POPUP_TRIGGER_FIRST ||
			Event->eventID == POPUP_TRIGGER_SECOND)
		{
			if (metric_insert_pt.textbox_id == TEXTBOX_METRIC_0)
				MetricConversion(TEXTBOX_METRIC_0, TEXTBOX_METRIC_1);
			else MetricConversion(TEXTBOX_METRIC_1, TEXTBOX_METRIC_0);
			TextboxGetTextPointer(metric_insert_pt.textbox_id, &textbox_text);
			TextboxSetInsertPointPositionByCharPos(metric_insert_pt.textbox_id, strlen(textbox_text));
			TextboxSetInsertPointOn(metric_insert_pt.textbox_id);
			FormSetFormActiveObject(FORM_METRIC, metric_insert_pt.textbox_id);
			return TRUE;
		}
		else 
		{
			if (Event->para1 == 0)
			{
				MathsAppPartialRestore(FORM_CALCULATOR);
				FormPopupForm(FORM_CALCULATOR);
			}
			else if (Event->para1 == 2)
			{
				low_memory_form_id = FORM_METRIC;
				if (MemoryLow)
				{
					MetricExchangeSetKeypadPos(FORM_EXCHANGE);
					FormPopupForm(FORM_EXCHANGE);
					return TRUE;
				}
				if (MathsAppPartialRestore(FORM_EXCHANGE) == FALSE)
				{
					ExchangeDisplayExchangeRate();
					ExchangeSetStringExchange0Text();
					ExchangeSetStringExchange1Text();
				}
				MetricExchangeSetKeypadPos(FORM_EXCHANGE);
				FormPopupForm(FORM_EXCHANGE);
			}
			else if (Event->para1 == 3)
			{
				MathsAppPartialRestore(FORM_LOAN);
				MetricExchangeSetKeypadPos(FORM_LOAN);
				metric_insert_pt2.insert_pt_on = FALSE;
				metric_insert_pt2.textbox_id = 0;
				TextboxSetInsertPointOff(TEXTBOX_LOAN_NUM_YEARS);
				TextboxSetInsertPointOff(TEXTBOX_LOAN_INTEREST_RATE);
				TextboxSetInsertPointOff(TEXTBOX_LOAN_LOAN_AMOUNT);
				TextboxSetInsertPointOff(TEXTBOX_LOAN_MONTHLY_PAYMENT);
				if (calculating_item != 0)
				{
					metric_insert_pt2.insert_pt_on = TRUE;
					metric_insert_pt2.textbox_id = TEXTBOX_LOAN_NUM_YEARS;
					TextboxSetInsertPointOn(TEXTBOX_LOAN_NUM_YEARS);
					FormSetFormActiveObject(FORM_LOAN, TEXTBOX_LOAN_NUM_YEARS);						
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_LOAN_NUM_YEARS, 0);
				}
				else
				{
					metric_insert_pt2.insert_pt_on = TRUE;
					metric_insert_pt2.textbox_id = TEXTBOX_LOAN_INTEREST_RATE;
					TextboxSetInsertPointOn(TEXTBOX_LOAN_INTEREST_RATE);
					FormSetFormActiveObject(FORM_LOAN, TEXTBOX_LOAN_INTEREST_RATE);
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_LOAN_INTEREST_RATE, 0);
				}
				for (tempID = CHECKBOX_LOAN_NUM_YEARS; tempID <= CHECKBOX_LOAN_MONTHLY_PAYMENT; tempID ++)
				{
					FormGetObjectPointer((ObjectID)(tempID), &object_type, (void**)&control_ptr);
					if (calculating_item == NO_SELECTION)
					{
						control_ptr->control_attr.control_enable = FALSE;
						((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
					}
					else if (tempID == (calculating_item + CHECKBOX_LOAN_NUM_YEARS))
					{
						control_ptr->control_attr.control_enable = FALSE;
						((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = TRUE;
					}
					else
					{
						control_ptr->control_attr.control_enable = TRUE;
						((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
					}
				}
				FormPopupForm(FORM_LOAN);
			}
		}
		return TRUE;
	case EVT_FORM_OPEN:
		ControlPopupSetSelectedItem(MODE_SELECTOR, 1);         
		FormDrawForm(FORM_METRIC);
		if (metric_insert_pt.textbox_id == TEXTBOX_METRIC_0)
			MetricConversion(TEXTBOX_METRIC_0, TEXTBOX_METRIC_1);
		else MetricConversion(TEXTBOX_METRIC_1, TEXTBOX_METRIC_0);
		return TRUE;
	case EVT_CONTROL_SELECT:
		if (Event->eventID == PUSHBUTTON_METRIC_LENGTH
			|| Event->eventID == PUSHBUTTON_METRIC_AREA
			|| Event->eventID == PUSHBUTTON_METRIC_VOLUME
			|| Event->eventID == PUSHBUTTON_METRIC_WEIGHT
			|| Event->eventID == PUSHBUTTON_METRIC_CAPACITY
			|| Event->eventID == PUSHBUTTON_METRIC_VELOCITY
			|| Event->eventID == PUSHBUTTON_METRIC_TEMPERATURE)
		{
			FormGetObjectPointer(TEXTBOX_METRIC_0, &object_type, (void**)&textbox_ptr);
			textbox_ptr->textbox_attr.textbox_highlight = FALSE;
			textbox_ptr->textbox_attr.textbox_insert_pt_visible = TRUE;	
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_METRIC_0, 0);			
			FormGetObjectPointer(TEXTBOX_METRIC_1, &object_type, (void**)&textbox_ptr);
			textbox_ptr->textbox_attr.textbox_highlight = FALSE;
			textbox_ptr->textbox_attr.textbox_insert_pt_visible = FALSE;									
			
			MetricChangePopupTriggerContent();
			TextboxSetText(TEXTBOX_METRIC_0, (BYTE*)(""));
			TextboxSetText(TEXTBOX_METRIC_1, (BYTE*)(""));
			ControlDrawControl(POPUP_TRIGGER_FIRST);
			ControlDrawControl(POPUP_TRIGGER_SECOND);
			
			FormSetFormActiveObject(FORM_METRIC, TEXTBOX_METRIC_0);
			TextboxDrawTextbox(TEXTBOX_METRIC_0);
			TextboxDrawTextbox(TEXTBOX_METRIC_1);				
			SetMetricInsertPt(TRUE, TEXTBOX_METRIC_0);
			ControlDrawControl(PUSHBUTTON_METRIC_CAPACITY);
			ControlDrawControl(PUSHBUTTON_METRIC_VELOCITY);
			ControlDrawControl(PUSHBUTTON_METRIC_TEMPERATURE);
		}
		return TRUE;
	case EVT_TEXTBOX_SELECT:
		metric_insert_pt.insert_pt_on = TRUE;
		metric_insert_pt.textbox_id = (ObjectID)(Event->eventID);
		if (metric_enter_pressed == 1)
		{
			metric_enter_pressed = 0;
			TextboxGetTextPointer(metric_insert_pt.textbox_id, &textbox_text);
			if (strlen(textbox_text) != 0)
			{
				FormGetObjectPointer(metric_insert_pt.textbox_id, &object_type, (void**)&textbox_ptr);
				TextboxSetInsertPointOff(metric_insert_pt.textbox_id);
				TextboxSetInsertPointPositionByCharPos(metric_insert_pt.textbox_id, 0);
				textbox_ptr->textbox_highlight_start_char = 0;
				textbox_ptr->textbox_highlight_end_char = strlen(textbox_text) - 1;
				textbox_ptr->textbox_highlight_length = strlen(textbox_text);
				textbox_ptr->textbox_attr.textbox_highlight = TRUE;
				TextboxDrawTextbox(metric_insert_pt.textbox_id);
			}
		}
		break;
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY && (Event->para2 & 0x300) == 0)
		{
			FormGetActiveObject(FORM_METRIC, &active_object);
			if (active_object == TEXTBOX_METRIC_0 || active_object == TEXTBOX_METRIC_1)
			{
				if (((UBYTE)(Event->para1) >= 48 && (UBYTE)(Event->para1) <= 57)/* || ((UBYTE)(Event->para1) == '.')*/)
				{
					FormGetObjectPointer(active_object, &object_type, (void**)&textbox_ptr);
					if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
						return TRUE;					
					if (strlen(textbox_ptr->textbox_string) == 1 && (UBYTE)(Event->para1) != '.' && textbox_ptr->textbox_string[0] == '0')
					{
						TextboxSetText(active_object, (BYTE*)(""));
						TextboxSetInsertPointPositionByCharPos(active_object, 0);
					}
					else if (strlen(textbox_ptr->textbox_string) == 2 && (UBYTE)(Event->para1) != '.' && textbox_ptr->textbox_string[0] == '-' && textbox_ptr->textbox_string[1] == '0')
					{
						TextboxSetText(active_object, (BYTE*)("-"));
						TextboxSetInsertPointPositionByCharPos(active_object, 1);
					}
					TextboxAddKeyInChar(active_object, (BYTE)(Event->para1));
				}
				else if ((UBYTE)(Event->para1) == '.')
				{
					FormGetObjectPointer(active_object, &object_type, (void**)&textbox_ptr);
					if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
						return TRUE;					
					
					for (i = 0; i < strlen(textbox_ptr->textbox_string); i++)
					{
						if (textbox_ptr->textbox_string[i] == '.')
							return TRUE;
					}
					if (strlen(textbox_ptr->textbox_string) == 0)
					{	
						TextboxAddKeyInChar(active_object, '0');
						TextboxAddKeyInChar(active_object, '.');
					}
					else
						TextboxAddKeyInChar(active_object, '.');
				}
				else if ((UBYTE)(Event->para1) == '-')
				{
					ControlGetPushedPushButton(FORM_METRIC, 1, &current_control_id);
					if (current_control_id == PUSHBUTTON_METRIC_TEMPERATURE)
					{
						FormGetObjectPointer(active_object, &object_type, (void**)&textbox_ptr);
						if (active_object == TEXTBOX_METRIC_0) 
							ControlPopupGetSelectedItem(POPUP_TRIGGER_FIRST, &selected_item);
						else
							ControlPopupGetSelectedItem(POPUP_TRIGGER_SECOND, &selected_item);					
						if (strlen(textbox_ptr->textbox_string) == 0 && selected_item != 2)
							TextboxAddKeyInChar(active_object, '-');
					}
				}
				if (metric_insert_pt.textbox_id == TEXTBOX_METRIC_0)
					MetricConversion(TEXTBOX_METRIC_0, TEXTBOX_METRIC_1);
				else MetricConversion(TEXTBOX_METRIC_1, TEXTBOX_METRIC_0);
				metric_enter_pressed = 1;
				return TRUE;
				
			}
		}
		break;
	case EVT_TEXTBOX_CHANGED:
		if (metric_insert_pt.textbox_id == TEXTBOX_METRIC_0)
			MetricConversion(TEXTBOX_METRIC_0, TEXTBOX_METRIC_1);
		else MetricConversion(TEXTBOX_METRIC_1, TEXTBOX_METRIC_0);
		metric_enter_pressed = 1;
		return TRUE;
	case EVT_BITMAP_SELECT:
		if (metric_insert_pt.insert_pt_on == FALSE) return TRUE;
		if (Event->eventID == BITMAP_METRIC_ENTER)
		{
			if (metric_insert_pt.textbox_id == TEXTBOX_METRIC_0)
				MetricConversion(TEXTBOX_METRIC_0, TEXTBOX_METRIC_1);
			else MetricConversion(TEXTBOX_METRIC_1, TEXTBOX_METRIC_0);
			metric_enter_pressed = 1;
			return TRUE;
		}
		FormSetFormActiveObject(FORM_METRIC, metric_insert_pt.textbox_id);
		FormGetObjectPointer(metric_insert_pt.textbox_id, &object_type, (void**)&textbox_ptr);
		TextboxSetInsertPointOn(metric_insert_pt.textbox_id);
		TextboxGetTextPointer(metric_insert_pt.textbox_id, &textbox_text);
		/*
		if (strlen(textbox_text) == 1 && Event->eventID != BITMAP_METRIC_LEFT &&
		Event->eventID != BITMAP_METRIC_RIGHT && Event->eventID != BITMAP_METRIC_C &&
		Event->eventID != BITMAP_METRIC_LSYM && textbox_text[0] == '0')
		{
		TextboxSetText(metric_insert_pt.textbox_id, (BYTE*)(""));
		TextboxSetInsertPointPositionByCharPos(metric_insert_pt.textbox_id, 0);
		}
		*/			
		if (Event->eventID != BITMAP_METRIC_LEFT &&
			Event->eventID != BITMAP_METRIC_RIGHT && Event->eventID != BITMAP_METRIC_C &&
			Event->eventID != BITMAP_METRIC_LSYM )			
		{
			if ((textbox_text[0] == '0' && strlen(textbox_text) == 1)) 
			{
				TextboxSetText(metric_insert_pt.textbox_id, (BYTE*)(""));
				TextboxSetInsertPointPositionByCharPos(metric_insert_pt.textbox_id, 0);
			}
			else if (textbox_text[0] == '-' && textbox_text[1] == '0' && strlen(textbox_text) == 2)
			{
				TextboxSetText(metric_insert_pt.textbox_id, (BYTE*)("-"));
				TextboxSetInsertPointPositionByCharPos(metric_insert_pt.textbox_id, 1);
			}										
		}
		
		
		switch(Event->eventID)
		{
		case BITMAP_METRIC_LEFT:
			new_event.eventType = EVT_KEY;
			new_event.eventID = SOFT_KEY;
			new_event.para1 = KEY_BACKSPACE;
			new_event.para2 = 0;
			new_event.evtPBP = NULL;
			TextboxHandleEvent(textbox_ptr , &new_event);
			break;
		case BITMAP_METRIC_C:
			TextboxSetInsertPointPositionByCharPos(metric_insert_pt.textbox_id, 0);
			TextboxSetText(metric_insert_pt.textbox_id, (BYTE*)(""));
			TextboxDrawTextbox(metric_insert_pt.textbox_id);
			break;
		case BITMAP_METRIC_RIGHT:
			ControlGetPushedPushButton(FORM_METRIC, 1, &current_control_id);
			if (current_control_id == PUSHBUTTON_METRIC_TEMPERATURE)
			{
				FormGetActiveObject(FORM_METRIC, &active_object);
				if (active_object == TEXTBOX_METRIC_0) 
					ControlPopupGetSelectedItem(POPUP_TRIGGER_FIRST, &selected_item);
				else
					ControlPopupGetSelectedItem(POPUP_TRIGGER_SECOND, &selected_item);					
				
				if (selected_item == 2)
					break;								
				
				
				i = textbox_ptr->textbox_insert_pt_char_pos;
				if (textbox_ptr->textbox_string[0] == '-')
				{
					TextboxDelete (metric_insert_pt.textbox_id, 0, 1);
					if (textbox_ptr->textbox_insert_pt_char_pos == 0)
						TextboxSetInsertPointPositionByCharPos(metric_insert_pt.textbox_id, 0);
					else 
					{
						i--;
						TextboxSetInsertPointPositionByCharPos(metric_insert_pt.textbox_id, i);
					}
				}
				else 
				{
					temp_text = (BYTE*)qmalloc((strlen(textbox_ptr->textbox_string) + 2) * sizeof(BYTE));
					strcpy((temp_text + 1),textbox_ptr->textbox_string);
					temp_text[0] = '-';
					TextboxSetText(metric_insert_pt.textbox_id, temp_text);
					qfree(temp_text);
					i++;
					TextboxSetInsertPointPositionByCharPos(metric_insert_pt.textbox_id, i);										
				}
				FormGetObjectPointer(metric_insert_pt.textbox_id, &object_type, (void**)&textbox_ptr);
				if (textbox_ptr->textbox_attr.textbox_highlight)
				{
					textbox_ptr->textbox_attr.textbox_highlight         = FALSE;
					textbox_ptr->textbox_attr.textbox_insert_pt_visible = TRUE;						        
					textbox_ptr->textbox_highlight_length               = 0;
				}                            
				
				TextboxDrawTextbox(metric_insert_pt.textbox_id);					
			}
			break;
		case BITMAP_METRIC_1:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			TextboxAddKeyInChar(metric_insert_pt.textbox_id, '1');
			break;
		case BITMAP_METRIC_2:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			TextboxAddKeyInChar(metric_insert_pt.textbox_id, '2');
			break;
		case BITMAP_METRIC_3:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			TextboxAddKeyInChar(metric_insert_pt.textbox_id, '3');
			break;
		case BITMAP_METRIC_4:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			TextboxAddKeyInChar(metric_insert_pt.textbox_id, '4');
			break;
		case BITMAP_METRIC_5:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			TextboxAddKeyInChar(metric_insert_pt.textbox_id, '5');
			break;
		case BITMAP_METRIC_6:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			TextboxAddKeyInChar(metric_insert_pt.textbox_id, '6');
			break;
		case BITMAP_METRIC_7:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			TextboxAddKeyInChar(metric_insert_pt.textbox_id, '7');
			break;
		case BITMAP_METRIC_8:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			TextboxAddKeyInChar(metric_insert_pt.textbox_id, '8');
			break;
		case BITMAP_METRIC_9:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			TextboxAddKeyInChar(metric_insert_pt.textbox_id, '9');
			break;
		case BITMAP_METRIC_0:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			TextboxAddKeyInChar(metric_insert_pt.textbox_id, '0');
			break;
		case BITMAP_METRIC_LSYM:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			for (i = 0; i < strlen(textbox_text); i++)
			{
				if (textbox_text[i] == '.')
				{	
					SetMetricInsertPt(TRUE, metric_insert_pt.textbox_id);
					return TRUE;
				}
			}
			if (strlen(textbox_text) == 0 || textbox_ptr->textbox_insert_pt_char_pos == 0)
			{	
				TextboxAddKeyInChar(metric_insert_pt.textbox_id, '0');
				TextboxAddKeyInChar(metric_insert_pt.textbox_id, '.');
			}
			else if (strlen(textbox_text) == 1 && textbox_ptr->textbox_insert_pt_char_pos == 1 && textbox_text[0] == '-')
			{
				TextboxSetText(metric_insert_pt.textbox_id, (BYTE*)("-0."));
				TextboxSetInsertPointPositionByCharPos(metric_insert_pt.textbox_id, 3);
			}
			else TextboxAddKeyInChar(metric_insert_pt.textbox_id, '.');
			break;
		case BITMAP_METRIC_RSYM:
			if (textbox_ptr->textbox_string[0] == '-' && (textbox_ptr->textbox_insert_pt_char_pos == 0 && textbox_ptr->textbox_attr.textbox_highlight == FALSE))
				return TRUE;					
			
			if (strlen(textbox_text) != 0 && textbox_ptr->textbox_insert_pt_char_pos != 0 && textbox_text[0] != '-')
			{
				TextboxAddKeyInChar(metric_insert_pt.textbox_id, '0');
				TextboxAddKeyInChar(metric_insert_pt.textbox_id, '0');
			}
			break;
			}
			SetMetricInsertPt(TRUE, metric_insert_pt.textbox_id);
			if (metric_insert_pt.textbox_id == TEXTBOX_METRIC_0)
				MetricConversion(TEXTBOX_METRIC_0, TEXTBOX_METRIC_1);
			else MetricConversion(TEXTBOX_METRIC_1, TEXTBOX_METRIC_0);
            metric_enter_pressed = 1;
			bitmap_entry = 1;
			return TRUE;
		default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	ExchangeMain
* Purpose: 	This function is the event handler for the first
page of the EXCHANGE MAIN application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN ExchangeMain(EvtType *Event)
{
	BYTE 		object_type;
    BYTE 		*textbox_text, *string_text;
	EvtType 	new_event;
	ObjectID 	active_object;
	WORD 		i;
    ObjectID    tempID;
    Control 	*control_ptr;
    Textbox		*textbox_ptr;
	
	
    if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
    { 
        if ((Event->para2 & 0x100) == 0 && (Event->para2 & 0x200) == 0)
        {                                     
            if (Event->para1 == LLETTER_METRIC_C || Event->para1 == SLETTER_METRIC_C)
            {
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_METRIC_C;
            }
        }                    
        else if (Event->para2 & 0x200)
        {
            if (Event->para1 == LLETTER_EXCHANGE_SAVE || Event->para1 == SLETTER_EXCHANGE_SAVE)
            {
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_EXCHANGE_CHANGE;
            }                                                
            else if (Event->para1 == '1')
            {
                ControlPopupPopupTrigger(POPUP_TRIGGER_F);
                return TRUE;
            }
            else if (Event->para1 == '2')
            {
                ControlPopupPopupTrigger(POPUP_TRIGGER_S);
                return TRUE;
            }                            
            else if (Event->para1 == '0')
            {
                ControlPopupPopupTrigger(MODE_SELECTOR);
                return TRUE;
            }                                        
        }
    }        
	
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			//SysGetAppID((BYTE*)("Mainmenu"), &app_id);
			SysGetAppID(MAINMENU, &app_id);
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
			EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
		}
		return TRUE;        
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction((USHORT)(Event->para1));
		return TRUE;
	case EVT_TEXTBOX_SELECT:
		metric_insert_pt1.insert_pt_on = TRUE;
		metric_insert_pt1.textbox_id = (ObjectID)(Event->eventID);
		if (exchange_enter_pressed == 1)
		{
			exchange_enter_pressed = 0;
			TextboxGetTextPointer(metric_insert_pt1.textbox_id, &textbox_text);
			if (strlen(textbox_text) != 0)
			{
				FormGetObjectPointer(metric_insert_pt1.textbox_id, &object_type, (void**)&textbox_ptr);
				TextboxSetInsertPointOff(metric_insert_pt1.textbox_id);
				TextboxSetInsertPointPositionByCharPos(metric_insert_pt1.textbox_id, 0);
				textbox_ptr->textbox_highlight_start_char = 0;
				textbox_ptr->textbox_highlight_end_char = strlen(textbox_text) - 1;
				textbox_ptr->textbox_highlight_length = strlen(textbox_text);
				textbox_ptr->textbox_attr.textbox_highlight = TRUE;
				TextboxDrawTextbox(metric_insert_pt1.textbox_id);
			}
		}
		break;
		
	case EVT_TEXTBOX_CHANGED:
		ExchangeCalculate();
		exchange_enter_pressed = 1;
		return TRUE;
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY && (Event->para2 & 0x300) == 0)
		{
			FormGetActiveObject(FORM_EXCHANGE, &active_object);
			if (active_object == TEXTBOX_EXCHANGE_INPUT || active_object == TEXTBOX_EXCHANGE_RATE)
			{
				if (((UBYTE)(Event->para1) >= 48 && (UBYTE)(Event->para1) <= 57))
				{
					TextboxGetTextPointer(active_object, &textbox_text);
					if (strlen(textbox_text) == 1 && (UBYTE)(Event->para1) != '.' && textbox_text[0] == '0')
					{
						TextboxSetText(active_object, (BYTE*)(""));
						TextboxSetInsertPointPositionByCharPos(active_object, 0);
					}
					TextboxAddKeyInChar(active_object, (BYTE)(Event->para1));
				}
				else if  ((UBYTE)(Event->para1) == '.')
				{
					FormGetObjectPointer(active_object, &object_type, (void**)&textbox_ptr);
					for (i = 0; i < strlen(textbox_ptr->textbox_string); i++)
					{
						if (textbox_ptr->textbox_string[i] == '.')
							return TRUE;
					}
					if (strlen(textbox_ptr->textbox_string) == 0)
					{	
						TextboxAddKeyInChar(active_object, '0');
						TextboxAddKeyInChar(active_object, '.');
					}
					else
						TextboxAddKeyInChar(active_object, '.');
				}
				ExchangeCalculate();
				exchange_enter_pressed = 1;
				return TRUE;
			}
		}
		break;
	case EVT_BITMAP_SELECT:
		if (Event->eventID == BITMAP_METRIC_ENTER)
		{
			ExchangeCalculate();
			exchange_enter_pressed = 1;
			return TRUE;
		}
		if (metric_insert_pt1.insert_pt_on == FALSE) return TRUE;
		FormSetFormActiveObject(FORM_EXCHANGE, metric_insert_pt1.textbox_id);
		FormGetObjectPointer(metric_insert_pt1.textbox_id, &object_type, (void**)&textbox_ptr);
		TextboxSetInsertPointOn(metric_insert_pt1.textbox_id);
		TextboxGetTextPointer(metric_insert_pt1.textbox_id, &textbox_text);
		if (strlen(textbox_text) == 1 && Event->eventID != BITMAP_METRIC_LEFT &&
			Event->eventID != BITMAP_METRIC_RIGHT && Event->eventID != BITMAP_METRIC_C &&
			Event->eventID != BITMAP_METRIC_LSYM && textbox_text[0] == '0')
		{
			TextboxSetText(metric_insert_pt1.textbox_id, (BYTE*)(""));
			TextboxSetInsertPointPositionByCharPos(metric_insert_pt1.textbox_id, 0);
		}
		switch(Event->eventID)
		{
		case BITMAP_METRIC_LEFT:
			new_event.eventType = EVT_KEY;
			new_event.eventID = SOFT_KEY;
			new_event.para1 = KEY_BACKSPACE;
			new_event.para2 = 0;
			new_event.evtPBP = NULL;
			TextboxHandleEvent(textbox_ptr , &new_event);
			break;
		case BITMAP_METRIC_C:
			TextboxSetInsertPointPositionByCharPos(metric_insert_pt1.textbox_id, 0);
			TextboxSetText(metric_insert_pt1.textbox_id, (BYTE*)(""));
			TextboxDrawTextbox(metric_insert_pt1.textbox_id);
			StringGetText(STRING_EXCHANGE_1, &string_text);
			string_text[5] = 0;
			StringDrawString(STRING_EXCHANGE_1);
			break;
		case BITMAP_METRIC_RIGHT:
			break;
		case BITMAP_METRIC_1:
			TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '1');
			break;
		case BITMAP_METRIC_2:
			TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '2');
			break;
		case BITMAP_METRIC_3:
			TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '3');
			break;
		case BITMAP_METRIC_4:
			TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '4');
			break;
		case BITMAP_METRIC_5:
			TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '5');
			break;
		case BITMAP_METRIC_6:
			TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '6');
			break;
		case BITMAP_METRIC_7:
			TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '7');
			break;
		case BITMAP_METRIC_8:
			TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '8');
			break;
		case BITMAP_METRIC_9:
			TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '9');
			break;
		case BITMAP_METRIC_0:
			TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '0');
			break;
		case BITMAP_METRIC_LSYM:
			for (i = 0; i < strlen(textbox_text); i++)
			{
				if (textbox_text[i] == '.')
				{
					SetMetricInsertPt1(TRUE, metric_insert_pt1.textbox_id);
					return TRUE;
				}
			}
			if (strlen(textbox_text) == 0 || textbox_ptr->textbox_insert_pt_char_pos == 0)
			{	
				TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '0');
				TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '.');
			}
			else TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '.');
			break;
		case BITMAP_METRIC_RSYM:
			if (strlen(textbox_text) != 0 && textbox_ptr->textbox_insert_pt_char_pos != 0)
			{
				TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '0');
				TextboxAddKeyInChar(metric_insert_pt1.textbox_id, '0');
			}
			break;
		}
		SetMetricInsertPt1(TRUE, metric_insert_pt1.textbox_id);
		ExchangeCalculate();
		exchange_enter_pressed = 1;
		return TRUE;
		case EVT_CONTROL_POPUP_SELECT:
			if (Event->eventID == POPUP_TRIGGER_F)
			{	
				ExchangeSetStringExchange0Text();
				ExchangeDisplayExchangeRate();				
                FormGetObjectPointer(TEXTBOX_EXCHANGE_RATE, &object_type, (void**)&textbox_ptr);
				textbox_ptr->textbox_attr.textbox_highlight = FALSE;
                textbox_ptr->textbox_attr.textbox_insert_pt_visible = FALSE;             
				TextboxDrawTextbox(TEXTBOX_EXCHANGE_RATE);
				ExchangeCalculate();
			}
			else if (Event->eventID == POPUP_TRIGGER_S)
			{
				ExchangeSetStringExchange1Text();
				ExchangeDisplayExchangeRate();
                FormGetObjectPointer(TEXTBOX_EXCHANGE_RATE, &object_type, (void**)&textbox_ptr);
				textbox_ptr->textbox_attr.textbox_highlight = FALSE;
                textbox_ptr->textbox_attr.textbox_insert_pt_visible = FALSE;                             
				TextboxDrawTextbox(TEXTBOX_EXCHANGE_RATE);
				ExchangeCalculate();
			}
			else 
			{
				if (Event->para1 == 0)
				{
					MathsAppPartialRestore(FORM_CALCULATOR);
					FormPopupForm(FORM_CALCULATOR);
				}
				else if (Event->para1 == 1)
				{
					MathsAppPartialRestore(FORM_METRIC);
					MetricExchangeSetKeypadPos(FORM_METRIC);
					metric_insert_pt.insert_pt_on = TRUE;
					metric_insert_pt.textbox_id = TEXTBOX_METRIC_0;
					TextboxSetInsertPointOn(TEXTBOX_METRIC_0);
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_METRIC_0, 0);
					TextboxSetInsertPointOff(TEXTBOX_METRIC_1);
					FormPopupForm(FORM_METRIC);
				}
				else if (Event->para1 == 3)
				{
					MathsAppPartialRestore(FORM_LOAN);
					MetricExchangeSetKeypadPos(FORM_EXCHANGE);
					metric_insert_pt2.insert_pt_on = FALSE;
					metric_insert_pt2.textbox_id = 0;
					TextboxSetInsertPointOff(TEXTBOX_LOAN_NUM_YEARS);
					TextboxSetInsertPointOff(TEXTBOX_LOAN_INTEREST_RATE);
					TextboxSetInsertPointOff(TEXTBOX_LOAN_LOAN_AMOUNT);
					TextboxSetInsertPointOff(TEXTBOX_LOAN_MONTHLY_PAYMENT);
					if (calculating_item != 0)
					{
						metric_insert_pt2.insert_pt_on = TRUE;
						metric_insert_pt2.textbox_id = TEXTBOX_LOAN_NUM_YEARS;
						TextboxSetInsertPointOn(TEXTBOX_LOAN_NUM_YEARS);
						TextboxSetInsertPointPositionByCharPos(TEXTBOX_LOAN_NUM_YEARS, 0);
						//24072000
						FormSetFormActiveObject(FORM_LOAN, TEXTBOX_LOAN_NUM_YEARS);
					}
					else
					{
						metric_insert_pt2.insert_pt_on = TRUE;
						metric_insert_pt2.textbox_id = TEXTBOX_LOAN_INTEREST_RATE;
						TextboxSetInsertPointOn(TEXTBOX_LOAN_INTEREST_RATE);
						TextboxSetInsertPointPositionByCharPos(TEXTBOX_LOAN_INTEREST_RATE, 0);
						//24072000
						FormSetFormActiveObject(FORM_LOAN, TEXTBOX_LOAN_INTEREST_RATE);
					}
                    for (tempID = CHECKBOX_LOAN_NUM_YEARS; tempID <= CHECKBOX_LOAN_MONTHLY_PAYMENT; tempID ++)
                    {
                        FormGetObjectPointer((ObjectID)(tempID), &object_type, (void**)&control_ptr);
                        if (calculating_item == NO_SELECTION)
                        {
                            control_ptr->control_attr.control_enable = FALSE;
                            ((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
                        }
                        else if (tempID == (calculating_item + CHECKBOX_LOAN_NUM_YEARS))
                        {
                            control_ptr->control_attr.control_enable = FALSE;
                            ((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = TRUE;
                        }
                        else
                        {
                            control_ptr->control_attr.control_enable = TRUE;
                            ((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
                        }
                    }
					FormPopupForm(FORM_LOAN);
				}
			}
			return TRUE;
		case EVT_FORM_OPEN:
            FormDrawForm(FORM_EXCHANGE);
            if (MemoryLow && !ex_rate_db_init)
			{
				FormInitAllFormObjects(FORM_EXCHANGE_DB_INIT);
				FormPopupForm(FORM_EXCHANGE_DB_INIT);
				return FALSE;
			}											
            if (!ex_rate_db_init)
			{
                //FormInitAllFormObjects(FORM_EXCHANGE_DB_INIT);           
                //FormPopupForm(FORM_EXCHANGE_DB_INIT);
                ExchangeInitExchangeRateDatabase();
                //return TRUE;
			}			
            TextboxSetInsertPointOff(TEXTBOX_EXCHANGE_RATE);        
            metric_insert_pt1.insert_pt_on = TRUE;
            metric_insert_pt1.textbox_id = TEXTBOX_EXCHANGE_INPUT;
            TextboxSetInsertPointOn(TEXTBOX_EXCHANGE_INPUT);
            FormSetFormActiveObject(FORM_EXCHANGE, TEXTBOX_EXCHANGE_INPUT);
            TextboxSetInsertPointPositionByCharPos(TEXTBOX_EXCHANGE_INPUT, 0);
            TextboxDrawTextbox(TEXTBOX_EXCHANGE_INPUT);
			
			
            if (try_exchange == 1)
                ExchangeCalculate();
            else try_exchange = 1;
			return TRUE;
		case EVT_CONTROL_SELECT:
			if (ExchangeUpdateExchangeRate() == TRUE)
				ExchangeCalculate();
			return TRUE;
		default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	ExchangeRateEnter
* Purpose: 	This function is the event handler for the first
page of the FORM_EXCHANGE_RATE
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN ExchangeRateEnter(EvtType *Event)
{
	Textbox		*textbox_ptr;
	BYTE		object_type;
	
    if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
    {
        if (Event->para2 & 0x200)
        {
            if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
            {
                Event->eventType = EVT_BITMAP_SELECT;               
            }
        }
    }                    
	
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EXCHANGE_RATE);
		return TRUE;
	case EVT_BITMAP_SELECT:
		FormGetObjectPointer(TEXTBOX_EXCHANGE_INPUT, &object_type, (void**)&textbox_ptr);
		textbox_ptr->textbox_attr.textbox_highlight = FALSE;
		TextboxSetInsertPointOff(TEXTBOX_EXCHANGE_INPUT);		
		FormSetFormActiveObject(FORM_EXCHANGE, TEXTBOX_EXCHANGE_RATE);
		TextboxSetInsertPointOn(TEXTBOX_EXCHANGE_RATE);
		try_exchange = 0;
		FormPopupForm(FORM_EXCHANGE);
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	LoanPaymentMain
* Purpose: 	This function is the event handler for the first
page of the FORM_LOAN
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN LoanPaymentMain(EvtType *Event)
{
	
	Textbox *textbox_ptr;
	BYTE object_type;
	EvtType new_event;
	BYTE *textbox_text;
	WORD i;
	ObjectID active_object;
    Control *control_ptr;
	
	
    if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
    { 
        if ((Event->para2 & 0x100) == 0 && (Event->para2 & 0x200) == 0)
        {                                     
            if (Event->para1 == LLETTER_METRIC_C || Event->para1 == SLETTER_METRIC_C)
            {
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_METRIC_C;
            }
        }                    
        else if (Event->para2 & 0x200)
        {
            if (Event->para1 == LLETTER_CLEAR || Event->para1 == SLETTER_CLEAR)
            {
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_LOAN_CLEAR_ALL;
            }                                                
            else if (Event->para1 == '0')
            {
                ControlPopupPopupTrigger(MODE_SELECTOR);
                return TRUE;
            }                                        
        }
    }        
	
	
	switch(Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			//SysGetAppID((BYTE*)("Mainmenu"), &app_id);
			SysGetAppID(MAINMENU, &app_id);
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
			EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
		}
		return TRUE;        
	case EVT_MENU_SELECT_ITEM:
		
		if (Event->para1 == 3)
			Event->para1 = 4;
		else if (Event->para1 == 4)
			Event->para1 = 5;
		else if (Event->para1 == 5)
			Event->para1 = 6;
		
		MenuItemSelectedAction((USHORT)(Event->para1));
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_LOAN);
		return TRUE;
	case EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case CHECKBOX_LOAN_NUM_YEARS:
			TextboxSetInsertPointOff(TEXTBOX_LOAN_NUM_YEARS);
			TextboxDrawTextbox(TEXTBOX_LOAN_NUM_YEARS);
			calculating_item = 0;                    
			for (i = CHECKBOX_LOAN_NUM_YEARS; i <= CHECKBOX_LOAN_MONTHLY_PAYMENT; i ++)
			{
				FormGetObjectPointer((ObjectID)(i), &object_type, (void**)&control_ptr);
				if (i == (calculating_item + CHECKBOX_LOAN_NUM_YEARS))
					control_ptr->control_attr.control_enable = FALSE;
				else control_ptr->control_attr.control_enable = TRUE;
			}
			metric_insert_pt2.insert_pt_on = FALSE;                    
			//LoanCalculation();
			return TRUE;
		case CHECKBOX_LOAN_INTEREST_RATE:
			TextboxSetInsertPointOff(TEXTBOX_LOAN_INTEREST_RATE);
			TextboxDrawTextbox(TEXTBOX_LOAN_INTEREST_RATE);                
			calculating_item = 1;
			for (i = CHECKBOX_LOAN_NUM_YEARS; i <= CHECKBOX_LOAN_MONTHLY_PAYMENT; i ++)
			{
				FormGetObjectPointer((ObjectID)(i), &object_type, (void**)&control_ptr);
				if (i == (calculating_item + CHECKBOX_LOAN_NUM_YEARS))
					control_ptr->control_attr.control_enable = FALSE;
				else control_ptr->control_attr.control_enable = TRUE;
			}
			metric_insert_pt2.insert_pt_on = FALSE;                                        
			//LoanCalculation();
			return TRUE;
		case CHECKBOX_LOAN_LOAN_AMOUNT:
			TextboxSetInsertPointOff(TEXTBOX_LOAN_LOAN_AMOUNT);
			TextboxDrawTextbox(TEXTBOX_LOAN_LOAN_AMOUNT);                
			calculating_item = 2;
			for (i = CHECKBOX_LOAN_NUM_YEARS; i <= CHECKBOX_LOAN_MONTHLY_PAYMENT; i ++)
			{
				FormGetObjectPointer((ObjectID)(i), &object_type, (void**)&control_ptr);
				if (i == (calculating_item + CHECKBOX_LOAN_NUM_YEARS))
					control_ptr->control_attr.control_enable = FALSE;
				else control_ptr->control_attr.control_enable = TRUE;
			}
			metric_insert_pt2.insert_pt_on = FALSE;                                        
			//LoanCalculation();
			return TRUE;
		case CHECKBOX_LOAN_MONTHLY_PAYMENT:
			TextboxSetInsertPointOff(TEXTBOX_LOAN_MONTHLY_PAYMENT);
			TextboxDrawTextbox(TEXTBOX_LOAN_MONTHLY_PAYMENT);
			calculating_item = 3;
			for (i = CHECKBOX_LOAN_NUM_YEARS; i <= CHECKBOX_LOAN_MONTHLY_PAYMENT; i ++)
			{
				FormGetObjectPointer((ObjectID)(i), &object_type, (void**)&control_ptr);
				if (i == (calculating_item + CHECKBOX_LOAN_NUM_YEARS))
					control_ptr->control_attr.control_enable = FALSE;
				else control_ptr->control_attr.control_enable = TRUE;
			}
			metric_insert_pt2.insert_pt_on = FALSE;                                        
			//LoanCalculation();
			return TRUE;
		case BUTTON_LOAN_CLEAR_ALL:                    
			TextboxSetText(TEXTBOX_LOAN_NUM_YEARS, (BYTE *)(""));
			TextboxSetText(TEXTBOX_LOAN_INTEREST_RATE, (BYTE *)(""));
			TextboxSetText(TEXTBOX_LOAN_LOAN_AMOUNT, (BYTE *)(""));
			TextboxSetText(TEXTBOX_LOAN_MONTHLY_PAYMENT, (BYTE *)(""));
			StringSetText(STRING_LOAN_TOTAL_PAYMENT_RESULT, (BYTE *)(""));
			StringSetText(STRING_LOAN_TOTAL_INTEREST_RESULT, (BYTE *)(""));
			if (metric_insert_pt2.insert_pt_on == TRUE)
			{
				TextboxSetInsertPointPositionByCharPos(metric_insert_pt2.textbox_id, 0);
				TextboxSetInsertPointOn(metric_insert_pt2.textbox_id);
				//24072000
				FormSetFormActiveObject(FORM_LOAN, metric_insert_pt2.textbox_id);
			}
			TextboxDrawTextbox(TEXTBOX_LOAN_NUM_YEARS);
			TextboxDrawTextbox(TEXTBOX_LOAN_INTEREST_RATE);
			TextboxDrawTextbox(TEXTBOX_LOAN_LOAN_AMOUNT);
			TextboxDrawTextbox(TEXTBOX_LOAN_MONTHLY_PAYMENT);
			StringDrawString(STRING_LOAN_TOTAL_PAYMENT_RESULT);
			StringDrawString(STRING_LOAN_TOTAL_INTEREST_RESULT);
			calculating_item = NO_SELECTION;
			for (i = CHECKBOX_LOAN_NUM_YEARS; i <= CHECKBOX_LOAN_MONTHLY_PAYMENT; i++)
			{
				FormGetObjectPointer((ObjectID)i, &object_type, (void**)&control_ptr);
				control_ptr->control_attr.control_enable = FALSE;
				((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
				ControlDrawControl((ObjectID)i);
			}
			return TRUE;
		default: break;
		}
		return TRUE;
		case EVT_CONTROL_POPUP_SELECT:
			if (Event->para1 == 0)
			{
				MathsAppPartialRestore(FORM_CALCULATOR);
				FormPopupForm(FORM_CALCULATOR);
			}
			else if (Event->para1 == 1)
			{
				MathsAppPartialRestore(FORM_METRIC);
				MetricExchangeSetKeypadPos(FORM_METRIC);
				metric_insert_pt.insert_pt_on = TRUE;
				metric_insert_pt.textbox_id = TEXTBOX_METRIC_0;
				TextboxSetInsertPointOn(TEXTBOX_METRIC_0);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_METRIC_0, 0);
				TextboxSetInsertPointOff(TEXTBOX_METRIC_1);
				FormPopupForm(FORM_METRIC);
			}
			else if (Event->para1 == 2)
			{
                low_memory_form_id = FORM_LOAN;
                if (MemoryLow)
                {
					MetricExchangeSetKeypadPos(FORM_EXCHANGE);
					FormPopupForm(FORM_EXCHANGE);
					return TRUE;
				}                	
                
				if (MathsAppPartialRestore(FORM_EXCHANGE) == FALSE)
				{
					ExchangeDisplayExchangeRate();
					ExchangeSetStringExchange0Text();
					ExchangeSetStringExchange1Text();
				}
				MetricExchangeSetKeypadPos(FORM_EXCHANGE);
                FormPopupForm(FORM_EXCHANGE);
			}
			return TRUE;		
		case EVT_BITMAP_SELECT:
			if (Event->eventID == BITMAP_METRIC_ENTER)
			{
				LoanCalculation();
                loan_enter_pressed = 1;
				return TRUE;
			}
			if (metric_insert_pt2.insert_pt_on == FALSE) return TRUE;
			FormSetFormActiveObject(FORM_LOAN, metric_insert_pt2.textbox_id);
			FormGetObjectPointer(metric_insert_pt2.textbox_id, &object_type, (void**)&textbox_ptr);
			TextboxSetInsertPointOn(metric_insert_pt2.textbox_id);
			TextboxGetTextPointer(metric_insert_pt2.textbox_id, &textbox_text);
			if (strlen(textbox_text) == 1 && Event->eventID != BITMAP_METRIC_LEFT &&
				Event->eventID != BITMAP_METRIC_RIGHT && Event->eventID != BITMAP_METRIC_C &&
				Event->eventID != BITMAP_METRIC_LSYM && textbox_text[0] == '0')
			{
				TextboxSetText(metric_insert_pt2.textbox_id, (BYTE*)(""));
				TextboxSetInsertPointPositionByCharPos(metric_insert_pt2.textbox_id, 0);
			}
			switch(Event->eventID)
			{
			case BITMAP_METRIC_LEFT:
				new_event.eventType = EVT_KEY;
				new_event.eventID = SOFT_KEY;
				new_event.para1 = KEY_BACKSPACE;
				new_event.para2 = 0;
				new_event.evtPBP = NULL;
				TextboxHandleEvent(textbox_ptr , &new_event);
				break;
			case BITMAP_METRIC_C:
				TextboxSetInsertPointPositionByCharPos(metric_insert_pt2.textbox_id, 0);
				TextboxSetText(metric_insert_pt2.textbox_id, (BYTE*)(""));
				TextboxDrawTextbox(metric_insert_pt2.textbox_id);
				break;
			case BITMAP_METRIC_RIGHT:
				break;
			case BITMAP_METRIC_1:
				TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '1');
				break;
			case BITMAP_METRIC_2:
				TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '2');
				break;
			case BITMAP_METRIC_3:
				TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '3');
				break;
			case BITMAP_METRIC_4:
				TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '4');
				break;
			case BITMAP_METRIC_5:
				TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '5');
				break;
			case BITMAP_METRIC_6:
				TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '6');
				break;
			case BITMAP_METRIC_7:
				TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '7');
				break;
			case BITMAP_METRIC_8:
				TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '8');
				break;
			case BITMAP_METRIC_9:
				TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '9');
				break;
			case BITMAP_METRIC_0:
				TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '0');
				break;
			case BITMAP_METRIC_LSYM:
				for (i = 0; i < strlen(textbox_text); i++)
				{
					if (textbox_text[i] == '.')
					{	
						SetMetricInsertPt2(TRUE, metric_insert_pt2.textbox_id);
						return TRUE;
					}
				}
				if (strlen(textbox_text) == 0 || textbox_ptr->textbox_insert_pt_char_pos == 0)
				{	
					TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '0');
					TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '.');
				}
				else TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '.');
				break;
			case BITMAP_METRIC_RSYM:
				if (strlen(textbox_text) != 0 && textbox_ptr->textbox_insert_pt_char_pos != 0)
				{
					TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '0');
					TextboxAddKeyInChar(metric_insert_pt2.textbox_id, '0');
				}
				break;
			}
			SetMetricInsertPt2(TRUE, metric_insert_pt2.textbox_id);
			LoanCalculation();
			loan_enter_pressed = 1;
			return TRUE;
			case EVT_TEXTBOX_SELECT:
				if (Event->eventID == (ObjectID)(calculating_item + TEXTBOX_LOAN_NUM_YEARS))
				{
					TextboxSetInsertPointOff(Event->eventID);
					enter_form_id = FORM_LOAN;
					loan_error = LOAN_CANT_SELECT;
					loan_enter_pressed = FALSE;
					FormInitAllFormObjects(FORM_METRIC_OVERFLOW);
					FormPopupForm(FORM_METRIC_OVERFLOW);
					return TRUE;
				}
				metric_insert_pt2.insert_pt_on = TRUE;
				metric_insert_pt2.textbox_id = (ObjectID)(Event->eventID);
				if (loan_enter_pressed == 1)
				{
					loan_enter_pressed = 0;
					TextboxGetTextPointer(metric_insert_pt2.textbox_id, &textbox_text);
					if (strlen(textbox_text) != 0)
					{
						FormGetObjectPointer(metric_insert_pt2.textbox_id, &object_type, (void**)&textbox_ptr);
						TextboxSetInsertPointOff(metric_insert_pt2.textbox_id);
						TextboxSetInsertPointPositionByCharPos(metric_insert_pt2.textbox_id, 0);
						textbox_ptr->textbox_highlight_start_char = 0;
						textbox_ptr->textbox_highlight_end_char = strlen(textbox_text) - 1;
						textbox_ptr->textbox_highlight_length = strlen(textbox_text);
						textbox_ptr->textbox_attr.textbox_highlight = TRUE;
						TextboxDrawTextbox(metric_insert_pt2.textbox_id);
					}
				}
				break;
			case EVT_TEXTBOX_CHANGED:
				LoanCalculation();
				loan_enter_pressed = 1;
				return TRUE;
			case EVT_KEY:
				if (Event->eventID == SOFT_KEY)
				{
					FormGetActiveObject(FORM_LOAN, &active_object);
					if (active_object == TEXTBOX_LOAN_NUM_YEARS || 
						active_object == TEXTBOX_LOAN_INTEREST_RATE ||
						active_object == TEXTBOX_LOAN_LOAN_AMOUNT || 
						active_object == TEXTBOX_LOAN_MONTHLY_PAYMENT)
					{
						if (((UBYTE)(Event->para1) >= 48 && (UBYTE)(Event->para1) <= 57))
						{
							TextboxGetTextPointer(active_object, &textbox_text);
							if (strlen(textbox_text) == 1 && (UBYTE)(Event->para1) != '.' && textbox_text[0] == '0')
							{
								TextboxSetText(active_object, (BYTE*)(""));
								TextboxSetInsertPointPositionByCharPos(active_object, 0);
							}
							TextboxAddKeyInChar(active_object, (BYTE)(Event->para1));
						}
						else if  ((UBYTE)(Event->para1) == '.')
						{
							FormGetObjectPointer(active_object, &object_type, (void**)&textbox_ptr);
							for (i = 0; i < strlen(textbox_ptr->textbox_string); i++)
							{
								if (textbox_ptr->textbox_string[i] == '.')
									return TRUE;
							}
							if (strlen(textbox_ptr->textbox_string) == 0)
							{	
								TextboxAddKeyInChar(active_object, '0');
								TextboxAddKeyInChar(active_object, '.');
							}
							else
								TextboxAddKeyInChar(active_object, '.');
						}
						LoanCalculation();
						loan_enter_pressed = 1;
						return TRUE;
					}
				}
				break;
			default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	MetricOverflow
* Purpose: 	This function is the event handler for FORM_METRIC_OVERFLOW
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN MetricOverflow(EvtType *Event)
{
    BYTE        *textbox_text;
    UWORD       i;
    BYTE        object_type;
    Form        *form_ptr;
    Textbox		*textbox_ptr;
    ObjectID	control_id, object_id;
    WORD		num_chars;
	
	
    if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
    {
        if (Event->para2 & 0x200)
        {
            if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
            {
                Event->eventType = EVT_BITMAP_SELECT;               
            }
        }
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		switch (enter_form_id)
		{
		case FORM_METRIC:
			FormSetDialogTitle (FORM_METRIC_OVERFLOW, OVERFLOW1);
			StringSetText(STRING_METRIC_OVERFLOW, OVERFLOW2);
			break;
		case FORM_EXCHANGE:
			FormSetDialogTitle (FORM_METRIC_OVERFLOW, OVERFLOW3);
			StringSetText(STRING_METRIC_OVERFLOW, OVERFLOW4);
			break;
		case FORM_LOAN:
			if (loan_error == LOAN_CANT_SELECT)
			{
				FormSetDialogTitle (FORM_METRIC_OVERFLOW, LOANERR);
				StringSetText(STRING_METRIC_OVERFLOW, CALERR1);
				break;
			}
			else if (loan_error == LOAN_NO_SOLUTION)
			{
				FormSetDialogTitle (FORM_METRIC_OVERFLOW, LOANERR);
				StringSetText(STRING_METRIC_OVERFLOW, CALERR2);
				break;
			}
			else if (loan_error == LOAN_OUT_OF_RANGE)
			{
				FormSetDialogTitle (FORM_METRIC_OVERFLOW, LOANERR);
				StringSetText(STRING_METRIC_OVERFLOW, CALERR3);
				break;
			}
			break;
		default: break;
		}
		FormDrawForm(FORM_METRIC_OVERFLOW);
		break;
		case EVT_BITMAP_SELECT:
			switch (enter_form_id)
			{
			case FORM_METRIC:
				TextboxGetTextPointer(metric_insert_pt.textbox_id, &textbox_text);
				TextboxDelete (metric_insert_pt.textbox_id, (strlen(textbox_text) - 1), 1);
				if (metric_insert_pt.textbox_id == TEXTBOX_METRIC_0)
				{
					MetricConversion(TEXTBOX_METRIC_0, TEXTBOX_METRIC_1);
					while (!MetricConversion(TEXTBOX_METRIC_0, TEXTBOX_METRIC_1))
						TextboxDelete (metric_insert_pt.textbox_id, (strlen(textbox_text) - 1), 1);
				}
				else
				{
					MetricConversion(TEXTBOX_METRIC_1, TEXTBOX_METRIC_0);
					while (!MetricConversion(TEXTBOX_METRIC_1, TEXTBOX_METRIC_0))
						TextboxDelete (metric_insert_pt.textbox_id, (strlen(textbox_text) - 1), 1);
				}
				TextboxSetInsertPointPositionByCharPos(metric_insert_pt.textbox_id, strlen(textbox_text));
				TextboxSetInsertPointOn(metric_insert_pt.textbox_id);
				FormSetFormActiveObject(FORM_METRIC, metric_insert_pt.textbox_id);			
				FormPopupForm(FORM_METRIC);
				break;
			case FORM_EXCHANGE:                 
				TextboxGetTextPointer(metric_insert_pt1.textbox_id, &textbox_text);
				TextboxDelete (metric_insert_pt1.textbox_id, (strlen(textbox_text) - 1), 1);
				TextboxGetNumOfChars(metric_insert_pt1.textbox_id, &num_chars);
				while (!ExchangeCalculate() && num_chars)
					TextboxDelete (metric_insert_pt1.textbox_id, (strlen(textbox_text) - 1), 1);
				TextboxSetInsertPointPositionByCharPos(metric_insert_pt1.textbox_id, strlen(textbox_text));
				TextboxSetInsertPointOn(metric_insert_pt1.textbox_id);
				FormSetFormActiveObject(FORM_EXCHANGE, metric_insert_pt1.textbox_id);			
				FormPopupForm(FORM_EXCHANGE);
				break;
			case FORM_LOAN:
				if (loan_error == LOAN_CANT_SELECT)
				{
					// =========================================================================================================
					// modified at 27072000
					ControlGetCheckedCheckbox(FORM_LOAN, 0, &control_id);
					object_id = metric_insert_pt2.textbox_id + 12;
					if (control_id == object_id)
					{
						metric_insert_pt2.textbox_id = TEXTBOX_LOAN_NUM_YEARS;
						if (control_id == CHECKBOX_LOAN_NUM_YEARS)
							metric_insert_pt2.textbox_id = TEXTBOX_LOAN_MONTHLY_PAYMENT;
					}
					TextboxGetTextPointer(metric_insert_pt2.textbox_id, &textbox_text);
					TextboxSetInsertPointPositionByCharPos(metric_insert_pt2.textbox_id, strlen(textbox_text));
					TextboxSetInsertPointOn(metric_insert_pt2.textbox_id);
					FormSetFormActiveObject(FORM_LOAN, metric_insert_pt2.textbox_id);
					FormGetObjectPointer((ObjectID)(calculating_item + TEXTBOX_LOAN_NUM_YEARS), &object_type, (void**)&textbox_ptr);
					textbox_ptr->textbox_attr.textbox_highlight = FALSE;
					textbox_ptr->textbox_highlight_length = 0;
					FormPopupForm(FORM_LOAN);
					break;
					// =========================================================================================================
				}
				else if (loan_error == LOAN_NO_SOLUTION || loan_error == LOAN_OUT_OF_RANGE)
				{
					TextboxGetTextPointer(metric_insert_pt2.textbox_id, &textbox_text);
					TextboxDelete (metric_insert_pt2.textbox_id, (strlen(textbox_text) - 1), 1);
					TextboxSetInsertPointPositionByCharPos(metric_insert_pt2.textbox_id, strlen(textbox_text));
					TextboxSetInsertPointOn(metric_insert_pt2.textbox_id);
					FormSetFormActiveObject(FORM_LOAN, metric_insert_pt2.textbox_id);        
					FormPopupForm(FORM_LOAN);
					break;
				}
				break;
			default: break;
			}
			break;
			default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	ExchangeDBInitMain
* Purpose: 	This function is the event handler for the first
page of the EXCHANGE DB INIT FORM application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN	ExchangeDBinitMain(EvtType *Event)
{
    BYTE    object_type;
    Bitmap  *bitmap_ptr;
    Control *control_ptr;
    AppID   tempID;
	
	switch (Event->eventType)
	{
	case EVT_BITMAP_SELECT:
		switch (low_memory_form_id)
		{
		case FORM_CALCULATOR:
			MathsAppPartialRestore(FORM_CALCULATOR);
			FormPopupForm(FORM_CALCULATOR);
			ControlSetLabel(MODE_SELECTOR, SIMPLE);
			ControlPopupSetSelectedItem(MODE_SELECTOR, 0);
			return TRUE;
		case FORM_METRIC:
			MathsAppPartialRestore(FORM_METRIC);
			MetricExchangeSetKeypadPos(FORM_METRIC);
			metric_insert_pt.insert_pt_on = TRUE;
			metric_insert_pt.textbox_id = TEXTBOX_METRIC_0;
			TextboxSetInsertPointOn(TEXTBOX_METRIC_0);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_METRIC_0, 0);
			TextboxSetInsertPointOff(TEXTBOX_METRIC_1);
			FormPopupForm(FORM_METRIC);
			ControlSetLabel(MODE_SELECTOR, IMPERIAL);
			ControlPopupSetSelectedItem(MODE_SELECTOR, 1);
			return TRUE;
		case FORM_LOAN:
			MathsAppPartialRestore(FORM_LOAN);
			MetricExchangeSetKeypadPos(FORM_EXCHANGE);
			metric_insert_pt2.insert_pt_on = FALSE;
			metric_insert_pt2.textbox_id = 0;
			TextboxSetInsertPointOff(TEXTBOX_LOAN_NUM_YEARS);
			TextboxSetInsertPointOff(TEXTBOX_LOAN_INTEREST_RATE);
			TextboxSetInsertPointOff(TEXTBOX_LOAN_LOAN_AMOUNT);
			TextboxSetInsertPointOff(TEXTBOX_LOAN_MONTHLY_PAYMENT);
			if (calculating_item != 0)
			{
				metric_insert_pt2.insert_pt_on = TRUE;
				metric_insert_pt2.textbox_id = TEXTBOX_LOAN_NUM_YEARS;
				TextboxSetInsertPointOn(TEXTBOX_LOAN_NUM_YEARS);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_LOAN_NUM_YEARS, 0);
			}
			else
			{
				metric_insert_pt2.insert_pt_on = TRUE;
				metric_insert_pt2.textbox_id = TEXTBOX_LOAN_INTEREST_RATE;
				TextboxSetInsertPointOn(TEXTBOX_LOAN_INTEREST_RATE);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_LOAN_INTEREST_RATE, 0);
			}
			for (tempID = CHECKBOX_LOAN_NUM_YEARS; tempID <= CHECKBOX_LOAN_MONTHLY_PAYMENT; tempID ++)
			{
				FormGetObjectPointer((ObjectID)(tempID), &object_type, (void**)&control_ptr);
				if (calculating_item == NO_SELECTION)
				{
					control_ptr->control_attr.control_enable = FALSE;
					((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
				}
				else if (tempID == (calculating_item + CHECKBOX_LOAN_NUM_YEARS))
				{
					control_ptr->control_attr.control_enable = FALSE;
					((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = TRUE;
				}       
				else        
				{
					control_ptr->control_attr.control_enable = TRUE;
					((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
				}
			}       
			FormPopupForm(FORM_LOAN);
			ControlSetLabel(MODE_SELECTOR, MORTAGE);
			ControlPopupSetSelectedItem(MODE_SELECTOR, 3);
			return TRUE;
		}				
		return TRUE;
		case EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			{			
                switch (low_memory_form_id)
                {
				case FORM_CALCULATOR:
					MathsAppPartialRestore(FORM_CALCULATOR);
					FormPopupForm(FORM_CALCULATOR);
					ControlSetLabel(MODE_SELECTOR, SIMPLE);
					ControlPopupSetSelectedItem(MODE_SELECTOR, 0);
					return TRUE;
				case FORM_METRIC:
					MathsAppPartialRestore(FORM_METRIC);
					MetricExchangeSetKeypadPos(FORM_METRIC);
					metric_insert_pt.insert_pt_on = TRUE;
					metric_insert_pt.textbox_id = TEXTBOX_METRIC_0;
					TextboxSetInsertPointOn(TEXTBOX_METRIC_0);
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_METRIC_0, 0);
					TextboxSetInsertPointOff(TEXTBOX_METRIC_1);
					FormPopupForm(FORM_METRIC);
					ControlSetLabel(MODE_SELECTOR, IMPERIAL);
					ControlPopupSetSelectedItem(MODE_SELECTOR, 1);
					return TRUE;
				case FORM_LOAN:
					MathsAppPartialRestore(FORM_LOAN);
					MetricExchangeSetKeypadPos(FORM_EXCHANGE);
					metric_insert_pt2.insert_pt_on = FALSE;
					metric_insert_pt2.textbox_id = 0;
					TextboxSetInsertPointOff(TEXTBOX_LOAN_NUM_YEARS);
					TextboxSetInsertPointOff(TEXTBOX_LOAN_INTEREST_RATE);
					TextboxSetInsertPointOff(TEXTBOX_LOAN_LOAN_AMOUNT);
					TextboxSetInsertPointOff(TEXTBOX_LOAN_MONTHLY_PAYMENT);
					if (calculating_item != 0)
					{
						metric_insert_pt2.insert_pt_on = TRUE;
						metric_insert_pt2.textbox_id = TEXTBOX_LOAN_NUM_YEARS;
						TextboxSetInsertPointOn(TEXTBOX_LOAN_NUM_YEARS);
						TextboxSetInsertPointPositionByCharPos(TEXTBOX_LOAN_NUM_YEARS, 0);
					}
					else
					{
						metric_insert_pt2.insert_pt_on = TRUE;
						metric_insert_pt2.textbox_id = TEXTBOX_LOAN_INTEREST_RATE;
						TextboxSetInsertPointOn(TEXTBOX_LOAN_INTEREST_RATE);
						TextboxSetInsertPointPositionByCharPos(TEXTBOX_LOAN_INTEREST_RATE, 0);
					}
					for (tempID = CHECKBOX_LOAN_NUM_YEARS; tempID <= CHECKBOX_LOAN_MONTHLY_PAYMENT; tempID ++)
					{
						FormGetObjectPointer((ObjectID)(tempID), &object_type, (void**)&control_ptr);
						if (calculating_item == NO_SELECTION)
						{
							control_ptr->control_attr.control_enable = FALSE;
							((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
						}
						else if (tempID == (calculating_item + CHECKBOX_LOAN_NUM_YEARS))
						{
							control_ptr->control_attr.control_enable = FALSE;
							((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = TRUE;
						}       
						else        
						{
							control_ptr->control_attr.control_enable = TRUE;
							((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
						}
					}       
					FormPopupForm(FORM_LOAN);
					ControlSetLabel(MODE_SELECTOR, MORTAGE);
					ControlPopupSetSelectedItem(MODE_SELECTOR, 3);
					return TRUE;
                }
			}				
			return TRUE;									
		case EVT_FORM_OPEN:
            FormGetObjectPointer(BITMAP_CAL_NO_MEM, &object_type, (void**)&bitmap_ptr);
            if (MemoryLow)
			{
                bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
                bitmap_ptr->bitmap_attr.bitmap_enable = TRUE;                
                StringSetText(STRING_EXCHANGE_DB_INIT, CALERR4);
				FormDrawForm(FORM_EXCHANGE_DB_INIT);
				return TRUE;				
			}
            bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
            bitmap_ptr->bitmap_attr.bitmap_enable = FALSE;                
            StringSetText(STRING_EXCHANGE_DB_INIT, CALMSG1);
            FormDrawForm(FORM_EXCHANGE_DB_INIT);
			
			InlaySetEnableStatus(FALSE);
            SystemSetMappedHardwareKeyStatus(FALSE);
            BatteryWarningSetEnableStatus(FALSE);				
            
			ExchangeInitExchangeRateDatabase();
			
			InlaySetEnableStatus(TRUE);
            SystemSetMappedHardwareKeyStatus(TRUE);
            BatteryWarningSetEnableStatus(TRUE);				
            
			FormPopupForm(FORM_EXCHANGE);
			return TRUE;
		default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:    CalculatorInvalidPaste
* Purpose:     This function is called to handle the FORM_CAL_INVALID_PASTE                
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN CalculatorInvalidPaste(EvtType *Event)
{
    Bitmap		*bitmap_ptr;
    BYTE		object_type;
	
	
    if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
    {
        if (Event->para2 & 0x200)
        {
            if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
            {
                Event->eventType = EVT_BITMAP_SELECT;               
            }
        }
    }                    
	
    
    switch (Event->eventType)
    {
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_CAL_INVALID_PASTE);
		return TRUE;
	case EVT_BITMAP_SELECT:
		switch (invalid_paste_id)
		{
		case FORM_CALCULATOR:
			FormSetEventHandler(FORM_CALCULATOR, (void**)&FormDispatchEvent, (void*)CalculatorMain);
			FormSetActiveForm(FORM_CALCULATOR);
			if (cal_icon_display == NO_OPERATION)
			{
				FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			}                    
			FormDrawForm(FORM_CALCULATOR);
			return TRUE;
		case FORM_EXCHANGE:
			FormSetEventHandler(FORM_EXCHANGE, (void**)&FormDispatchEvent, (void*)ExchangeMain);
			FormSetActiveForm(FORM_EXCHANGE);
			FormDrawForm(FORM_EXCHANGE);
			return TRUE;
		case FORM_METRIC:
			FormSetEventHandler(FORM_METRIC, (void**)&FormDispatchEvent, (void*)MetricMain);
			FormSetActiveForm(FORM_METRIC);
			FormDrawForm(FORM_METRIC);
			return TRUE;
		case FORM_LOAN:
			FormSetEventHandler(FORM_LOAN, (void**)&FormDispatchEvent, (void*)LoanPaymentMain);
			FormSetActiveForm(FORM_LOAN);
			FormDrawForm(FORM_LOAN);
			return TRUE;
		default: return FALSE;
		}
        default: return FALSE;
    }
}
