/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   appsave.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#include "stdafx.h"
#include "app.h"
#include "system.h"
#include "sysetup.h"
#include "exrate.h"

extern BYTE try_exchange;
extern BOOLEAN low_memory;
extern BOOLEAN percent_pressed;

/********************************************************
* Function:	MathsAppSave
* Purpose: 	This function is called to save the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void MathsAppSave()
{
	BYTE application_status = RESTART;
	BYTE *object_text;
	WORD count = 0;
	ObjectID control_id, active_form_id;
	SHORT selected_item_num;
	BYTE *textbox_text, *string_text;
	Form	*form_ptr;
	BYTE object_type;
	
	FormGetActiveFormID(&active_form_id);
	if (active_form_id == FORM_CALCULATOR || active_form_id == FORM_CAL_INVALID_PASTE)
		application_status = CALCULATOR;
	else if (active_form_id == FORM_METRIC)
		application_status = METRIC;
	else if (active_form_id == FORM_EXCHANGE || active_form_id == FORM_EXCHANGE_RATE ||
		active_form_id == FORM_EXCHANGE_DB_INIT)
		application_status = EXCHANGE;
    else if (active_form_id == FORM_LOAN)
		application_status = LOAN;
	else if (active_form_id == FORM_METRIC_OVERFLOW && enter_form_id == FORM_METRIC)
	{
		application_status = METRIC;
		TextboxGetTextPointer(metric_insert_pt.textbox_id, &textbox_text);
		TextboxDelete (metric_insert_pt.textbox_id, (strlen(textbox_text) - 1), 1);
		if (metric_insert_pt.textbox_id == TEXTBOX_METRIC_0)
			MetricConversion(TEXTBOX_METRIC_0, TEXTBOX_METRIC_1);
		else MetricConversion(TEXTBOX_METRIC_1, TEXTBOX_METRIC_0);
	}
	else if (active_form_id == FORM_METRIC_OVERFLOW && enter_form_id == FORM_EXCHANGE)
	{
		application_status = EXCHANGE;
		TextboxGetTextPointer(metric_insert_pt1.textbox_id, &textbox_text);
		TextboxDelete (metric_insert_pt1.textbox_id, (strlen(textbox_text) - 1), 1);
	}
	else if (active_form_id == FORM_METRIC_OVERFLOW && enter_form_id == FORM_LOAN)
	{
		application_status = LOAN;
		
        if (loan_error == LOAN_NO_SOLUTION || loan_error == LOAN_OUT_OF_RANGE)
        {
            TextboxGetTextPointer(metric_insert_pt2.textbox_id, &textbox_text);
            TextboxDelete (metric_insert_pt2.textbox_id, (strlen(textbox_text) - 1), 1);
        }		
	}		
	
	
	
	MathsDatabaseChecking();
	
	DataWriteField(maths_dbid, MATHS_STATUS, 0, 1, (BYTE*)&application_status);
	
	/* CALCULATOR_INFO record */
	if (FormGetObjectPointer(FORM_CALCULATOR, &object_type, (void**)&form_ptr) == TRUE)
	{
		DataWriteField(maths_dbid, CALCULATOR_INFO, 0, sizeof(BOOLEAN), (BYTE*)&has_memory_content);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 1, sizeof(BOOLEAN), (BYTE*)&error_occured);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 2, sizeof(BOOLEAN), (BYTE*)&negative);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 3, sizeof(double), (BYTE*)&input_buffer);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 4, sizeof(double), (BYTE*)&memory_buffer);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 5, sizeof(double), (BYTE*)&temp_buffer);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 6, sizeof(double), (BYTE*)&temp_buffer1);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 7, sizeof(double), (BYTE*)&result_buffer);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 8, sizeof(BYTE), (BYTE*)&operation);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 9, sizeof(BYTE), (BYTE*)&last_input_type);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 10, strlen(display_buffer) + 1, display_buffer);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 11, sizeof(BOOLEAN), (BYTE*)&operator_pressed);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 12, sizeof(BYTE), (BYTE*)&displaying_buffer);
		if (StringGetText(DISPLAY, &object_text) == TRUE)
			DataWriteField(maths_dbid, CALCULATOR_INFO, 13, (strlen(object_text) + 1), object_text);
		else DataWriteField(maths_dbid, CALCULATOR_INFO, 13, 1, (BYTE*)(""));
		DataWriteField(maths_dbid, CALCULATOR_INFO, 14, sizeof(BOOLEAN), (BYTE*)&has_decimal);
        DataWriteField(maths_dbid, CALCULATOR_INFO, 15, sizeof(WORD), (BYTE*)&num_digits);
        DataWriteField(maths_dbid, CALCULATOR_INFO, 16, sizeof(WORD), (BYTE*)&cal_icon_display);
        DataWriteField(maths_dbid, CALCULATOR_INFO, 17, sizeof(BOOLEAN), (BYTE*)&percent_pressed);
	}
	
	/* METRIC_INFO record */
	if (FormGetObjectPointer(FORM_METRIC, &object_type, (void**)&form_ptr) == TRUE)
	{
		ControlGetPushedPushButton(FORM_METRIC, 1, &control_id);
		DataWriteField(maths_dbid, METRIC_INFO, 0, sizeof(ObjectID), (BYTE*)&control_id);
		ControlPopupGetSelectedItem(POPUP_TRIGGER_FIRST, &selected_item_num);
		DataWriteField(maths_dbid, METRIC_INFO, 1, sizeof(SHORT), (BYTE*)&selected_item_num);
		ControlPopupGetSelectedItem(POPUP_TRIGGER_SECOND, &selected_item_num);
		DataWriteField(maths_dbid, METRIC_INFO, 2, sizeof(SHORT), (BYTE*)&selected_item_num);
		TextboxGetTextPointer(TEXTBOX_METRIC_0, &textbox_text);
		DataWriteField(maths_dbid, METRIC_INFO, 3, strlen(textbox_text) + 1, textbox_text);
		TextboxGetTextPointer(TEXTBOX_METRIC_1, &textbox_text);
		DataWriteField(maths_dbid, METRIC_INFO, 4, strlen(textbox_text) + 1, textbox_text);
	}
	
    /* EXCHANGE_INFO record */
	if (FormGetObjectPointer(FORM_EXCHANGE, &object_type, (void**)&form_ptr) == TRUE)
	{
		StringGetText(STRING_EXCHANGE_0, &string_text);
		DataWriteField(maths_dbid, EXCHANGE_INFO, 0, strlen(string_text) + 1, string_text);
		TextboxGetTextPointer(TEXTBOX_EXCHANGE_INPUT, &textbox_text);
		DataWriteField(maths_dbid, EXCHANGE_INFO, 1, strlen(textbox_text) + 1, textbox_text);
		StringGetText(STRING_EXCHANGE_1, &string_text);
		DataWriteField(maths_dbid, EXCHANGE_INFO, 2, strlen(string_text) + 1, string_text);
		TextboxGetTextPointer(TEXTBOX_EXCHANGE_RATE, &textbox_text);
		DataWriteField(maths_dbid, EXCHANGE_INFO, 3, strlen(textbox_text) + 1, textbox_text);
		ControlPopupGetSelectedItem(POPUP_TRIGGER_F, &selected_item_num);
		DataWriteField(maths_dbid, EXCHANGE_INFO, 4, sizeof(SHORT), (BYTE*)&selected_item_num);
		ControlPopupGetSelectedItem(POPUP_TRIGGER_S, &selected_item_num);
		DataWriteField(maths_dbid, EXCHANGE_INFO, 5, sizeof(SHORT), (BYTE*)&selected_item_num);
	}
	
	/* LOAN_INFO record */
	if (FormGetObjectPointer(FORM_LOAN, &object_type, (void**)&form_ptr) == TRUE)
	{
		TextboxGetTextPointer(TEXTBOX_LOAN_NUM_YEARS, &textbox_text);
		DataWriteField(maths_dbid, LOAN_INFO, 0, strlen(textbox_text) + 1, textbox_text);
		TextboxGetTextPointer(TEXTBOX_LOAN_INTEREST_RATE, &textbox_text);
		DataWriteField(maths_dbid, LOAN_INFO, 1, strlen(textbox_text) + 1, textbox_text);
		TextboxGetTextPointer(TEXTBOX_LOAN_LOAN_AMOUNT, &textbox_text);
		DataWriteField(maths_dbid, LOAN_INFO, 2, strlen(textbox_text) + 1, textbox_text);
		TextboxGetTextPointer(TEXTBOX_LOAN_MONTHLY_PAYMENT, &textbox_text);
		DataWriteField(maths_dbid, LOAN_INFO, 3, strlen(textbox_text) + 1, textbox_text);
		StringGetText(STRING_LOAN_TOTAL_PAYMENT_RESULT, &string_text);
		DataWriteField(maths_dbid, LOAN_INFO, 4, strlen(string_text) + 1, string_text);
		StringGetText(STRING_LOAN_TOTAL_INTEREST_RESULT, &string_text);
		DataWriteField(maths_dbid, LOAN_INFO, 5, strlen(string_text) + 1, string_text);
		DataWriteField(maths_dbid, LOAN_INFO, 6, 1, (BYTE*)&calculating_item);
	}
	
    if (ex_rate_db_init)
    {
        ExchangeUpdateDatabase();
        qfree(ExchangeRate);
    }
	DataCloseDB(maths_dbid);
}

/********************************************************
* Function:	MathskAppRestore
* Purpose: 	This function is called to restore the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		restart		whether the application is restart or not
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void MathsAppRestore(BOOLEAN restart)
{
	BYTE 				application_status;
	BYTE 				*buffer;
	UWORD 				byte_read;
    CountrySettings     country;
    Bitmap              *bitmap_ptr;
    BYTE                object_type;
    Control             *control_ptr;
    ObjectID            i;
    
	/* low memory */
	low_memory = FALSE;
	
	/* Calculator */
	comma_type = 0;
	operation = NO_OPERATION;
	last_input_type = CAL_EMPTY;
	has_memory_content = FALSE;
	error_occured = FALSE;
	negative = FALSE;
	input_buffer = 0;
	memory_buffer = 0;
	temp_buffer = 0;
	temp_buffer1 = 0;
	result_buffer = 0;
	display_value = 0;
    display_buffer = (BYTE*)qmalloc(50*sizeof(BYTE));
    strcpy(display_buffer,"");
	displaying_buffer = 0;
	num_digits = 0;
	operator_pressed = FALSE;
	has_decimal = FALSE;
	metric_enter_pressed = 0;
	exchange_enter_pressed = 0;
	loan_enter_pressed = 0;
    try_exchange = 1;    
    percent_pressed = FALSE;
	
	
	/* Metric */
	SetMetricInsertPt(FALSE, 0);
	
	/* Exchange */
	SetMetricInsertPt1(FALSE, 0);
	
	/* Loan */
	SetMetricInsertPt2(FALSE, 0);
	
	MathsDatabaseChecking();
	if (restart == TRUE)
		application_status = RESTART;
	else
	{
		DataGetField(maths_dbid, MATHS_STATUS, 0, &buffer, &byte_read);
		application_status = *buffer;
		qfree(buffer);
	}
	
	DataGetField(maths_dbid, EXCHANGE_INFO, 6, &buffer, &byte_read);
	ex_rate_db_init = *(BOOLEAN*)buffer;
	qfree(buffer);
	
    if (ex_rate_db_init)
    {
        DataGetField(maths_dbid, EXCHANGE_RATE, 0, &buffer, &byte_read);
        ExchangeRate = (EXCHANGERATE*)buffer;
    }
	
    if (MemoryLow && application_status == EXCHANGE && !ex_rate_db_init)
	{
		application_status = CALCULATOR;
		DataWriteField(maths_dbid, MATHS_STATUS, 0, sizeof(BYTE), &application_status);
	}
	
#ifdef PR31700
	if (!SySetupGetCountrySettings(&country))
		comma_type = SYSETUP_NUMS_C_F;
	else comma_type = country.nums;
#endif
	
#ifdef PC_SIM
	comma_type = SYSETUP_NUMS_S_C;
#endif
	
	if (comma_type == SYSETUP_NUMS_F_C || comma_type == SYSETUP_NUMS_S_C ||
		comma_type == SYSETUP_NUMS_N_C)
	{
        BitmapInitBitmap(BITMAP_DOT);
		FormGetObjectPointer(BITMAP_DOT, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
        BitmapInitBitmap(BITMAP_COMMA);
		FormGetObjectPointer(BITMAP_COMMA, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
	}
	
	if (application_status == CALCULATOR || application_status == RESTART)
		MathsAppPartialRestore(FORM_CALCULATOR);
	else if (application_status == METRIC)
		MathsAppPartialRestore(FORM_METRIC);
	else if (application_status == EXCHANGE)
		MathsAppPartialRestore(FORM_EXCHANGE);
	else if (application_status == LOAN)
		MathsAppPartialRestore(FORM_LOAN);
	
	switch(application_status)
	{
	case RESTART:
		StringSetText(DISPLAY, (BYTE*)("0  "));
		FormPopupForm(FORM_CALCULATOR);
		cal_icon_display = NO_OPERATION;
		operation = ADD;
		break;
	case CALCULATOR:
		ControlPopupSetSelectedItem(MODE_SELECTOR, 0);
		FormPopupForm(FORM_CALCULATOR);
		break;
	case METRIC:
		ControlPopupSetSelectedItem(MODE_SELECTOR, 1);
		MetricExchangeSetKeypadPos(FORM_METRIC);
		SetMetricInsertPt(TRUE, TEXTBOX_METRIC_0);
		TextboxGetTextPointer(TEXTBOX_METRIC_0, &buffer);
		TextboxSetInsertPointPositionByCharPos(TEXTBOX_METRIC_0, strlen(buffer));
		TextboxSetInsertPointOn(TEXTBOX_METRIC_0);
		FormSetFormActiveObject(FORM_METRIC, TEXTBOX_METRIC_0);
		FormPopupForm(FORM_METRIC);
		break;
	case EXCHANGE:
		MetricExchangeSetKeypadPos(FORM_EXCHANGE);
		ControlPopupSetSelectedItem(MODE_SELECTOR, 2);
		SetMetricInsertPt1(TRUE, TEXTBOX_EXCHANGE_INPUT);
		TextboxGetTextPointer(TEXTBOX_EXCHANGE_INPUT, &buffer);
		TextboxSetInsertPointPositionByCharPos(TEXTBOX_EXCHANGE_INPUT, strlen(buffer));
		TextboxSetInsertPointOn(TEXTBOX_EXCHANGE_INPUT);
		FormSetFormActiveObject(FORM_EXCHANGE, TEXTBOX_EXCHANGE_INPUT);
		FormPopupForm(FORM_EXCHANGE);
		break;
	case LOAN:
		MetricExchangeSetKeypadPos(FORM_LOAN);
		ControlPopupSetSelectedItem(MODE_SELECTOR, 3);
		if (calculating_item == 0)
		{
			SetMetricInsertPt2(TRUE, TEXTBOX_LOAN_INTEREST_RATE);
		}
		else
		{	
			SetMetricInsertPt2(TRUE, TEXTBOX_LOAN_NUM_YEARS);
		}
		TextboxGetTextPointer(metric_insert_pt2.textbox_id, &buffer);
		TextboxSetInsertPointPositionByCharPos(metric_insert_pt2.textbox_id, strlen(buffer));
		TextboxSetInsertPointOn(metric_insert_pt2.textbox_id);
		FormSetFormActiveObject(FORM_LOAN, metric_insert_pt2.textbox_id);
		for (i = CHECKBOX_LOAN_NUM_YEARS; i <= CHECKBOX_LOAN_MONTHLY_PAYMENT; i ++)
		{
			FormGetObjectPointer((ObjectID)(i), &object_type, (void**)&control_ptr);
			if (calculating_item == NO_SELECTION)
			{
				control_ptr->control_attr.control_enable = FALSE;
				((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
			}
			else if (i == (calculating_item + CHECKBOX_LOAN_NUM_YEARS))
			{
				control_ptr->control_attr.control_enable = FALSE;
				((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = TRUE;
			}
			else
			{
				control_ptr->control_attr.control_enable = TRUE;
				((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
			}
		}
		FormPopupForm(FORM_LOAN);
		break;
	default: break;
	}
}

/********************************************************
* Function:	MathsDatabaseChecking
* Purpose: 	This function is called to check whether the required database 
is already exist or not. If not, it will creat it
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void MathsDatabaseChecking()
{
	BYTE			application_status;
	BOOLEAN			temp;
	double			temp1;
	BYTE			temp2;
	ObjectID		temp3;
	SHORT			temp4;
    WORD            temp5;
	
	if (DataFindDB(MATHSDB, &maths_dbid) != TRUE)
	{
		/* New Database */
		DataNewDB(MATHSDB,1,MATHSAPP,&maths_dbid);
		DataOpenDB(maths_dbid,0,OPEN_RW);
		
		/* create Status record */
		DataNewRecordWithID(maths_dbid, MATHS_STATUS, 0, 1);
		application_status = RESTART;
		DataWriteField(maths_dbid, MATHS_STATUS, 0, 1, &application_status);
	}
	else if (DataIsDBOpen(maths_dbid, NULL, NULL) == FALSE)
		DataOpenDB(maths_dbid,0,OPEN_RW);
	
	if (DataRecordInfo(maths_dbid, MATHS_STATUS, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{	
		DataNewRecordWithID(maths_dbid, MATHS_STATUS, 0, 1);
		application_status = RESTART;
		DataWriteField(maths_dbid, MATHS_STATUS, 0, 1, &application_status);
	}
	
    if (DataRecordInfo(maths_dbid, CALCULATOR_INFO, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
        DataNewRecordWithID(maths_dbid, CALCULATOR_INFO, 0, 18);
		temp = FALSE;
		DataWriteField(maths_dbid, CALCULATOR_INFO, 0, sizeof(BOOLEAN), (BYTE*)&temp);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 1, sizeof(BOOLEAN), (BYTE*)&temp);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 2, sizeof(BOOLEAN), (BYTE*)&temp);
		temp1 = 0;
		DataWriteField(maths_dbid, CALCULATOR_INFO, 3, sizeof(double), (BYTE*)&temp1);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 4, sizeof(double), (BYTE*)&temp1);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 5, sizeof(double), (BYTE*)&temp1);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 6, sizeof(double), (BYTE*)&temp1);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 7, sizeof(double), (BYTE*)&temp1);
		temp2 = NO_OPERATION;
		DataWriteField(maths_dbid, CALCULATOR_INFO, 8, sizeof(BYTE), (BYTE*)&temp2);
		temp2 = CAL_EMPTY;
		DataWriteField(maths_dbid, CALCULATOR_INFO, 9, sizeof(BYTE), (BYTE*)&temp2);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 10, 2, (BYTE*)("0"));
		DataWriteField(maths_dbid, CALCULATOR_INFO, 11, sizeof(BOOLEAN), (BYTE*)&temp);
		temp2 = 0;
		DataWriteField(maths_dbid, CALCULATOR_INFO, 12, sizeof(BYTE), (BYTE*)&temp2);
		DataWriteField(maths_dbid, CALCULATOR_INFO, 13, 1, (BYTE*)(""));
		DataWriteField(maths_dbid, CALCULATOR_INFO, 14, sizeof(BOOLEAN), (BYTE*)&temp);
        DataWriteField(maths_dbid, CALCULATOR_INFO, 15, sizeof(WORD), (BYTE*)&temp5);
        temp5 = NO_OPERATION;
        DataWriteField(maths_dbid, CALCULATOR_INFO, 16, sizeof(BYTE), (BYTE*)&temp5);
        temp = FALSE;
        DataWriteField(maths_dbid, CALCULATOR_INFO, 17, sizeof(BOOLEAN), (BYTE*)&temp);
	}
    if (DataRecordInfo(maths_dbid, METRIC_INFO, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		DataNewRecordWithID(maths_dbid, METRIC_INFO, 0, 5);
		temp3 = PUSHBUTTON_METRIC_LENGTH;
		DataWriteField(maths_dbid, METRIC_INFO, 0, sizeof(ObjectID), (BYTE*)&temp3);
		temp4 = 0;
		DataWriteField(maths_dbid, METRIC_INFO, 1, sizeof(SHORT), (BYTE*)&temp4);
        temp4 = 3;
		DataWriteField(maths_dbid, METRIC_INFO, 2, sizeof(SHORT), (BYTE*)&temp4);
		DataWriteField(maths_dbid, METRIC_INFO, 3, 1, (BYTE*)(""));
		DataWriteField(maths_dbid, METRIC_INFO, 4, 1, (BYTE*)(""));
	}
    if (DataRecordInfo(maths_dbid, EXCHANGE_INFO, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		DataNewRecordWithID(maths_dbid, EXCHANGE_INFO, 0, 7);
        DataWriteField(maths_dbid, EXCHANGE_INFO, 0, 5, CALSTR1);
		DataWriteField(maths_dbid, EXCHANGE_INFO, 1, 1, (BYTE*)(""));
        DataWriteField(maths_dbid, EXCHANGE_INFO, 2, 5, CALSTR2);
        DataWriteField(maths_dbid, EXCHANGE_INFO, 3, 13, (BYTE*)("1.130178799"));
        temp4 = EXCHANGE_DEFAULT_COUNTRY_1;   
		DataWriteField(maths_dbid, EXCHANGE_INFO, 4, sizeof(SHORT), (BYTE*)&temp4);
        temp4 = EXCHANGE_DEFAULT_COUNTRY_2;
		DataWriteField(maths_dbid, EXCHANGE_INFO, 5, sizeof(SHORT), (BYTE*)&temp4);
		temp = FALSE;
		DataWriteField(maths_dbid, EXCHANGE_INFO, 6, sizeof(SHORT), (BYTE*)&temp);
	}
	if (DataRecordInfo(maths_dbid, LOAN_INFO, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		DataNewRecordWithID(maths_dbid, LOAN_INFO, 0, 7);
		DataWriteField(maths_dbid, LOAN_INFO, 0, 1, (BYTE*)(""));
		DataWriteField(maths_dbid, LOAN_INFO, 1, 1, (BYTE*)(""));
		DataWriteField(maths_dbid, LOAN_INFO, 2, 1, (BYTE*)(""));
		DataWriteField(maths_dbid, LOAN_INFO, 3, 1, (BYTE*)(""));
		DataWriteField(maths_dbid, LOAN_INFO, 4, 1, (BYTE*)(""));
		DataWriteField(maths_dbid, LOAN_INFO, 5, 1, (BYTE*)(""));
		temp2 = -1;
		DataWriteField(maths_dbid, LOAN_INFO, 6, 1, (BYTE*)&temp2);
	}
}

/********************************************************
* Function:	MathsAppPartialRestore
* Purpose: 	This function is called to partially restore the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		restored_form
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN MathsAppPartialRestore(ObjectID restored_form)
{
	Form			*form_ptr;
	Bitmap			*bitmap_ptr;
	BYTE			object_type;
	BYTE			application_status;
	BYTE			*buffer;
	UWORD			byte_read;
	CountrySettings	country;
	Control			*control_ptr;
	BOOLEAN			found = FALSE;
	SHORT			item_num;
	BOOLEAN			bitmap_drawn, bitmap_enable, bitmap_active, bitmap_visible;
	
	if (FormGetObjectPointer(restored_form, &object_type, (void**)&form_ptr) == TRUE)
		return FALSE;
	
	if (FormGetObjectPointer(MODE_SELECTOR, &object_type, (void**)&control_ptr) == TRUE)
	{
		found = TRUE;
		ControlPopupGetSelectedItem(MODE_SELECTOR, &item_num);
	}		
	
	switch (restored_form)
	{
	case FORM_CALCULATOR:
		FormInitAllFormObjects(FORM_CALCULATOR);
		if (found == TRUE)
			ControlPopupSetSelectedItem(MODE_SELECTOR, item_num);
		DataGetField(maths_dbid, CALCULATOR_INFO, 0, &buffer, &byte_read);
		has_memory_content = *(BOOLEAN*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 1, &buffer, &byte_read);
		error_occured = *(BOOLEAN*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 2, &buffer, &byte_read);
		negative = *(BOOLEAN*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 3, &buffer, &byte_read);
		input_buffer = *(double*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 4, &buffer, &byte_read);
		memory_buffer = *(double*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 5, &buffer, &byte_read);
		temp_buffer = *(double*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 6, &buffer, &byte_read);
		temp_buffer1 = *(double*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 7, &buffer, &byte_read);
		result_buffer = *(double*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 8, &buffer, &byte_read);
		operation = *buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 9, &buffer, &byte_read);
		last_input_type = *buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 10, &buffer, &byte_read);
		strcpy(display_buffer, buffer);
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 11, &buffer, &byte_read);
		operator_pressed = *(BOOLEAN*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 12, &buffer, &byte_read);
		displaying_buffer = *buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 13, &buffer, &byte_read);
		StringSetText(DISPLAY, buffer);
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 14, &buffer, &byte_read);
		has_decimal = *(BOOLEAN*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 15, &buffer, &byte_read);
		num_digits = *(WORD*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 16, &buffer, &byte_read);
		cal_icon_display = *(WORD*)buffer;
		qfree(buffer);
		DataGetField(maths_dbid, CALCULATOR_INFO, 17, &buffer, &byte_read);
		percent_pressed = *(BOOLEAN*)buffer;
		qfree(buffer);
		
		
#ifdef PR31700
		if (!SySetupGetCountrySettings(&country))
			comma_type = SYSETUP_NUMS_C_F;
		else comma_type = country.nums;
#endif
		
#ifdef PC_SIM
		comma_type = SYSETUP_NUMS_S_C;
#endif
		
		if (comma_type == SYSETUP_NUMS_F_C || comma_type == SYSETUP_NUMS_S_C ||
			comma_type == SYSETUP_NUMS_N_C)
		{
			FormGetObjectPointer(BITMAP_DOT, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_COMMA, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
		}
		
		if (has_memory_content == FALSE)
		{
			BitmapGetAttribute(BITMAP_DISPLAY_M,&bitmap_drawn, &bitmap_enable,
				&bitmap_active,&bitmap_visible);
			
			BitmapSetAttribute(BITMAP_DISPLAY_M,bitmap_drawn, bitmap_enable,
				bitmap_active, FALSE);
		}
		
		if (has_memory_content == TRUE)
		{
			BitmapGetAttribute(BITMAP_DISPLAY_M,&bitmap_drawn, &bitmap_enable,
				&bitmap_active,&bitmap_visible);
			BitmapSetAttribute(BITMAP_DISPLAY_M,bitmap_drawn, bitmap_enable,
				bitmap_active, TRUE);
		}
		if (displaying_buffer == INPUT && 
			last_input_type != MPLUS &&
			last_input_type != MMINUS &&
			last_input_type != MR)
			CalculatorDisplayBufferToDisplay(FROM_INPUT);
		else
			CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
		
		if (cal_icon_display == ADD)
		{
			FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		}            
		else if (cal_icon_display == SUB)
		{
			FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		}            			
		else if (cal_icon_display == TIMES)
		{
			FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
		}            						
		else if (cal_icon_display == DIV)
		{
			FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		}            			
		else
		{
			
			FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		}            							
		
		
		
		break;
		case FORM_METRIC:
			FormInitAllFormObjects(FORM_METRIC);
			if (found == TRUE)
				ControlPopupSetSelectedItem(MODE_SELECTOR, item_num);
			DataGetField(maths_dbid, METRIC_INFO, 0, &buffer, &byte_read);
			FormSetControlGroupSelection(FORM_METRIC, (*(ObjectID*)buffer));
			qfree(buffer);
            MetricChangePopupTriggerContent();
			DataGetField(maths_dbid, METRIC_INFO, 1, &buffer, &byte_read);
			ControlPopupSetSelectedItem(POPUP_TRIGGER_FIRST, (*(SHORT*)buffer));
			qfree(buffer);
			DataGetField(maths_dbid, METRIC_INFO, 2, &buffer, &byte_read);
			ControlPopupSetSelectedItem(POPUP_TRIGGER_SECOND, (*(SHORT*)buffer));
			qfree(buffer);
			DataGetField(maths_dbid, METRIC_INFO, 3, &buffer, &byte_read);
			TextboxSetText(TEXTBOX_METRIC_0, buffer);
			qfree(buffer);
			DataGetField(maths_dbid, METRIC_INFO, 4, &buffer, &byte_read);
			TextboxSetText(TEXTBOX_METRIC_1, buffer);
			qfree(buffer);
			MetricSetConversionTable();
			break;
		case FORM_EXCHANGE:
			FormInitAllFormObjects(FORM_EXCHANGE);
			if (found == TRUE)
				ControlPopupSetSelectedItem(MODE_SELECTOR, item_num);
			DataGetField(maths_dbid, EXCHANGE_INFO, 0, &buffer, &byte_read);
			StringSetText(STRING_EXCHANGE_0, buffer);
			qfree(buffer);
			DataGetField(maths_dbid, EXCHANGE_INFO, 1, &buffer, &byte_read);
			TextboxSetText(TEXTBOX_EXCHANGE_INPUT, buffer);
			qfree(buffer);
			DataGetField(maths_dbid, EXCHANGE_INFO, 2, &buffer, &byte_read);
			StringSetText(STRING_EXCHANGE_1, buffer);
			qfree(buffer);
			DataGetField(maths_dbid, EXCHANGE_INFO, 3, &buffer, &byte_read);
			TextboxSetText(TEXTBOX_EXCHANGE_RATE, buffer);
			qfree(buffer);
			DataGetField(maths_dbid, EXCHANGE_INFO, 4, &buffer, &byte_read);
			ControlPopupSetSelectedItem(POPUP_TRIGGER_F, (*(SHORT*)buffer));
			qfree(buffer);
			DataGetField(maths_dbid, EXCHANGE_INFO, 5, &buffer, &byte_read);
			ControlPopupSetSelectedItem(POPUP_TRIGGER_S, (*(SHORT*)buffer));
			qfree(buffer);
			break;
		case FORM_LOAN:
			FormInitAllFormObjects(FORM_LOAN);
			if (found == TRUE)
				ControlPopupSetSelectedItem(MODE_SELECTOR, item_num);
			DataGetField(maths_dbid, LOAN_INFO, 0, &buffer, &byte_read);
			TextboxSetText(TEXTBOX_LOAN_NUM_YEARS, buffer);
			qfree(buffer);
			DataGetField(maths_dbid, LOAN_INFO, 1, &buffer, &byte_read);
			TextboxSetText(TEXTBOX_LOAN_INTEREST_RATE, buffer);
			qfree(buffer);
			DataGetField(maths_dbid, LOAN_INFO, 2, &buffer, &byte_read);
			TextboxSetText(TEXTBOX_LOAN_LOAN_AMOUNT, buffer);
			qfree(buffer);
			DataGetField(maths_dbid, LOAN_INFO, 3, &buffer, &byte_read);
			TextboxSetText(TEXTBOX_LOAN_MONTHLY_PAYMENT, buffer);
			qfree(buffer);
			DataGetField(maths_dbid, LOAN_INFO, 4, &buffer, &byte_read);
			StringSetText(STRING_LOAN_TOTAL_PAYMENT_RESULT, buffer);
			qfree(buffer);
			DataGetField(maths_dbid, LOAN_INFO, 5, &buffer, &byte_read);
			StringSetText(STRING_LOAN_TOTAL_INTEREST_RESULT, buffer);
			qfree(buffer);
			DataGetField(maths_dbid, LOAN_INFO, 6, &buffer, &byte_read);
			calculating_item = *buffer;
			qfree(buffer);
			break;
	}
	return TRUE;
}
