/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   cal.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "sysetup.h"

/********************************************************
* Function:	CalculatorCalculation
* Purpose: 	T
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
Err CalculatorCalculation(BYTE next_operation)
{
	double temp_buffer = 100;
	double temp_buffer1 = 0;
	double temp_buffer2 = 1;
    double temp_result = 0;
	
	
	if (next_operation == PERCENT)
	{
        if (operation == ADD)
        {
            input_buffer = (result_buffer * input_buffer/temp_buffer) + result_buffer;
            temp_buffer = input_buffer;
            input_buffer = result_buffer;
            result_buffer = temp_buffer;
            displaying_buffer = RESULT;
        }
        else if (operation == SUB)
        {
            input_buffer = result_buffer - (result_buffer * input_buffer/temp_buffer);
            temp_buffer = input_buffer;
            input_buffer = result_buffer;
            result_buffer = temp_buffer;
            displaying_buffer = RESULT;           
        }
        else if (operation == TIMES)
		{
            input_buffer = input_buffer/temp_buffer * result_buffer;
            temp_buffer = input_buffer;
            input_buffer = result_buffer;
            result_buffer = temp_buffer;
            displaying_buffer = RESULT;
		}
        else if (operation == DIV)
        {
            temp_result = input_buffer/temp_buffer;
            if (temp_result)
                result_buffer       = result_buffer / temp_result;
            else
            {
                error_occured = TRUE;
                result_buffer = 0;
            }
            displaying_buffer   = RESULT;
            operation = DIV;
        }
        return TRUE;
	}
	
	if (next_operation == SQUROOT)
	{
		if ((last_input_type == MR && displaying_buffer == INPUT) || last_input_type == DIGITS ||
            last_input_type == SQUROOT_I/* || last_input_type == PERCENT*/)
			input_buffer = sqrt(input_buffer);
        else if (last_input_type == PERCENT || last_input_type == OPERATOR ||
			last_input_type == SQUROOT_R || last_input_type == EQUAL ||
			last_input_type == MPLUS || last_input_type == MMINUS ||
			(last_input_type == MR && displaying_buffer == RESULT))
			result_buffer = sqrt(result_buffer);
	}
	else if (next_operation == EQUAL)
	{
		switch (operation)
		{
		case ADD: //result_buffer += input_buffer;
			result_buffer = add(result_buffer, input_buffer);
			break;
		case SUB: result_buffer = subtract(result_buffer,input_buffer);
			break;
		case TIMES: result_buffer *= input_buffer;
			break;
		case DIV:  if (input_buffer == 0)
					   error_occured = TRUE;
			else
				result_buffer = result_buffer/input_buffer;
			break;
		default: break;
		}
	}
	else if (operation == ADD)
        //result_buffer += input_buffer;
        result_buffer = add(result_buffer, input_buffer);
	else if (operation == SUB)
		result_buffer = subtract(result_buffer,input_buffer);
	else if (operation == TIMES)
		result_buffer *= input_buffer;
	else if (operation == DIV)
	{
		if (input_buffer == 0)
			error_occured = TRUE;
		else
			result_buffer = result_buffer/input_buffer;
	}
	if (next_operation != EQUAL && next_operation != PERCENT && next_operation != SQUROOT)
		operation = next_operation;
	return TRUE;
}

/********************************************************
* Function:	CalculatorClearDisplayBuffer
* Purpose: 	This function is called to clear the display_buffer
variable to 0.
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void  CalculatorClearDisplayBuffer()
{
	if (display_buffer == NULL)
		display_buffer = (BYTE*)qmalloc(50*sizeof(BYTE));
	strcpy(display_buffer, (BYTE*)(""));
	has_decimal = FALSE;
	num_digits = 0;
	display_value = 0;
}

/********************************************************
* Function:	CalculatorDisplayBufferToDisplay
* Purpose: 	this function is called to format the data
in display_buffer variable to the string DISPLAY
* Scope:		Application
* Input:		new_digit		the new_digit to be added
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void CalculatorDisplayBufferToDisplay(BYTE option)
{
	
    String *string_ptr;
    BYTE object_type;
	BYTE *filtered;
	BYTE *to_display;
	BYTE *temp_string;
	
	WORD total_num_comma = 0;
	BYTE comma_pos[3];
	BYTE comma_sign[9];
	
	WORD i = 0, j = 0;
	
	BOOLEAN bitmap_drawn = FALSE;
	BOOLEAN bitmap_visible = FALSE;
	BOOLEAN bitmap_enable = FALSE;
	BOOLEAN bitmap_active = FALSE;
	BOOLEAN zero = TRUE;
	BOOLEAN decimal = FALSE;
	BOOLEAN digit = FALSE;
	SHORT decimal_pos = 0;
	WORD count = 0;
	WORD length;
	
	double temp_value;
	/* initialisation */	
	filtered = (BYTE*)qmalloc(50*sizeof(BYTE));
	filtered[0] = '\0';
	to_display = (BYTE*)qmalloc(50*sizeof(BYTE));
	decimal_pos = -1;
	comma_pos[0] = -1;
	comma_pos[1] = -1;
	comma_pos[2] = -1;
	comma_sign[0] = ',';
	comma_sign[1] = ',';
	comma_sign[2] = ',';
	comma_sign[3] = ',';
	comma_sign[4] = ',';
	comma_sign[5] = ',';
	comma_sign[6] = ',';
	comma_sign[7] = ',';
	comma_sign[8] = ',';
	
	CalculatorChopDisplay(display_buffer, 12, &temp_string);
	strcpy(display_buffer, temp_string);
	qfree(temp_string);
	/* filtering */
	if (*display_buffer == '-')
	{
		if (strlen(display_buffer) > 14)
			length = 14;
		else length = strlen(display_buffer);
	}
	else
	{
		if (strlen(display_buffer) > 13)
			length = 13;
		else length = strlen(display_buffer);
	}
	
	temp_value = display_value;
	
    if (strlen(display_buffer) == 0 || error_occured == TRUE || temp_value >= 999999999999.5 || temp_value <= -999999999999.5)
	{
		strcpy(filtered, (BYTE*)("0."));
		if (strlen(display_buffer) != 0) error_occured = TRUE;
		decimal_pos = 1;
		decimal = TRUE;
		digit = TRUE;
		negative = FALSE;
	}
	else
	{
		j = 0;
		for (i = 0; i < length; i++)
		{
			if (i == 0)
			{
				if (display_buffer[0] == '-')
				{
					negative = TRUE;
					continue;
				}
				else negative = FALSE;
			}
			if (digit == FALSE && display_buffer[i] == '0')
				continue;
			else if (display_buffer[i] == '.')
			{
				if (digit == FALSE && decimal == FALSE)
				{
					digit = TRUE;
					decimal = TRUE;
					decimal_pos = 1;
					strcpy(filtered, (BYTE*)("0."));
					j = 2;
				}
				else
				{
					decimal = TRUE;
					decimal_pos = j;
					filtered[j] = '.';
					filtered[j + 1] = '\0';
					j++;
				}
			}
			else
			{
				digit = TRUE;
				filtered[j] = display_buffer[i];
				filtered[j + 1] = '\0';
				j++;
			}
		}
		if (strlen(filtered) == 0)
		{
			decimal = TRUE;
			digit = TRUE;
			decimal_pos = 1;
			strcpy(filtered, (BYTE*)("0."));
		}
	}
	
				
	if (decimal_pos == -1)
		i = strlen(filtered);
	else i = decimal_pos;
	do
	{
		i -= 3;
		if (i > 0)
		{
			total_num_comma ++;
			comma_pos[total_num_comma - 1] = (BYTE)i;
		}
	}while(i > 0);
	j = 0;
	for (i = 0; i < strlen(filtered); i++)
	{
		if (total_num_comma > 0 )
			if (comma_pos[total_num_comma - 1] == i)
			{
				to_display[j] = comma_sign[comma_type];		
				total_num_comma--;
				j++;		
			}
			to_display[j] = filtered[i];
			j++;
	}
	if (decimal == FALSE)
	{	
		to_display[j] = '.';
		to_display[j + 1] = '\0';
	}
	else to_display[j] = '\0';
	
	if (option == FROM_CALCULATION)
	{
		i = strlen(to_display) - 1;
		while (to_display[i] == '0')
		{
			to_display[i] = '\0';
			i--;
		}
	}
	
	if (error_occured == FALSE)
	{
		if (to_display[strlen(to_display) - 1]	== '.' && has_decimal == FALSE)
			to_display[strlen(to_display) - 1]	= '\0';
		if (negative == TRUE)
		{
			strcpy((filtered + 1), to_display);
			filtered[0] = '-';
			strcpy(to_display, filtered);
		}
	}
	else strcpy(to_display, CALSTR3);
	
	
	/* add zeros spacing at the end of the display */ 
	i = strlen(to_display);
	for (j = i; j < (i + 2); j++)
	{
		to_display[j] = 32;
		to_display[j+1] = 0;
	}
	
	
	/* Change the display format */
	switch (comma_type)
	{
	case SYSETUP_NUMS_C_F:
		break;
	case SYSETUP_NUMS_F_C:
		for (i = 0; i < strlen(to_display); i++)
		{
			if (to_display[i] == ',')
				filtered[i] = '.';
			else if (to_display[i] == '.')
				filtered[i] = ',';
			else filtered[i] = to_display[i];
		}
		filtered[i] = 0;
		strcpy(to_display, filtered);
		break;
	case SYSETUP_NUMS_S_C:
		for (i = 0; i < strlen(to_display); i++)
		{
			if (to_display[i] == ',')
				filtered[i] = 32;
			else if (to_display[i] == '.')
				filtered[i] = ',';
			else filtered[i] = to_display[i];
		}
		filtered[i] = 0;
		strcpy(to_display, filtered);
		break;
	case SYSETUP_NUMS_S_F:
		for (i = 0; i < strlen(to_display); i++)
		{
			if (to_display[i] == ',')
				filtered[i] = 32;
			else filtered[i] = to_display[i];
		}
		filtered[i] = 0;
		strcpy(to_display, filtered);
		break;
	case SYSETUP_NUMS_N_C:
		count = 0;
		for (i = 0; i < strlen(to_display); i++)
		{
			if (to_display[i] == '.')
				filtered[i - count] = ',';
			else if (to_display[i] == ',')
				count ++;
			else filtered[i - count] = to_display[i];
		}
		filtered[i - count] = 0;
		strcpy(to_display, filtered);
		break;
	case SYSETUP_NUMS_N_F:
		count = 0;
		for (i = 0; i < strlen(to_display); i++)
		{
			if (to_display[i] == ',')
				count ++;
			else filtered[i - count] = to_display[i];
		}
		filtered[i - count] = 0;
		strcpy(to_display, filtered);
		break;
	default: break;
	}
	
	
	
	StringSetText(DISPLAY, to_display);
	qfree(filtered);
	qfree(to_display);
	
	if (has_memory_content == FALSE)
	{
		BitmapGetAttribute(BITMAP_DISPLAY_M,&bitmap_drawn, &bitmap_enable,
			&bitmap_active,&bitmap_visible);
		
		BitmapSetAttribute(BITMAP_DISPLAY_M,bitmap_drawn, bitmap_enable,
			bitmap_active, FALSE);
		BitmapEraseBitmap(BITMAP_DISPLAY_M);
	}
	
	
	StringDrawString(DISPLAY);
	
	
	if (has_memory_content == TRUE)
	{
		BitmapGetAttribute(BITMAP_DISPLAY_M,&bitmap_drawn, &bitmap_enable,
			&bitmap_active,&bitmap_visible);
		
		BitmapSetAttribute(BITMAP_DISPLAY_M,bitmap_drawn, bitmap_enable,
			bitmap_active, TRUE);
		BitmapDrawBitmap(BITMAP_DISPLAY_M);
	}
    CalculatorDrawSymbol();
}

/********************************************************
* Function:	CalculatorNewDigitToDisplayBuffer
* Purpose: 	This function is called to add a new digit
to the display_buffer
* Scope:		Application
* Input:		new_digit		the new_digit to be added
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void CalculatorNewDigitToDisplayBuffer(BYTE new_digit)
{
	if (num_digits >= 12) return;
	if (new_digit == '.' && has_decimal == TRUE)
		return;
	else if (new_digit == '0' && has_decimal == FALSE && strlen(display_buffer) == 2
		&& display_buffer[0] == '0' && display_buffer[1] == '.')
		return;
	else if (new_digit == '0' && has_decimal == FALSE && strlen(display_buffer) == 1
		&& display_buffer[0] == '0')
		return;
	else if (strlen(display_buffer) == 0 && new_digit == '.')
	{
		strcpy(display_buffer, (BYTE*)("0."));
		has_decimal = TRUE;
        num_digits ++;
	}
	else 
	{
		if (strlen(display_buffer) == 1 && display_buffer[0] == '0' && new_digit >= '1' && new_digit <= '9')
			num_digits = 0;
		
		if (new_digit == '.')
			has_decimal = TRUE;
        sprintf((char*)(display_buffer + strlen(display_buffer)), "%c", new_digit);
	}
	if (new_digit != '.')
		num_digits ++;
	display_value = atod((char*)display_buffer);
	CalculatorDisplayBufferToDisplay(FROM_INPUT);
}

/********************************************************
* Function:	CalculatorInit
* Purpose: 	This function is called to initialise the calculator variables
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void CalculatorInit()
{
	comma_type = 0;
}

/********************************************************
* Function:	CalculatorChopDisplay
* Purpose: 	This function is called in order to chop the display of number 
to the required and accepted number of digits
* Scope:		Application
* Input:		input_string	The input string of the display
num_of_digits	number of digits that can be displayed
* Output:		output_string	Th chopped string
* Return:		None
* Comment: 	None
*********************************************************/
void CalculatorChopDisplay(BYTE *input_string, USHORT num_of_digits, BYTE **output_string)
{
	BOOLEAN is_negative = FALSE;
	BOOLEAN has_decimal = FALSE;
	USHORT length_of_input, i, decimal_pos = 0;
	BYTE *temp_string, *temp_string1;
	double temp, temp1;
	ObjectID active_form;
	
	if (*input_string == '-')
		is_negative = TRUE;
	
	length_of_input = strlen(input_string);
	
	*output_string = (BYTE*)qmalloc((length_of_input + 1) * sizeof(BYTE));
	temp_string = (BYTE*)qmalloc((length_of_input + 1) * sizeof(BYTE));
	
	if ((is_negative == FALSE && length_of_input <= (num_of_digits + 1))
		|| (is_negative == TRUE && length_of_input <= (num_of_digits + 2)))
	{
		strcpy(*output_string, input_string);
		qfree(temp_string);
		return;
	}
	else 
	{
		temp = atod((char*)input_string);
		strcpy(temp_string, input_string);		
		for (i = 0; i < length_of_input; i++)
		{
			if (temp_string[i] >= 48 && temp_string[i] <= 57)
			{
				if (i == (num_of_digits + 1) && is_negative == FALSE)
					temp_string[i] = '5';
				else if (i == (num_of_digits + 2) && is_negative == TRUE)
					temp_string[i] = '5';
				else temp_string[i] = '0';
			}
		}
		temp1 = atod((char*)temp_string);			
		temp += temp1;
		temp_string1 = (BYTE*)qmalloc(100 * sizeof(BYTE));
		dtoa(temp, (char*)(temp_string1), 20);
		
		FormGetActiveFormID(&active_form);		
		if (is_negative == TRUE)
		{
			if (active_form != FORM_CALCULATOR)
				num_of_digits --;
		}
		if (active_form == FORM_CALCULATOR)		
		{
			if (is_negative == FALSE)
				(temp_string1)[num_of_digits + 1] = '\0';
			else
				(temp_string1)[num_of_digits + 2] = '\0';
		}
		else
		{
			if (is_negative == FALSE)
				(temp_string1)[num_of_digits] = '\0';
			else
				(temp_string1)[num_of_digits + 1] = '\0';
		}
		strcpy(*output_string, temp_string1);
		qfree(temp_string1);
		qfree(temp_string);
	}
}

/********************************************************
* Function:	CalculatorDrawSymbol
* Purpose: 	This function is called to draw the 
ADD, DIV, SUB, MUL symbol
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void CalculatorDrawSymbol()
{
	Bitmap	*bitmap_ptr;
	BYTE	object_type;
	
	if (cal_icon_display == ADD)
	{
		FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
		FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
	}            
	else if (cal_icon_display == SUB)
	{
		FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
		FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
	}            			
	else if (cal_icon_display == TIMES)
	{
		FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
	}            						
	else if (cal_icon_display == DIV)
	{
		FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
		FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
	}            			
	else
	{
		
		FormGetObjectPointer(BITMAP_CAL_PLUS, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_DIV, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_SUB, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_CAL_MUL, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
	}            							
	
	
	switch (cal_icon_display)
	{
	case ADD: BitmapDrawBitmap(BITMAP_CAL_PLUS);
		break;
	case DIV: BitmapDrawBitmap(BITMAP_CAL_DIV);
		break;
	case SUB: BitmapDrawBitmap(BITMAP_CAL_SUB);
		break;
	case TIMES: BitmapDrawBitmap(BITMAP_CAL_MUL);
		break;
	default: break;
	}
}

/********************************************************
* Function:    CalculatorFilterPasteText
* Purpose:     This function is called to filter
the input text                                 
* Scope:		Application
* Input:		None
* Output:		None
* Return:      TRUE        able to paste into calculator
FALSE       can't paste
* Comment: 	None
*********************************************************/
BOOLEAN CalculatorFilterPasteText(BYTE *paste_text, BYTE **result_text, double *result_value, BOOLEAN *decimal_place)
{
    UWORD       num_chars = 0, count;
    BOOLEAN     decimal = FALSE;
	
    num_chars = strlen(paste_text);
	
    for (count = 0; count < num_chars; count ++)
    {
        if (paste_text[count] == '.')
        {
            if (decimal == FALSE)
                decimal = TRUE;
            else
                return FALSE;
        }
        else if (paste_text[count] > '9' || paste_text[count] < '0')
            return FALSE;
    }
	
    *result_value = atod((char*)paste_text);
	
    if (fabs(*result_value) > (double)999999999999.0)
        return FALSE;
    else if (fabs(*result_value) < 1e-11)
    {
        strcpy(paste_text, (BYTE*)("0"));
        *result_value = 0;
    }
	
    CalculatorChopDisplay(paste_text, 12, result_text);
	
    if (decimal)
        *decimal_place = TRUE;
    else *decimal_place = FALSE;
    return TRUE;
}

/********************************************************
* Function:    CalculatorCheckPasteText
* Purpose:     This function is called to check the paste text
to FORM_METRIC, FORM_EXCHANGE and FORM_LOAN
If it can fit into the textbox, then it will be pasted
into the textbox
* Scope:		Application
* Input:		None
* Output:		None
* Return:      TRUE        able to paste into textbox
FALSE       Can't Paste
* Comment: 	None
*********************************************************/
BOOLEAN CalculatorCheckPasteText()
{
    BYTE        *paste_text, data_type, object_type, *chopped_text;
    WORD        data_size, num_chars, count;
    ObjectID    active_form_id, active_object_id;
    Textbox     *addr;
    BOOLEAN     decimal = FALSE;
    double      paste_value = 0;
	
    
    if (FormGetActiveFormID(&active_form_id) != TRUE)
        return FALSE;
    if (FormGetActiveObject(active_form_id, &active_object_id) != TRUE)
        return FALSE;
    if (FormGetObjectPointer(active_object_id, &object_type, (void**)&addr) != TRUE)
        return FALSE;
    if (object_type != TEXTBOX)
        return FALSE;
	
    paste_text = (BYTE*)ClipboardGetItem(&data_type, &data_size);
    if (paste_text == NULL)
		return FALSE;
	
    num_chars  = strlen(paste_text);
    if (num_chars > addr->textbox_max_chars)
        return FALSE;
	
    for (count = 0; count < num_chars; count ++)
    {
        if (paste_text[count] == '.')
        {
            if (decimal == FALSE)
                decimal = TRUE;
            else
                return FALSE;
        }
        else if (paste_text[count] > '9' || paste_text[count] < '0')
            return FALSE;
    }
	
    paste_value = atod((char*)paste_text);
	
    switch (addr->textbox_max_chars)
    {
	case 8:
		if (fabs(paste_value) > 1e+8)
			return FALSE;
		else if (fabs(paste_value) < 1e-5)
		{
			paste_value = 0;
			strcpy(paste_text, (BYTE*)("0"));
			break;
		}
	case 12:
		if (fabs(paste_value) > 1e+12)
			return FALSE;
		else if (fabs(paste_value) < 1e-10)
		{
			paste_value = 0;
			strcpy(paste_text, (BYTE*)("0"));
			break;
		}                
	default: break;
    }
	
    CalculatorChopDisplay(paste_text, (USHORT)(addr->textbox_max_chars), &chopped_text);
    TextboxSetText(active_object_id, chopped_text);
    addr->textbox_attr.textbox_highlight = FALSE;
    addr->textbox_highlight_start_char = 0;
    addr->textbox_highlight_length = 0;
    TextboxSetInsertPointOn(active_object_id);
    TextboxSetInsertPointPositionByCharPos(active_object_id, strlen(addr->textbox_string));
    TextboxDrawTextbox(active_object_id);
	
    qfree(chopped_text);
    qfree(paste_text);
    return TRUE;
}

/********************************************************
* Function:	CalculatorGetDisplay
* Purpose: 	this function is called to format the data
in display_buffer variable to the string DISPLAY
* Scope:		Application
* Input:		new_digit		the new_digit to be added
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void CalculatorGetDisplay(BYTE	*input_string, BYTE option)
{
	
    String *string_ptr;
    BYTE object_type;
	BYTE *filtered;
	BYTE *to_display;
	BYTE *temp_string;
	
	WORD total_num_comma = 0;
	BYTE comma_pos[3];
	BYTE comma_sign[9];
	
	WORD i = 0, j = 0;
	
	BOOLEAN bitmap_drawn = FALSE;
	BOOLEAN bitmap_visible = FALSE;
	BOOLEAN bitmap_enable = FALSE;
	BOOLEAN bitmap_active = FALSE;
	BOOLEAN zero = TRUE;
	BOOLEAN decimal = FALSE;
	BOOLEAN digit = FALSE;
	SHORT decimal_pos = 0;
	WORD count = 0;
	WORD length;
	
	double temp_value;
	/* initialisation */	
	filtered = (BYTE*)qmalloc(50*sizeof(BYTE));
	filtered[0] = '\0';
	to_display = (BYTE*)qmalloc(50*sizeof(BYTE));
	decimal_pos = -1;
	comma_pos[0] = -1;
	comma_pos[1] = -1;
	comma_pos[2] = -1;
	comma_sign[0] = ',';
	comma_sign[1] = ',';
	comma_sign[2] = ',';
	comma_sign[3] = ',';
	comma_sign[4] = ',';
	comma_sign[5] = ',';
	comma_sign[6] = ',';
	comma_sign[7] = ',';
	comma_sign[8] = ',';
	
	CalculatorChopDisplay(input_string, 12, &temp_string);
	strcpy(input_string, temp_string);
	qfree(temp_string);
	/* filtering */
	if (*input_string == '-')
	{
		if (strlen(input_string) > 14)
			length = 14;
		else length = strlen(input_string);
	}
	else
	{
		if (strlen(input_string) > 13)
			length = 13;
		else length = strlen(input_string);
	}
	
	temp_value = display_value;
	
    if (strlen(input_string) == 0 || error_occured == TRUE || temp_value >= 999999999999.5 || temp_value <= -999999999999.5)
	{
		strcpy(filtered, (BYTE*)("0."));
		if (strlen(input_string) != 0) error_occured = TRUE;
		decimal_pos = 1;
		decimal = TRUE;
		digit = TRUE;
		negative = FALSE;
	}
	else
	{
		j = 0;
		for (i = 0; i < length; i++)
		{
			if (i == 0)
			{
				if (input_string[0] == '-')
				{
					negative = TRUE;
					continue;
				}
				else negative = FALSE;
			}
			if (digit == FALSE && input_string[i] == '0')
				continue;
			else if (input_string[i] == '.')
			{
				if (digit == FALSE && decimal == FALSE)
				{
					digit = TRUE;
					decimal = TRUE;
					decimal_pos = 1;
					strcpy(filtered, (BYTE*)("0."));
					j = 2;
				}
				else
				{
					decimal = TRUE;
					decimal_pos = j;
					filtered[j] = '.';
					filtered[j + 1] = '\0';
					j++;
				}
			}
			else
			{
				digit = TRUE;
				filtered[j] = input_string[i];
				filtered[j + 1] = '\0';
				j++;
			}
		}
		if (strlen(filtered) == 0)
		{
			decimal = TRUE;
			digit = TRUE;
			decimal_pos = 1;
			strcpy(filtered, (BYTE*)("0."));
		}
	}
	
				
	if (decimal_pos == -1)
		i = strlen(filtered);
	else i = decimal_pos;
	
	do
	{
		i -= 3;
		if (i > 0)
		{
			total_num_comma ++;
			comma_pos[total_num_comma - 1] = (BYTE)i;
		}
	}while(i > 0);
	
    strcpy(to_display, filtered);
	
	if (decimal == FALSE)
	{	
		to_display[j] = '.';
		to_display[j + 1] = '\0';
	}
	else to_display[j] = '\0';
	
	if (option == FROM_CALCULATION)
	{
		i = strlen(to_display) - 1;
		while (to_display[i] == '0')
		{
			to_display[i] = '\0';
			i--;
		}
	}
	
	if (error_occured == FALSE)
	{
		if (to_display[strlen(to_display) - 1]	== '.' && has_decimal == FALSE)
			to_display[strlen(to_display) - 1]	= '\0';
		if (negative == TRUE)
		{
			strcpy((filtered + 1), to_display);
			filtered[0] = '-';
			strcpy(to_display, filtered);
		}
	}
	else strcpy(to_display, CALSTR3);
	
	strcpy(input_string, to_display);
	qfree(filtered);
    qfree(to_display);         
}                              
