/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   menufunc.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/


#include "stdafx.h"
#include "app.h"

BOOLEAN  function_from_menu = FALSE;

//#define DEBUG

/********************************************************
* Function:	MenuItemSelectedAction
* Purpose: 	This fucntion is to do an action when 
an item in a menu is selected
* Scope:		application/internal
* Input:		menu_item		The item number of the selectd menu item
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void MenuItemSelectedAction(USHORT item_num)
{
    ObjectID    active_form_id;
    ObjectID    active_object_id;
    BOOLEAN     highlighted = FALSE, insert_pt = FALSE;
    BYTE        object_type;
    void        *addr;
    BYTE        *string_text, *textbox_text, *temp_text, data_type, *result_text;
    WORD        data_size;
    double      result_value;
    BOOLEAN     decimal_place;
    double      temp;
    BYTE        *calculator_string, temp_string[100];
    WORD		count;
	
	FormGetActiveFormID(&active_form_id);
	FormGetActiveObject(active_form_id, &active_object_id);
	if (FormGetObjectPointer(active_object_id, &object_type, (void**)&addr) == FALSE)
		return;
	
	switch(item_num)
	{
	case MENU_ITEM_COPY:
		if (active_form_id == FORM_CALCULATOR)
		{
			strcpy(temp_string, display_buffer);
			CalculatorGetDisplay(temp_string, FROM_CALCULATION);
			ClipboardPutItem(CLIP_TEXT_DATA, (void *)temp_string, (strlen(temp_string) + 1));
		}
		else if (object_type == TEXTBOX)
		{
			KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
			function_from_menu = TRUE;
		}
		break;
	case MENU_ITEM_CUT:
		if (object_type == TEXTBOX)
		{
			KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
			function_from_menu = TRUE;
		}
		break;
	case MENU_ITEM_PASTE:
		if (object_type == TEXTBOX)
		{
			if (CalculatorCheckPasteText() == FALSE)
			{
				invalid_paste_id = active_form_id;
				FormPopupForm(FORM_CAL_INVALID_PASTE);
			}
			else
			{
				switch (active_form_id)
				{
				case FORM_METRIC:
					if (metric_insert_pt.textbox_id == TEXTBOX_METRIC_0)
						MetricConversion(TEXTBOX_METRIC_0, TEXTBOX_METRIC_1);
					else MetricConversion(TEXTBOX_METRIC_1, TEXTBOX_METRIC_0);
					break;
				case FORM_EXCHANGE:
					ExchangeCalculate();
					break;
				case FORM_LOAN:
					LoanCalculation();
					loan_enter_pressed = 1;
					break;
				}
			}
		}
		break;
	case MENU_ITEM_COPY_RESULT:
		StringGetText(STRING_EXCHANGE_1, &string_text);
		ClipboardPutItem(CLIP_TEXT_DATA, (void *)(string_text+5), strlen((string_text + 5)) + 1);
		break;
	case MENU_ITEM_TOTAL_PAYMENT:
		StringGetText(STRING_LOAN_TOTAL_PAYMENT_RESULT, &string_text);
		ClipboardPutItem(CLIP_TEXT_DATA, (void *)(string_text), strlen((string_text)) + 1);
		break;
	case MENU_ITEM_TOTAL_INTEREST:
		StringGetText(STRING_LOAN_TOTAL_INTEREST_RESULT, &string_text);
		ClipboardPutItem(CLIP_TEXT_DATA, (void *)(string_text), strlen((string_text)) + 1);
		break;
	case MENU_ITEM_CALCULATING_ITEM:
		if (calculating_item == NO_SELECTION)
			break;
		TextboxGetTextPointer((ObjectID)(calculating_item + TEXTBOX_LOAN_NUM_YEARS), &textbox_text);
		ClipboardPutItem(CLIP_TEXT_DATA, (void *)(textbox_text), strlen((textbox_text)) + 1);
		break;
	case MENU_ITEM_CALCULATOR_PASTE:
		temp_text = (BYTE*)ClipboardGetItem(&data_type, &data_size);
		if (temp_text == NULL)
			return;
		if (CalculatorFilterPasteText(temp_text, &result_text, &result_value, &decimal_place) == TRUE)
		{
			if (last_input_type == PERCENT)
			{
				temp = input_buffer;
				input_buffer = result_buffer;
				result_buffer = temp;
				displaying_buffer = INPUT;
			}
			has_decimal = FALSE;
			if (last_input_type == EQUAL || last_input_type == MPLUS ||
				last_input_type == MMINUS)
			{
				CalculatorClearDisplayBuffer();
				result_buffer = 0;
				operation = ADD;
			}
			
			strcpy(display_buffer, result_text);
			display_value = result_value;
			has_decimal = decimal_place;
			
			CalculatorDisplayBufferToDisplay(FROM_CALCULATION);
			if (displaying_buffer == INPUT)
			{
				input_buffer = display_value;
				last_input_type = MR;
			}
			else if (displaying_buffer == RESULT)
			{
				input_buffer = display_value;
				if (last_input_type == EQUAL)
				{
					result_buffer = 0;
					//last_input_type = DIGITS;
					last_input_type = MR;
					operation = ADD;
					operator_pressed = FALSE;
				}
				else
				{
					displaying_buffer = INPUT;
					last_input_type = MR;
				}
			}
			qfree(result_text);
		}
		else
		{
			invalid_paste_id = FORM_CALCULATOR;
			FormPopupForm(FORM_CAL_INVALID_PASTE);
		}
		qfree(temp_text);
		break;
	default:
		break;
	}
}


/********************************************************
* Function:	CalculatorBlockCopyCutPaste 
* Purpose: 	This function is called to COPY, CUT, PASTE, UNDO
* Scope:		application/internal
* Input:		Event
* Output:		None
* Return:		TRUE        if handled
FALSE       if not handled
* Comment: 	None
*********************************************************/
BOOLEAN     CalculatorBlockCopyCutPaste (EvtType *Event)
{   
    ObjectID    active_form_id;
    WORD        para2 = 0;
	
    if (Event->eventType == EVT_FIELD_JOT_PASTE_STRING ||
        Event->eventType == EVT_TEXTBOX_JOT_PASTE_STRING)
    {
#ifdef DEBUG
        printf("\n Jot Event is ignored");
#endif
        pfree(Event->evtPBP);
        return TRUE;
    }
	
	if (function_from_menu)
	{
		function_from_menu = FALSE;
		return FALSE;
    }
	
	FormGetActiveFormID(&active_form_id);
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if (Event->para2 & 0xFF)
			para2 = Event->para2 & 0xFF;
		else if (Event->para2 & 0x100)
		{
			if (Event->para1 == 'C' || Event->para1 == 'c')
				para2 = KEY_COPY;
			else if (Event->para1 == 'V' || Event->para1 == 'v')
				para2 = KEY_PASTE;
			else if (Event->para1 == 'X' || Event->para1 == 'x')
				para2 = KEY_CUT;
			else if (Event->para1 == 'Z' || Event->para1 == 'z')
				para2 = KEY_UNDO;
		}
		
		switch(para2)
		{
		case KEY_COPY:
			Event->eventType    =   EVT_MENU_SELECT_ITEM;
			Event->para1        =   0;
			if (active_form_id == FORM_CALCULATOR)
				Event->eventID      =   MENU_POPUP_0;
			else if (active_form_id == FORM_METRIC)
				Event->eventID      =   MENU_POPUP_1;
			else if (active_form_id == FORM_EXCHANGE)
				Event->eventID      =   MENU_POPUP_2;
			else if (active_form_id == FORM_METRIC)
				Event->eventID      =   MENU_POPUP_3;
			return FALSE;
		case KEY_PASTE:
			Event->eventType    =   EVT_MENU_SELECT_ITEM;
			if (active_form_id == FORM_CALCULATOR)
			{
				Event->eventID      =   MENU_POPUP_0;
				Event->para1        =   1;
			}
			else if (active_form_id == FORM_METRIC)
			{
				Event->eventID      =   MENU_POPUP_1;
				Event->para1        =   2;
			}
			else if (active_form_id == FORM_EXCHANGE)
			{
				Event->eventID      =   MENU_POPUP_2;
				Event->para1        =   2;
			}
			else if (active_form_id == FORM_METRIC)
			{
				Event->eventID      =   MENU_POPUP_3;
				Event->para1        =   2;
			}
			return FALSE;
		case KEY_CUT:
			Event->eventType    =   EVT_MENU_SELECT_ITEM;
			Event->para1        =   1;
			if (active_form_id == FORM_CALCULATOR)
				return TRUE;
			else if (active_form_id == FORM_METRIC)
				Event->eventID      =   MENU_POPUP_1;
			else if (active_form_id == FORM_EXCHANGE)
				Event->eventID      =   MENU_POPUP_2;
			else if (active_form_id == FORM_METRIC)
				Event->eventID      =   MENU_POPUP_3;
			return FALSE;
		case KEY_UNDO:
			Event->eventType    =   EVT_MENU_SELECT_ITEM;
			Event->para1        =   3;
			if (active_form_id == FORM_CALCULATOR)
				return TRUE;
			else if (active_form_id == FORM_METRIC)
				Event->eventID      =   MENU_POPUP_1;
			else if (active_form_id == FORM_EXCHANGE)
				Event->eventID      =   MENU_POPUP_2;
			else if (active_form_id == FORM_METRIC)
				Event->eventID      =   MENU_POPUP_3;
			return FALSE;
		default:
			return FALSE;
		}
	}
	return FALSE;
}
